// Bound on polynomial solutions of the parametric Risch DE -- base case

// given a, b, q[1], ... q[m] in k[t], with k=const(k), a<>0, return n in Z_
// such that degree(q) <= n for any solution c[1], ..., c[m] in k
// and q in k[t] of a*diff(q,t)+b*q=sum(c[i]*q[i], i=1..m).

// Follows Bronstein, Symbolic Integration I, p. 228

intlib::algebraic::rde::parametricBoundDegreeBase :=
proc(a, b, q)
  local da, db, dc, m, n;
begin
  da := degree(a);
  db := degree(b);
  dc := max(0, op(map(q, degree)));
  n := max(0, dc-max(db, da-1));
  if db=da-1 then // possible cancellation
    m := -lcoeff(b)/lcoeff(a);
    if testtype(m, Type::Integer) then
      n := max(0, m, dc-db);
    end_if;
  end_if;
  return(n);
end:
