// parametric Risch DE, polynomials: degree bound

// Given a differential field k and a monomial t over k,
// a, b, g1, ..., gm in k[t], a<>0, find a bound on the degree of any
// q satisfying a*d(q)+b*q=sum(c[i]*g[i]) for c[i] in const(k).

// Combines the routines from Bronstein, Symbolic Integration I, pp. 227-230

intlib::algebraic::rde::parametricDegreeBound :=
proc(a : DOM_POLY, b : DOM_POLY, g : DOM_LIST, ts : DOM_LIST, diffs : DOM_LIST, algs : DOM_LIST)
begin
  if nops(ts) = 1 then
    intlib::algebraic::rde::parametricBoundDegreeBase(a, b, g, ts, diffs, algs);
  else
    case degree(diffs[-1], [ts[-1]])
    of 0 do
      // primitive
      intlib::algebraic::rde::parametricBoundDegreePrim(a, b, g, ts, diffs, algs);
      break;
    of 1 do
      // hyperexponential
      assert(iszero(coeff(diffs[-1], [ts[-1]], 0)));
      intlib::algebraic::rde::parametricBoundDegreeExp(a, b, g, ts, diffs, algs);
      break
    otherwise
      intlib::algebraic::rde::parametricBoundDegreeNonlinear(a, b, g, ts, diffs, algs);
    end_case;
  end_if;
end_proc:
