// Normal part of the denominator of the solution of a parametric RDE.

// Given a derivation d on k[t] and f,g1, ..., gn in k(t) with f weakly
// normalized w.r.t. t, return [a, b, G1, ..., Gn, h] such that
// a, h in k[t], b in k<t>, G1, ..., Gn in k(t), and for any solution
// c1, ..., cn in Const(k) and y in k(t) of d(y)+f*y=sum(c[i]*g[i], i=1..n),
// q = y*h in k<t> satisfies a*D(q)+b*q=sum(c[i]*G[i], i=1..n).
//
// Follows Bronstein, Symbolic Integration I, p. 219.

intlib::algebraic::rde::parametricNormalDenominator :=
proc(fNum : DOM_POLY, fDen : DOM_POLY, g : DOM_LIST,
  ts : DOM_LIST, diffs : DOM_LIST, algs : DOM_LIST)
  local dn, ds, en, es, p, h, G, bNum, bDen, tmp;
begin
  [dn, ds] := intlib::algebraic::splitFactor(fDen, ts, diffs, algs);
  [en, es] := intlib::algebraic::splitFactor(lcm(op(map(g, op, 2))), ts, diffs, algs);
  p := gcd(dn, en);
  h := divide(gcd(en, en'), gcd(p, p'), Quo); // Exact
  // G[i] = dn*h^2*g[i]
  G := map(g,
    l -> intlib::algebraic::normal(expr(dn*h^2)*expr(l[1])/expr(l[2]), [ts[-1]]));
  // b = dn*h*f-dn*d(h) = (h*fNum/ds - fDen/ds*d(h)) = (h*fNum - fDen*d(h))/ds
  bNum := (h*fNum - intlib::algebraic::diff(ts, diffs, algs)(h)*fDen);
  bDen := ds;
  tmp := gcd(bNum, bDen);
  bNum := divide(bNum, tmp, Quo); // Exact
  bDen := divide(bDen, tmp, Quo); // Exact
  [dn*h, [bNum, bDen], G, h];
end:
