// Given a derivation d on k[t], n in Z_ and b, q1, ..., qm in k[t] with
// b in k, d <> diff(.,t), and (dt in k or dt/t in k), return
// h1,...,hr in k[t] and a matrix (a hash) A with coefficients in Const(k)
// such that if c1,...,cm in Const(k) and q in k[t] satisfy degree(q)<=n
// and d(q)+b*q=sum(c[i]*q[i]) then q=sum(d[j]*h[j]) where d[1],...,d[r] in
// Const(k) and A*transpose([c1,...,cm,d1,...,dr])=0

// Follows Bronstein, Symbolic Integration I, p. 241 f.

intlib::algebraic::rde::parametricPolyRDECancelLiouville :=
proc(b : DOM_POLY, q : DOM_LIST, n : DOM_INT, ts : DOM_LIST, diffs : DOM_LIST, algs : DOM_LIST)
  local d, f, df, A, i, fi, Ai, bi, h;
begin
  assert(nops(ts)>1 and degree(diffs[-1], [ts[-1]]) < 2);
  assert(n >= 0);
  d := intlib::algebraic::diff(ts, diffs, algs);
  // collect the f[i,.] and A[i,.] returned from the individual
  // problems over k
  f := [];
  df := [];
  A := table(0);
  A["m"] := nops(q);
  A["cols"] := nops(q);
  A["rows"] := 0;
  bi := coeff(diffs[-1], [ts[-1]], 1);
  for i from n downto 0 do
    [fi, Ai, h] := intlib::algebraic::rde::parametricRDE(
      op(intlib::algebraic::normal(expr(b)+i*bi, [ts[-2]])),
      map(map(q, coeff, i).map(df, coeff, [ts[-1]], i),
        intlib::algebraic::normal, [ts[-2]]),
      ts[1..-2], diffs[1..-2], algs[1..-2]);
    if fi=FAIL then
      return([FAIL, FAIL]);
    end_if;
    assert(A["cols"] = Ai["m"]); // what we found so far is in the new rhs
    A["m"] := Ai["m"];
    A := intlib::algebraic::rde::combineHashMatrices(A, Ai);
    // TODO: simplification. Lines with exactly two non-zero
    // entries, both pointing to q[i] -> check for combinability.
    fi := map(fi, f -> expr(f)/expr(h));
    f := f.map(fi, f -> poly([[f, i]], [ts[-1]])); // f[i]/h*t^i
    df := df.map(fi, f -> -d(f*ts[-1]^i)+expr(b)*f*ts[-1]^i);
  end_for;
  A["m"] := nops(q);
  intlib::algebraic::rde::simplifyHashMatrix(f, A);
end_proc:
