// Given a derivation d on k[t], n in Z_ and b, q1, ..., qm in k[t] with
// degree(b) < degree(d(t)-1) and either d = d/dt or degree(d(t))>1, return
// h1,...,hr in k[t] and a matrix (a hash) A with coefficients in Const(k)
// such that if c1,...,cm in Const(k) and q in k[t] satisfy degree(q)<=n
// and d(q)+b*q=sum(c[i]*q[i]) then q=sum(d[j]*h[j]) where d[1],...,d[r] in
// Const(k) and A*transpose([c1,...,cm,d1,...,dr])=0

// Follows Bronstein, Symbolic Integration I, p. 238

intlib::algebraic::rde::parametricPolyRDENoCancel2 :=
proc(b : DOM_POLY, q : DOM_LIST, n, ts : DOM_LIST, diffs : DOM_LIST, algs : DOM_LIST)
  local d, t, ddt, ldt, m, i, j, s, h, f, B, hh, q0, dc, fi, A, A2, u, db, lcb, r, eq;
begin
  t := ts[-1];
  assert(iszero(b) or degree(b) < degree(diffs[-1], [t]));
  assert(nops(ts)=1 or degree(diffs[-1], [t])>1);
  
  d := intlib::algebraic::diff(ts, diffs, algs);
  ddt := degree(diffs[-1], [t]);
  ldt := lcoeff(diffs[-1], [t]);
  
  m := nops(q);
  h := [poly(0, [t])$m];
  while n > 0 do
    for i from 1 to m do
      s := poly([[coeff(q[i], [n+ddt-1])/(n*ldt),n]], [t]);
      h[i] := h[i] + s;
      q[i] := q[i] - d(s) - b*s;
    end_for;
    n := n-1;
  end_while;
  if degree(b) > 0 then
    db := degree(b);
    lcb := lcoeff(b);
    s := map(q, qi -> coeff(qi, db)/lcb);
    h := zip(h, s, _plus);
    q := zip(q, s, (qi, si) -> qi - poly(d(si), [t]) - multcoeffs(b, si));
    if _and(op(map(q, iszero))) then
      dc := -1;
      A := table(0);
      A["m"] := m;
      A["cols"] := 2*m;
      A["rows"] := m;
      for i from 1 to m do
        A[i, i] := 1;
        A[i, i+m] := -1;
      end_for;
    else
      dc := max(op(map(q, degree)));
      A := table(0);
      A["m"] := m;
      A["rows"] := dc+1;
      A["cols"] := m;
      for i from 0 to dc do
        for j from 1 to m do
          A[i+1, j] := coeff(q[j], i);
        end_for;
      end_for;
      [A2, u] := intlib::algebraic::rde::constantSystem(A, [0$(dc+1)], ts, diffs, algs);
      A := table(0);
      A["m"] := m;
      A["cols"] := 2*m;
      A["rows"] := m;
      for i from 1 to m do
        A[i, i] := 1;
        A[i, i+m] := -1;
      end_for;
      A := intlib::algebraic::rde::combineHashMatrices(A, A2);
    end_if;
    return([h, A]);
  else
    assert(nops(ts)>1);
    q0 := map(q, q->intlib::algebraic::normal(q(0), [ts[-2]]));
    [f, B, hh] := intlib::algebraic::rde::parametricRDE(
      op(intlib::algebraic::normal(expr(b), [ts[-2]])),
      q0, ts[1..-2], diffs[1..-2], algs[1..-2]);
    r := nops(f);
    hh := expr(hh);
    f := map(f, fi -> poly([[expr(fi)/hh, 0]], [t]));
    if _and(op(map(q, iszero))) then
      dc := -1;
      for fi in f do
        fi := expr(d(fi)+b*fi);
        if not testeq(fi, 0, Goal=FALSE, Steps=2) then
          dc := 0;
          break;
        end_if;
      end_for;
    else
      dc := max(op(map(q, degree)));
    end_if;
    if dc >= 0 then
      A := table(0);
      A["m"] := m;
      A["rows"] := dc+1;
      A["cols"] := m+r;
      for i from 0 to dc do
        for j from 1 to m do
          A[i+1, j] := coeff(q[j], i);
        end_for;
      end_for;
      for j from 1 to r do
        A[1, m+j] := -d(expr(f[j]))-expr(b)*expr(f[j]);
      end_for;
      [A2, u] := intlib::algebraic::rde::constantSystem(A, [0$(dc+1)], ts, diffs, algs);
      // stack A2 and B
      for eq in [op(B)] do
        if type(op(eq, 1)) = "_exprseq" then
          [i, j] := [op(eq, 1)];
          A2[i+A2["rows"], j] := op(eq, 2);
        end_if;
      end_for;
      A2["rows"] := A2["rows"] + B["rows"];
      A2["cols"] := max(A2["cols"], B["cols"]);
      // add the constraints c[i]=e[i]
      A := table(0);
      A["m"] := m;
      A["cols"] := 2*m;
      A["rows"] := m;
      for i from 1 to m do
        A[i, i] := 1;
        A[i, i+m] := -1;
      end_for;
      A := intlib::algebraic::rde::combineHashMatrices(A, A2);
    else
      // add the constraints c[i]=e[i]
      A := table(0);
      A["m"] := m;
      A["cols"] := 2*m;
      A["rows"] := m;
      for i from 1 to m do
        A[i, i] := 1;
        A[i, i+m] := -1;
      end_for;
      A := intlib::algebraic::rde::combineHashMatrices(B, A);
    end_if;
    return([f.h, A]);
  end_if;
end_proc:
