// simplify return values for the parametric RDE functions:
// given a list h of polynomials and a matrix M (encoded as
// a hash), return h' and M' s.t. whenever
// M*(c1,...,cm,d1,...dr)^T=0 and M*(c1,...,cm,e1,...es)^T=0,
// sum(d[i]*h[i]) = sum(e[i]*h'[i]).

// implemented simplifications:
// - removes zero polynomials

intlib::algebraic::rde::simplifyHashMatrix :=
proc(h, M)
  local i, m, deleteRows, deleteCols;
begin
  m := M["m"];
  deleteRows := table();
  deleteCols := table();
  for i from nops(h) downto 1 do
    if iszero(h[i]) then
      // removing a zero h[i] involves
      // - deleting all rows in M where the coefficient
      //   relevant for h[i] is non-zero, since they do not
      //   restrict the other values in any way
      map([op(M)],
        eq -> (if type(op(eq, 1)) = "_exprseq" and
          op(eq, [1, 2]) = i+m and not iszero(op(eq, 2)) then
            deleteRows[op(eq, [1, 1])] := TRUE;
          end_if; eq)):
      // - deleting the column
      deleteCols[i+m] := TRUE:
      // - deleting the polynomial
      delete h[i];
    end_if;
  end_for;
  if nops(deleteCols) > 0 or nops(deleteRows) > 0 then
    M["cols"] := M["cols"]-nops(deleteCols);
    M["rows"] := M["rows"]-nops(deleteRows);
    M := [op(M)];
    // decreasing lists:
    deleteCols := revert(sort(map([op(deleteCols)], op, 1)));
    deleteRows := revert(sort(map([op(deleteRows)], op, 1)));
    for i in deleteCols do
      i := op(i, 1);
      M := map(M,
        proc(eq)
        begin
          if type(op(eq, 1)) = "_exprseq" then
            if op(eq, [1, 2]) > i then
              return(subsop(eq, [1, 2] = op(eq, [1, 2]) - 1));
            elif op(eq, [1, 2]) = i then
              return(null());
            end_if;
          end_if;
          eq;
        end);
    end_for;
    for i in deleteRows do
      i := op(i, 1);
      M := map(M,
        proc(eq)
        begin
          if type(op(eq, 1)) = "_exprseq" then
            if op(eq, [1, 1]) > i then
              return(subsop(eq, [1, 1] = op(eq, [1, 1]) - 1));
            elif op(eq, [1, 1]) = i then
              return(null());
            end_if;
          end_if;
          eq;
        end);
    end_for;
    M := table(M, 0);
  end_if;
  
  // delete zero rows
  deleteRows := table((i = TRUE) $ i = 1..M["rows"]);
  map([op(M)],
    proc(eq)
    begin
      if type(op(eq, 1)) = "_exprseq" then
        delete deleteRows[op(eq, [1, 1])];
      end_if;
    end);
  if nops(deleteRows) > 0 then
    M["rows"] := M["rows"]-nops(deleteRows);
    M := [op(M)];
    deleteRows := revert(sort(map([op(deleteRows)], op, 1)));
    for i in deleteRows do
      i := op(i, 1);
      M := map(M,
        proc(eq)
        begin
          if type(op(eq, 1)) = "_exprseq" then
            if op(eq, [1, 1]) > i then
              return(subsop(eq, [1, 1] = op(eq, [1, 1]) - 1));
            elif op(eq, [1, 1]) = i then
              return(null());
            end_if;
          end_if;
          eq;
        end);
    end_for;
    M := table(M, 0);
  end_if;
  
  assert(M["rows"] >= 0);
  assert(M["cols"] >= M["m"]);
  return([h, M]);
end_proc:
