// Find the special part of the demoninator of the solution of the RDE
//
// branches for the relevant cases

intlib::algebraic::rde::specialDenominator :=
proc(a, bNum, bDen, cNum, cDen, ts, diffs, algs, tType=UNKNOWN)
  local t, dt, nb, nc, n, alpha, beta, m, N;
begin
  t := ts[-1];
  dt := poly(diffs[-1], [t]);
  if tType=UNKNOWN then
    if iszero(degree(dt)) then
      tType := "Primitive";
    elif degree(dt)=1 and iszero(coeff(dt, 0)) then
      tType := "Hyperexponential"
    elif degree(dt)=2 and coeff(dt, 2)=coeff(dt, 0) and iszero(coeff(dt, 1)) then
      tType := "Hypertangent"
    else
      error("Can't handle monomial ".expr2text(t).
            " with derivative ".expr2text(expr(dt)));
    end_if;
  end_if;
  case tType
  of "Primitive" do
    // k<t> = k[t]
    if not iszero(degree(bDen)) then
      [bNum, bDen] := intlib::algebraic::normal(
        normal(expr(bNum)/expr(bDen), Expand = FALSE,
        Rationalize = (x -> rationalize(x, table(normal::rationalizeOptions, MinimalPolynomials = TRUE)))),
        op(bNum, 2));
    end_if;
    // assert(degree(bDen)=0); // we sometimes have problems cancelling
    if not iszero(degree(bDen)) then
      return([FAIL $ 4]);
    end_if;
    if not iszero(degree(cDen)) then
      [cNum, cDen] := intlib::algebraic::normal(
        normal(expr(cNum)/expr(cDen), Expand = FALSE,
        Rationalize = (x -> rationalize(x, table(normal::rationalizeOptions, MinimalPolynomials = TRUE)))),
        op(cNum, 2));
    end_if;
    // assert(degree(cDen)=0); // we sometimes have problems cancelling
    if not iszero(degree(cDen)) then
      return([FAIL $ 4]);
    end_if;
    return([a, multcoeffs(bNum, 1/tcoeff(bDen)),
            multcoeffs(cNum, 1/tcoeff(cDen)), poly(1, [t])]);
  of "Hyperexponential" do
    // follows Bronstein, Symbolic Integration I, p. 190
    assert(not iszero(coeff(a, 0)));
    nb := intlib::algebraic::orderAt(poly(t,[t]), bNum, bDen);
    nc := intlib::algebraic::orderAt(poly(t,[t]), cNum, cDen);
    n := min(0, nc-min(0, nb));
    if iszero(nb) then
      assert(not iszero(coeff(bDen, 0)*coeff(a, 0)));
      alpha := intlib::algebraic::normal(-coeff(bNum, 0)/
                                         (coeff(bDen, 0)*coeff(a, 0)), [ts[-2]]);
      if (m := intlib::algebraic::rde::parametricLogarithmicDerivative
        (alpha[1], alpha[2], ts, diffs, algs))[1] = 1 then
        n := min(n,m[2]);
      end_if;
    end_if;
    N := max(0, -nb, n-nc);
    // note: b,c in k<t>, i.e., bNum and dNum are powers of t, 
    // since t is a hyperexponential monomial.
    return([poly(expr(a)*t^N, [t]), 
            poly(expr(bNum)/expr(bDen)*t^N+n*expr(a)*diffs[-1]*t^(N-1), [t]),
            poly(expr(cNum)/expr(cDen)*t^(N-n), [t]), poly(t^(-n), [t])]);
  of "Hypertangent" do
    // follows Bronstein, Symbolic Integration I, p. 192
    // is only permissible over fields not containing sqrt(-1):
    assert(not has([a, bNum, bDen, cNum, cDen, diffs, algs], I));
    assert(gcd(a, poly(t^2+1, [t]))=poly(1, [t]));
    nb := intlib::algebraic::orderAt(poly(t^2+1,[t]), bNum, bDen);
    nc := intlib::algebraic::orderAt(poly(t^2+1,[t]), cNum, cDen);
    n := min(0, nc-min(0, nb));
    if iszero(nb) then
      alpha := -bNum(I)/(bDen(I)*a(I));
      // careful rectform:
      assert(not has(alpha, t));
      alpha := intlib::algebraic::normal(subs(alpha, I=t), [t]);
      while degree(alpha[2]) > 1 do
        alpha[2] := poly(subs(eval(alpha[2](I)), I=t), [t]);
      end_while;
      if degree(alpha[2]) > 0 then
        alpha[1] := alpha[1]*poly(alpha[2](-t), [t]);
        alpha[2] := coeff(alpha[2],0)^2-coeff(alpha[2],1)^2;
      end_if;
      while degree(alpha[1]) > 1 do
        alpha[1] := poly(subs(eval(alpha[1](I)), I=t), [t]);
      end_while;
      beta := coeff(alpha[1],0)/alpha[2];
      alpha := coeff(alpha[1],1)/alpha[2];
      // end of careful rectform
      
      if (m := intlib::algebraic::rde::parametricLogarithmicDerivative
        (2*beta, t, ts, diffs, algs)) <> FAIL then
        error("not yet implemented");
        /* if ??? then
          n := min(n,m[2]);
        end_if; */
      end_if;
    end_if;
    N := max(0, -nb, n-nc);
    return([a*poly((t^2+1)^N, [t]), 
            poly(normal((expr(bNum)/expr(bDen)+n*expr(a)*diffs[-1]/(t^2+1))*(t^2+1)^N), [t]),
            poly(normal(expr(cNum)/expr(cDen)*(t^2+1)^(N-n)), [t]), poly((t^2+1)^(-n), [t])]);
  otherwise error("Unknown monomial type '".expr2text(tType)."'");
  end_case;
end:
