// symbolic integration via the Risch algorithm

// This is the interface function transforming a suitable
// expression into a rational function over a differential
// field, calling the Risch integration, and transforming
// the result back to a standard expression.

// currently, only purely transcendental elementary 
// field towers are supported

intlib::algebraic::int :=
proc(f, x, options=table())
  local hasComplex, // sinpos, sinargs, sinarg,
        ts, vals, diffs, algs, ft, backsubsts, integral, i, checkdiff, ident;
begin
  // integration with tan has not been completely implemented
  hasComplex := TRUE;
%if FALSE then
  // if f does not contain complex numbers, it may contain tan
  hasComplex := has(f, I);
  if not hasComplex then
    misc::maprec(f, {_power} = (ex -> if testtype(op(ex, 2), DOM_RAT) and 
                                        is(op(ex, 1)<0) <> FALSE then
                                        hasComplex := TRUE;
                                        misc::breakmap();
                                      end));
  end_if;
end_if;
  if hasComplex then
    // rewrite sin, cos, tan, cot, ... to exp
    f := subs(f,
      [hold(sin) = (ex -> if has(ex, x) then I/2*(exp(-I*ex)-exp(I*ex))
                          else sin(ex) end),
       hold(cos) = (ex -> if has(ex, x) then 1/2*(exp(-I*ex)+exp(I*ex))
                          else cos(ex) end),
       hold(tan) = (ex -> if has(ex, x) then I*(1-exp(2*ex*I))/(1+exp(2*ex*I)) 
                          else tan(ex) end),
       hold(cot) = (ex -> if has(ex, x) then (exp(ex*2*I)*I + I)/(exp(ex*2*I) - 1) 
                          else cot(ex) end),
       hold(sinh) = (ex -> if has(ex, x) then exp(ex)/2 - 1/(2*exp(ex))
                          else sinh(ex) end),
       hold(cosh) = (ex -> if has(ex, x) then 1/(2*exp(ex)) + exp(ex)/2
                          else cosh(ex) end),
       hold(tanh) = (ex -> if has(ex, x) then (exp(2*ex) - 1)/(exp(2*ex) + 1)
                          else tanh(ex) end),
       hold(coth) = (ex -> if has(ex, x) then (exp(2*ex) + 1)/(exp(2*ex) - 1) 
                          else coth(ex) end),
/* all of these introduce algebraics *
       hold(arcsin) = (ex -> if has(ex, x) then -ln((1 - ex^2)^(1/2) + ex*I)*I
                             else arcsin(ex) end),
       hold(arccos) = (ex -> if has(ex, x) then -ln(ex + (1 - ex^2)^(1/2)*I)*I
                             else arccos(ex) end),
       hold(arctan) = (ex -> if has(ex, x) then (ln(1 - ex*I)*I)/2 - (ln(1 + ex*I)*I)/2
                             else arctan(ex) end),
       hold(arccot) = (ex -> if has(ex, x) then (ln(1 - I/ex)*I)/2 - (ln(1 + I/ex)*I)/2
                             else arccot(ex) end),
       hold(arcsinh) = (ex -> if has(ex, x) then ln(ex + (ex^2 + 1)^(1/2))
                              else arcsinh(ex) end),
       hold(arccosh) = (ex -> if has(ex, x) then ln(ex + (ex^2 - 1)^(1/2))
                              else arccosh(ex) end),
 */
       hold(arctanh) = (ex -> if has(ex, x) then ln(ex + 1)/2 - ln(1 - ex)/2
                              else arctanh(ex) end),
       hold(arccoth) = (ex -> if has(ex, x) then ln(1/ex + 1)/2 - ln(1 - 1/ex)/2
                              else arccoth(ex) end),
       null()
       ],EvalChanges);
  else
%if FALSE then // Activate after implementing integration w.r.t. hypertangents!
    // rewrite sin and cos to tan
    // look for sin(x)/cos(x) and make tan(x) from that
    sinpos := {prog::find(f, hold(sin))};
    sinargs := select(map(sinpos, p -> op(f, p[1..-2].[1])), has, x);
    for sinarg in sinargs do
      f := subsex(f, sin(sinarg)/cos(sinarg)=tan(sinarg));
    end_for;
    
    f := subs(f,
      [hold(sin) = (ex -> if has(ex, x) then 2*tan(ex/2)/(tan(ex/2)^2+1)
                                        else sin(ex) end),
       hold(cos) = (ex -> if has(ex, x) then (1-tan(ex/2)^2)/(tan(ex/2)^2+1)
                                        else cos(ex) end)],
       EvalChanges);
end_if;
  end_if;

  [ts, vals, diffs, algs, ft, backsubsts] := intlib::algebraic::fieldTower(
    f, x, table(options/*, "TreatAlgebraicsAsTranscendentals"=TRUE*/));
  if has([ts, vals, diffs, ft, backsubsts], [FAIL, undefined]) then
    return(FAIL);
  end_if;
  if not testtype(subs(ft, map(ts, t -> t=#t)), Type::RatExpr(#t, Type::IndepOf(#t))) then
    error("bad result from intlib::algebraic::fieldTower!");
  end_if;

  if nops(ts)=1 then
    i := intlib::algebraic::rational(ft, ts[1], options);
    return(i | [ts[1] = vals[1]].backsubsts)
  end_if;


  // Risch only works for simple towers
  checkdiff := proc(ex)
  begin
    if not has(ex, ts) then return(TRUE); end_if;
    // arcsin(x) etc. doesn't work in Risch.
    case type(ex)
    of "_power" do
      if domtype(op(ex, 2)) <> DOM_INT then return(FALSE); end_if;
      return(checkdiff(op(ex, 1)));
    of "_plus" do
    of "_mult" do
      return(_and(map(op(ex), checkdiff)));
    end_case;
    if domtype(ex) = DOM_EXPR and has(ex, ts) then
      // warning("got ".ex);
      return(FALSE);
    end_if;
    TRUE;
  end_proc;
  for i from 1 to nops(diffs) do
    if i < nops(diffs) and has(diffs[i], ts[i+1..-1]) then
      return(FAIL);
    end_if;
    if not checkdiff(diffs[i]) then
      return(FAIL);
    end_if;
    // and only for monomials
    if not testtype(diffs[i], Type::PolyExpr(ts[i], Type::IndepOf(ts[i]))) then
      return(FAIL);
    end_if;
  end_for;
  
  ft := intlib::algebraic::normal(ft, [ts[-1]]);
  
  integral := intlib::algebraic::rischInt(ft[1], ft[2], ts, diffs, algs);
  
  // sums can have introduced new identifiers, avoid aliasing problems
  for ident in (indets(integral) minus Type::ConstantIdents minus
    indets(map(ft, poly2list))) intersect
    (indets(map(backsubsts, op, 2)) minus indets(map(backsubsts, op, 1))) do
    integral := subs(integral,
      ident = solvelib::getIdent(Any, indets(backsubsts.[integral])));
  end_for;

  integral := subs(integral, revert(zip(ts, vals, `=`)), backsubsts);
  
  if options[hold(DontSimplifyComplexIntegral)] <> TRUE then
    if traperror((ft := intlib::simplifyComplexIntegral(integral, x, Unique)),
      MaxSteps = intlib::simplifyMaxSteps(f, integral, "simpCint")) = 0 then
      if intlib::Simplify::defaultValuation(ft) <
        intlib::Simplify::defaultValuation(integral) then
        integral := ft;
      end_if;
    end_if;
  end_if;
  
  return(integral);
end:
