// Integration of Hypertangent Functions

/// /// Since coupledDESystem is currently missing, handling of
/// /// hypertngents is not really implemented yet.
/// 
/// // Given a differentail field k such that not I in k, a hypertangent monomial t
/// // over k and f in k(t), return g elementary over k(t) and a Boolean b such that
/// // f-d(g) in k if b=TRUE, or f-d(g) (and hence f) does not have an elementary 
/// // integral over k(t) if b=FALSE.
/// 
/// // follows Bronstein, Symbolic Integration I, p. 172 and p. 167
/// 
    intlib::algebraic::integrateHypertangent := () -> FAIL:
/// proc(fNum, fDen, ts, diffs, algs)
///   local g1, g2, h, r, good, p, q1, q2, c, gc;
/// begin
///   assert(not has([args()], I));
///   [g1, h, r] := intlib::algebraic::Hermite(fNum, fDen, ts, diffs, algs);
///   [g2, good] := intlib::algebraic::residueReduce(h[1], h[2], ts, diffs, algs);
///   if not good then
///     return([g1+g2, FALSE]);
///   end_if;
///   // p := h-D(g2)+r
///   p := intlib::algebraic::normal(expr(h[1])/expr(h[2])
///         - intlib::algebraic::diff(ts, diffs, algs)(g2)
///         + expr(r[1])/expr(r[2]), [ts[-1]]);
///   
///   [q1, good] := intlib::algebraic::integrateHypertangentReduced
///        (p[1], p[2], ts, diffs, algs);
///   if not good then
///     return([g1+g2+q1, FALSE]);
///   end_if;
///   // p := p - d(q1);
///   r := intlib::algebraic::normal(intlib::algebraic::diff(ts, diffs, algs)(q1), [ts[-1]]);
///   gc := gcd(p[1], r[2]);
///   p[1] := intlib::algebraic::polyDivide(p[1], gc);
///   r[2] := intlib::algebraic::polyDivide(r[2], gc);
///   gc := gcd(p[2], r[1]);
///   p[2] := intlib::algebraic::polyDivide(p[2], gc);
///   r[1] := intlib::algebraic::polyDivide(r[1], gc);
///   p := [p[1]*r[2]+p[2]*r[1], p[2]*r[2]];
///   
///   assert(degree(p[2])=0);
///   
///   p := multcoeffs(p[1], 1/lcoeff(p[2]));
///   
///   // IntegrateHypertangentPolynomial(p)
///   [q2, r] := intlib::algebraic::polynomialReduce(p, ts, diffs, algs);
///   c := coeff(r, 1)*(ts[-1]^2+1)/(2*diffs[-1]);
/// 
///   // TODO: options
///   if iszero(intlib::Simplify(intlib::algebraic::diff(ts, diffs, algs)(c), table(), Steps=20)) then
///     return([g1+g2+q1+q2+c*ln(ts[-1]^2+1), TRUE]);
///   end_if;
///   return([g1+g2+q1+q2, FALSE]);
/// end_proc:
/// 