// Integration of primitive functions

// With t a primitive monomial over k, f in k(t),
// return g elementary over k(t) and a Boolean b
// such that, if b=TRUE, f-D(g) in k, and if b=FALSE,
// f does not have an elementary integral over k(t).

// Follows Bronstein, Symbolic Integration I, p. 160

intlib::algebraic::integratePrimitive :=
proc(fNum, fDen, ts, diffs, algs)
  local g1, h, r, g2, good, p, q;
begin
  [g1, h, r] := intlib::algebraic::Hermite(fNum, fDen, ts, diffs, algs);
  if g1 = FAIL then return([0, FALSE]); end_if;
  [g2, good] := intlib::algebraic::residueReduce(h[1], h[2], ts, diffs, algs);
  if not good then
    return([g1+g2, FALSE]);
  end_if;
  // h := h-D(g2)+r
  p := intlib::algebraic::normal(expr(h[1])/expr(h[2])
        -intlib::algebraic::diff(ts, diffs, algs)(g2), [ts[-1]]);
  p := [p[1]*r[2]+p[2]*r[1], p[2]*r[2]];

  assert(iszero(mapcoeffs(divide(p[1], p[2], Rem), normal)));
  
  p := intlib::algebraic::polyDivide(p[1], p[2]);
  
  [q, good] := intlib::algebraic::integratePrimitivePolynomial(p, ts, diffs, algs);
  return([g1+g2+expr(q), good]);
end:
