// limited integration -- reduction to a polynomial problem

// Given a derivation d on k(t) and f,w1,...,wn in k(t)
// (each given as a list of [numerator, denominator]),
// return [a,b,h,N,g,[v1,...,vm]] such that a,b,h in k[t],
// N in N_, g, v1,...,vm in k(t) and for any solution v in k(t),
// c1,...,cm in const(k) of f=d(v) + sum(c[i]*w[i]), p=v*h in k<t>,
// and p and the c[i] satisfy a*d(p) + b*p = g + sum(c[i]*v[i]).
// Furthermore, if S_1^{irr}=S^{irr}, then p in k[t], and if
// t is nonlinear or Liouvillian over k, then deg(p)<=N.

// Follows Bronstein, Symbolic Integration I, p. 248

intlib::algebraic::limitedIntegrateReduce :=
proc(fNum, fDen, w, ts, diffs, algs)
  local d, dn, ds, en, es, a, b, c, hn, hs, N, ahn;
begin
  d := intlib::algebraic::diff(ts, diffs, algs);
  [dn, ds] := intlib::algebraic::splitFactor(fDen, ts, diffs, algs);
  en := map(map(w, op, 2), intlib::algebraic::splitFactor, ts, diffs, algs);
  es := map(en, op, 2);
  en := map(en, op, 1);
  // TODO: Replace lcm by something more careful
  c := lcm(dn, op(en));
  // TODO replace gcd by something more careful
  hn := gcd(c, diff(c, ts[-1]));
  a := hn;
  b := -d(hn);
  N := 0;
  // either this reduction to k[t] for S_1^{irr}=S^{irr}
  // has a bug or the condition is badly written.
  // see test file for an example that breaks if this branch is enabled.
  if degree(diffs[-1], [ts[-1]])<2 // TODO: More examples of S_1^{irr}=S^{irr}?
  // e.g., hypertangents?
  then
    hs := lcm(ds, op(es));
    a := hn*hs;
    b := b-hn*divide(d(hs),hs,Quo); // known to be exact, since hs is special
    N := degree(hn)+degree(hs)+
      max(0,1-degree(diffs[-1],[ts[-1]])-
        // \nu_\infty
        min(op(map([[fNum, fDen]].w,
          v -> degree(v[2])-degree(v[1])))));
  end_if;
  // TODO: how much normalization can we avoid?
  ahn := -expr(a*hn);
  w := map(w,
    proc(wi)
      local t;
    begin
      t := intlib::algebraic::normal(ahn/expr(wi[2]), [ts[-1]]);
      [t[1]*wi[1], t[2]];
    end_proc);
  ahn := intlib::algebraic::normal(-ahn/expr(fDen), [ts[-1]]);
  fNum := fNum*ahn[1];
  fDen := ahn[2];
  return([a, b, a, N, [fNum, fDen], w]);
end_proc:
