// get the numerator and denominator of an expression known to be rational in
// a list of indets

// Note: The denominator returned will be monic. This is the representation
// implicitly used throughout Bronstein's book.

intlib::algebraic::normal :=
proc(ex, ts)
  local num, den, g, rat;
begin
  if has(ex, FAIL) then return([FAIL, FAIL]); end_if;
  // [num, den] := intlib::algebraic::normal_rek(ex, ts);
  [num, den] := normal(ex, Iterations=1, Rationalize=(x -> (x, {})), List, Expand = TRUE);
  num := poly(num, ts);
  den := poly(den, ts);
  if has([num, den], I) then
    // gcd tends to be *very* expensive in this situation.
    // In a lot of cases, we get a polynomial in the end:
    if nops(ts) = 1 and iszero(mapcoeffs(divide(num, den, Rem), normal, NoGcd)) then
      num := mapcoeffs(divide(num, den, Quo), normal, NoGcd);
      den := poly(1, ts);
      return([num, den]);
    end_if;
    // else, try with ignoring the special properties of I first, to avoid
    // Dom::AlgebraicExtension as far as possible:
    rat := rationalize([poly2list(num), poly2list(den)]);
    num := poly(rat[1][1], ts);
    den := poly(rat[1][2], ts);
    g := gcd(num, den);
    g := poly(g, Expr);
    num := intlib::algebraic::polyDivide(num, g);
    den := intlib::algebraic::polyDivide(den, g);
    num := subs(num, rat[2],EvalChanges);
    den := subs(den, rat[2],EvalChanges);
    // but still need another round
  end_if;
  g := gcd(poly(num /* , Dom::ExpressionField() */), poly(den /* , Dom::ExpressionField() */));
  g := poly(g, Expr);
  num := intlib::algebraic::polyDivide(num, g);
  den := intlib::algebraic::polyDivide(den, g);
  g := lcoeff(den);
  num := multcoeffs(num, 1/g);
  den := multcoeffs(den, 1/g);
  if has([poly2list(num), poly2list(den)], ts) then
    return([FAIL, FAIL]);
  end_if;
  [num, den]
end:
