// order at a

// simply following the definition from
// Bronstein, Symbolic integration I, pp. 107, 109, 115

intlib::algebraic::orderAt :=
proc(a, fNum, fDen)
  local n;
begin
  if a = infinity then
    if iszero(fNum) then return(0); end_if;
    return(degree(fDen)-degree(fNum));
  else
    if iszero(fNum) then return(infinity); end_if;
    n := 0;
    while iszero(mapcoeffs(divide(fNum, a, Rem), normal)) do
      n := n+1;
      fNum := mapcoeffs(intlib::algebraic::polyDivide(fNum, a), normal);
    end_while;
    while iszero(mapcoeffs(divide(fDen, a, Rem), normal)) do
      n := n-1;
      fDen := mapcoeffs(intlib::algebraic::polyDivide(fDen, a), normal);
    end_while;
    return(n);
  end_if;
end_proc:
