// create a polynomial, possibly after normalizing
//
// It happens in surprisingly many places in the Risch algorithm
// that expressions which are mathematically known to be polynomial
// in some variable are still rational. This routine creates a DOM_POLY from them.

intlib::algebraic::poly :=
proc(a, ts)
  local p;
begin
  p := poly(a, ts);
  if p = FAIL then
    p := intlib::algebraic::normal(a, ts);
    if not iszero(degree(p[2])) then
      p := intlib::algebraic::normal(intlib::Simplify(a), ts);
    end_if;
    assert(iszero(degree(p[2])));
    p := p[1]/expr(p[2]);
  end_if;
  p;
end_proc:
