// ratlinsolve - search rational solutions of linear system with constant coeffs

intlib::algebraic::ratlinsolve :=
proc(eqs, ts)
  local zeroes, t, sol, r, i, f, substs,
        linsolve_params, nonrat_idents, eqs2, sol2;
begin
  // start with using linearity

  // terms which are not sums are linear
  // in one indet., which is therefore zero
  eqs := select(eqs, _not@iszero);
  if select(eqs, _not@has, ts) <> [] then
    // equation not zero, but does not depend on vars to solve for?
    return(FAIL);
  end_if;
  zeroes := map(select({op(ts)}, t -> not has(eqs, [t])), `=`, 0);
  while ((t := select(eqs, _not@hastype, "_plus"))) <> [] do
    t := map(t, eq -> numeric::indets(eq) intersect {op(ts)});
    t := select(t, e -> nops(e)=1);
    if nops(t) = 0 then break; end_if;
    t := map(t, e -> op(e)=0);
    zeroes := zeroes union {op(t)};
    eqs := subs(eqs, zeroes);
    eqs := select(eqs, _not@iszero);
    if select(eqs, _not@has, ts) <> [] then
      // equation not zero, but does not depend on vars to solve for?
      return(FAIL);
    end_if;
  end_while;
  sol := numeric::linsolve(eqs, select(ts, t -> not has(zeroes, t)), 
                           Symbolic, NoWarning);
                           
  if _and(op(map(sol, eq -> testtype(op(eq, 2), Type::Rational)))) then
    return([op(zeroes)].sol);
  end_if;
  linsolve_params := numeric::indets(sol) minus numeric::indets([args()]);
  // using depth-first search, replace all non-rational constants in the
  // solution by new identifiers:
  r := solvelib::getIdent(Any, indets({sol, args()}));
  i := 0;
  f :=
  proc(x)
    option remember;
  begin
    if testtype(x, Type::Rational) then x
    elif testtype(x, Type::Constant) then
      i := i+1;
      r[i];
    else x end_if;
  end_proc:
  sol := misc::maprec(sol, TRUE=f);
  substs := select([op(op(f, 5))], _not@bool);
  // strictly speaking, at this place, we should try and find 
  // rational dependencies between the entries, e.g. ln(2) and ln(4).
  
  if nops(substs) = 0 then return(FAIL); end_if;
  // all the identifiers in the solution but not in the input
  // can be adjusted to yield rational solutions.
  nonrat_idents := map(substs, op, 2);
  // the coefficients in front of these non-rationals in the solution must be zero.
  eqs2 := map({op(sol)}, op, 2);
  eqs2 := map(eqs2, poly, nonrat_idents);
  if has(map(eqs2, poly2list), nonrat_idents) then return(FAIL); end_if;
  eqs2 := map(eqs2, p -> p - poly(coeff(p, [0$nops(nonrat_idents)]), nonrat_idents));
  eqs2 := map(eqs2, coeff);
  
  sol2 := intlib::algebraic::linsolve([op(eqs2)], ts.[op(linsolve_params)]);
  
  if sol2 = FAIL then
    return(FAIL);
  end_if;

  sol := subs(sol, sol2, map(nonrat_idents, `=`, 0));
  [op(zeroes)].select(sol.sol2, eq -> contains(ts, op(eq, 1)) > 0);
end:
