// reduce a rational expression mod simple algebraic dependencies
//
// input can be an expression or a polynomial. 

intlib::algebraic::reduceModAlgebraics :=
proc(f, ts, diffs, algs)
  local i, t, ts_algs, a, n;
begin
  ts_algs := select([$1..nops(ts)],
    i -> _lazy_and(algs[i] <> [], algs[i][1] = "simpleradical"));
  if ts_algs = [] then
    return(f);
  end_if;
  
  if domtype(f) = DOM_POLY then
    f := mapcoeffs(f, intlib::algebraic::reduceModAlgebraics, ts, diffs, algs);
    ts_algs := select(ts_algs, i -> contains(op(f, 2), ts[i])>0);
    if ts_algs = [] then
      return(f);
    end_if;
  end_if;

  for i in revert(ts_algs) do
    t := ts[i];
    [n, a] := algs[i][2..3];
    a := poly(t^n-a, [t]);
    if domtype(f) = DOM_POLY then
      a := poly(a, op(f, 2));
      f := divide(f, a, Rem);
    else
      f := intlib::algebraic::normal(f, [t]);
      f := map(f, divide, a, Rem);
      f := expr(f[1])/expr(f[2]);
    end_if;
  end_for;

  f;
end_proc:
