/*--
intlib::defInt( f,x=a..b, options )

--*/

// tests xrng used to be x=a..b
intlib::xrngTest:=
  proc(xrng)
    name intlib;
  begin
    if type(xrng) <> "_equal" then
       error("Second argument must be of form x=a..b")
    elif domtype(op(xrng,1)) <> DOM_IDENT then
       error("Integration variable is not an identifier")
    elif type(op(xrng,2)) <> "_range" then
       error("Second argument must be of form x=a..b")
//    elif has(op(xrng,2), op(xrng,1)) then
//       error("Range depends upon integration variable")
    end_if;
    null()
  end_proc:

// main procedure for definite integration
intlib::defInt:=
prog::remember
(
 proc(f :Type::Arithmetical, xrng) // options
      local prop,C,F,Ft,options,x,a,b,f0,x0,a0,b0,vorz, tmp, Float, Ima, Imb,
        lfa, lfb, y;
      save _X_; // necessary to make assumption on integration variable
                // I choose _X_ instead of _X as in intlib::int, since this is
                // more efficient if intlib::int is called
      name intlib::defInt;
    begin
    f0:=f;
//    if testargs() then f:=eval(f); intlib::xrngTest(xrng) end_if;

    x:=op(xrng,1); a:=op(op(xrng,2),1); b:=op(op(xrng,2),2);
    options:=intlib::getOptions(args(3..args(0)));
    
    [a0, b0] := [a, b];
    
    // empty range
    if iszero(b - a) then
      userinfo(1, "definite lookup: found empty range, result is 0");
      return(0)
    end_if;

    // transform to real range
    if {a, b} intersect {infinity+I*infinity, infinity-I*infinity,
                         -infinity+I*infinity, -infinity-I*infinity} <> {} then
      error("Invalid border")
    end_if;
    Ima:= Im(a);
    Imb:= Im(b);

    if is(Ima = 0 and Imb = 0) = FALSE then
      y := solvelib::getIdent(R_, indets([args()]));
      if has({Ima, Imb}, infinity) then
        if Re(a) <> Re(b) then
          error("Real parts must be equal")
        end_if;
    // make int(f(x), x= c+I*Ima...c+I*Imb) into
    //    I*int(f(c+I*y), y=Ima..Imb)
        return(I*intlib::defInt(subs(f, x=Re(a)+I*y, EvalChanges),
          y=Ima..Imb, table(options, NoWarning=TRUE)));
      else
        // finite range
        // in int(f(x), x=a..b), substitute y=(x-a)/(b-a), obtaining
        //    int(f((b-a)*y + a) *(b-a), y=0..1)
        return((b-a)*intlib::defInt(subs(f, x=(b-a)*y+a, EvalChanges), y=0..1,
          table(options, NoWarning=TRUE)));
      end_if;
    else
      vorz:=1;
    end_if;
 
    if is(a > b, Goal=TRUE) or is(a <= b, Goal=FALSE)=FALSE then
      vorz := -vorz;
      [a, b] := [b, a];
    end;

    assume(a <= x <= b, _and);

 
    //----------------------------------------------
    // Changed by Walter, 13.12.05:
    // Move the call of diracInt to this place.
    // Later, x will be substituted by _X_ which
    // is assumed to lie in the open interval (a, b),
    // so that int(dirac(_X_), _X_ = a..b) does not
    // see the boundaries and returns 0.
    //----------------------------------------------
    if has(f, dirac) then
       tmp:= intlib::diracDef(f, x, a, b, options);
       if tmp <> FAIL then
          return(vorz*tmp);
       else
          return(hold(int)(f0, x=a0..b0, intlib::printOptions(options)));
       end_if;
    end_if;
    //----------------------------------------------
    // end of change by Walter
    //----------------------------------------------
    
    if traperror((tmp := intlib::defInt_rational(f, x, a, b, options))) = 0
      and tmp <> FAIL then
      if domtype(tmp) = piecewise then
        tmp := piecewise::disregardPoints(tmp, {x});
      end_if;
      return(vorz*tmp);
    end_if;

    if traperror((tmp := intlib::residueInt(f, x, a, b, options))) = 0
      and tmp <> FAIL then
      if domtype(tmp) = piecewise then
        tmp := piecewise::disregardPoints(tmp, {x});
      end_if;
      return(vorz*tmp);
    end_if;

    C := null();
    if x = _X_ then
      if property::hasprop(x) then // x has property
        prop:=Dom::Interval(a,b);
        if getprop(x) intersect prop <> prop
        then // properties may be inconsistent
          if intlib::printWarningsFlag and options[NoWarning]<>TRUE then
            warning("While integrating, we will assume ".strprint(NoNL, x).
                    " has property ".strprint(NoNL, prop).
                    " instead of given property ".strprint(NoNL, getprop(x)).".");
          end_if;
          unassume(x);
        end_if;
      end_if;
      assumeAlso(a < x < b);
    else
//      if has([args()], [_X_]) or property::hasprop(_X_) then
        C:=genident("__X");
        if property::hasprop(_X_) then
          assumeAlso(_and(op(subs(property::showprops(_X_), _X_=C)))):
        end_if;
//      end_if;
      delete _X_;
      if property::hasprop(x) then // x has property
        prop:=Dom::Interval(a,b);
        if getprop(x) intersect prop=prop
          then
          assumeAlso(_X_ in prop); // properties are consistent
        else // properties may be inconsistent
          if intlib::printWarningsFlag and options[NoWarning]<>TRUE then
            warning("While integrating, we will assume ".strprint(NoNL, x).
                    " has property ".strprint(NoNL, prop).
                    " instead of given property ".strprint(NoNL, getprop(x)).".");
          end_if;
          assumeAlso(_X_ in prop);
        end_if;
      else
        assumeAlso(a < _X_ < b);
      end_if;

      if has(f,int) then
        // in that case the following subs of this procedure may lead to
        // a wrong result, since different integration variables may become
        // the same
        if getprop(_X_)=Dom::Interval(a,b) then
          // perhaps it is now possible to solve the nested integrals
          x0:=genident("_X_");
          zip([x0],[Type::Interval(a,b)],assume);
          f:=subs(f,x=x0,EvalChanges);
          if has(f,int) then
            return(vorz*hold(int)(f0,x=a..b,intlib::printOptions(options)))
          end_if;
          f:=subs(f,x0=x,EvalChanges);
          delete x0;
        else
          return(vorz*hold(int)(f0,x=a..b,intlib::printOptions(options)))
        end_if;
      end_if;

//    f := intlib::Simplify(f, options, Steps=10);
//    // this may create a piecewise object
//    if f::dom::int <> FAIL then
//      return(f::dom::int(f, x=a..b, intlib::printOptions(options)));
//    end_if;

      if C <> null() then
        f:=subs(f,[_X_=C,x=_X_],EvalChanges);
//      f:=Simplify(f, Steps=10);
        a:=subs(a,[_X_=C/* ,x=_X_ */]);
        b:=subs(b,[_X_=C/* ,x=_X_ */]);
      
        // for easier backsubstitution
        C := C = _X_;
      end_if;
    end_if;

    tmp:=f;
    f:=misc::maprec(f, {DOM_FLOAT,DOM_COMPLEX}=(x->numeric::rationalize(x,Minimize)));
    Float:=if f<>tmp then float else id end_if;

    // trying to integrate a sum term by term first
    // is in general a *good* idea.
    // Beware: int( (heaviside(x - x0) - heaviside(x - x1))*f(t), x = -infinity..infinity)
    //         = int(f(t), x = x0 .. x1).
    // Here, int(heaviside(x - x0)*f(t), -infinity .. infinity) may be undefined!
    // We need to do some work here!
    Ft := intlib::defInt_termByTerm(f, _X_, a, b, options);
    if Ft = FAIL or has(Ft, int) or has(Ft, hold(int)) or has(Ft, undefined) or
      // could be something like z*infinity - infinity, i.e., undefined
      (has(Ft, infinity) and Ft <> infinity and Ft <> -infinity)
      then
      F:=intlib::defInt_intern(f,_X_=a..b,options);
      if Ft = FAIL or has(Ft, undefined) or
        not has(F, int) or
        Simplify::defaultValuation(F) < Simplify::defaultValuation(Ft) then
        Ft := F;
      end;
    else
      F := Ft;
    end_if;
    
    if domtype(Ft) = piecewise then
      Ft := piecewise::disregardPoints(Ft, {x});
      if Ft = undefined then Ft := FAIL; end_if;
    end_if;

    if Ft = FAIL then
      if a = -infinity and b <> infinity then
        lfa := intlib::limit(_X_*f, _X_=a);
        if is(lfa = 0)=FALSE then
          // divergent. undefined or +/-infinity?
          tmp := discont(f, _X_=a..b) minus {a,b};
          if domtype(tmp) = DOM_SET then
            Ft := intlib::limit(f*(_X_-b), _X_=b, Left)-sign(lfa)*infinity +
              _plus(op(map(tmp, x0 -> intlib::limit(f*(_X_-x0), _X_=x0, Left)
                                    - intlib::limit(f*(_X_-x0), _X_=x0, Right))));
          end_if;
        end_if;
      end_if;
      if Ft = FAIL and b = infinity and a <> -infinity then
        lfb := intlib::limit(_X_*f, _X_=b);
        if is(lfb = 0) = FALSE then
          // divergent. undefined or infinity?
          tmp := discont(f, _X_=a..b) minus {a,b};
          if domtype(tmp) = DOM_SET then
            Ft := sign(lfb)*infinity - intlib::limit(f*(_X_-a), _X_=a, Right) +
              _plus(op(map(tmp, x0 -> intlib::limit(f*(_X_-x0), _X_=x0, Left)
                                    - intlib::limit(f*(_X_-x0), _X_=x0, Right))));
          end_if;
        end_if;
      end_if;
      if Ft = FAIL and a=-infinity and b=infinity then
        lfa := intlib::limit(_X_*f, _X_=a);
        lfb := intlib::limit(_X_*f, _X_=b);
        if is(lfa*lfb > 0, Goal=TRUE) then
          // divergent
          Ft := undefined;
        elif is(lfa*lfb < 0, Goal=TRUE) then
          tmp := discont(f, _X_=a..b) minus {a,b};
          if domtype(tmp) = DOM_SET then
            Ft := sign(lfb)*infinity +
              _plus(op(map(tmp, x0 -> intlib::limit(f*(_X_-x0), _X_=x0, Left)
                                    - intlib::limit(f*(_X_-x0), _X_=x0, Right))));
          end_if;
        end_if;
      end_if;
      // we've just added a few limits up there
      if Ft = undefined and options[PrincipalValue] = TRUE then
        Ft := FAIL;
      end_if;
    end_if;
    
//    if type(F)<>"int" then
    // avoid aliasing problems, g520729
    Ft := misc::maprec(Ft,
      {"limit"} = (l ->
        if has(op(l, [2, 2]), [_X_, x]) then
          subs(l, _X_ = solvelib::getIdent(R_, indets({l, f, Ft, x})), Unsimplified)
        else l end_if),
      Unsimplified);
    if _X_ <> x then
      Ft:=subs(Ft,[_X_=x,C], Unsimplified);
    end_if;

    if domtype(Ft) = piecewise then
      Ft := piecewise::disregardPoints(Ft, {x});
      if Ft = undefined then Ft := FAIL; end_if;
    end_if;

%if FALSE then // testeq uses expand, which can be very expensive
    if _X_ <> x then
      F:=subs(F,[_X_=x,C], Unsimplified);
    end_if;
    if F = FAIL or has(F,int) then
    // use symmetries unless integrand contains symbolic int
      if not has(f, hold(int)) and
         {a,b} intersect {infinity, -infinity, RD_INF, RD_NINF} = {} then
        c := (a+b)/2;
        if traperror((fc := subs(f, x=c,EvalChanges))) = 0 then
          if intlib::isodd(f, x, c, fc) then
            userinfo(2, "integrand is odd around ".expr2text(c));
            return(Float(vorz * fc * (b-a)));
          end_if;
          if intlib::iseven(f, x, (a+b)/2) then
            userinfo(2, "integrand is even around ".expr2text(c));
            return(Float(vorz * 2 * intlib::defInt(f, x=c..b, args(3..args(0)))));
          end_if;
        elif options[PrincipalValue] then
          if intlib::iseven(f, x, (a+b)/2) then
            userinfo(2, "integrand is even around ".expr2text(c));
            return(Float(vorz * 2 * intlib::defInt(f, x=c..b, args(3..args(0)))));
          end_if;
        end_if;
      end_if;

      if not hastype(F, piecewise) then
        F:=hold(int)(Float(f0),x=a0..b0,
                     intlib::printOptions(options));
      end_if;
    end_if;
end_if;
    if Ft=FAIL then
      return(hold(int)(Float(f0),x=a0..b0,
                       intlib::printOptions(options)));
    end_if;
    Float(vorz*Ft)
  end_proc, () -> [//Pref::experimentalInt(),
		 property::depends([args()])],
     PreventRecursion,
     ((f, xrn) -> hold(int)(f, xrn, intlib::printOptions(intlib::getOptions(args(3..args(0))))))):

intlib::defInt_termByTerm :=
proc(f, x, a, b, options)
  local f0, e, i, r, r2;
  save MAXEFFORT;
begin
  f0:=f;
  if type(f)="_mult" and contains(map({op(f)},type),"_plus") then
//      f:=expand(f)
    f := [op(f)];
     // find the first sum in the operands, expand
    for i from 1 to nops(f) do
      if type(f[i]) = "_plus" then
        e := f[i];
        delete f[i];
        f := `*`(op(f));
        f := map(e, `*`, f);
        break;
      end_if;
    end_for;
  end_if;
  if type(f)="_plus" then
    MAXEFFORT := min(MAXEFFORT, 1.5*MAXEFFORT/(nops(f)));
    r:=0;
    r2 := 0;
    for e in [op(f)] do
      i:=intlib::defInt(e, x=a..b, options);
      if hastype(i,"int") or hastype(i, "limit") or has(i, [infinity, RD_INF, RD_NINF]) then
        r2 := r2+e;
      else
        r:=r+i
      end_if
    end_for;
    if r=undefined then
      return(FAIL);
    end_if;
    if iszero(r2) then
      return(r);
    else
      if iszero(r) or has(r, [infinity, RD_INF, RD_NINF, undefined]) then
        return(FAIL);
      end_if;
      return(r+int(r2, x=a..b, intlib::printOptions(options)));
    end_if;
  end_if;
  FAIL
end_proc:

// try analyzing rational functions before going into indefinite integration etc.
// most of this only works for constant coefficients
// This routine actually only detects a couple of obvious cases of infinity and undefined
// but it also handles polynomial inputs
intlib::defInt_rational :=
proc(f, x, a, b, options)
  local num, den, zeroes, x0, integral, la, lb, F;
begin
  if testtype(f, Type::RatExpr(x, Type::IndepOf(x))) then
    if testtype(f, Type::PolyExpr(x, Type::IndepOf(x))) then
      if a = -infinity and b = infinity then
        if options[PrincipalValue] = TRUE then
          a := 0;
          f := f + (f | x=-x);
        else
          return(FAIL);
        end_if;
      end_if;
      
      F := poly(f, [x]);
      if domtype(F) = DOM_POLY then
        F := int(F, x);
        return(eval(F(b) - F(a)));
      end_if;
    end_if;
    [num, den] := normal(f, List, Expand = FALSE);
    integral := 0;
    zeroes := solve(den, x=a..b,
      if options[IgnoreAnalyticConstraints]=TRUE then IgnoreAnalyticConstraints end_if);
    if domtype(zeroes) = DOM_SET then
      for x0 in zeroes minus {a, b} do
        // how expensive is this limit call really?
        // It should not be too bad, and we would otherwise
        // need to do pretty much a complete limit calculation ourselves.
        integral := integral + limit(f, x=x0, Real);
        if hastype(integral, "limit") then
          return(FAIL);
        end_if;
        if integral = undefined then
          if options[PrincipalValue] = TRUE then
            return(FAIL); // we probably could do better, but this isn't wrong
          end_if;
          return(integral);
        end_if;
      end_for;
      if b-a = infinity then
        la := limit(f, x=a, Right);
        lb := limit(f, x=b, Left);
        if is(la > 0, Goal=TRUE) and a = -infinity or la = infinity then
          integral := integral + infinity;
        elif is(la < 0, Goal=TRUE) and a = -infinity or la = -infinity then
          integral := integral - infinity;
        end_if; 
        if is(lb > 0, Goal=TRUE) and b = infinity or lb = infinity then
          integral := integral + infinity;
        elif is(lb < 0, Goal=TRUE) and b = infinity or lb = infinity then
          integral := integral - infinity;
        end_if;
      end_if;
      if has(integral, infinity) or
        (integral = undefined and options[PrincipalValue] <> TRUE) then
        return(integral);
      end_if;
    end_if;
  end_if;
  FAIL;
end_proc:


intlib::defInt_intern :=
  proc(f,xrng)  // options
    local i,res,tmp,g,fac,options,x,b,a,hf, ret, evalhull,
      tmp2, method, methods, backHand, cond;
    save _X_; // to make prog::check happy.  already saved by our caller.
  begin
//    if testargs() then f:=eval(f); intlib::xrngTest(xrng) end_if;

    if f = undefined then
      return(undefined)
    end_if;
    x:=op(xrng,1); a:=op(op(xrng,2),1); b:=op(op(xrng,2),2);
    options:=intlib::getOptions(args(3..args(0)));
    if testtype(f,Type::PolyExpr(x)) and not options[PrincipalValue] then
       // no singularity possible
       f:=poly(f,[x]);
       f:=_plus(coeff(f,i)*x^(i+1)/(i+1) $ i=0..degree(f));
       return(intlib::int_eval(f,x=b)-intlib::int_eval(f,x=a))
    elif is(b<a)=TRUE then
       return(-intlib::defInt_intern(f,x=b..a,options))
    end_if;

    // dirac must not reach some of the functions below
    if has(f, hold(dirac)) then return(intlib::diracDef(f, x, a, b, options)); end_if;

    // utility function: hull(f | _X_=u...v)
    evalhull := proc(f, u, v)
                  local iv;
                begin
                  iv := u...v;
                  hull(interval::evalSimple(f, _X_=iv));
                end_proc;

    // integrand bounded away from zero over infinite interval?
    if a = -infinity and b <> infinity and is(b > -infinity)=TRUE then
      ret := FAIL;
      if traperror((hf := evalhull(f, RD_NINF, -1e100);
                    if min(hf,10^(2-DIGITS)) = 10^(2-DIGITS) then
                      ret := infinity;
                    elif max(hf,-10^(2-DIGITS)) = -10^(2-DIGITS) then
                      ret := -infinity;
                    end_if)) = 0 and ret <> FAIL then
        return(ret);
      end_if;
    end_if;
    if b = infinity and a <> -infinity and is(a < infinity)=TRUE then
      ret := FAIL;
      if traperror((hf := evalhull(f, 1e100, RD_INF);
                    if min(hf, 10^(2-DIGITS)) = 10^(2-DIGITS) then
                      ret := infinity;
                    elif max(hf, -10^(2-DIGITS)) = -10^(2-DIGITS) then
                      ret := -infinity;
                    end_if)) = 0 and ret <> FAIL then
        return(ret);
      end_if;
    end_if;

    // handle int(positive(x)/x, x=0..t) and similar
    if is(b>a) = TRUE and traperror((hf := evalhull(f, a, b))) = 0 and
       (op(hf, 1) = RD_NINF or op(hf, 2) = RD_INF) then
      ret := FAIL;
      // avoid missing other poles
      if traperror((hf := evalhull(eval(f*(_X_-a)), a, b)))
         = 0 and op(hf, 0) = hold(hull) and
         op(hf, 1) > RD_NINF and op(hf, 2) < RD_INF then
        ret := FAIL;
        if traperror((hf := evalhull(eval(f*(_X_-a)),
                               a, (a+(b-a)*10^(3-DIGITS)));
                      if min(hf,10^(2-DIGITS)) = 10^(2-DIGITS) then
                        ret := infinity;
                      elif max(hf,-10^(2-DIGITS)) = -10^(2-DIGITS) then
                        ret := -infinity;
                      end_if)) = 0 and ret <> FAIL then
          return(ret);
        end_if;
      end_if;
      if traperror((hf := evalhull(eval(f*(b-_X_)), a, b)))
         = 0 and op(hf, 0) = hold(hull) and
         op(hf, 1) > RD_NINF and op(hf, 2) < RD_INF then
        ret := FAIL;
        if traperror((hf := evalhull(eval(f*(b-_X_)),
                                 (b-(b-a)*10^(3-DIGITS)), b);
                      if min(hf,10^(2-DIGITS)) = 10^(2-DIGITS) then
                        ret := infinity;
                      elif max(hf,-10^(2-DIGITS)) = -10^(2-DIGITS) then
                        ret := -infinity;
                      end_if)) = 0 and ret <> FAIL then
          return(ret);
        end_if;
      end_if;
    end_if;

    // frac(x) = x-floor(x)
    f := subs(f, hold(frac)=(x->x-floor(x)),EvalChanges);

    // functions containing ceil/floor are handled by this function:
    if has(f, {hold(ceil), hold(floor), hold(round),
               hold(heaviside)}) then
      i := intlib::defInt_ceil_floor(f, x, a, b, options);
      if i <> FAIL then return(i); end_if;
    end_if;
    // abs(real stuff) is also handled by partitioning the interval
    if has(f, {hold(abs), hold(surd), hold(sign)}) then
      i := intlib::defInt_abs(f, x, a, b, options);
      if i <> FAIL then return(i); end_if;
    end_if;

    // rewrite sign to rectform
    f := subs(f, hold(sign)=(x -> intlib::Simplify(expr(rectform(sign(x))), options)),EvalChanges);
    if has(f, {hold(abs), hold(surd), hold(sign)}) then
      return(intlib::antiderivative(f, x=a..b, options));
    end_if;

    // first try the lookup method
    // remove constant factors before lookup method
    if type(f)="_mult" then
      g:=select(f,has,x); fac:=select(f,not has,x)
    else g:=f; fac:=1
    end_if;

    methods := [()->(intlib::definite(g,a,b,options)*fac),
      ()->(if fac = -1 then tmp:=intlib::definite(f,a,b,options); else FAIL; end_if),
      ()->(intlib::specialFunctionDef(g,x,a,b,options)*fac),
      proc() local res; begin
        res:=intlib::antiderivative(g,x=a..b,options);
        if type(res)="int" then
          return(FAIL);
        else
          return(res*fac);
        end_if;
      end_proc,
      ()->(meijerG::convolutionInt(g,x=a..b)*fac)];
    backHand := [];

    res := FAIL;
    for method in methods do
      tmp:=method();
      if type(tmp)="int" then next; end_if;
      if tmp=FAIL then next; end_if;

      /* Boese Ergebnisse rausfiltern */
      if type(tmp)=piecewise then
        tmp2 := split([op(tmp)],X->hastype(op(X,2), "hypergeom"));
        if nops(tmp2[1])>0 then
          backHand := backHand.[op(tmp2[1])];
          if nops(tmp2[2])>0 then
            tmp := piecewise(op(tmp2[2]));
          else
            next;
          end_if;
        end_if;
      else
        if hastype(tmp, "hypergeom") then
          backHand := backHand.[[TRUE, tmp]];
          next;
        end_if;
      end_if;

      if type(res)=piecewise and type(tmp)=piecewise then
        res:=piecewise::_concat(res,tmp);
      else
        res:=tmp;
      end_if;
      if type(res)<>piecewise or
        piecewise::isDefined(res)=TRUE then
        return(res)
      end_if;
    end_for;

    /* Wenn wir hier sind, haben wir noch kein allgemeingueltiges Ergebnis */
    if nops(backHand)<>0 then
      if res=FAIL then
        res := piecewise(op(backHand));
      elif type(res)=piecewise then
        cond := not(_or(op(map([op(res)], op, 1))));
        tmp := piecewise(op(map(backHand, X->[X[1] and cond, X[2]])));
        res := piecewise::_concat(res, tmp);
      end_if;
    end_if;

    if type(res)=piecewise then
      res:=piecewise::fillCases(res, intlib::frozenInt(f,x=a..b,intlib::printOptions(options)));
    end_if;

    if hastype(res, "limit") then
      return(res);
    else
      if has(res, I) and freeIndets(res)={} and
        traperror((ret := expr(rectform(res))), MaxSteps=10)=0 and
        intlib::Simplify::defaultValuation(ret) < intlib::Simplify::defaultValuation(res) then
        res := ret;
      end_if;
      return(intlib::Simplify(res, options));
    end_if;
  end_proc:

intlib::antiderivative :=
  proc(f :Type::Arithmetical,xrng) // options
    save calledFromWithinDefInt;
    local g,g0,s,y,eps,lr,ia,ib,x,a,b,options,treat_disconts,i,j;
  begin

    // first do some tests and extract from arguments
    if testargs() then f:=eval(f); intlib::xrngTest(xrng) end_if;

    x:=op(xrng,1); a:=op(op(xrng,2),1); b:=op(op(xrng,2),2);
    options:=intlib::getOptions(args(3..args(0)));

    // set flag to prevent some simplifications done in indefinite integration
    sysassign(calledFromWithinDefInt,TRUE);

    // compute the antiderivative
    g:=intlib::int(f,x,options);
    
//    if hastype(g, "int") then
//      g := Simplify(g);
//    end_if;
//    if hastype(g, "int") then
//      return(hold(int)(f,x=a..b,intlib::printOptions(options)));
//    end_if;
    
    // try to evaluate a sum(....z=RootOf(..))
    g0:=g;
    if type(g)="sum" then
      g0:=intlib::expandSum(g,x);
    elif has(g,sum) then
      g0:=map(g,intlib::expandSum,x);
    end_if;
    // test heuristically, if complexity of g0 is not too big,
    // otherwise exponential growth in memory usage may occur
    if length(g)*intlib::memGrowthFactor > length(g0) then g:=g0 end_if;
//    if has(g,I) then
//      g:=intlib::simplifyComplexIntegral(g,x,hold(Unique));
//    end_if;

    // substitute remaining two-argument arcus tangents
    // otherwise we could run into a bad branch and getting a wrong answer
    if has(g,arctan) then
      g:=subs(g,hold(arctan)=proc(x,y)
                                  begin
                                    if args(0)=1 then
                                      arctan(x)
                                    else
                                      -I * ln((x+I*y)/(abs(x+I*y)))
                                    end_if
                                  end_proc,
                                  EvalChanges);
    end_if;
    if has(g,arg) then
      g:=subs(g,hold(arg)=proc(x,y)
                          begin
                            if args(0)=1 then
                              -I * ln(x/abs(x))
                            else
                              -I * ln((x+I*y)/(abs(x+I*y)))
                            end_if
                          end_proc,
                          EvalChanges);
    end_if;

    userinfo(2,"antiderivative is",g);
    if not hastype(g, "int") and g<>NIL then
      if options[Continuous] then // g is assumed to be continuous
        if not has({a, b}, {infinity, -infinity}) then
          if traperror((g0 := (intlib::int_eval(g,x=b)
                               -intlib::int_eval(g,x=a))),
                        MaxSteps=intlib::discontMaxSteps(g, x, a, b)) = 0 then
            return(g0);
          end_if;
          if traperror(((g0 := intlib::limit(g, x=b, Right)
                             - intlib::limit(g, x=a, Left))))=0 then
            return(g0);
          end_if;
          return(hold(int)(f,x=a..b,intlib::printOptions(options)));
        end_if;
        s:={};
        userinfo(2,"antiderivative is assumed to be continuous");
      else
        // discontinuities in a..b
        // for finding discontinuities, we expand RootOf:
        g0 := misc::maprec(g,
                           {RootOf} =
                           (rof -> solve(op(rof, 1), op(rof, 2),
                                         if options[IgnoreAnalyticConstraints]=TRUE then IgnoreAnalyticConstraints end_if,
                                         MaxDegree=4, IgnoreSpecialCases)));
        if hastype(g0, "sum") then
          g0:= eval(g0);
        end_if;

        if hastype(g, "sum") or hastype(g0,RootOf) or has(f, dirac) then // this would yield an error within discont
          s:=Type::Interval(a,b);
        else
          traperror((g0:=intlib::Simplify(g0, options, Steps=50, KernelSteps=5)),
                    MaxSteps=intlib::simplifyMaxSteps(f, g, discont));
          userinfo(2,"searching for discontinuities of ",g0,"in ",a..b);
          // discont sometimes(!) is way happier getting lns
          if traperror((s:=intlib::discont(g0, x=a..b)),
                       MaxSteps=intlib::discontMaxSteps(g0, x, a, b)) <> 0 
            and (not has(g0, hold([arctan, arctanh])) or
              traperror((s:=intlib::discont(rewrite(g0, ln), x=a..b)),
                       MaxSteps=intlib::discontMaxSteps(g0, x, a, b)) <> 0)
            then
            if intlib::printWarningsFlag and options[NoWarning]<>TRUE then
              warning("Could not determine discontinuities within reasonable time")
            end_if;
            s:= Type::Interval(a, b)
          end_if;
          if hastype(s, Dom::Interval) and has(g0, hold([arctan, arctanh])) then
            traperror((s:=intlib::discont(rewrite(g0, ln), x=a..b)),
                       MaxSteps=intlib::discontMaxSteps(g0, x, a, b));
          end_if;
        end_if;
      end_if;
      // it can happen that discont fails to detect that it returned
      // the same point multiple times. Ensure this does not happen:
      if type(s) = DOM_SET then
        s := intlib::Simplify(s, options, KernelSteps=intlib::discontMaxSteps(g0, x, a, b));
        // esp. with IgnoreAnalyticConstraints, this simplification may cause
        // entries in s (discontinuities) to lie outside the interval of integration
        s := select(s, x0 -> is(a <= x0 <= b, Goal=FALSE) <> FALSE);
        s := [op(s)];
        for i from 1 to nops(s)-1 do
          for j from i+1 to nops(s) do
            if j > nops(s) then break end_if; // nops(s) can change within the loop
            if 0 in hull(s[i]-s[j]) then
              eps := intlib::Simplify(s[i]-s[j], options,
                KernelSteps=floor(intlib::discontMaxSteps(g0, x, a, b)/6));
              if iszero(eps) then
                delete s[j];
                j := j-1;
              elif bool(0 in interval(eps)) = TRUE then
                if intlib::printWarningsFlag and options[NoWarning]<>TRUE then
                  warning("Can't ensure that discontinuities of the antiderivative are distinct.");
                end_if;
                return(FAIL);
              end_if;
            end_if;
          end_for;
        end_for;
        s := {op(s)};
      end_if;
      userinfo(2,"potential discontinuities of the antiderivative are",s);
      if type(s) <> DOM_SET and
         type(s) <> piecewise then
        if intlib::printWarningsFlag and options[NoWarning]<>TRUE then
          if length(expr2text(s)) < 50 then
            warning("potential discontinuities of the antiderivative are:\n ".
                    expr2text(s));
          end_if;
          warning("Found potential discontinuities of the antiderivative.".
                  "\nTry to use properties (?assume).");
        end_if;
      end_if;
      treat_disconts :=
      proc(s)
        name intlib::antiderivative::treat_disconts;
        local integral;
      begin
        if type(s) = DOM_SET then
          if options[PrincipalValue] then
            // both limits should be done at the same time. transform to eps->0, Right:
            eps:= genident("eps");
            if a=-infinity then
              ia := subs(g, x=-1/eps);
            else
              ia := subs(g, x=a+eps);
            end_if;
            if b=infinity then
              ib := subs(g, x=1/eps);
            else
              ib := subs(g, x=b-eps);
            end_if;
            lr := intlib::boundaryTest(ib-ia, eps=0, Right);
            if not lr[1] and intlib::printWarningsFlag and options[NoWarning]<>TRUE then
              warning("Antiderivative is unbounded at borders");
            end_if;
            integral := lr[2];
          else
            ia := FAIL;
            if not (a in s or has(a, infinity)) then
              // g is continuous at x=a, therefore bounded.
              // still, discont doesn't treat x*arctan(1/x)
              // as discontinuous at x=0, and we can get errors evaluating:
              traperror((ia := evalAt(g, x=a)));
            end_if;
            if ia = FAIL then
              lr:=intlib::boundaryTest(g,x=a,Right);
              if not lr[1] and intlib::printWarningsFlag and options[NoWarning]<>TRUE then
                warning("Antiderivative is unbounded at lower limit");
              end_if;
              ia:=lr[2];
            end_if;

            ib := FAIL;
            if not (b in s or has(b, infinity)) then
              traperror((ib := evalAt(g, x=b)));
            end_if;
            if ib = FAIL then
              lr:=intlib::boundaryTest(g,x=b,Left);
              if not lr[1] and intlib::printWarningsFlag and options[NoWarning]<>TRUE then
                warning("Antiderivative is unbounded at upper limit");
              end_if;
              ib:=lr[2];
            end_if;

            integral:=ib-ia;
          end_if;
          
          s:=s minus {a,b};
          for y in s do
            if options[PrincipalValue] then // compute principal value
              eps:= genident("eps");
              integral:=integral
                       +intlib::limit(subs(g,x=y-eps)-subs(g,x=y+eps),
                                      eps=0,Right);
            else
              lr:=intlib::poleLRTest(g,x=y);
              if lr[1] then integral:=integral+lr[2]-lr[3];
              //else return(hold(int)(f,x=a..b))
              // otherwise there should not be a discontinuity
              end_if;
            end_if
          end_for;
          if not hastype(integral, {"int", "limit"}) then
            traperror((integral := Simplify(integral, Steps=30)),
                      MaxSteps=intlib::simplifyMaxSteps(f, integral, return));
          end_if;
          return(integral);
        else
          integral := intlib::frozenInt(f, xrng, intlib::printOptions(options));
        end_if;
      end_proc;
      // discont sometimes returns discontinuities clearly outside the range given.
      s := s intersect Dom::Interval([a], [b]);
      if type(s) <> piecewise then return(subs(treat_disconts(s), hold(intlib::frozenInt)=hold(int))); end_if;
      s := piecewise::extmap(s, treat_disconts);
      if type(s) <> piecewise then return(subs(s, hold(intlib::frozenInt)=hold(int))); end_if;
      s := piecewise::selectExpressions(s, _not@hastype, "int");
      if type(s) = piecewise then s := piecewise::selectExpressions(s, _not@has, hold(intlib::frozenInt)); end_if;
      if type(s) = piecewise then s := piecewise::selectExpressions(s, `<>`, FAIL); end_if;
      if type(s) = piecewise then s := piecewise::selectConditions(s, _not@has, [x]); end_if;
      // genuine undefined would have been returned above.
      // Here, we have an ex-piecewise where we just discarded branches we don't like.
      if type(s) <> piecewise and s <> undefined then
        return(subs(s, hold(intlib::frozenInt)=hold(int)));
      end_if;
      return(piecewise::fillCases(subs(s, hold(intlib::frozenInt)=hold(int)),
        hold(int)(f,x=a..b,intlib::printOptions(options))));
    end_if;
    if a=b then 0 else hold(int)(f,x=a..b,intlib::printOptions(options)) end_if
  end_proc:

intlib::boundaryTest:= // test, if lower or upper bound of given range is
  proc(f,x,dir)        // bounded
    local t,r;
  begin
    userinfo(6,"test, if antiderivative is bounded at ".expr2text(x));
    r:=intlib::limit(f,x,dir);
  //t:=(if has(r,{infinity,-infinity,undefined}) then FALSE else TRUE end_if);
    t:=not(bool(has(r,{infinity,-infinity,undefined})));
    [t,r]
  end_proc:

intlib::poleLRTest:=  // test, if limit's result is correct most probably
  proc(f,x)           // for inner discontinuous points
    local r,t,s;
  begin
    userinfo(6,"test, if antiderivative is indeed discontinuous at ".
               (s:=expr2text(x);));
    //if type(op(x,2))=stdlib::Infinity then
    if has(op(x,2),{infinity,-infinity}) then
      r:=intlib::limit(f,x);
      r:=[r,r];
    else
      r:=[intlib::limit(f,x,Left),intlib::limit(f,x,Right)]
    end_if;
    //t:=(if has(r,{infinity,-infinity,undefined}) or r[1]<>r[2] then TRUE
    //  else FALSE
    //    end_if);
    t:=bool(has(r,{infinity,-infinity,undefined}) or r[1]<>r[2]);
    userinfo(10, (if t then "is discontinuous at ".s
                 else "not discontinuous at ".s
                 end_if;));
    [t, op(r)]
  end_proc:

// wrapper function for limit which secures that only a valid value
// like an arithmetical expression or a symbolic limit-call is returned
// and performs a timeout wrapper.
intlib::limit:=
  proc()
    local lim;
  begin
    lim := FAIL;
    traperror((lim := eval(hold(limit)(args()))),
              MaxSteps=intlib::limitMaxSteps(args()));
    case type(lim)
      // of piecewise do  
      of Dom::Interval do
      of DOM_FAIL do
        hold(limit)(args());
        break
      otherwise
        lim
    end_case
  end_proc:


/*--
        intlib::int_eval(f,x=a,dir,typ)

        evaluates f in x=a with direction dir (Left or Right) and typ=TRUE
        iff a is a singular point
--*/
intlib::int_eval := proc(f,x)
begin
   //if type(op(x,2))=stdlib::Infinity then
   if has(op(x,2),{infinity,-infinity}) then
       intlib::limit(f,x)
   elif args(0)>=4 and args(4) then
       intlib::limit(f,x,args(3))
   else
       subs(f,x,EvalChanges)
   end_if
end_proc:
