defint_patterns:=[
    [1/(x^2+1)^2, PI/8+1/4, [u=0, v=1]],
    [x^2/(x^2+1)^2, PI/8-1/4, [u=0, v=1]],

   // [1/(a*x+b), ln(1+a/b)/a, [u=0, v=1, a>0, b>0]],
   // [1/(x^2+a), (ln(sqrt(-a)-1)-ln(sqrt(-a)+1))/2/sqrt(-a), [u=0, v=1, a<-1]],

    [1/(a*x^2+b), arctan(sqrt(a/b))/sqrt(a*b), [u=0, v=1, a>0, b>0]],
    [x/(a*x^2+b), ln(1+a/b)/2/a, [u=0, v=1, a>0, b>0]],

    [1/(a+x)/(b+x^2), PI*a/2/sqrt(b)/(a^2+b)+ln(sqrt(b)/a)/(a^2+b), [u=0, v=infinity, a>0, b>0]],
    [1/(a+d*x^2)/(b+e*x^2)/(c+f*x^2),
      PI/(2*d*e*f)*(sqrt(a/d)+sqrt(b/e)+sqrt(c/f))/
        (sqrt(a/d)*sqrt(b/e)*sqrt(c/f)*(sqrt(a/d)+sqrt(b/e))*
        (sqrt(a/d)+sqrt(c/f))*(sqrt(b/e)+sqrt(c/f))),
      [u=0, v=infinity, not a/d<=0, not b/e<=0, not c/f<=0]],
    [x^2/(a+d*x^2)/(b+e*x^2)/(c+f*x^2),
      PI/(2*d*e*f)/(sqrt(a/d)+sqrt(b/e))/(sqrt(b/e)+sqrt(c/f))/(sqrt(c/f)+sqrt(a/d)),
      [u=0, v=infinity, not a/d<=0, not b/e<=0, not c/f<=0]],

    [1/sqrt(a+b*x^2), ln(sqrt(1+b/a)+sqrt(b/a))/sqrt(b), [u=0, v=1, a>0, b>0]],
// Huh?
//    [x/sqrt(a+b*x^2), ln(sqrt(a+b)-sqrt(a))/b, [u=0, v=1, a>0, a+b>0]],
    [x/sqrt(a+b*x^2),
      (sqrt(a+b)-sqrt(a))/b,
      [u=0, v=1, a>0, b>0]],
//    [1/sqrt(x^2-1)/(a+b*x),
//      2/sqrt(a^2-b^2)*arctan(sqrt((a-b)/(a+b))),
//      [u=1, v=infinity, b>0, a>b]],

    [(1-x^a)^b, PI/a/sin(PI/a), [u=0, v=1, a>1, a*b=-1]],
    [(1/(1-x^a))^b, PI/a/sin(PI/a), [u=0, v=1, a>1, a*b=1]],

    [sqrt(a+b*x^2), sqrt(a+b)/2 + (ln(sqrt(a+b)+sqrt(b)) - ln(a)/2)*a/2/sqrt(b), [u=0, v=1, a>0, b>0]],

    // Dwight, Tables of integrals and other mathematical data
    [x^a*(1-x^b)^c, beta(c+1,(a+1)/b)/b, [u=0, v=1, Re(a)>-1, b>0, Re(c)>-1]], // 855.42

    [x^a/(b+x), PI*b^a/sin((a+1)*PI), [u=0, v=infinity, Re(a)<0, Re(a)>-1, not b<=0]],  // 856.04
//    [1/(1+x^a), PI/a/sin(PI/a), [u=0, v=infinity, Re(a)>1]], // 856.05
    [1/(a*x^b+c), PI/(b*sin(PI/b)*a^(1/b)*c^(1-1/b)),
      [u=0, v=infinity, b>1, c<>0]],
    [x^a*(1+x)^b, beta(a+1,-1-a-b), [u=0, v=infinity, Re(a)>-1, Re(a+b)<-1]],  // 856.11, GR8.380.3a
    [1/(x^2+a)/(x^2+b), PI/2/(a*sqrt(b)+b*sqrt(a)), [u=0, v=infinity, not a<=0, not b<=0]], // 856.31

    [sqrt(1-x)/(a*x-1), -2/a*(1-sqrt((1-a)/a)*arctan(sqrt(a/(1-a)))), [u=0, v=1, a>0, a<1]],
    [1/sqrt(1-x)/(a*x-1), -2*arcsin(sqrt(a))/sqrt(a-a^2), [u=0, v=1, not a>1]],

    [(-ln(x))^a, gamma(a+1), [u=0, v=1, Re(a)>-1]], // 863.01
    [x^a*ln(x), -1/(a+1)^2, [u=0, v=1, Re(a)>-1]],  // 863.02
    [ln(x)/(x^2-1), PI^2/8, [u=0, v=1]], // 863.31
    [x*ln(x)/(x^2-1), PI^2/24, [u=0, v=1]], // 863.32
    [x*ln(x)/(x^2+1), -PI^2/48, [u=0, v=1]], // GR 4.231.14
    [x*ln(x)/(x+1), PI^2/12-1, [u=0, v=1]], // GR 4.231.19, corrected
    [(1-x)*ln(x)/(1+x), 1-PI^2/6, [u=0, v=1]], // GR 4.231.20
    [x^2*ln(x)/(x^2-1), PI^2/8-1, [u=0, v=1]],  // 863.33
    [ln(x)/(x^2+1), -CATALAN, [u=0, v=1]],  // 863.34
    [ln(x)/(x+1)^2, -ln(2), [u=0, v=1]],  // 863.35, GR 4.231.6
    [ln(x)/(a*x^2+b)^n, 
      gamma(n-1/2)*sqrt(PI)/(4*(n-1)!*sqrt(b)^(2*n-1)*sqrt(a))*
      (2*ln(sqrt(b)/(2*sqrt(a)))-EULER-psi(n-1/2)),
      [u=0, v=infinity, a>0, b>0]], // GR 4.231.7
    [ln(x)*(1-x^(n2))/(1-x^2)^2,
      psi(n2/2 - 1/2, 1)/8 - ln(2)/2 - psi(n2/2 - 1/2)/4 -
      (n2*psi(n2/2 - 1/2, 1))/8 - EULER/4 - PI^2/16, [u=0, v=1, n2>3]], // GR 4.231.16
    [-(ln(x)*(x^n - 1))/(x - 1)^2, - EULER - psi(n) - n*psi(n, 1),
      [u=0, v=1, n>1]], // GR 4.231.18
    [ln(x)^2/(x^2-x+1), 10*PI^3/(81*sqrt(3)), [u=0, v=1]], // GR 4.261.2
    [ln(x)^2/(x^2-x+1), 20*PI^3/(81*sqrt(3)), [u=0, v=infinity]], // GR 4.261.2
    [ln(x)^2/(x^2-x+1), 10*PI^3/(81*sqrt(3)), [u=1, v=infinity]], // GR 4.261.2
    [ln(x)^2/(x^2+x+1), 8*PI^3/(81*sqrt(3)), [u=0, v=1]], // GR 4.261.3
    [ln(x)^2/(x^2+x+1), 16*PI^3/(81*sqrt(3)), [u=0, v=infinity]], // GR 4.261.3
    [ln(x)^2/(x^2+x+1), 8*PI^3/(81*sqrt(3)), [u=1, v=infinity]], // GR 4.261.3
    [ln(x)^2/(x-1)/(x+a), (PI^2+ln(a)^2)*ln(a)/3/(a+1), [u=0, v=infinity, a>0]], // GR 4.261.4
    [ln(x)^2/(x^2+a*x+b), (PI^2+ln(a+1)^2)*ln(a+1)/3/(a+1), [u=0, v=infinity, b=-a-1, a>-1]], // GR 4.261.4
    [ln(x)^2/(x^2+1), PI^3/8, [u=0, v=infinity]], // GR 4.261.6, corrected
    [ln(x)/sqrt(1-x^2), -PI/2*ln(2), [u=0, v=1]], // 863.41
    [ln(x)^2/sqrt(1-x^2), PI/2*(ln(2)^2+PI^2/12), [u=0, v=1]], // GR 4.261.9
    [x*ln(x)/sqrt(1-x^2), ln(2)-1, [u=0, v=1]], // 863.42
    [x^2*ln(x)/sqrt(1-x^2), PI/8*(1-2*ln(2)), [u=0, v=1]],
    [ln(x)*sqrt(1-x^2), -PI/4*(ln(2)+1/2), [u=0, v=1]], // 863.43
    [(1-x^a)*(1-x^b)/ln(x), ln((a+b+1)/(a+1)/(b+1)), [u=0, v=1, a>-1, b>-1, a+b>-1]], // 863.54
    [x^n*ln(1-x), -(EULER + psi(n + 2))/(n + 1), [u=0, v=1, n>=0]], // 863.73
    [ln(1-x)/(1+x^2), PI/8*ln(2)-CATALAN, [u=0, v=1]],  // 864.01
    [ln(1+x)/(1+x^2), PI/8*ln(2), [u=0, v=1]],  // 864.02
    [arctanh(x)/(1+x^2), CATALAN/2, [u=0, v=1]],
    [ln(1+x^2)/(1+x^2), PI/2*ln(2)-CATALAN, [u=0, v=1]],  // 864.04
    [ln(1-x^a)/x, -PI^2/6/a, [u=0, v=1, Re(a)>0]],  // 864.21
    [ln(1+x^a)/x, PI^2/12/a, [u=0, v=1, Re(a)>0]],  // 864.22
    [arctanh(x^a)/x, PI^2/8/a, [u=0, v=1, Re(a)>0]],
    [ln(1-x)/sqrt(1-x^2), -2*CATALAN-PI/2*ln(2), [u=0, v=1]], // 864.31
    [ln(1+x)/sqrt(1-x^2), 2*CATALAN-PI/2*ln(2), [u=0, v=1]],  // 864.32
    [arctanh(x)/sqrt(1-x^2), 2*CATALAN, [u=0, v=1]],
    [ln(x)/(x^2-1), PI^2/4, [u=0, v=infinity]],  // 864.53
    [ln(x)/(x^2+a), PI/4/sqrt(a)*ln(a), [u=0, v=infinity, a>0]], // 864.54
    [ln(1+x)/(1+x^2), PI/4*ln(2)+CATALAN, [u=0, v=infinity]],  // 864.61
    
    [ln(ln(1/x))/sqrt(ln(1/x)), -(EULER+ln(4))*sqrt(PI), [u=0, v=1]], // GR 4.229.3

    [ln(1+exp(-x)), PI^2/12, [u=0, v=infinity]],  // 865.81
    [ln(1-exp(-x)), -PI^2/6, [u=0, v=infinity]], // 865.82

    [ln(x)*exp(a*x), (ln(-a)+EULER)/a, [u=0, v=infinity, Re(a)<0]], // 865.901
    [ln(x)/exp(a*x), -(ln(a)+EULER)/a, [u=0, v=infinity, Re(a)>0]],
    [x*ln(x)*exp(a*x), -(ln(-a)-1+EULER)/a^2, [u=0, v=infinity, Re(a)<0]], // 865.902
    [x*ln(x)/exp(a*x), -(ln(a)-1+EULER)/a^2, [u=0, v=infinity, Re(a)>0]],
    [x^2*ln(x)*exp(a*x), (ln(-a)-3/2+EULER)*2/a^3, [u=0, v=infinity, Re(a)<0]], // 865.903
    [x^2*ln(x)/exp(a*x), -(ln(a)-3/2+EULER)*2/a^3, [u=0, v=infinity, Re(a)>0]],
    [x^w*exp(-a*x)*ln(x), 1/(a^(w+1))*gamma(w+1)*(psi(w+1)-ln(a)), [u=0, v=infinity, Re(a)>0, Re(w+1)>0]], // GR 4.352.1
    [x^w/exp(a*x)*ln(x), 1/(a^(w+1))*gamma(w+1)*(psi(w+1)-ln(a)), [u=0, v=infinity, Re(a)>0, Re(w+1)>0]], // GR 4.352.1
  
    // Grbner & Hofreiter, Integraltafel, 2. Teil
    [1/(a*x^2+b*x+c), (arctan((a+b/2)/sqrt(a*c-b^2/4))-arctan(b/sqrt(4*a*c-b^2)))/sqrt(a*c-b^2/4), [u=0, v=1, 4*a*c>b^2, b>0]], // 131.2a
    [1/(x*(a*x+b)+c), (arctan((a+b/2)/sqrt(a*c-b^2/4))-arctan(b/sqrt(4*a*c-b^2)))/sqrt(a*c-b^2/4), [u=0, v=1, 4*a*c>b^2, b>0]], // 131.2a
    [1/(a+b*sqrt(x)), 2/b-2*a/b^2*ln(1+b/a), [u=0, v=1, a*(a+b)>0, a in R_]],  // 211.1b
    /* These seem to be wrong
    [1/(a*x^2+b*x+c)/sqrt(x), PI/sqrt(2*c*(sqrt(a*c)+b)), [a>0, b>0, a*c>b^2, u=0, v=infinity]],  // 211.6a
    [1/(a*x^2+b*x+c)*sqrt(x), PI/sqrt(2*a*(sqrt(a*c)+b)), [a>0, b>0, a*c>b^2, u=0, v=infinity]],  // 211.6b
    */
    [1/(a*x^2+b*x+c)/sqrt(x),
      (PI*(((2*a)/(b - (b^2 - 4*a*c)^(1/2)))^(1/2) - ((2*a)/(b + (b^2 - 4*a*c)^(1/2)))^(1/2)))/(b^2 - 4*a*c)^(1/2),
      [not (b+sqrt(b^2-4*a*c))/a < 0, not (b-sqrt(b^2-4*a*c))/a < 0, u=0, v=infinity]], // residue calculus
    [1/(x*(a*x+b)+c)/sqrt(x),
      (PI*(((2*a)/(b - (b^2 - 4*a*c)^(1/2)))^(1/2) - ((2*a)/(b + (b^2 - 4*a*c)^(1/2)))^(1/2)))/(b^2 - 4*a*c)^(1/2),
      [not (b+sqrt(b^2-4*a*c))/a < 0, not (b-sqrt(b^2-4*a*c))/a < 0, u=0, v=infinity]], // residue calculus
    [sqrt(x)/(a*x^2+b*x+c),
      (PI*2^(1/2)*((a/(b - (b^2 - 4*a*c)^(1/2)))^(1/2) + (a/(b + (b^2 - 4*a*c)^(1/2)))^(1/2)))/(2*a) -
        (PI*2^(1/2)*b*((a/(b - (b^2 - 4*a*c)^(1/2)))^(1/2) - (a/(b + (b^2 - 4*a*c)^(1/2)))^(1/2)))/(2*a*(b^2 - 4*a*c)^(1/2)),
      [not (b+sqrt(b^2-4*a*c))/a < 0, not (b-sqrt(b^2-4*a*c))/a < 0, u=0, v=infinity]], // residue calculus
    [sqrt(x)/(x*(a*x+b)+c),
      (PI*2^(1/2)*((a/(b - (b^2 - 4*a*c)^(1/2)))^(1/2) + (a/(b + (b^2 - 4*a*c)^(1/2)))^(1/2)))/(2*a) -
        (PI*2^(1/2)*b*((a/(b - (b^2 - 4*a*c)^(1/2)))^(1/2) - (a/(b + (b^2 - 4*a*c)^(1/2)))^(1/2)))/(2*a*(b^2 - 4*a*c)^(1/2)),
      [not (b+sqrt(b^2-4*a*c))/a < 0, not (b-sqrt(b^2-4*a*c))/a < 0, u=0, v=infinity]], // residue calculus
    [1/(a*x+b)/sqrt(x), PI/sqrt(a*b), [u=0, v=infinity, a>0, b>0]],  // 211.7
    [(-(x+c)*(x+d))^a, (v-u)^(2*a+1)/(2*a+1)!*gamma(a+1)^2, [c=-u, d=-v, matchlib::block(2*a in Z_)]], // 212.3
    [1/sqrt(x^2+a), ln(1+sqrt(2)), [u=0, v^2=a, v>0]], // 214.1b
    [x/sqrt(x^2+a), v*(sqrt(2)-1), [u=0, v^2=a, v>0]], // 214.1c
    [x^2/sqrt(x^2+a), v^2/2*(sqrt(2)-ln(1+sqrt(2))), [u=0, v^2=a, v>0]], // 214.1d
    [1/x/sqrt(x^2+a), PI/2/u, [u>0, v=infinity, a=-u^2]], // 215.2c
    [1/sqrt(a-x^2)/(x^2+c), PI/2/sqrt(c)/sqrt(c+a), [u=0, v^2=a, v>0, a>0, c>0]], // 216.8a
    [x/sqrt(a-x^2)/(x^2+c), 1/sqrt(a+c)*ln((sqrt(a)+sqrt(a+c))/sqrt(c)), [u=0, v^2=a, v>0, a>0, c>0]], // 216.8b
    [1/sqrt(a-x^2)/(x^2+c), -PI/2/sqrt(-c)/sqrt(-c-a), [u=0, v^2=a, v>0, a>0, -c>a]], // 216.9a
    [x/sqrt(a-x^2)/(x^2+c), -arcsin(sqrt(-a/c))/sqrt(-a-c), [u=0, v^2=a, v>0, a>0, -c>a]],  // 216.9b

    [x^n/(exp(a*x)-1), abs(bernoulli(n+1))/2/(n+1)*(2*PI/a)^(n+1), [u=0, v=infinity, a>0, n>0, n mod 2=1]],  // 313.9a
    [x^n/(exp(a*x)+1), (2^n-1)/(n+1)*abs(bernoulli(n+1))*(PI/a)^(n+1), [u=0, v=infinity, a>0, n>0, n mod 2=1]],  // 313.10a
    [x^a*exp(x^2)^b, gamma((a+1)/2)/(-b)^((a+1)/2)/2, [u=0, v=infinity, a>-1, b<0]],  // 314.2

    [ln(a*x^2+b)/(c*x^2+d), PI/sqrt(c*d)*ln((sqrt(a*d)+sqrt(b*c))/sqrt(c)), [u=0, v=infinity, a>0, b>0, c>0, d>0]],  // 325.18
    [ln(1+a*x^2)/sqrt(1-x^2), PI*ln((1+sqrt(1+a))/2), [u=0, v=1, a>=-1]], // 325.21b
 
    [ln(a*x), ln(a)-1, [u=0, v=1, a>0]],

    [arcsin(x), PI/2-1, [u=0, v=1]],
    [arccos(x), 1, [u=0, v=1]],

/// highly suspect,
/// inconsistent with numerical integration
/// and with Maple and Mathematica
///    [tan(x+a*I), PI*I, [u=0, v=infinity, Re(a)>0]],

    [arccot(x)^2, PI*ln(2), [u=0, v=infinity]],

    [x^a*ln(x)^b, gamma(b+1)/(-a-1)^(b+1), [u=1, v=infinity, a<-1, b>-1]],

    // Bronstein, Taschenbuch der Mathematik (1.1.3.4)
    [x^a*exp(b*x^2), gamma((a+1)/2)/2/(-b)^((a+1)/2), [Re(a)>-1, Re(b)<0, u=0, v=infinity]],
    [x^a/exp(b*x^2), gamma((a+1)/2)/2/b^((a+1)/2), [Re(a)>-1, Re(b)>0, u=0, v=infinity]],

    [cos(a*x)*exp(b*x^2), sqrt(-PI/b)/2*exp(a^2/4/b), [b<0, u=0, v=infinity]],
    [cos(a*x)/exp(b*x^2), sqrt(PI/b)/2*exp(-a^2/4/b), [b>0, u=0, v=infinity]],

    [sin(x)*exp(a*x)/x, arccot(-a), [a<0, u=0, v=infinity]],
    [sin(x)/exp(a*x)/x, arccot(a), [a>0, u=0, v=infinity]],

    // Gradshteyn, 3.311
    [exp(p*x)/(1+exp(-x)), (psi((1-p)/2)-psi(-p/2))/2,
     [u=0, v=infinity, Re(p)<0]],
    [exp(p*x)/(1+exp(q*x)), PI/q*csc(p/q*PI),
     [u=-infinity, v=infinity, q>p, p>0]],
    [exp(p*x)/(1+exp(q*x)), -PI/q*csc(p/q*PI),
     [u=-infinity, v=infinity, q<p, p<0]],
    [exp(p*x)/(1+a*exp(q*x)), 
      matchlib::block(sum::sum_fn(k -> (-a)^k/(-p-k*q), 0..infinity)),
     [u=0, v=infinity, -1<a, a<0]],

    // Gradshteyn, 3.611
    [(1-cos(x))^n*sin(n*x), 0, [u=0, v=2*PI]],
    [(cos(x)-1)^n*sin(n*x), 0, [u=0, v=2*PI]],
    [(1-cos(x))^n*cos(n*x), (-1)^n*PI/(2^(n-1)), [u=0, v=2*PI]],
    [(cos(x)-1)^n*cos(n*x), PI/(2^(n-1)), [u=0, v=2*PI]],

    // 3.613
    [cos(n0*x)/(1+a*cos(x)), (PI/sqrt(1-a^2))*((sqrt(1-a^2)-1)/a)^abs(n0), 
      [u=0, v=PI, not a<=-1, not a>=1]],
    [cos(n0*x)/(1+a*cos(x)+b), PI*(-a/2)^abs(n0)/(1-b),
      [u=0, v=PI, not a<=-2, not a>=2, b=a^2/4]],
    [cos(n0*x)/(1+a*cos(x)+b), PI/((b-1)*(-a/2)^abs(n0)),
      [u=0, v=PI, a<=-2 or a>=2, b=a^2/4]],
    [sin(n*x)*sin(x)/(1+a*cos(x)+b),
      (PI/2)*(-a/2)^(n-1),
      [u=0, v=PI, not a<=-2, not a>=2, b=a^2/4]],
    [sin(n0*x)*sin(x)/(a*cos(x)+b),
      sign(n0)*PI/(2*(-a/2)^(abs(n0)-1)),
      [u=0, v=PI, a<=-2 or a>=2, b=a^2/4+1]],
    [cos(n0*x)*cos(x)/(a*cos(x)+b),
      (PI/2)*(b/(2-b))*(-a/2)^(n0-1),
      [u=0, v=PI, a>-2, a<0, b=a^2/4+1]],
    [cos(n0*x)*cos(x)/(a*cos(x)+b),
      (PI/2)*(b/(2+b))*(a/2)^(n0-1),
      [u=0, v=PI, a<2, a>0, b=-(a^2/4+1)]],
    [cos(n0*x)*cos(x)/(a*cos(x)+b),
      (PI/(2*(-a/2)^(n0+1))*(b/(b-2))),
      [u=0, v=PI, a<-2, b=a^2/4+1]],
    [cos(n0*x)*cos(x)/(a*cos(x)+b),
      (-PI/(2*(a/2)^(n0+1))*(b/(b+2))),
      [u=0, v=PI, a>2, b=-(a^2/4+1)]],
    // TODO: The denominator will often be rewritten to one of the forms
    //  a*cos(x)^2-a^2/16-a/2-1
    //  a*sin(x)^2+a^2/16-a/2+1
    // with a new a that equals -2*a of the ones listed here:
    [sin(n1*x)*sin(x)/(1+a*cos(2*x)+b),
      (PI/2)*(-a/2)^((n1+1)/2-1)/(1-a/2),
      [u=0, v=PI, not a<=-2, not a>=2, b=a^2/4]],
    [sin(n1*x)*sin(x)/(1+a*cos(2*x)+b),
      (PI/2)*1/((-a/2)^((n1+1)/2)*(1-a/2)),
      [u=0, v=PI, a<=-2 or a>=2, b=a^2/4]],
    [cos(n1*x)*cos(x)/(1+a*cos(2*x)+b),
      (PI/2)*(-a/2)^((n1+1)/2-1)/(1+a/2),
      [u=0, v=PI, a>-2, a<0, b=a^2/4]],
    [cos(n1*x)*cos(x)/(-1+a*cos(2*x)+b),
      -(PI/2)*(a/2)^((n1+1)/2-1)/(1-a/2),
      [u=0, v=PI, a<2, a>0, b=-a^2/4]],
    [cos(n1*x)*cos(x)/(1+a*cos(2*x)+b),
      -(PI/2)*1/((-a/2)^((n1+1)/2)*(1+a/2)),
      [u=0, v=PI, a<-2, b=a^2/4]],
    [cos(n1*x)*cos(x)/(-1+a*cos(2*x)+b),
      (PI/2)*1/((a/2)^((n1+1)/2)*(1-a/2)),
      [u=0, v=PI, a>2, b=-a^2/4]],
    [sin(m*x)*(c*sin(n*x)-c*a*sin((n-1)*x))/(d*(a^2+1)-2*d*a*cos(x)),
      0,
      [u=0, v=PI, m<n, -1<a, a<1]],
    [(c*sin(m*x)*sin(n*x)-c*a*sin(m*x)*sin((n-1)*x))/(d*(a^2+1)-2*d*a*cos(x)),
      0,
      [u=0, v=PI, m<n, -1<a, a<1]],
    [sin(m*x)*(c*sin(n*x)-c*a*sin((n-1)*x))/(d*(a^2+1)-2*d*a*cos(x)),
      PI/2*a^(m-n)*d/c,
      [u=0, v=PI, m>=n, -1<a, a<1]],
    [(c*sin(m*x)*sin(n*x)-c*a*sin(m*x)*sin((n-1)*x))/(d*(a^2+1)-2*d*a*cos(x)),
      PI/2*a^(m-n)*d/c,
      [u=0, v=PI, m>=n, -1<a, a<1]],
    [(c*cos(n*x)+e*cos((n+1)*x))/(f+g*cos(x)),
      2*PI*(-e/c)^n*e/(c^2*g),
      [u=0, v=PI, e<>0, c<>0, -1<e/c, e/c<1, f=2*(e/c)/g*((e/c)^2+1)]],

      
    // 3.616
    [(1+a*cos(x)+b)^n*cos(n*x),
      (-1)^n*PI*(-a/2)^n,
      [u=0, v=PI, b=a^2/4]],
    [sin(n*x)*(a*cos(2*x)+b)^(-m), 0,
      [u=0, v=2*PI, b=-a^2/4-1, a in R_, a<>-2, a<>2]],
    [sin(n*x)*(a*cos(x)^2+b)^(-m), 0,
      [u=0, v=2*PI, b=-a^2/16-a/2-1, a in R_, a<>-4, a<>4]],
    [sin(n*x)*(a*sin(x)^2+b)^(-m), 0,
      [u=0, v=2*PI, b=a^2/16-a/2+1, a in R_, a<>-4, a<>4]],

    // 3.618
    // TODO: cos(n2*x) will be expanded by intlib::Simplify and therefore not matched in this form.
    [cos(n2*x)/(a^2*cos(x)^2+b^2*sin(x)^2)^r,
      binomial(n2,n2/2)*PI*(b^2-a^2)^(n2/2)/(2*a*b)^(n2+1),
      [u=0, v=PI/2, r=(n2+1)/2]],
    [cos(n2*x)/((a^2 - b^2)*cos(x)^2 + b^2)^r,
      binomial(n2,n2/2)*PI*(b^2-a^2)^(n2/2)/(2*a*b)^(n2+1),
      [u=0, v=PI/2, r=(n2+1)/2]],
    [cos(n2*x)/((b^2 - a^2)*sin(x)^2 + a^2)^r,
      binomial(n2,n2/2)*PI*(b^2-a^2)^(n2/2)/(2*a*b)^(n2+1),
      [u=0, v=PI/2, r=(n2+1)/2]],
    [cos(n2*x)/(a*cos(x)^2+b*sin(x)^2)^r,
      binomial(n2,n2/2)*PI*(b-a)^(n2/2)/(2*sqrt(a*b))^(n2+1),
      [u=0, v=PI/2, a>0, b>0, r=(n2+1)/2]],
    [cos(n2*x)/((a - b)*cos(x)^2 + b)^r,
      binomial(n2,n2/2)*PI*(b-a)^(n2/2)/(2*sqrt(a*b))^(n2+1),
      [u=0, v=PI/2, a>0, b>0, r=(n2+1)/2]],
    [cos(n2*x)/((b - a)*sin(x)^2 + a)^r,
      binomial(n2,n2/2)*PI*(b-a)^(n2/2)/(2*sqrt(a*b))^(n2+1),
      [u=0, v=PI/2, a>0, b>0, r=(n2+1)/2]],

    // 3.624
    [sin(x)^p/(cos(x)^q), 1/(p+1),
      [u=0, v=PI/4, p>-1, q=p+2]],
//    [sin(x)^p/cos(x)^q,
//      (1/2)*gamma(p/2)*gamma(3/2-p)/gamma(3/2-p/2) 
//      [u=0, v=PI/2, 0<Re(p)<3/2, q=2*p]],
    [sin(a*x)^2/sin(x)^2,
      a*PI/2-1/2*sin(PI*a)*(a*(psi((a+1)/2)-psi(a/2))-1),
      [u=0, v=PI/2, a>0]],
    [sin(a*x)^2/sin(x/2)^2,
      2*a*PI-sin(PI*a*2)*(a*2*(psi((a*2+1)/2)-psi(a))-1),
      [u=0, v=PI, a>0]],

    // 3.631
    [sin(x)^q*sin(p*x),
      (1/(1-p))*cos(p*PI/2), // the factor 2 in G seems to be a typo
      [u=0, v=PI/2, Re(p)>1, q=p-2]],
    [sin(x)^p*sin(p*x),
      2^(-p)*PI*sin(p*PI/2),
      [u=0, v=PI, Re(p)>-1]], // POSSIBLE BUG: does not match for p=2 (simplification)
    [sin(x)^(-p)*sin(p*x),
      2^(p)*PI*sin(p*PI/2),
      [u=0, v=PI, Re(p)<1]],
    [sin(x)^n*sin(m2*x), 0,
      [u=0, v=PI]],
    [sin(x)^(n1)*sin(m1*x),
      (-1)^((m1-1)/2)*PI/2^n1*binomial(n1,(n1-m1)/2),
      [u=0, v=PI, n1>=m1]],
    [sin(x)^n1*sin(m1*x), 0,
      [u=0, v=PI, n1 < m1]],
    [sin(x)^n1*sin(m1*x),
      1/2*(-1)^((m1-1)/2)*PI/2^n1*binomial(n1,(n1-m1)/2),
      [u=0, v=PI/2, n1 >= m1]],
    [sin(x)^n1*sin(m1*x), 0,
      [u=0, v=PI/2, n1 < m1]],
    [sin(x)^n*cos(m1*x), 0,
      [u=0, v=PI]],

    [sin(x)^q*cos(p*x),
      sin(p*PI/2)/(p-1),
      [u=0, v=PI/2, Re(p)>1, q=p-2]],
    [sin(x)^p*cos(p*x),
      PI*cos(p*PI/2)/2^p,
      [u=0, v=PI, Re(p)>-1]],
    [sin(x)^(-p)*cos(p*x),
      PI*cos(p*PI/2)*2^p,
      [u=0, v=PI, Re(p)<1]],
    [sin(x)^n2*cos(m2*x),
      (-1)^(m2/2)*PI/2^n2*binomial(n2,(n2-m2)/2),
      [u=0, v=PI, n2>=m2]],
    [sin(x)^n2*cos(m2*x),
      (-1)^(m2/2)*PI/2^n2*binomial(n2,(n2-m2)/2)/2,
      [u=0, v=PI/2, n2>=m2]],
      
    [sin(x)^(n2)*cos(m2*x), 0,
      [u=0, v=PI, n2 < m2]],
    [sin(x)^(n2)*cos(m2*x), 0,
      [u=0, v=PI/2, n2 < m2]],

    [cos(x)^q*sin(p*x), 1/(p-1),
      [u=0, v=PI/2, Re(p)>1, q=p-2]],

    [cos(x)^n*sin(n*x),
      (1/2^(n+1))*sum::sum_fn(k -> 2^k/k, 1..n),
      [u=0, v=PI/2]],

    [cos(x)^q*cos(p*x), 0,
      [u=0, v=PI/2, Re(p)>1, q=p-2]],
    [cos(x)^n*cos(n*x), PI/2^(n+1),
      [u=0, v=PI/2]],

    // 3.632
    [sin(x)^q*cos(a*(PI/2-x)),
      2^q*gamma((q+1-a)/2)*gamma((q+1+a)/2)*gamma(q+1)/
      (gamma(q+1-a)*gamma(q+1+a)),
      [u=0, v=PI, (q+1)^2<a^2]],
    [cos(x)^n*sin(n*x)*sin(m2*x),
      PI/2^(n+2)*binomial(n,m2/2),
      [u=0, v=PI/2]],
    [cos(x)^n*cos(n*x)*cos(m2*x),
      PI/2^(n+2)*binomial(n,m2/2),
      [u=0, v=PI/2]],
    [cos(x)^n*cos(n0*x)*cos(m2*x),
      PI/2^n0*binomial(n,m2/2-1),
      [u=0, v=PI/2, n+1>m2/2-1, n0=n+2]],
    [cos(x)^r*sin(p*x)*sin(q*x),
      (PI/2^(p+q+2))*sum::sum_fn(k -> binomial(p,k)*binomial(q,k), 1..infinity),
      [u=0, v=PI/2, p+q>-1, r=p+q]],

    // 3.634
    [cos(x)^q*sin(p*x)*cos(n*x)*sin(x),
      (PI/2^(p+n))*gamma(p+n-1)/((n-1)!*gamma(p)),
      [u=0, v=PI/2, p>-n-1, q=p+n-2, q<>0, p<>0]],

    // 3.635
    [cos(x)^q*sin(p*x)*tan(x),
      p*PI*gamma(q)/(2^(q+1)*gamma((q-p)/2+1)*gamma((q+p)/2+1)),
      [u=0, v=PI/2, q>0]],
    [cos(x)^n*sin(m*x)*cot(x), PI/2,
      [u=0, v=PI/2, m=n+2]],

    // 3.636
    [tan(x)^p/cos(x),
      gamma(p/2+1/2)*gamma(-p/2)/(2*sqrt(p/2)),
      [u=0, v=PI/2, -1<Re(p), Re(p)<2]],
    [cot(x)^p/sin(x),
      gamma(p/2+1/2)*gamma(-p/2)/(2*sqrt(p/2)),
      [u=0, v=PI/2, -1<Re(p), Re(p)<2]],

    // 3.638
    [sin(x)^p/(cos(2*x)^q*cos(x)),
      PI*sec(p/2*PI)/2,
      [u=0, v=PI/4, abs(Re(p))<1, q=p/2+1/2]],
    [sin(2*x)^q/(cos(2*x)^p*cos(x)),
      2*gamma(p+1/2)*gamma(1-p)*sin((2*p-1)*PI/4)/(sqrt(PI)*(2*p-1)),
      [u=0, v=PI/4, -1/2<Re(p), Re(p)<1, q=p-1/2]],
    [cos(x)^q*sin(p*x)/sin(x), PI/2,
      [u=0, v=PI/2, p>0, q=p-1, q<>0]],

    // Gradshteyn, pp. 408-419
    [sin(a*x^2), (1/2)*sqrt(PI/(2*a)),
      [u=0, v=infinity, a>0]],
    [sin(a*x^2)*cos(b*x),
      1/2*sqrt(PI/a)*cos(b^2/4/a+PI/4),
      [u=0, v=infinity, a>0, b>0]],
    [cos(a*x^2)*cos(b*x),
      1/2*sqrt(PI/(2*a))*(cos(b^2/4/a)+sin(b^2/4/a)),
      [u=0, v=infinity, a>0, b>0]],
    // 3.691
    [(cos(a*x)+sin(a*x))*sin(b*x^2),
      1/(2*sqrt(b))*sqrt(PI/2)*((1+2*fresnelC(sqrt(2/PI)*a/(2*sqrt(b))))*
      sin(a^2/(4*b))+(1-2*fresnelS(sqrt(2/PI)*a/(2*sqrt(b))))*cos(a^2/(4*b))),
      [u=0, v=infinity, a>0, b>0]],
    [(cos(a*x)+sin(a*x))*cos(b*x^2),
      (1/(2*sqrt(b)))*sqrt(PI/2)*((1+2*fresnelC(sqrt(2/PI)*a/(2*sqrt(b))))*
       cos(a^2/(4*b))+(1-2*fresnelS(sqrt(2/PI)*a/(2*sqrt(b))))*sin(a^2/(4*b))),
      [u=0, v=infinity, a>0, b>0]],

    [sin(a*x^2)*sin(b*x)*sin(c*x),
      sqrt(PI)*sin(b*c/2/a)*cos((b^2+c^2)/4/abs(a)-PI/4)/(2*sqrt(abs(a))),
      [u=0, v=infinity, a in R_, b in R_, c in R_]],
    [sin(a*x^2)*cos(b*x)*cos(c*x),
      sqrt(PI)*cos(b*c/2/a)*cos((b^2+c^2)/4/abs(a)+PI/4)/(2*sqrt(abs(a)))*sign(a),
      [u=0, v=infinity, a in R_, b in R_, c in R_]],
    [cos(a*x^2)*sin(b*x)*sin(c*x),
      sqrt(PI)*sin(b*c/2/abs(a))*sin((b^2+c^2)/4/abs(a)-PI/4)/(2*sqrt(abs(a))),
      [u=0, v=infinity, a in R_, b in R_, c in R_]],
    [sin(a*x^2)*cos(b*x^2),
      (1/4)*sqrt(PI/2)*(1/sqrt(abs(a)+abs(b))+1/sqrt(abs(a)-abs(b)))*sign(a),
      [u=0, v=infinity, abs(a)>abs(b), b in R_, a in R_]],
    [sin(a*x^2)*cos(b*x^2),
      (1/4)*sqrt(PI/2)*(1/sqrt(abs(a)+abs(b))-1/sqrt(abs(b)-abs(a)))*sign(a),
      [u=0, v=infinity, abs(b)>abs(a), a in R_, b in R_]],
    [sin(a*x^2)^2-sin(b*x^2)^2,
      (1/8)*(sqrt(PI/abs(b))-sqrt(PI/abs(a))),
      [u=0,v=infinity,a in R_, b in R_]],
    [cos(a*x^2)^2-sin(b*x^2)^2,
      (1/8)*(sqrt(PI/abs(b))+sqrt(PI/abs(a))),
      [u=0, v=infinity, a in R_, b in R_]],
    [cos(a*x^2)^2-cos(b*x^2)^2,
      (1/8)*(sqrt(PI/abs(a))-sqrt(PI/abs(b))),
      [u=0, v=infinity, a in R_, b in R_]],
    [sin(a*x^2)^4-sin(b*x^2)^4,
      (1/64)*(8-sqrt(2))*(sqrt(PI/abs(b))-sqrt(PI/abs(a))),
      [u=0, v=infinity, a in R_, b in R_]],

    // Gradshteyn, p. 410
    [cos(a*x^2)^4-sin(b*x^2)^4,
      (1/8)*(sqrt(PI/abs(a))+sqrt(PI/abs(b)))+
        (1/32)*(sqrt(PI/abs(2*a))-sqrt(PI/abs(2*b))),
      [u=0, v=infinity, a in R_, b in R_]],
    [cos(a*x^2)^4-cos(b*x^2)^4,
      (1/64)*(8+sqrt(2))*(sqrt(PI/abs(a))-sqrt(PI/abs(b))),
      [u=0, v=infinity, a in R_, b in R_]],
    [sin(a*x^2)^n2, infinity,
      [u=0, v=infinity, a<>0]],
    [cos(a*x^2)^n2, infinity,
      [u=0, v=infinity]],

    [sin(a*x^2)^n1,
      matchlib::block(sum::sum_fn(k -> (-1)^((n1-1)/2+k)*binomial(n1,k)*
            sqrt(PI/(2*(n1-2*k)*a)), 0..(n1-1)/2)/2^n1*sign(a)),
      [u=0, v=infinity, a in R_]],
    [cos(a*x^2)^(n1),
      matchlib::block(sum::sum_fn(k -> binomial(n1,k)*
           sqrt(PI/(2*(n1-2*k)*a)), 0..(n1-1)/2)/2^n1),
      [u=0, v=infinity, a in R_]],

    // 3.692
    [sin(a-x^2)+cos(a-x^2),
      sqrt(PI/a)*sin(a),
      [u=0, v=infinity]],
    [cos(x^2/2-PI/8)*cos(a*x),
      sqrt(PI/2)*cos(a^2/2-PI/8),
      [u=0, v=infinity, a in R_]],
    [sin(a*(1-x^2))*cos(b*x),
      -(1/2)*sqrt(PI/abs(a))*cos(abs(a)+b^2/abs(4*a)+PI/4)*sign(a),
      [u=0, v=infinity, a in R_, b in R_]],
    [cos(a*(1-x^2))*cos(b*x),
      (1/2)*sqrt(PI/abs(a))*sin(abs(a)+b^2/abs(4*a)+PI/4),
      [u=0, v=infinity, a in R_, b in R_]],
    [sin(a*x^2+c)*cos(b*x),
      (1/2)*sqrt(PI/(2*abs(a)))*sign(a),
      [u=0, v=infinity, a in R_, b in R_, c=b^2/4/a]],
    [cos(a*x^2+c)*cos(b*x),
      (1/2)*sqrt(PI/(2*abs(a))),
      [u=0, v=infinity, a in R_, b in R_, c=b^2/4/a]],
    [cos(sqrt(x^2-1))-cos(sqrt(x^2+1)),
      matchlib::block(sum::sum_fn(n -> PI/(2^(4*n+1)*
          ((2*n)!)^2*(n+1/2)), 0..infinity)),
      [u=-infinity, v=infinity]],
    
    // 3.698
    [sin(a/x^2)*sin(b*x^2),
      (1/(4*sqrt(abs(b))))*sqrt(PI/2)*(sin(2*sqrt(abs(a*b)))-
       cos(2*sqrt(abs(a*b)))+exp(-2*sqrt(abs(a*b))))*sign(a*b),
      [u=0, v=infinity, a in R_, b in R_]],
    [sin(a/x^2)*cos(b*x^2),
      (1/(4*sqrt(abs(b))))*sqrt(PI/2)*(sin(2*sqrt(abs(a*b)))+
       cos(2*sqrt(abs(a*b)))-exp(-2*sqrt(abs(a*b))))*sign(a),
      [u=0, v=infinity, a in R_, b in R_]],
    [cos(a/x^2)*sin(b*x^2),
      (1/(4*sqrt(abs(b))))*sqrt(PI/2)*(sin(2*sqrt(abs(a*b)))+
       cos(2*sqrt(abs(a*b)))+exp(-2*sqrt(abs(a*b))))*sign(b),
      [u=0, v=infinity, a in R_, b in R_]],
    [cos(a/x^2)*cos(b*x^2),
       (1/(4*sqrt(abs(b))))*sqrt(PI/2)*(cos(2*sqrt(abs(a*b)))-
       sin(2*sqrt(abs(a*b)))+exp(-2*sqrt(abs(a*b)))),
      [u=0, v=infinity, a in R_, b in R_]],

    // 3.699
    [sin(a*x^2+b/x^2),
      sqrt(2*PI)*(cos(2*sqrt(a*b))+sin(2*sqrt(a*b)))/(4*sqrt(abs(a)))*sign(a),
      [u=0, v=infinity, a in R_, b in R_, a*b>0]],
    [cos(a*x^2+b/x^2),
      sqrt(2*PI)*(cos(2*sqrt(a*b))-sin(2*sqrt(a*b)))/(4*sqrt(abs(a))),
      [u=0, v=infinity, a in R_, b in R_, a*b>0]],
    [sin(a*x^2+b/x^2+c),
      sqrt(2*PI)/(4*sqrt(a)),
      [u=0, v=infinity, a>0, b>0, c=-2*sqrt(a*b)]],
    [sin(a*x^2+b/x^2+c),
      -sqrt(2*PI)/(4*sqrt(-a)),
      [u=0, v=infinity, a<0, b<0, c=-2*sqrt(a*b)]],
    [cos(a*x^2+b/x^2+c),
      sqrt(2*PI)/(4*sqrt(a)),
      [u=0, v=infinity, a>0, b>0, c=-2*sqrt(a*b)]],
    [cos(a*x^2+b/x^2+c),
      sqrt(2*PI)/(4*sqrt(-a)),
      [u=0, v=infinity, a<0, b<0, c=-2*sqrt(a*b)]],
    [sin(a*x^2+b/x^2),
      (sqrt(2*PI)/(4*sqrt(a)))*exp(-2*sqrt(-a*b)),
      [u=0, v=infinity, a>0, b<0]],
    [sin(a*x^2+b/x^2),
      -(sqrt(2*PI)/(4*sqrt(-a)))*exp(-2*sqrt(-a*b)),
      [u=0, v=infinity, a<0, b>0]],
    [cos(a*x^2+b/x^2),
      (sqrt(2*PI)/(4*sqrt(a)))*exp(-2*sqrt(-a*b)),
      [u=0, v=infinity, a>0, b<0]],
    [cos(a*x^2+b/x^2),
      (sqrt(2*PI)/(4*sqrt(-a)))*exp(-2*sqrt(-a*b)),
      [u=0, v=infinity, a<0, b>0]],

    // 3.716
    [cos(a*tan(x)), PI*exp(-a)/2,
      [u=0, v=PI/2, a>=0]],
    [cos(a*tan(x)), PI*exp(a)/2,
      [u=0, v=PI/2, a<=0]],
    [sin(a*tan(x))*sin(2*x), PI*a*exp(-a)/2,
      [u=0, v=PI/2, a>=0]],
    [sin(a*tan(x))*sin(2*x), PI*a*exp(a)/2,
      [u=0, v=PI/2, a<=0]],
    [cos(a*tan(x))*sin(x)^2, ((1-a)/4)*PI*exp(-a),
      [u=0, v=PI/2, a>=0]],
    [cos(a*tan(x))*sin(x)^2, ((1-a)/4)*PI*exp(a),
      [u=0, v=PI/2, a<=0]],
    [cos(a*tan(x))*cos(x)^2, ((1+a)/4)*PI*exp(-a),
      [u=0, v=PI/2, a>=0]],
    [cos(a*tan(x))*cos(x)^2, ((1+a)/4)*PI*exp(a),
      [u=0, v=PI/2, a<=0]],
    [sin(a*tan(x))*tan(x), PI*exp(-a)/2,
      [u=0, v=PI/2, a>0]],
    [sin(a*tan(x))*tan(x), -PI*exp(a)/2,
      [u=0, v=PI/2, a<0]],
    [sin(a*tan(x))*sin(x)^2*tan(x),
      ((2-a)/4)*PI*exp(-a),
      [u=0, v=PI/2, a>0]],
    [sin(a*tan(x))*sin(x)^2*tan(x),
      -((2+a)/4)*PI*exp(a),
      [u=0, v=PI/2, a<0]],
    [sin(a*tan(x))^2, PI*(1-exp(-2*a))/4,
      [u=0, v=PI/2, a>0]],
    [sin(a*tan(x))^2, -PI*(1-exp(2*a))/4,
      [u=0, v=PI/2, a<0]],
    [cos(a*tan(x))^2, PI*(1+exp(-2*a))/4,
      [u=0, v=PI/2, a>=0]],
    [cos(a*tan(x))^2, PI*(1+exp(2*a))/4,
      [u=0, v=PI/2, a<=0]],
    [sin(a*tan(x))^2*cot(x)^2, PI*(exp(-2*a)+2*a-1)/4,
      [u=0, v=PI/2, a>=0]],
    [sin(a*tan(x))^2*cot(x)^2, -PI*(exp(2*a)-2*a-1)/4,
      [u=0, v=PI/2, a<=0]],
    [sin(a*cot(x))*sin(2*x), a*PI*exp(-a)/2,
      [u=0, v=PI/2, a>=0]],
    [sin(a*cot(x))*sin(2*x), a*PI*exp(a)/2,
      [u=0, v=PI/2, a<=0]],

    // 3.718
    [sin(a*tan(x)+p*x)*sin(x)^q, 0,
      [u=0, v=PI/2, Re(p)<0,a>0, q=-p-2]],
    [sin(n*tan(x)+p*x)*cos(x)^q/sin(x), PI/2,
      [u=0, v=PI/2, Re(p)>0, q=p-1]],
    [cos(a*tan(x)+p*x)*cos(x)^q,
      PI*exp(-a)*a^(-p-1)/gamma(-p),
      [u=0, v=PI/2, a>0,Re(p)<-1, q=-p-2]],
    [cos(a*tan(x)+p*x)*cos(x)^p,
      2^(-p-1)*PI*exp(-a),
      [u=0, v=PI/2, a>=0, Re(p)>-1]],

    [(sin(n*x)-sin(n*x-a*tan(x)))*cos(x)^(n-1)/sin(x), PI/2,
      [u=0, v=PI/2, n=0,a>0]],
    [(sin(n*x)-sin(n*x-a*tan(x)))*cos(x)^(n-1)/sin(x), PI*(1-exp(-a)),
      [u=0, v=PI/2, n=1,a>=0]],

/* Combinations of trigonometric and rational functions */
    // 3.722
    [sin(a*x)/(x+b),
      Ci(a*b)*sin(a*b)-cos(a*b)*Si(a*b),
      [u=0, v=infinity, abs(arg(b))<PI,a>0]],
    [sin(a*x)/(x+b),
      PI*exp(I*a*b),
      [u=-infinity, v=infinity, a>0,Im(b)>0]],
    [cos(a*x)/(x+b),
      -sin(a*b)*Si(a*b)-cos(a*b)*Ci(a*b),
      [u=0, v=infinity, abs(arg(b))<PI, a>0]],
    [cos(a*x)/(x+b),
      -PI*exp(I*a*b),
      [u=-infinity, v=infinity, a>0, Im(b)>0]],
    [sin(a*x)/(-x+b),
      -PI*exp(I*a*b),
      [u=-infinity, v=infinity, a>0,Im(b)>0]],
    [cos(a*x)/(-x+b),
      -PI*exp(I*a*b),
      [u=-infinity, v=infinity, a>0,Im(b)>0]],

    // 3.723
    [sin(a*(b-x))/(c+x^2),
      PI*exp(-a*sqrt(c))*sin(a*b)/sqrt(c),
      [u=-infinity, v=infinity, a>0, b>0, c>0]],
    [cos(a*(b-x))/(c+x^2),
      PI*exp(-a*sqrt(c))*cos(a*b)/sqrt(c),
      [u=-infinity, v=infinity, a>0, b>0, c>0]],
    [sin(a*x)/(b-x^2),
      (sin(a*sqrt(b))*Ci(a*sqrt(b))-
       cos(a*sqrt(b))*(Si(a*sqrt(b))+PI/2))/sqrt(b),
      [u=0, v=infinity, a>0]],
    [cos(a*x)/(b-x^2),
      PI*sin(a*b)/(2*sqrt(b)),
      [u=0, v=infinity, a>0, b>0]],
    [x*sin(a*x)/(b-x^2),
      -PI*cos(a*sqrt(b))/2,
      [u=0, v=infinity, a>0, b>=0]],
    [x*cos(a*x)/(b-x^2),
      cos(a*sqrt(b))*Ci(a*sqrt(b))+
      sin(a*sqrt(b))*(Si(a*sqrt(b))+PI/2),
      [u=0, v=infinity, a>0]],
    [sin(a*x)/(x*(x+b)),
      -PI*(cos(a*b)-1)/b,
      [u=-infinity, v=infinity, a>0, b<0]],
    // 3.724
    [(b+c*x)/(p+q*x+x^2)*sin(a*x),
      PI*exp(-a*sqrt(p-q^2/4))*(((c*q/2-b)/sqrt(p-q^2/4))
      *sin(a*q/2)+c*cos(a*q/2)),
      [u=-infinity, v=infinity, a>0, p>q^2]],
    [(b+c*x)/(p+q*x+x^2)*cos(a*x),
      PI*exp(-a*sqrt(p-q^2/4))*(((b-c*q/2)/sqrt(p-q^2/4))
        *cos(a*q/2)+c*sin(a*q/2)),
      [u=-infinity, v=infinity, a>0, p>q^2]],
    [(cos(c)-x*cos(b))*cos(a*x)/(1-2*x*cos(t)+x^2),
      PI*exp(-a*sin(t))*sin(b+a*cos(t)),
      [u=-infinity, v=infinity, a>0, t^2<PI^2, c=b-t]],

    // Page 419 equation 3.725
    [sin(a*x)/(x*(b+x^2)),
      PI*(1-exp(-a*sqrt(b)))/(2*b),
      [u=0, v=infinity, a>0, abs(arg(b))<PI]],
    [sin(a*x)/(x*(b-x^2)),
      PI*(1-cos(a*sqrt(b)))/(2*b),
      [u=0, v=infinity, a>0, b>0]],
    [sin(a*x)*cos(b*x)/(x*(x^2+c)),
      PI*E^(sqrt(c)*b)*sinh(a*sqrt(c))/(2*c),
      [u=0, v=infinity, 0<a, a<b]],
    [sin(a*x)*cos(b*x)/(x*(x^2+c)),
      -PI*exp(-a*sqrt(c))*cosh(b*sqrt(c))/(2*c)+PI/(2*c),
      [u=0, v=infinity, a>b, b>0]],

    // 3.727
    [x*sin(a*x)/(b+x^4),
      PI*exp(-a*b^(1/4)/sqrt(2))*sin(a*b^(1/4)/sqrt(2))/(2*sqrt(b)),
      [u=0, v=infinity, a>0, b>0]],
    [x*sin(a*x)/(b-x^4),
      PI*(E^(-a*b^(1/4))-cos(a*b^(1/4)))/(4*sqrt(b)),
      [u=0, v=infinity, a>0, b>0]],

    /* Page 420-429
       Topic: Trig function */

    [x^2*cos(a*x)/(b+x^4),
      PI*sqrt(2)*exp(-a*b^(1/4)/sqrt(2))*(cos(a*b^(1/4)/sqrt(2))
       -sin(a*b^(1/4)/sqrt(2)))/(4*b^(1/4)),
      [u=0, v=infinity, a>0, b>0]],
    [x^2*cos(a*x)/(b-x^4),
      PI*(sin(a*b^(1/4))-exp(-a*b^(1/4)))/(4*b^(1/4)),
      [u=0, v=infinity, a>0, b>0]],
    [x^3*sin(a*x)/(b+x^4),
      (PI/2)*exp(-a*b^(1/4)/sqrt(2))*cos(a*b^(1/4)/sqrt(2)),
      [u=0, v=infinity, a>0, b>0]],
    [x^3*sin(a*x)/(b-x^4),
      (-PI/4)*(exp(-a*b^(1/4))-cos(a*b^(1/4))),
      [u=0, v=infinity, a>0, b>0]],
    [x^3*sin(a*x)/(x^2+b)^3,
      PI*exp(-a*sqrt(b))*(3*a-sqrt(b)*a^2)/(16*sqrt(b)),
      [u=0, v=infinity, a>0, b>0]],
    [x^3*sin(a*x)/(x^2+b^2)^4,
      PI*exp(-a*sqrt(b))*(3+3*a*sqrt(b)-a^2*b)/(96*b^(3/2)),
      [u=0, v=infinity, a>0, b>0]],

    // 3.728
    [x*sin(a*x)/((b+x^2)*(y+x^2)),
      PI*(exp(-a*sqrt(b))-exp(-a*sqrt(y)))/
        (2*sqrt(b)*y*(b-y)),
      [u=0, v=infinity, a>0,Re(b)>0,Re(y)>0]],

    /* Begin page 421 */
    [x^3*sin(a*x)/((b+x^2)*(y^2+x^2)),
      PI*(b*exp(-a*sqrt(b))-y^2*exp(-a*y))/(2*(b-y^2)),
      [u=0, v=infinity, a>0, abs(arg(b)) < PI, Re(y)>0]],
    [cos(a*x)/((b-x^2)*(c-x^2)),
      PI*(sqrt(b)*sin(a*sqrt(c))-sqrt(c)*sin(a*sqrt(b)))
        /(2*sqrt(b*c)*(b-c)),
      [u=0, v=infinity, a>0, b>0, c>0]],
    [x*sin(a*x)/((b-x^2)*(c-x^2)),
      PI*(cos(a*sqrt(b))-cos(a*sqrt(c)))/(2*(b-c)),
      [u=0, v=infinity, a>0, b>=0, c>=0]],
    [x^2*cos(a*x)/((b-x^2)*(c-x^2)),
      PI*(sqrt(c)*sin(a*sqrt(c))-sqrt(b)*sin(a*sqrt(b)))/
         (2*(b-c)),
      [u=0, v=infinity, a>0, b>0, c>0]],
    [x^3*sin(a*x)/((b-x^2)*(c-x^2)),
      PI*(b*cos(a*sqrt(b))-c*cos(a*sqrt(c)))/
         (2*(b-c)),
      [u=0, v=infinity, a>0, b>0, c>0]],
    [x*sin(a*x)/((b-x^2)*(c+x^2)),
      (PI/2)*(exp(-a*sqrt(c))-cos(sqrt(b)*a))/(a^2+c),
      [u=0, v=infinity, a>0, b>0, c>0]],

    // 3.729 
    [x*sin(a*x)/(b+x^2)^2,
      PI*a*exp(-a*sqrt(b))/(4*sqrt(b)),
      [u=0, v=infinity, a>0, b>0]],
    [x^3*sin(a*x)/(b+x^2)^2,
      (PI/4)*(2-a*sqrt(b))*E^(-a*sqrt(b)),
      [u=0, v=infinity, a>0, b>0]],

    // 3.372 
    [(1/(b+(y-x)^2)+1/(b+(y+x)^2))*cos(a*x),
      (PI/sqrt(b))*exp(-a*sqrt(b))*cos(a*y),
      [u=0, v=infinity, a>0,abs(Im(y))<Re(sqrt(b))]],
    [((y-x)/(b+(y-x)^2)+(y+x)/(b+(y+x)^2))*cos(a*x),
      PI*exp(-a*sqrt(b))*sin(a*y),
      [u=0, v=infinity, a>0, abs(Im(a))<Re(sqrt(b))]],

    // 3.733
    [cos(a*x)/(x^4+b*x^2*cos(t)+c),
      PI*exp(-a*sqrt(b/2)*cos(t/2))*
      sin(t/2+a*sqrt(b/2)*sin(t/2))/(2*sqrt(b/2)^3*sin(t)),
      [u=0, v=infinity, a>0, b>0, abs(t)<PI,c=b^2/4]],
    [x*sin(a*x)/(x^4+b*x^2*cos(t)+c),
      PI*exp(-a*sqrt(b/2)*cos(t/2))*sin(a*sqrt(b/2)*sin(t/2))/
        (b*sin(t)),
      [u=0, v=infinity, a>0, b>0, abs(t)<PI, c=b^2/4]],
    [x^2*cos(a*x)/(x^4+b*x^2*cos(t)+c),
      PI*exp(-a*sqrt(b/2)*cos(t/2))*
       sin(t/2-a*sqrt(b/2)*sin(t/2))/(2*sqrt(b/2)*sin(t)),
      [u=0, v=infinity, a>0, b>0, abs(t)<PI, c=b^2/4]],
    [x^3*sin(a*x)/(x^4+b*x^2*cos(t)+c),
      PI*exp(-a*sqrt(b/2)*cos(t/2))*
        sin(t-a*sqrt(b/2)*sin(t/2))/(2*sin(t)),
      [u=0, v=infinity, a>0, b>0, abs(t)<PI, c=b^2/4]],
    [sin(a*x)/(x*(x^4+b*x^2*cos(t)+b^2/4)),
      (PI/(b^2/2))*(1-exp(-a*sqrt(b/2)*cos(t/2))*
        sin(t+a*sqrt(b/2)*sin(t/2))/sin(t)),
      [u=0, v=infinity, a>0, b>0, abs(t)<PI]],
    // 3.734
    [sin(a*x)/(x*(b+x^4)),
      (PI/(2*b))*(1-exp(-a*b^(1/4)/sqrt(2))*cos(a*b^(1/4)/sqrt(2))),
      [u=0, v=infinity, a>0, b>0]],
    [sin(a*x)/(x*(b-x^4)),
      (PI/(4*b))*(2-exp(-a*b^(1/4))*cos(a*b^(1/4))),
      [u=0, v=infinity, a>0, b>0]],

    // 3.735
    [sin(a*x)/(x*(b+x^2)^2),
      (PI/(2*b^2))*(1-(2+a*sqrt(b))/2*exp(-a*sqrt(b))),
      [u=0, v=infinity, a>0, b>0]],

    // 3.736
    [cos(a*x)/((b+x^2)*(c-x^4)),
      (PI/(8*b^(5/2)))*(sin(a*sqrt(b))+
        (2+a*sqrt(b))*exp(-a*sqrt(b))),
      [u=0, v=infinity, a>0, b>0, c=b^2]],
    [x*sin(a*x)/((b+x^2)*(c-x^4)),
      (PI/(8*b^2))*((1+a*sqrt(b))*exp(-a*sqrt(b))
        -cos(a*sqrt(b))),
      [u=0, v=infinity, a>0, b>0, c=b^2]],
    [x^2*cos(a*x)/((b+x^2)*(c-x^4)),
      (PI/(8*b^(3/2)))*(sin(a*sqrt(b))
        -a*sqrt(b)*exp(-a*sqrt(b))),
      [u=0, v=infinity, a>0, b>0, c=b^2]],
    [x^3*sin(a*x)/((b+x^2)*(c-x^4)),
      (PI/(8*b))*((1-a*sqrt(b))*exp(-a*sqrt(b))
        -cos(a*sqrt(b))),
      [u=0, v=infinity, a>0, b>0, c=b^2]],
    [x^4*cos(a*x)/((b+x^2)*(c-x^4)),
      (PI/(8*sqrt(b)))*(sin(a*sqrt(b))
        +(a*sqrt(b)-2)*exp(-a*sqrt(b))),
      [u=0, v=infinity, a>0, b>0, c=b^2]],
    [x^5*sin(a*x)/((b+x^2)*(c-x^4)),
      PI/8*((-3+a*sqrt(b))*exp(-a*sqrt(b))-cos(a*sqrt(b))),
      [u=0, v=infinity, a>0, b>0, c=b^2]],
    /* begin 3.737 
    Skip 1 2 3 because MUpad can't handle it*/
    [x*sin(a*x)/(b+x^2)^3,
      PI*a*(1+a*sqrt(b))*exp(-a*sqrt(b))/(16*b^(3/2)),
      [u=0, v=infinity, a>0, b>0]],
    [x*sin(a*x)/(b+x^2)^4,
      PI*a*(3+3*a*sqrt(b)+a^2*b)*exp(-a*sqrt(b))/(95*b^(5/2)),
      [u=0, v=infinity, a>0, b>0]],

    // 3.741
    [sin(a*x)*sin(b*x)/x,
      1/4*ln(((a+b)/(a-b))^2),
      [u=0, v=infinity, a>0, b>0]],
    [sin(a*x)*cos(b*x)/x, PI/2,
      [u=0, v=infinity, a>b, b>=0]],
    [sin(a*x)*cos(b*x)/x, PI/4,
      [u=0, v=infinity, a=b, b>0]],
    [sin(a*x)*cos(b*x)/x, 0,
      [u=0, v=infinity, b>a, a>=0]],
    [sin(a*x)*sin(b*x)/x^2, a*PI/2,
      [u=0, v=infinity, 0<a, a<=b]],
    [sin(a*x)*sin(b*x)/x^2, b*PI/2,
      [u=0, v=infinity, 0<b, b<=a]],
      
    [sin(a*x)^2*sin(b*x)^2/x^2,
      PI/4*min(abs(a), abs(b)),
      [u=0, v=infinity, a in R_, b in R_]],

    // 3.742
    [sin(a*x)*sin(b*x)/(c+x^2),
      PI*(exp(-abs(a-b)*sqrt(c))-exp(-abs(a+b)*sqrt(c)))/(4*sqrt(c)),
      [u=0, v=infinity, a>0, b>0, Re(sqrt(c))>0]],
    [sin(a*x)*sin(b*x)/(c+x^2),
      PI*(exp(-a*sqrt(c))*sinh(b*sqrt(c)))/(2*sqrt(c)),
      [u=0, v=infinity, c>0, a>=b, b>=0]],
    [sin(a*x)*sin(b*x)/(c+x^2),
      PI*(exp(-b*sqrt(c))*sinh(a*sqrt(c)))/(2*sqrt(c)),
      [u=0, v=infinity, c>0, b>=a, a>=0]],
    [sin(a*x)*cos(b*x)/(c+x^2),
      (exp(-a*sqrt(c))/(4*sqrt(c)))*(exp( b*sqrt(c))*Ei(sqrt(c)*(a-b))
                                    +exp(-b*sqrt(c))*Ei(sqrt(c)*(a+b)))
     -(exp( a*sqrt(c))/(4*sqrt(c)))*(exp( b*sqrt(c))*Ei(sqrt(c)*(-a-b))
                                    +exp(-b*sqrt(c))*Ei(sqrt(c)*(b-a))),
      [u=0, v=infinity, c>0]],

    [cos(a*x)*cos(b*x)/(c+x^2),
      PI*(exp(-abs(a-b)*sqrt(c))+exp(-abs(a+b)*sqrt(c)))/(4*sqrt(c)),
      [u=0, v=infinity, a>0, b>0, Re(sqrt(c))>0]],
    [cos(a*x)*cos(b*x)/(c+x^2),
      PI*(exp(-a*sqrt(c))*cosh(b*sqrt(c)))/(2*sqrt(c)),
      [u=0, v=infinity, c>0,a>=b, b>=0]],
    [cos(a*x)*cos(b*x)/(c+x^2),
      PI*(exp(-b*sqrt(c))*cosh(a*sqrt(c)))/(2*sqrt(c)),
      [u=0, v=infinity, c>0,b>=a>=0]],
    [x*sin(a*x)*cos(b*x)/(x^2+c),
      PI*exp(-a*sqrt(c))*cosh(b*sqrt(c))/2,
      [u=0, v=infinity, 0<b, b<a]],
    [x*sin(a*x)*cos(b*x)/(x^2+c),
      PI*exp(-2*a*sqrt(c))/4,
      [u=0, v=infinity, 0<b, b=a]],
    [x*sin(a*x)*cos(b*x)/(x^2+c),
      -PI*exp(-b*sqrt(c))*sinh(a*sqrt(c))/2,
      [u=0, v=infinity, 0<a, a<b]],

    [sin(a*x)*sin(b*x)/(p-x^2),
      -PI*cos(a*sqrt(p))*sin(b*sqrt(p))/(2*sqrt(p)),
      [u=0, v=infinity, a>b, b>0]],
    [sin(a*x)*sin(b*x)/(p-x^2),
      -PI*sin(2*a*sqrt(p))/(4*sqrt(p)),
      [u=0, v=infinity, a=b, b>0]],
    [sin(a*x)*sin(b*x)/(p-x^2),
      -PI*sin(a*sqrt(p))*cos(b*sqrt(p))/(2*sqrt(p)),
      [u=0, v=infinity, b>a, a>0]],

    [sin(a*x)*cos(b*x)/(p-x^2),
      -PI*cos(a*sqrt(p))*cos(b*sqrt(p))/2,
      [u=0, v=infinity, a>b>0]],
    [sin(a*x)*cos(b*x)/(p-x^2),
      -PI*cos(2*a*sqrt(p))/4,
      [u=0, v=infinity, a=b, b>0]],
    [sin(a*x)*cos(b*x)/(p-x^2),
      PI*sin(a*sqrt(p))*sin(b*sqrt(p))/2,
      [u=0, v=infinity, b>a, a>0]],

    [cos(a*x)*cos(b*x)/(p-x^2),
      PI*sin(a*sqrt(p))*cos(b*sqrt(p))/(2*sqrt(p)),
      [u=0, v=infinity, a>b, b>0]],
    [cos(a*x)*cos(b*x)/(p-x^2),
      PI*sin(2*a*sqrt(p))/(4*sqrt(p)),
      [u=0, v=infinity, a=b, b>0]],
    [cos(a*x)*cos(b*x)/(p-x^2),
      PI*cos(a*sqrt(p))*sin(b*sqrt(p))/(2*sqrt(p)),
      [u=0, v=infinity, b>a, a>0]],

    // 3.743
    [sin(a*x)/(sin(b*x)*(x^2+c)),
      PI*sinh(a*sqrt(c))/(2*sqrt(c)*sinh(b*sqrt(c))),
      [u=0, v=infinity, 0<a, a<b, Re(sqrt(c))>0]],

    [sin(a*x)*x/(cos(b*x)*(x^2+c)),
      -PI*sinh(a*sqrt(c))/(2*cosh(b*sqrt(c))),
      [u=0, v=infinity, 0<a, a<b,Re(sqrt(c))>0]],
    [cos(a*x)*x/(sin(b*x)*(x^2+c)),
      PI*cosh(a*sqrt(c))/(2*sinh(b*sqrt(c))),
      [u=0, v=infinity, 0<a, a<b, Re(sqrt(c))>0]],
    [cos(a*x)/(cos(b*x)*(x^2+c)),
      PI*cosh(a*sqrt(c))/(2*sqrt(c)*cosh(b*sqrt(c))),
      [u=0, v=infinity, 0<a, a<b, Re(sqrt(c))>0]],

    // 3.744
    [sin(a*x)/(cos(b*x)*x*(x^2+c)),
      PI*sinh(a*sqrt(c))/(2*c*cosh(b*sqrt(c))),
      [u=0, v=infinity, 0<a, a<b,Re(sqrt(c))>0]],
    // 3.745
    [sin(a*x)/(cos(b*x)*x*(c-x^2)),
      0,
      [u=0, v=infinity, 0<a, a<b, c>0]],

    /*Begin 3.75
      Combination of trigonometric and algebraic functions 
      Begin 3.751*/
    [sin(a*x)/sqrt(x+b),
      sqrt(PI/(2*a))*(cos(a*b)-sin(a*b)+2*Ci(sqrt(a*b))*sin(a*b)
        -2*Si(sqrt(a*b))*cos(a*b)),
      [u=0, v=infinity, a>0,abs(arg(b))<PI]],
    [cos(a*x)/sqrt(x+b),
      sqrt(PI/(2*a))*(cos(a*b)+sin(a*b)-2*Ci(sqrt(a*b))*cos(a*b)
        -2*Si(sqrt(a*b))*sin(a*b)),
      [u=0, v=infinity, a>0, abs(arg(b))<PI]],
    [sin(a*x)/sqrt(x-u),
      sqrt(PI/(2*a))*(sin(a*u)+cos(a*u)),
      [v=infinity, a>0, u>0]],
    [cos(a*x)/sqrt(x-u),
      sqrt(PI/(2*a))*(cos(a*u)-sin(a*u)),
      [v=infinity, a>0, u>0]],

    // 3.752
    [sin(a*x)*sqrt(1-x^2),
      sum::sum_fn(k -> (-1)^k*a^(2*k+1)/((2*k+1)!!*(2*k+3)!!), 0..infinity),
      [u=0, v=1, a>0]],
    [cos(a*x)*sqrt(1-x^2),
      PI/(2*a)*besselJ(1, a),
      [u=0, v=1]],

    // 3.757
    [sin(a*x)/sqrt(x),
      sqrt(PI/(2*a)),
      [u=0, v=infinity]],
    [cos(a*x)/sqrt(x),
      sqrt(PI/(2*a)),
      [u=0, v=infinity]],

    // 3.763
    [sin(a*x)*sin(b*x)*sin(c*x)/x,
      0,
      [u=0, v=infinity, c<a-b,c>a+b]],
    [sin(a*x)*sin(b*x)*sin(c*x)/x,
      PI/8,
      [u=0, v=infinity, c=a-b, c=a+b, a<>0, b<>0, c<>0]],
    [sin(a*x)*sin(b*x)*sin(c*x)/x,
      PI/4,
      [u=0, v=infinity, a-b<c, c<a+b, a>=b, b>0, c>0]],
    [sin(a*x)*sin(b*x)*sin(c*x)/x^2,
      (c+a+b)*ln(c+a+b)/4-(c+a-b)*ln(c+a-b)/4
        -abs(c-a-b)*ln(abs(c-a-b))*sign(a+b-c)/4
        +abs(c-a+b)*ln(abs(a-b-c))*sign(a-b-c)/4,
      [u=0, v=infinity, a>=b, b>0, c>0]],
    [sin(a*x)*sin(b*x)*sin(c*x)/x^3,
      PI*b*c/2,
      [u=0, v=infinity, 0<c, c<a-b, c>a+b]],
    [sin(a*x)*sin(b*x)*sin(c*x)/x^3,
      PI*b*c/2-PI*(a-b-c)^2/8,
      [u=0, v=infinity, a-b<c, c<a+b,a>=b, b>0,c>0]],

    // 3.764
    [x^p*sin(a*x+b),
      gamma(1+p)*cos(b+p*PI/2)/a^(p+1),
      [u=0, v=infinity, a>0, -1<p, p<0]],
    [x^p*cos(a*x+b),
      -gamma(1+p)*sin(b+p*PI/2)/a^(p+1),
      [u=0, v=infinity, a>0, -1<p, p<0]],

    // 3.767
    [x^c*sin(a*x+b)/(y+x^2),
      -(PI/2)*y^((c-1)/2)*exp(-a*sqrt(y)),
      [u=0, v=infinity, a>0,Re(sqrt(y))>0,abs(Re(c))<1, c=-b/(PI/2)-1]],
    [x^b*cos(a*x+c)/(y+x^2),
      (PI/2)*y^((b-1)/2)*exp(-a*sqrt(y)),
      [u=0, v=infinity, a>0, Re(sqrt(y))>0, Re(sqrt(y))<1, c=-b*PI/2]],
    [x^c*sin(a*x+d)/(x^2-b),
      (PI/2)*b^((c-1)/2)*cos(a*sqrt(b)+d),
      [u=0, v=infinity, a>0, b>0, -1<Re(c)<0, d=-(c+1)*PI/2]],
    [x^c*cos(a*x+d)/(x^2-b^2),
      -(PI/2)*b^(c-2)*sin(a*b-PI*c/2),
      [u=0, v=infinity, a>0, b>0, abs(Re(c))<1, d=-c*PI/2]],

    // 3.678
    [(x-u)^b*sin(a*x),
      gamma(b+1)*sin(a*u+(b+1)*PI/2)/a^(b+1),
      [v=infinity, a>0, -1<Re(b)<0]],
    [(x-u)^b*cos(a*x),
      gamma(b+1)*cos(a*u+(b+1)*PI/2)/a^(b+1),
      [v=infinity, a>0,0<Re(b)<1]],

    // 3.776
// TODO: Questionable. Should that have been (c*(b+x)^(2+p*q))?
    [(c*(b+x)^2+p*q)*sin(a*x)/(b+x)^r,
      a/b^p,
      [u=0, v=infinity, a>0, b>0, p>0, c=a^2, q=p+1, r=p+2]],
    [(a^2*(b+x)^2+p*q)*cos(a*x)/(b+x)^r,
      a/b^(p+1),
      [u=0, v=infinity, a>0, b>0, p>0, q=p+1, r=p+2]],

    // 3.784
    [(sin(a*x)-a*x*cos(a*x))/x^3,
      PI*a^2*sign(a)/4,
      [u=0, v=infinity]],
    [(cos(a*x)-cos(b*x))/(x^2*(x^2+c)),
      PI*((b-a)*sqrt(c)+E^(-b*sqrt(c))-E^(-a*sqrt(c)))/(2*c^(3/2)),
      [u=0, v=infinity, a>0, b>0]],

    // 3.786 
    [(1-cos(a*x))*sin(b*x)/x^2,
      (b/2)*ln((b^2-a^2)/b^2)+(a/2)*ln((a+b)/(a-b)),
      [u=0, v=infinity, a>0, b>0]],
    [(1-cos(a*x))*cos(b*x)/x,
      ln(sqrt(abs(a^2-b^2))/b),
      [u=0, v=infinity, a>0, b>0]],
    [(1-cos(a*x))*cos(b*x)/x^2,
      PI*(a-b)/2,
      [u=0, v=infinity, a>=b, b>0]],
    [(1-cos(a*x))*cos(b*x)/x^2,
      PI*(a+b)/2,
      [u=0, v=infinity, a>=-b, b<0]],
    [(1-cos(a*x))*cos(b*x)/x^2,
      PI*(-a-b)/2,
      [u=0, v=infinity, -a>=b, b>0]],
    [(1-cos(a*x))*cos(b*x)/x^2,
      PI*(-a+b)/2,
      [u=0, v=infinity, -a>=-b, b<0]],

    [(1-cos(a*x))*cos(b*x)/x^2,
      0,
      [u=0, v=infinity, 0<a, a<=b]],
    [(1-cos(a*x))*cos(b*x)/x^2,
      0,
      [u=0, v=infinity, 0>a, -a<=b]],
    [(1-cos(a*x))*cos(b*x)/x^2,
      0,
      [u=0, v=infinity, 0<a, a<=-b]],
    [(1-cos(a*x))*cos(b*x)/x^2,
      0,
      [u=0, v=infinity, 0>a, -a<=-b]],

    // 3.787
    [(sin(a*x)^2-sin(b*x)^2)/x,
      ln(a/b)/2,
      [u=0, v=infinity, a>0,b>0]],
    [(x^3-sin(x)^3)/x^5,
      13*PI/32,
      [u=0, v=infinity]],
    // TODO: check condition
    [(3-4*sin(a*x)^2)*sin(a*x)^2/x,
      ln(2)/2,
      [u=0, v=infinity, Re(a)>0]],
    [(4*sin(a*x)^2-3)*sin(a*x)^2/x,
      -ln(2)/2,
      [u=0, v=infinity, Re(a)>0]],

    // 3.789
    [(4*x^2*cos(x)+(PI-x)*x)/sin(x),
      PI^2*ln(2),
      [u=0, v=PI/2]],

    // 3.792
    [1/(1+a*cos(x)+b),
      (v-u)/(1-b),
      [matchlib::block(testtype((v-u)/2*PI, Type::Integer)), b=a^2/4, b<1]],
    [x*cos(x)/(1+a*sin(x)+b),
      matchlib::block(PI*ln(1+a/2)/a
        - sum::sum_fn(k -> 
             (-1)^k*b^k/(2*k+1)^2, 0..infinity)),
      [u=0, v=PI/2, b=a^2/4, b<1]],

    [1/((1+a*cos(b*x)+d)*(c+x^2)),
      PI*(1-a/2*exp(-b*sqrt(c)))/
        (2*sqrt(c)*(1-d)*(1+a/2*exp(-b*sqrt(c)))),
      [u=0, v=infinity, d=a^2/4, d<1, b>=0]],
    [1/((1+a*cos(b*x)+c)*(d-x^2)),
      a*PI*sin(b*sqrt(d))/
         (sqrt(d)*(1-c)*(1+a*cos(b*sqrt(d))+c)),
      [u=0, v=infinity, c=a^2/4, 0<c, c<1, b>0]],
    [sin(c*x)*x/((1+a*cos(b*x)+d)*(e+x^2)),
      (PI/2)*(exp(-sqrt(e)*c)+(a/2)^(c/b))/
        ((1+a/2*exp(-b*sqrt(e)))*(1+a/2*exp(b*sqrt(e)))),
      [u=0, v=infinity, d=a^2, d<1, b>0, c>0]],
    [sin(b*x)*x/((1+a*cos(b*x)+c)*(d+x^2)),
      PI/(2*(exp(b*sqrt(d))+a/2)),
      [u=0, v=infinity, c=a^2/4, c<1, b>0]],

    [sin(c*x)*x/((1+a*cos(b*x)+d)*(e-x^2)),
      PI*((-a/2)^(c/b)-cos(sqrt(e)*c))/(2*(1+a*cos(b*sqrt(e))+d)),
      [u=0, v=infinity, d=a^2/4, d<1, b>0, c>0]],
    [cos(c*x)/((1+a*cos(b*x)+d)*(e-x^2)),
      (PI/(2*sqrt(e)*(1-d)))*(((1-d)*sin(sqrt(e)*c)
           +2*(-a/2)^(c/b+1)*sin(sqrt(e)*b))/
      (1+a*cos(sqrt(e)*b)+d)),
      [u=0, v=infinity, d=a^2/4, d<1, b>0, c>0]],
    [(1+d*cos(b*x))/((1+a*cos(b*x)+c)*(1+x^2)),
      PI*exp(b)/(2*exp(b)+a),
      [u=0, v=infinity, c=a^2/4, c<1, b>0, d=2*a]],

    // 3.821
    [x*sin(x)^p,
      PI^2/2^(p+1)*gamma(p+1)/gamma(p/2+1)^2,
      [u=0, v=PI, p>-1]],
    [x*sin(x)^n1,
      (-1)^(v/PI+1)*v*(n1-1)!!/n1!!,
      [u=0, v/PI in N_]],
    [x*sin(x)^n2,
      v^2/2*(n2-1)!!/n2!!,
      [u=0, v/PI in N_]],
    [x*sin(x)^n1,
      gamma((n1+1)/2)/gamma(n1/2+1)*sum::sum_fn(
        k -> gamma(k+1/2)/gamma(k+1)/2/(2*k+1), 0..(n1-1)/2),
     [u=0, v=PI/2]],
    [x*sin(x)^n2,
      PI^2/8*(n2-1)!!/n2!!+
      gamma((n2+1)/2)/gamma(n2/2+1)*sum::sum_fn(
        k -> gamma(k)/gamma(k+1/2)/4/k, 1..n2/2),
      [u=0, v=PI/2]],
    [x*cos(x)^n1,
      PI/2*(n1-1)!!/n1!! -
      gamma((n1+1)/2)/gamma(n1/2+1)*sum::sum_fn(
        k -> gamma(k+1/2)/gamma(k+1)/2/(2*k+1), 0..(n1-1)/2),
      [u=0, v=PI/2]],
    [x*cos(x)^n2,
      PI^2/8*(n2-1)!!/n2!! -
      gamma(n2/2+1/2)/gamma(n2/2+1)*sum::sum_fn(
        k -> gamma(k)/gamma(k+1/2)/4/k, 1..n2/2),
      [u=0, v=PI/2]],

//    [x*cos(x)^n2,
//      PI^2/2*(n2-1)!!/n2!!,
//      [u=0, v=PI]],
///    [x*cos(x)^n2,
///      (v^2-u^2)/2*(n2-1)!!/n2!!,
///      [u in R_, v in R_]],
    
    [sin(x)^p/x,
      sqrt(PI)/2*gamma(p/2)/gamma((p+1)/2),
      [u=0, v=infinity, p in Q_, p > 0,
       numer(p) in 2*Z_ + 1, denom(p) in 2*Z_ + 1]],
    [sin(x)^n1/x,
      PI/2*(n1-2)!!/(n1-1)!!,
      [u=0, v=infinity, n1>2]],
    [sin(x)^n2/x,
      infinity,
      [u=0, v=infinity]],
    [sin(a*x)^2/x^2,
      abs(a)*PI/2,
      [u=0, v=infinity, a in R_]],
    [sin(a*x)^n2/x^2,
      abs(a)*PI/2*(n2-3)!!/(n2-2)!!,
      [u=0, v=infinity, a in R_, n2>3]],
    [sin(a*x)^n1/x^3,
      sign(a)*a^2*PI/4*n1*(n1-4)!!/(n1-1)!!,
      [u=0, v=infinity, a in R_, n1>4]],
    [sin(x)^p/x^2,
      matchlib::block(p*int(sin(x)^(p-1)/x*cos(x), x=0..infinity)),
      [u=0, v=infinity, matchlib::block(is(p>1, Goal=TRUE))]],
    [sin(a*x)^m/x^n, 
      matchlib::block(intlib::definite::sin_power_times_x_power(m, n)*a^(n-1)),
      [u=0, v=infinity, matchlib::block(testtype(m, DOM_INT)), m>=n, n>0, a>0]],
    [sin(x)^p/x^m,
      matchlib::block(p*(p-1)/((m-1)*(m-2))*int(sin(x)^(p-2)/x^(m-2), x=0..infinity)
         - p^2/((m-1)*(m-2))*int(sin(x)^p/x^(m-2), x=0..infinity)),
      [u=0, v=infinity, matchlib::block(is(p>m-1, Goal=TRUE)),
       matchlib::block(is(m>3, Goal=TRUE)=TRUE)]],
    [sin(p*x)^n2/sqrt(x),
      infinity,
      [u=0, v=infinity, p<>0]],
    [sin(p*x)^n1/sqrt(x),
      matchlib::block(1/2^(n1-1)*sqrt(PI/(2*p))*
      sum::sum_fn(k -> (-1)^k*binomial(n1,(n1-1)/2+k+1)*1/sqrt(2*k+1), 0..(n1-1)/2)),
      [u=0, v=infinity]],
    // addendum from the old matcher code
    [sin(a*x)^3/x, sign(a)*PI/4,
      [u=0, v=infinity]],
    [sin(a*x)^3/x^2, 3/4*a*ln(3),
      [u=0, v=infinity]],
    [sin(a*x)^b/x^n, sign(a^b)*infinity,
      [u=0, v=infinity, n>1, b-n<=-1]],

    // TODO: pattern for ln(x)^n*exp(-x^2) ???
    [ln(x)*exp(-x^2), -sqrt(PI)/4*(EULER+ln(4)), [u=0, v=infinity]],
    [ln(x)/exp(x^2), -sqrt(PI)/4*(EULER+ln(4)), [u=0, v=infinity]],
    [ln(x)^2*exp(-x^2), sqrt(PI)/8*((EULER+ln(4))^2+PI^2/2), [u=0, v=infinity]],
    [ln(x)^2/exp(x^2), sqrt(PI)/8*((EULER+ln(4))^2+PI^2/2), [u=0, v=infinity]],

    // Gradshteyn, 4.222
    [ln((x^2+a)/(x^2+b)),
      (sqrt(a)-sqrt(b))*PI,
      [u=0, v=infinity, a>0, b>0]],
    [ln(x)*ln((x^2+a)/(x^2+b)),
      (sqrt(b)-sqrt(a))*PI + PI*ln(sqrt(a)^sqrt(a)/sqrt(b)^sqrt(b)),
      [u=0, v=infinity, a>0, b>0]],
    [ln(x)*ln(1+b/x^2),
      PI*sqrt(b)*ln(sqrt(b)-1),
      [u=0, v=infinity, b>0]],

  // rather use indefinite integrals for these
    [sin(a*x)/x, PI/2, [a>0, u=0, v=infinity]],
    [sin(a*x)/x, -PI/2, [a<0, u=0, v=infinity]],
    [(cos(a*x)-cos(b*x))/x, ln(b/a), [u=0, v=infinity, not b/a <= 0]],

    // TODO: sin(x)*cos(a*x)/x

    [sin(x)/sqrt(x), sqrt(PI/2), [u=0, v=infinity]],
    [x*sin(b*x)/(x^2+a), PI/2*exp(-sqrt(a)*b), [a>0, b>0, u=0, v=infinity]],
    [x*sin(b*x)/(x^2+a), -PI/2*exp(sqrt(a)*b), [a>0, b<0, u=0, v=infinity]],
    
    [cos(a*x)/(x^2+1), PI/2*exp(-a), [a>0, u=0, v=infinity]],
    [cos(a*x)/(x^2+1), PI/2*exp(a), [a<0, u=0, v=infinity]],
    [sin(a*x)^2/x^2, PI/2*abs(a), [a in R_, u=0, v=infinity]],

    [1/sqrt(1+a*x^2), arcsin(sqrt(-a))/sqrt(-a), [not a<=-1, u=0, v=1]],
    [x/sqrt(1-x^2)/sqrt(1+a*x^2), 1/4/sqrt(-a)*arctanh(sqrt(-a)), [not a<=-1, u=0, v=1]],

    [ln(x)/(x-1), PI^2/6, [u=0, v=1]],
    [ln(x)/(x+1), -PI^2/12, [u=0, v=1]],

    // dauert lange bis es gefunden wird, da int zunchst die Summe im Zhler zerlegt
    [(x^a-1)*(x^b-1)/(x-1)/ln(x), -ln(gamma(a+1)*gamma(b+1)/gamma(a+b+1)), [a>-1, b>-1, a+b>-1, u=0, v=1]],

    [ln(1/x)^a, gamma(a+1), [a>-1, u=0, v=1]],

    [x*ln(sin(x)), -PI^2*ln(2)/2, [u=0, v=PI]],
    [sin(x)/x*ln(x), -PI/2*EULER, [u=0, v=infinity]],
    [sin(x)/x*ln(x)^2, PI/2*EULER^2+PI^3/24, [u=0, v=infinity]],

    [ln(a+b*cos(x)), PI*ln((a+sqrt(a^2-b^2))/2), [a>=b or a>=-b, u=0, v=PI]],

    [ln(x/sqrt(1-x^2))/sqrt(1-x^2), 0, [u=0, v=1]],  // int(ln(tan(x)), x=0..PI/2)
    [ln(1+tan(x)), PI/8*ln(2), [u=0, v=PI/4]],

    // Gradshteyn, Table of Integrals, Series and Products
    [ln(1+a*x)*x/sqrt(1-x^2), -1+PI/2/a+sqrt(1-a^2)/a*(arcsin(a)-PI/2), [not a<-1, u=0, v=1]],  // 4.292.4
    [arctanh(a*x)*x/sqrt(1-x^2), PI/2/a*(1-sqrt(1-a^2)), [not a<-1, not a>1, u=0, v=1]],
    [ln(1+a*x)/x/sqrt(1-x^2), PI^2/8-arccos(a)^2/2, [not a<-1, u=0, v=1]],  // 4.292.5
    [arctanh(a*x)/x/sqrt(1-x^2), PI^2/4-PI/2*arccos(a), [not a<-1, not a>1, u=0, v=1]],

    // integral representations of special functions
    [exp(-x^2)/x*sin(a*x), erf(a/2)*PI/2, [a in R_, u=0, v=infinity]],

    [exp(a*x)/x, Ei(1, -a), [Re(a)<0, u=1, v=infinity]],

    // other trig patterns
    [cos(x)/(x^2+a^2), PI/a*exp(-a), 
     [u=-infinity, v=infinity, Re(a) > 0]], // Mma
    [cos(x)/(x^2+a), PI/sqrt(a)*exp(-sqrt(a)),
     [u=-infinity, v=infinity, not a<=0]],
    [sin(x)/(x^2+a), 0,
     [u=-infinity, v=infinity, not a<=0]], // Mma, simplified

    // keep this as long as indefinite integration cannot handle it:
    [(cos(x)-1)/x, Ci(v)-ln(v)-EULER, [u=0]],

    [1/sqrt(1+a*x^2)/sqrt(1-x^2), ellipticF(arcsin(v), -a), [u=0, v>=-1, v<=1]],
    [sqrt(1+a*x^2)/sqrt(1-x^2), ellipticE(arcsin(v), -a), [u=0, v>=-1, v<=1]],
    [1/sqrt(1+a*x^2)/(b+c*x^2)/sqrt(1-x^2), ellipticPi(-c/b, arcsin(v), -a)/b, [u=0, v>=-1, v<=1]],

    [x^a*(x+d)^b*exp(c*x), gamma(a+1)*kummerU(a+1,a+b+2,-c*d)*d^(a+b+1), [Re(a)>-1, Re(c)<0, d>0, u=0, v=infinity]],
    [x^a*(x+d)^b/exp(c*x), gamma(a+1)*kummerU(a+1,a+b+2,c*d)*d^(a+b+1), [Re(a)>-1, Re(c)>0, d>0, u=0, v=infinity]],

    [x^n/(exp(x)+a), -polylog(n+1,-a)*gamma(n+1)/a, [not a<=-1, u=0, v=infinity]],

    [x^a*(1-x)^b*exp(c*x), hypergeom([a+1],[a+b+2],c)*beta(a+1,b+1), 
      [Re(a)>-1, Re(b)>-1, matchlib::block(not iszero(a) or not iszero(b)), u=0, v=1]],

    [x^a/(exp(x)+1), zeta(a+1)*gamma(a+1)*(1-2^(-a)), [Re(a)>-1, u=0, v=infinity]],
    [x^a/(exp(x)-1), zeta(a+1)*gamma(a+1), [Re(a)>0, u=0, v=infinity]],

    // integral representations for CATALAN
    [x*exp(x/2)/(exp(x)+1), 4*CATALAN, [u=0, v=infinity]],
    [x/cosh(x), 2*CATALAN, [u=0, v=infinity]],
    [arctan(x)/x, CATALAN, [u=0, v=1]],
    [ellipticK(x)/sqrt(x), 4*CATALAN, [u=0, v=1]],
    [ellipticK(x^2), 2*CATALAN, [u=0, v=1]],
    [ellipticE(x^2), CATALAN+1/2, [u=0, v=1]],
    [arctan(x)^2, PI^2/16+PI/4*ln(2)-CATALAN, [u=0, v=1]],

    // integral representations for EULER
    [ln(-ln(x)), -EULER, [u=0, v=1]],
    [ln(ln(1/x)), -EULER, [u=0, v=1]],

    // integrals involving special functions
    [besselJ(a,x), 1, [Re(a)>0, u=0, v=infinity]],
    [besselJ(a,x)^2/x, 1/2/a, [Re(a)>0, u=0, v=infinity]],
    [besselY(a,x), -tan(a*PI/2), [Re(a)<1, Re(a)>-1, u=0, v=infinity]],

    [ellipticK(a*x^2)*x/sqrt(1-x^2), (PI^2/4-PI/2*arccos(sqrt(a)))/sqrt(a), [u=0, v=1]],

    // misc patterns
    [1/sqrt(a/x+b), PI*a/(-b)^(3/2)/2, [b<0, u=0, v*b=-a]],
    
    [x/sin(x), 2*CATALAN, [u=0, v=PI/2]],
    [ln(x)/(x+1), -PI^2/12, [u=0, v=1]],
    [ln(x)/(1-x), -PI^2/6, [u=0, v=1]],
    [ln(1+x)/x, PI^2/12, [u=0, v=1]],
    [ln(x)*ln(1+x), -2*ln(2)-PI^2/12+2, [u=0, v=1]],
    [ln(x)/(1-x^2), -PI^2/8, [u=0, v=1]],
    [ln((1+x)/(1-x))/x, PI^2/4, [u=0, v=1]],
    [ln((1+exp(x))/(exp(x)-1)), PI^2/4, [u=0, v=infinity]],
    [x*ln(sin(x)), -PI^2*ln(2)/2, [u=0, v=PI]],
    // (29) from Victor Adamchik paper in ISSAC'97
    [1/(1+x^2)*ln(ln(1/x)),
      PI/2*ln((2*PI)^(1/2)*gamma(3/4)/gamma(1/4)), [u=0, v=1]],
    // (30) from Victor Adamchik paper in ISSAC'97
    [x/(1+x^4)*ln(ln(1/x)),
      PI/4*ln(PI^(1/2)*gamma(3/4)/gamma(1/4)), [u=0, v=1]],
    // (31) from Victor Adamchik paper in ISSAC'97
    [1/(1+x^3)*ln(ln(1/x)),
      ln(2)/6*ln(3/2)-PI*(ln(54)-8*ln(2*PI)+12*ln(gamma(1/3)))/6/3^(1/2), 
      [u=0, v=1]],
    // (32) from Victor Adamchik paper in ISSAC'97
    [1/(1-x+x^2)*ln(ln(1/x)),
      PI*(5*ln(2*PI)-6*ln(gamma(1/6)))/3/3^(1/2), [u=0, v=1]],
    // from Victor Adamchik paper in ISSAC'97, 3.5 page 6
    [1/(1+x+x^2)*ln(ln(1/x)),
      PI*(-3*ln(3)+8*ln(2*PI)-12*ln(gamma(1/3)))/6/3^(1/2), [u=0, v=1]],
    // from Victor Adamchik paper in ISSAC'97, 3.6 page 6
    [x/(1+x+x^2+x^3+x^4)*ln(ln(1/x)),
      PI/5*(cot(2*PI/5)*ln(2*PI)-2*ln(gamma(1/5)/gamma(4/5))*sin(PI/5)
      +2*ln(gamma(2/5)/gamma(3/5))*sin(2*PI/5)), [u=0, v=1]],
    // (42) from Victor Adamchik paper in ISSAC'97
    [x^(1/2)/(1+x)^2*ln(ln(1/x)),
      EULER/2-3/2*ln(2)+ln(4*gamma(3/4)/gamma(1/4))+PI/2*ln(2*PI^(1/2)*
      gamma(3/4)/gamma(1/4)), [u=0, v=1]],
    // (43) from Victor Adamchik paper in ISSAC'97
    [x^(1/2)/(1+x^3)^2*ln(ln(1/x)),
      -EULER/6-1/3*ln(6^(1/2)*gamma(3/4)/gamma(1/4))+PI/6*ln(2*(PI/3)^(1/2)*
      gamma(3/4)/gamma(1/4)), [u=0, v=1]],
    // (44) from Victor Adamchik paper in ISSAC'97
    [x/(1-x+x^2)^2*ln(ln(1/x)),
      -EULER/3-1/3*ln(6*3^(1/2)/PI)+PI*3^(1/2)/27*(5*ln(2*PI)
      -6*ln(gamma(1/6))), [u=0, v=1]],
    // (47) from Victor Adamchik paper in ISSAC'97
    [x^(1/2)/(1+x)^3*ln(ln(1/x)),
      -CATALAN/2/PI+PI/8*ln(2*PI^(1/2)*gamma(3/4)/gamma(1/4)), [u=0, v=1]],
    // (48) from Victor Adamchik paper in ISSAC'97
    [1/(1+x^2)^3*ln(ln(1/x)),
      1/32*(-16*ln(2)+3*PI*ln(2*PI)+8*CATALAN/PI-8*EULER+2*(3*PI-8)*
      ln(gamma(3/4)/gamma(1/4))), [u=0, v=1]],
    // (49) from Victor Adamchik paper in ISSAC'97
    [(1-6*x^2+x^4)/(1+x^2)^3*ln(ln(1/x)),
      2*CATALAN/PI, [u=0, v=1]],
    [sech(x)*tanh(x)/x, 4*CATALAN/PI, [u=0, v=infinity]],
    // (50) from Victor Adamchik paper in ISSAC'97
    [tanh(x)/x/(1-2*cosh(2*x))^2,
      (-2*3^(1/2)*PI^2-3*PI*ln(3)+3^(1/2)*psi(1/6,1))/18/PI, 
      [u=0, v=infinity]],
    // (51) from bug report #723
    [ln((exp(I*x) + 1)/sign(exp(I*x) + 1)), CATALAN, [u=0, v=PI/2]],
    

    // exponential Fourier transform
    /*
    [gx*exp(s*x),
      matchlib::block(transform::fourier(gx, x, I*s)),
      [matchlib::block(not iszero(s)), u=-infinity, v=infinity]],
    */
    
    [x*exp(a*x)*exp(b*x^2),
      (a*sqrt(-b)*sqrt(PI) + a*sqrt(b)*sqrt(PI)*erfi(a/2/sqrt(b)))/
      (4*b^2*exp(a^2/4/b))-1/2/b,
      [u=0, v=infinity, Re(b)<0]],
    [x*exp(a*x)*exp(b*x^2),
      a*sqrt(PI)/(2*(-b)^(3/2)*exp(a^2/(4*b))),
      [u=-infinity, v=infinity, Re(b)<0]],
    [exp(a*x+b*x^2),
      sqrt(-PI/(4*b))*exp(-a^2/(4*b))*(1-
        erf(-a*sqrt(-1/(4*b))+u/(2*sqrt(-1/(4*b))))),
      [u >= 0, v=infinity, b<>0, Re(1/b)<0]], // GR 3.322.1/2
    [exp(a*x+b*x^2),
      exp(-a^2/(4*b))*sqrt(PI)/sqrt(-b),
      [u=-infinity, v=infinity, Re(b)<0]], // GR 3.323.3
    // numeric::int fails to verify this one:
    [exp(-x^t), gamma(1/t)/t,
      [u=0, v=infinity, Re(t)>0]], // GR 3.326.1
    [exp(-exp(x))*exp(t*x), gamma(t),
      [u=-infinity, v=infinity, Re(t)>0]], // GR 3.328
    
    // from old lookup
    [x^w*ln(b*x^d)^m3*exp(q*x^s)*sin(c*x^s),
      matchlib::block(intlib::intdef1("sin", w, b, d, m3, -q, s, c)),
      [u=0, v=infinity, m3>=0, Re(q) <= 0]],
    [x^w*ln(b*x^d)^m3*exp(q*x^s)*cos(c*x^s),
      matchlib::block(intlib::intdef1("cos", w, b, d, m3, -q, s, c)),
      [u=0, v=infinity, m3>=0, Re(q) <= 0]],
    [x^w*ln(b*x^d)^m3*exp(q*x^s),
      matchlib::block(intlib::intdef1(" ", w, b, d, m3, -q, s, 0)),
      [u=0, v=infinity, m3>=0, Re(q) <= 0]],
    [x^w*ln(b*x^d)^m3*sin(c*x^s),
      matchlib::block(intlib::intdef1("sin", w, b, d, m3, 0, s, c)),
      [u=0, v=infinity, m3>=0]],
    [x^w*ln(b*x^d)^m3*cos(c*x^s),
      matchlib::block(intlib::intdef1("cos", w, b, d, m3, 0, s, c)),
      [u=0, v=infinity, m3>=0]],
    [x^w*ln(b*x^d)*exp(q*x^s)*sin(c*x^s),
      matchlib::block(intlib::intdef1("sin", w, b, d, 1, -q, s, c)),
      [u=0, v=infinity, Re(q) <= 0]],
    [x^w*ln(b*x^d)*exp(q*x^s)*cos(c*x^s),
      matchlib::block(intlib::intdef1("cos", w, b, d, 1, -q, s, c)),
      [u=0, v=infinity, Re(q) <= 0]],
    [x^w*ln(b*x^d)*exp(q*x^s),
      matchlib::block(intlib::intdef1(" ", w, b, d, 1, -q, s, 0)),
      [u=0, v=infinity, Re(q) <= 0]],
    [x^w*ln(b*x^d)*sin(c*x^s),
      matchlib::block(intlib::intdef1("sin", w, b, d, 1, 0, s, c)),
      [u=0, v=infinity]],
    [x^w*ln(b*x^d)*cos(c*x^s),
      matchlib::block(intlib::intdef1("cos", w, b, d, 1, 0, s, c)),
      [u=0, v=infinity]],
    [x^w*exp(q*x^s)*sin(c*x^s),
      matchlib::block(intlib::intdef1("sin", w, 0, 0, 0, -q, s, c)),
      [u=0, v=infinity, Re(q) <= 0]],
    [x^w*exp(q*x^s)*cos(c*x^s),
      matchlib::block(intlib::intdef1("cos", w, 0, 0, 0, -q, s, c)),
      [u=0, v=infinity, Re(q) <= 0]],
    [x^w*exp(q*x^s),
      matchlib::block(intlib::intdef1(" ", w, 0, 0, 0, -q, s, 0)),
      [u=0, v=infinity, Re(q) <= 0]],
    [x^w*sin(c*x^s),
      matchlib::block(intlib::intdef1("sin", w, 0, 0, 0, 0, s, c)),
      [u=0, v=infinity]],
    [x^w*cos(c*x^s),
      matchlib::block(intlib::intdef1("cos", w, 0, 0, 0, 0, s, c)),
      [u=0, v=infinity]],
    // _X^_pattern(w)*exp(-_X^_pattern(_s)*_pattern(u, not has, _X))*ln(_X^_pattern(d)*_pattern(b, not has, _X))^_pattern(m, Type::NonNegInt)
    // _X^_pattern(w)*exp(-_X^_pattern(_s)*_pattern(u, not has, _X))*cos(_X^_pattern(_s)*_pattern(c, not has, _X))*ln(_X^_pattern(d)*_pattern(b, not has, _X))^_pattern(m, Type::NonNegInt)
    // int(t^w*ln(b*t^d)^m*exp(-u*t^s)*cos(c*t^s),t=0..infinity)
    // int(t^w*ln(b*t^d)^m*exp(-u*t^s),t=0..infinity)
    // from the definition of beta:
    [sin(x)^r*ln(sin(x))^n3*cos(x)^s*ln(cos(x))^m3,
      matchlib::block(2^(-n3-m3-1)*D([1$m3, 2$n3], beta)((r+1)/2,(s+1)/2)),
      [u=0, v=PI/2, m3>=0, n3>=0]],
    [x^r*ln(x)^n,
      -infinity,
      [u=0, v=1, r<=-1]],
    [x^r*ln(x)^n,
      (-1)^n*(r+1)^(-n-1)*gamma(n+1),
      [u=0, v=1, Re(r)>-1]],
/* wrong for [n3=3, m3=3, r=-2, q=2, s=0]
    [x^r*ln(x)^n3*(1-x^q)^s*ln(1-x^q)^m3,
      matchlib::block(n3!*m3!*
        sum::sum_fn(v -> intlib::C(n3-v,1,1,0,0)*
             sum::sum_fn(r -> binomial(v+(r+1)/(q-1)+1,(r+1)/(q-1))*
               intlib::C(m3-(r+1)/(q-1),1,1,0,0)*intlib::C(v+(r+1)/(q-1)+1,1,0,0,1), 0..m3),
               0..n3)/q^(n3+1)),
      [u=0, v=1, q>0, q<>1, n3>=0, m3>0, (r+1)/(q-1)=-1, s=0]], // formula (3.1) of Koelbig
*/
/* seems wrong for [m3 = 1, n3 = 1, q = 7, r = 1, s = 1]
    [x^r*ln(x)^n3*(1-x^q)^s*ln(1-x^q)^m3,
      matchlib::block(D([1$m3, 2$n3], beta)((r+1)/(q-1)+1, s+1)/q^(n3+1)),
      [u=0, v=1, q>0, q<>1, n3>=0, m3>0, r<>0, not((r+1)/(q-1)=-1 and s=0 and m3>0)]],
*/
    // int(t^r*ln(t)^m/(1+b*t^s)^l,t=0..infinity)
    // int(t^r*ln(t)^m/(1-t)^l,t=0..infinity)
    // 
    [x^k/(exp(x)+1),
      gamma(k+1)*(1-2^(-k))*zeta(k+1),
      [u=0, v=infinity, Re(k)>-1, k<>0]],
    [x^k/(exp(x)+1),
      ln(2),
      [u=0, v=infinity, k=0]],
    
    [x^a*(1-x)^b, beta(a+1, b+1),
      [u=0, v=1, Re(a)>-1, Re(b)>-1]], // GR 8.380.1a
    [x^a*(1-x^2)^b, beta((a+1)/2, b+1)/2,
      [u=0, v=1, Re(a)>-1, Re(b)>-1]], // GR 8.380.1b
    [sin(x)^a*cos(x)^b, beta((a+1)/2, (b+1)/2)/2,
      [u=0, v=PI/2, Re(a)>-1, Re(b)>-1]], // GR 8.380.2

    [x^s*hypergeom([a, b], [c], -x),
      pochhammer(a, -s-1)*pochhammer(b, -s-1)*gamma(s+1)/pochhammer(c, -s-1),
      [u=0, v=infinity, Re(s)>-1, Re(a-s)>1, Re(b-s)>1, not(c in Z_ and c <= 0)]], // GR 7.511
    [x^(a-g)*(1-x)^(g-b-1)*hypergeom([a, b], [g], x),
      pochhammer(1 + a/2 - b, b)*gamma(g)*pochhammer(1 + a, -g)*pochhammer(g - a/2, -b),
      [u=0, v=1, Re(a+1) > Re(g), Re(g) > Re(b), Re(g - a/2 - b) > 0]], // GR 7.512.1
    [x^r*(1-x)^(b-g-n0)*hypergeom([-n0, b], [g], x),
      pochhammer(g+n0, -n0)*beta(r+1, b-g+1)*pochhammer(g-r-1, n0),
      [u=0, v=1, Re(r)>-1, Re(b-g) > n0-1]], // GR 7.512.2
    [x^(r-1)*(1-x)^(b-r-1)*hypergeom([a, b], [g], x),
      pochhammer(g-r, r)*gamma(r)*pochhammer(b, -r)*pochhammer(g-a, -r),
      [u=0, v=1, Re(r)>0, Re(b-r)>0, Re(g-a-r)>0]], // GR 7.512.3
    [x^(g-1)*(1-x)^(r-1)*hypergeom([a, b], [g], x),
      gamma(g)*gamma(r)*gamma(g+r-a-b)/(gamma(g+r-a)*gamma(g+r-b)),
      [u=0, v=1, Re(g)>0, Re(r)>0, Re(g+r-a-b)>0]], // GR 7.512.4
    [x^r*(1-x)^s*hypergeom([a, b], [g], x),
      beta(r+1, s+1)*hypergeom([a, b, r+1], [g, r + s + 2], 1),
      [u=0, v=1, Re(r)>-1, Re(s)>-1, Re(g + s - a - b) > -1]], // GR 7.512.5
    [x^(l-1)*(1-x)^(b-l-1)*hypergeom([a, b], [l], z*x),
      beta(l, b-l)/(1-z)^a,
      [u=0, v=1, Re(b)>Re(l), Re(l)>0, not z > 1]], // GR 7.512.6
    [x^l*(1-x)^e*hypergeom([a, b], [g], z*x)*hypergeom([h, k], [f], (1-x)*y),
      beta(f, g)*(1-y)^(a+b-g-f)*hypergeom([a, b], [f+g], y+z-y*z),
      [u=0, v=1, 0<Re(g), Re(f)>0, not z > 1, not y > 1,
       e=f-1, h=f+g-a, k=f+g-b, l=g-1]], // GR 7.512.7
    [x^l*(1-x)^e*hypergeom([a, b], [g], z*x)*hypergeom([h, k], [f], y+w*x),
      beta(f,g)*(1-y)^(a+b-g-f)*hypergeom([a, b], [f+g], y+z-y*z),
      [u=0, v=1, 0<Re(g), Re(f)>0, not z > 1, not y > 1,
       e=f-1, h=f+g-a, k=f+g-b, l=g-1, w=-y]], // GR 7.512.7
    // 8, 9
    [x^(g-1)*(x+z)^(-s)*hypergeom([a, b], [g], -x),
      gamma(g)*gamma(a-g+s)*gamma(b-g+s)/(gamma(s)*gamma(a+b-g+s)) *
      hypergeom([a-g+s, b-g+s], [a+b-g+s], 1-z),
      [u=0, v=infinity, Re(g)>0, Re(a-g+s)>0, Re(b-g+s)>0, not(z <= 0)]], // GR 7.512.10
    // 11, 12: Matcher can't handle lists of unknown length
    [x^(s-1)*(1-x^2)^w*hypergeom([-n, a], [b], x^2),
      beta(w+1, s/2)/2*hypergeom([-n, a, s/2], [b, w+1+s/2], 1),
      [u=0, v=1, Re(s)>0, Re(w)>-1]], // GR 7.513
    
    // 7.521: Matcher can't handle lists of unknown length
    // 7.522.1: MacRobert's E function is not in MuPAD
    [exp(b*x)*x^(a-1)*hypergeom([1/2+v, 1/2-v], [a], -x/2),
      2^a*exp(-b)/sqrt(PI)*gamma(a)*(-2*b)^(1/2-a)*besselK(v, -b),
      [u=0, v=infinity, Re(a)>0, Re(b)<0]], // GR 7.522.2
    [exp(b*x)*(x)^(a-1)*hypergeom([1/2+v, 1/2-v], [a], -x),
      2*exp(-b/2)/sqrt(PI)*gamma(a)*(-b)^(1/2-a)*besselK(v, -b),
      [u=0, v=infinity, Re(a)>0, Re(b)<0]], // GR 7.522.2
    [exp(b*x)*x^(g-1)*hypergeom([a, c], [g], l*x),
      gamma(g)*(-b)^(-g)*(b/l)^((a+c-1)/2)*exp(b/2/l)*whittakerW((1-a-c)/2, (a-c)/2, b/l),
      [u=0, v=infinity, Re(b)<0, Re(g)>0, not(l >= 0)]], // GR 7.522.3
    // 7.522.4: Unknown Psi function of three arguments
    // 7.522.5: Matcher can't handle lists of unknown length
    [x^(b-1)*exp(t*x)*hypergeom([-n, n+1], [1, b], x),
      matchlib::block(gamma(b)/(-t)^b*expr(orthpoly::legendre(n, 1+2/t))),
      [u=0, v=infinity, Re(t)<0, Re(b)>0]], // GR 7.522.6
    [x^(b-1)*exp(t*x)*hypergeom([-n, n], [b, 1/2], x),
      gamma(b)/(-t)^b*cos(2*n*arcsin(1/sqrt(-t))),
      [u=0, v=infinity, Re(t)<0, Re(b)>0]], // GR 7.522.7
    // 7.522.8,9: Matcher can't handle lists of unknown length
    [x^(g-1)*(1-x)^r*exp(z*x)*hypergeom([a, b], [g], x),
      gamma(g)*gamma(r+1)*gamma(g+r+1-a-b)/(gamma(g+r+1-a)*gamma(g+r+1-b)) *
      exp(z)*hypergeom([r+1, g+r+1-a-b], [g+r+1-a, g+r+1-b], -z),
      [u=0, v=1, Re(g)>0, Re(r)>-1, Re(g+r-a-b)>-1]], // GR 7.523
    // 7.524.1: Lommel function
    // 7.524.2,3: Matcher can't handle lists of unknown length
    // 7.525.1: Matcher can't handle lists of unknown length
    // 7.525.2: Lommel function
    // 7.526.1,2: Unknown Psi function of three arguments
    // 7.526.3: Looks pointless
    
    [(1-exp(-x))^l*exp(t*x)*hypergeom([a,b],[c],d*exp(-x)),
      beta(-t,l+1)*hypergeom([a,b,-t],[c,l+1-t],d),
      [u=0, v=infinity, Re(l+1)>0, Re(t)<0, not(1-d<0)]], // GR 7.527.1
    [(1-exp(-x))^t*exp(-a*x)*hypergeom([-n, t+b+n], [b], exp(-x)),
      beta(a, t+n+1)*beta(a,b+n-a)/beta(a, a-b),
      [u=0, v=infinity, Re(a)<0, Re(t)>-1, a <> b, b+n <> a]], // GR 7.527.2
    [(1-exp(-x))^(c-1)*exp(t*x)*hypergeom([a,b],[c],1-exp(-x)),
      (gamma(-t)*gamma(c-a-b-t)*gamma(c))/(gamma(c-a-t)*gamma(c-b-t)),
      [u=0, v=infinity, Re(t)<0, Re(-t)>Re(a+b-c), Re(c)>0]], // GR 7.527.3
    [(1-exp(-x))^(c-1)*exp(t*x)*hypergeom([a,b],[c],d*(1-exp(-x))),
      beta(-t,c)*hypergeom([a,b],[c-t],d),
      [u=0, v=infinity, Re(t)<0, Re(c)>0, not(1-d<0)]], // GR 7.527.4

    [x*sin(u*x)*hypergeom([a, b], [3/2], c*x^2),
      2^(1-a-b)*PI*sqrt(-c)^(-a-b)*u^(a+b-2)*besselK(a-b, u/sqrt(-c))/gamma(a)/gamma(b),
      [u=0, v=infinity, u>0, Re(a)>1/2, Re(b)>1/2, c<0]], // GR 7.531.1
    [x*sin(u*x)*hypergeom([a, b], [3/2], -c^2*x^2),
      2^(1-a-b)*PI*c^(-a-b)*u^(a+b-2)*besselK(a-b, u/c)/gamma(a)/gamma(b),
      [u=0, v=infinity, u>0, Re(a)>1/2, Re(b)>1/2, c in R_]], // GR 7.531.1
    [x*cos(u*x)*hypergeom([a, b], [3/2], c*x^2),
      2^(1-a-b)*PI*sqrt(-c)^(-a-b)*u^(a+b-1)*besselK(a-b, u/sqrt(-c))/gamma(a)/gamma(b),
      [u=0, v=infinity, u>0, Re(a)>0, Re(b)>0, c<0]], // GR 7.531.1
    [x*cos(u*x)*hypergeom([a, b], [3/2], -c^2*x^2),
      2^(1-a-b)*PI*abs(c)^(-a-b)*u^(a+b-1)*besselK(a-b, u/abs(c))/gamma(a)/gamma(b),
      [u=0, v=infinity, u>0, Re(a)>0, Re(b)>0, c in R_]], // GR 7.531.1

    // Bessel functions
    [cos(z*sin(x)), besselJ(0, z)*PI,
      [frac(u/(2*PI))=0, v-u=PI]], // A&S, 9.1.18
    [cos(z*cos(x)), besselJ(0, z)*PI,
      [frac(u/(2*PI))=0, v-u=PI]], // A&S, 9.1.18
    [cos(z*sin(x))*sin(x)^a,
      besselJ(a/2,z)*sqrt(PI)*gamma(a/2+1/2)/(z/2)^(a/2),
      [frac(u/(2*PI))=0, v-u=PI]], // A&S, 9.1.20
    [(1-x^2)^a*cos(z*t),
      besselJ(a+1/2,z)*sqrt(PI)*gamma(a+1)/(z/2)^(a+1/2)/2,
      [u=0, v=1, Re(a)>-1]], // A&S, 9.1.20
    [cos(z*sin(x)-n*x),
      besselJ(n,z)*PI,
      [u=0, v=PI]], // A&S, 9.1.21
    [exp(z*cos(x))*cos(n*x),
      besselJ(n,z/I)*PI*I^n,
      [u=0, v=PI]], // A&S, 9.1.21
    [sin(z*cosh(x)),
      besselJ(0,z)*PI/2,
      [u=0, v=infinity, z>0]], // A&S, 9.1.23
    [cos(z*cosh(t)),
      -besselY(0,z)*PI/2,
      [u=0, v=infinity, z>0]], // A&S, 9.1.23
    [sin(z*x)/(x^2+1)^a,
      besselJ(a-1/2,z)*sqrt(PI)*gamma(1-a)*(z/2)^(a-1/2)/2,
      [u=1, v=infinity, z>0, abs(Re(a-1/2)) < 1/2]], // A&S, 9.1.24
    [cos(z*x)/(x^2+1)^a,
      -besselY(a-1/2,z)*sqrt(PI)*gamma(1-a)*(z/2)^(a-1/2)/2,
      [u=1, v=infinity, z>0, abs(Re(a-1/2)) < 1/2]], // A&S, 9.1.24
    [exp(z*cos(x)),
      besselI(0, z)*PI,
      [frac(u/(2*PI))=0, v-u=PI]], // A&S, 9.6.16
    [cosh(z*cos(x)),
      besselI(0, x)*PI,
      [frac(u/(2*PI))=0, v-u=PI]], // A&S, 9.6.16
    [exp(z*cos(x))*sin(x)^a,
      besselI(a/2, z)*sqrt(PI)*gamma(a/2+1/2)/(z/2)^(a/2),
      [frac(u/(2*PI))=0, v-u=PI]], // A&S, 9.6.18
    [exp(z*cos(x))*sin(x)^a,
      besselI(a/2, -z)*sqrt(PI)*gamma(a/2+1/2)/(-z/2)^(a/2),
      [frac(u/(2*PI))=0, v-u=PI]], // A&S, 9.6.18
    [(1-x^2)^a*exp(z*x),
      besselI(a+1/2, z)*sqrt(PI)*gamma(a+1)/(z/2)^(a+1/2),
      [u=-1, v=1, Re(a)>-1]], // A&S, 9.6.18
    [(1-x^2)^a*exp(z*x),
      besselI(a+1/2, -z)*sqrt(PI)*gamma(a+1)/(-z/2)^(a+1/2),
      [u=-1, v=1, Re(a)>-1]], // A&S, 9.6.18
    [exp(z*cos(x))*cos(n*x),
      besselI(n,x)*PI,
      [u=0, v=PI]], // A&S, 9.6.19
    [cos(z*sinh(x)),
      besselK(0,z),
      [u=0, v=infinity]], // A&S, 9.6.21
    [cos(z*x)/sqrt(x^2+1),
      besselK(0,z),
      [u=0, v=infinity]], // A&S, 9.6.21
    [cos(z*sinh(x))*cosh(a*x),
      besselK(a,z)*sec(a/2*PI),
      [u=0, v=infinity, abs(Re(a))<1, z>0]], // A&S, 9.6.22
    [sin(z*sinh(t))*sinh(a*t),
      besselK(a,z)*csc(a/2*PI),
      [u=0, v=infinity, abs(Re(a))<1, z>0]], // A&S, 9.6.22
    [exp(z*cosh(x))*sinh(x)^a,
      besselK(a,-z)*gamma(a/2+1/2)/sqrt(PI)/(z/2)^(a/2),
      [u=0, v=infinity, Re(a)>-1, Re(z)<0]], // A&S, 9.6.23
    [exp(z*x)*(x^2-1)^a,
      besselK(a,-z)*gamma(a+1)/sqrt(PI)/(z/2)^(a+1/2),
      [u=1, v=infinity, Re(a)>-1, Re(z)<0]], // A&S, 9.6.23
    [exp(z*cosh(x))*cosh(a*x),
      besselK(a,-z),
      [u=0, v=infinity, Re(z)<0]], // A&S 9.6.24
    [cos(z*x)/(x^2+y^2)^a,
      besselK(a-1/2,y*z)*sqrt(PI)*z^(a-1/2)/gamma(a)/(2*y)^(a-1/2),
      [u=0, v=infinity, Re(a)>-a, z>0, Re(y)>0]], // A&S, 9.6.25
      
    [exp(z*sqrt(x^2 + 1)),
      besselK(1, -z),
      [u=0, v=infinity, Re(z)<0]], // A&S, 9.6.24, with nu=1, t=sinh(x) (thanks Walter)
    [exp(z*sqrt(x^2 + 1)),
      2*besselK(1, -z),
      [u=-infinity, v=infinity, Re(z)<0]], // by symmetry
    
    [exp(y*sqrt(x^2+z^2))/sqrt(x^2+z^2)*x^a,
      besselK(a/2, -y*z)*gamma(a/2+1/2)/sqrt(PI)/(-y/2*z)^(a/2),
      [u=0, v=infinity, Re(a)>-1, Re(z)>0, y<0]], // GR 8.432.9
    [exp(y*sqrt(x^2+z^2))/sqrt(x^2+z^2)*x^a,
      2*besselK(a/2, -y*z)*gamma(a/2+1/2)/sqrt(PI)/(-y/2*z)^(a/2),
      [u=-infinity, v=infinity, a>-1, a in 2*Z_, Re(z)>0, y<0]], // by symmetry

    null()
]:


cauchy_patterns := [
  // Gradshteyn, 3.748
  [x*tan(x), -PI*ln(2),
    [u=0, v=PI]],

  // 3.749
  [x*tan(a*x)/(x^2+b),
    PI/(exp(2*a*sqrt(b))+1),
    [u=0, v=infinity, a>0, b>0]],
  [x*cot(a*x)/(x^2+b),
    PI/(exp(2*a*sqrt(b))-1),
    [u=0, v=infinity, a>0, b>0]],
  [x*tan(a*x)/(b-x^2), infinity,
    [u=0, v=infinity, b>0]],
  [x*tan(a*x)/(b+x^2), -infinity,
    [u=0, v=infinity, b<0]],
  [x*cot(a*x)/(b-x^2), infinity,
    [u=0, v=infinity, b>0]],
  [x*cot(a*x)/(b+x^2), -infinity,
    [u=0, v=infinity, b<0]],
  [x*csc(a*x)/(b-x^2), infinity,
    [u=0, v=infinity, b>0]],
  [x*csc(a*x)/(b+x^2), -infinity,
    [u=0, v=infinity, b<0]],

  [ln(x)/(a-b*x^2), -PI^2/(4*sqrt(a*b)), [u=0, v=infinity, a>0, b>0]], // GR 4.231.10

  [tan(a*x)/x, PI/2, [a>0, u=0, v=infinity]],
  [tan(a*x)/x, -PI/2, [a<0, u=0, v=infinity]],

  [sin(x)/(x^2+a), 0,
    [u=-infinity, v=infinity]], // by symmetry

  null()
]:
