alias(bl=matchlib::block):

int::addpattern :=
proc(pattern, var, result, pat_vars, conds)
  option hold;
begin
  pattern := context(pattern);
  var := context(var);
  result := context(hold(matchlib::block)(result));
  if args(0) > 3 then
    pat_vars := context(pat_vars);
  else
    pat_vars := [];
  end;
  if args(0) > 4 then
    conds := context(hold(map)(hold(hold)(conds), matchlib::block));
  else
    conds := [];
  end;
  if domtype(conds) <> DOM_LIST then conds := [conds]; end_if;

  // if called as int::addpattern(pattern, x=a..b, result, ...),
  // then this is going to be a definite integral
  if type(var)="_equal" and type(rhs(var))="_range" then
    intlib::definite::addpattern([
        context(pattern),
        context(result), // result
        context(op(rhs(var), 1)), // lower bound
        context(op(rhs(var), 2)), // upper bound
        conds
      ], lhs(var), pat_vars);

    return(null());
  end_if;

  if var <> _X and has([pattern, result, pat_vars, conds], _X) then
    [pattern, result, pat_vars, conds] := 
      subs([pattern, result, pat_vars, conds], _X=genident("_X"));
  end;
  [pattern, result, pat_vars, conds] :=
    subs([pattern, result, pat_vars, conds], var = _X);

  matchlib::addpatterns(intlib::userpatternsFSA, intlib::userpatterns,
	                    [[pattern, result, pat_vars, conds,
	                      map(pat_vars, v -> subs(bl(not has(`#v`, _X)), `#v`=v))]],
	                    int::addpattern::generalize, FALSE, FAIL);

  intlib::int(Remember, Clear);
  intlib::int_intern(Remember, Clear);
  
  null();
end:

int::addpattern := funcenv(int::addpattern):

int::addpattern::substitute_x_in_condition :=
proc(cond)
begin
  case op(cond, 0)
    of hold(_not) do
    of hold(_and) do
    of hold(_xor) do
    of hold(_or) do
      return(op(cond, 0)(op(map([op(cond)], int::addpattern::substitute_x_in_condition))));
    // this is the central point:
    // a condition of "not has(a, _X)" should not become
    // "not has(a, `f(_X)`)"
    of hold(has) do
      return(subsop(cond, 1=int::addpattern::
		            substitute_x_in_condition(op(cond, 1))));
  end_case;
  subs(cond, hold(_X)=`#f(_X)`);
end_proc:

int::addpattern::rewriteToDiff :=
proc(ex)
begin
  subs(ex, hold(D) = (()->stdlib::D2diff(hold(D)(args()))),EvalChanges);
end:

int::addpattern::rewriteToD :=
proc(ex)
begin
  subs(ex, hold(diff) = (()->stdlib::diff2D(hold(diff)(args()))),EvalChanges);
end:

// check not has(Simplify(rewrite(`#f'(_X)*const`/
//				 diff(`#f(_X)`, hold(_X)), D)),
//                _X)
int::addpattern::isConstTimesDiff :=
proc(fp, f)
  local t, res;
begin
  if traperror((t := int::addpattern::rewriteToDiff(fp/diff(f, hold(_X)));
/*		res := testeq(diff(t, hold(_X)), 0,
                              NumberOfRandomTests = 20)*/
          res := iszero(diff(t, hold(_X)))),
	       MaxSteps = intlib::isDiffOfMaxSteps(f, fp)) = 0
    then
    return(bool(res = TRUE));
  else
    FALSE
  end_if;
end_proc:

int::addpattern::intbysubst :=
proc(pat)
begin
  if not has(pat[1], hold(_X)) or
     has(pat[1], {`#fx`, `#gx`, `#px`, `#qx`, `#qx1`}) then
   return(pat);
  end_if;
  [(matchlib::block@(x->x))(`##`(`#f'(_X)*const`)
   *subs(matchlib::unblock(pat[1]), _X=`##`(`#f(_X)`), Unsimplified)),
   matchlib::addpatterns::dowithresult(pat[2],
       int::addpattern::substitute_x_in_condition,
       r -> subs(bl(Simplify(int::addpattern::rewriteToD(`#f'(_X)*const`/
				     diff(`#f(_X)`, _X) * `#p`), Steps=20)),
		 `#p` = subs(matchlib::unblock(r),
                             hold(_X)=`#f(_X)`, hold(int)=hold(intlib::intfn),
                             Unsimplified))),
   map(pat[3], int::addpattern::substitute_x_in_condition).
   [bl(has(`#f(_X)`, hold(_X))),
    bl(int::addpattern::isConstTimesDiff(`#f'(_X)*const`, `#f(_X)`))]],
   // for f'(x)=const:
  [subs(pat[1], _X=`##`(`#f(_X)`)),
   matchlib::addpatterns::dowithresult(pat[2],
       int::addpattern::substitute_x_in_condition,
       r -> subs(bl(`#p`/diff(`#f(_X)`, _X)),
		 `#p` = subs(matchlib::unblock(r),
                             hold(_X)=`#f(_X)`, hold(int)=hold(intlib::intfn),
                             Unsimplified))),
   map(pat[3], int::addpattern::substitute_x_in_condition).
   [bl(has(`#f(_X)`, _X)),
    bl(not has(diff(`#f(_X)`, _X), _X))]];
end_proc:


// for patterns matching a _plus expression, add `#hx`
// to the pattern and int(`#hx`, x) to the result:
int::addpattern::generalizesum :=
p -> (if type(p[1])="_plus" then
	   [p[1]+`##`(`#hx`),
	    matchlib::addpatterns::dowithresult(p[2], id,
	       r -> subs(matchlib::block(`#r`+int(`#hx`, _X)), 
                      `#r`=matchlib::unblock(r)))].p[3..-1]
      else p end_if):

int::addpattern::generalize := int::addpattern::intbysubst@int::addpattern::generalizesum:


prog::setcheckglobals(int::addpattern, {_X}):
