//    

/*

intlib::byparts(f,u) performs integration by parts on f where u is the part
		     to be integrated.

First implementation from Francois Maltey improved by Paul Zimmermann.
Corrected by Winfried Fakler.
Example:
>> intlib::byparts(hold(int)(cos(x)^n,x=0..PI/2),cos(x));

 n - 1      /                      n - 2                  n - 2          PI
0      - int| sin(x) (sin(x) cos(x)      - n sin(x) cos(x)     ), x = 0..--
            \                                                            2

   \
   |
   /


>> intlib::byparts(hold(int)(sqrt(1+x^2)*x^n,x),x^n);

             n + 1   2     1/2      /        n + 2           \
            x      (x  + 1)         |       x                |
            ------------------ - int| -------------------, x |
                  n + 1             |           2     1/2    |
                                    \ (n + 1) (x  + 1)       /
*/

intlib::byparts :=
  proc( intf, du: Type::Arithmetical)
    local v, u, f, var, x, uv, udv, ret;
  begin

    if not( type(intf)="int" ) then
       return(misc::maprec(intf, {"int"} = (x -> intlib::byparts(x, du))));
    end_if;
    if has(intf, hold(D)) then
       intf:= rewrite(intf, diff);
    end_if;
    if has(du, hold(D)) then
       du:= rewrite(du, diff);
    end_if;

    f := op(intf, 1) ;
    var := op(intf, 2) ;
    x :=op(var,1);
    u := expand(int(du, x));
    v := f/du ;
    uv:=combine(u*v);
    udv:=combine(u*diff(v,x));
    if type(var)="_equal" then // definite integration 
      if has(uv,int) then
        if intlib::printWarningsFlag then
          warning("found no closed form for ".expr2text(hold(int)(du, x)));
        end_if;
        hold(intlib::byparts)(intf,du);
      else
	if traperror((ret :=
		      intlib::limit(uv,x=op(var,[2,2]), Left)-intlib::limit(uv,x=op(var,[2,1]), Right)
		      - hold(int)(udv, var))) <> 0 then
	  error("error evaluating u*v at bounds");
	else
	  ret
	end_if;
      end_if;
    else
       uv - hold(int)(udv, var)
    end_if
  end_proc:
