// intlib::discont: Call discont, tracing all is-calls to the identifiers
// found.  If no set or piecewise of sets is returned, try assumptions.
// This may be an expensive operation.

intlib::discont_intern :=
proc(f, xr, notTheseIdents={}, cond)
local s, ids, conds, i, a, l, res, OtherTRUE, backtrans;
save is, property; // for tracing of conditions
begin
  // for complex intervals, we'll remap to 0..1
  backtrans := id;
  if has(xr, I) then
    backtrans := subs(x -> `#l`+(`#r`-`#l`)*x,
                      [`#l`=op(xr,[2,1]), `#r`=op(xr,[2,2])]);
    f := subs(f, op(xr, 1)=backtrans(op(xr,1)));
    xr := subsop(xr, 2=0..1);
  end_if;
  
  // for simpler Otherwise-treatment
  OtherTRUE := x -> x;
  OtherTRUE(Otherwise) := TRUE;
  ids := [op(indets(f) minus notTheseIdents)];
  map(ids, property::trace);
  s := piecewise::disregardPoints(discont(f, xr));
  conds := map(ids, property::untrace);
  if s::dom = DOM_SET then
    return([cond, map(s, backtrans)]);
  elif s::dom = piecewise and {domtype(piecewise::expression(s,i))$i=1..nops(s)}={DOM_SET} then
    return([cond and OtherTRUE(piecewise::condition(s, i)),
            map(piecewise::expression(s, i), backtrans)] $ i = 1..nops(s))
  else
    // choose the identifier with the simplest conditions
    l := prog::sort(select([$1..nops(ids)], i -> conds[i]<>[]),  i -> Simplify::defaultValuation(conds[i]));
    if l=[] then 
      if s::dom = piecewise then
        return([cond and OtherTRUE(piecewise::condition(s, i)),
                Dom::ImageSet(backtrans(`#a`), `#a`,
                              piecewise::expression(s, i))] $ i = 1..nops(s))
      else
        return([cond, Dom::ImageSet(backtrans(`#a`), `#a`, s)]);
      end_if;
    end_if;
    a := ids[l[1]];
    conds := conds[l[1]];
    conds := map(conds, proc(X)
      begin
        if nops(X)=1 then
          X;
        else
          [op(X,1) in property::prop2set(op(X,2))];
        end_if;
      end_proc);
    res := [proc() // procedure to localize effects of assumptions
            begin
              assume(op(conds[i]));
              intlib::discont_intern
                (f, xr, notTheseIdents union {a},
                 cond and op(conds[i]));
          end_proc() $ i = 1..nops(conds)];
    res := prog::sort(select(res, _not@has, hold(discont)), Simplify::defaultValuation);
    op(map(res, s->[subs(s[1], #a=backtrans(#a)),
      Dom::ImageSet(backtrans(`#a`), `#a`, s[2])]));
  end_if;
end_proc:

intlib::discont := 
proc(f, xr)
  local x, branches, pw;
begin
  x := op(xr, 1);
  pw := proc() // temporarily unassume x
  begin
    unassume(x);
    if type(f)=piecewise then
      piecewise::extmap(f, intlib::discont, xr);
    else
      branches := [intlib::discont_intern(f, xr, {}, TRUE), [Otherwise, C_]];
      eval(hold(piecewise)(op(branches)));
    end_if;
  end_proc();
  // *with* the assumptions on x, simplify conditions and discard branches where conditions contain x.
  if pw::dom = piecewise then
    branches := [op(pw)];
    branches := map(branches, b -> [simplify::simplifyCondition(b[1]), b[2]]);
    branches := select(branches, b -> not has(b[1], x));
    pw := eval(hold(piecewise)(op(branches)));
  end_if;
  pw;
end_proc:

intlib::discont := prog::remember(intlib::discont, property::depends):

null():

