/*--
intlib::int(f,x) - computes the antiderivative of the function f(x) with
                   respect to the variable x.
--*/

intlib::int:=
prog::remember(
  proc(f :Type::Arithmetical, x :DOM_IDENT, options=table() : DOM_TABLE)
    local prop,C,F, xpos, xexpr, removeConstFromLn, fac, fhasC;
    name intlib::int;
    save _X; //necessary to make assumption on integration variable
  begin
    removeConstFromLn :=
    proc(t)
      local c, c2, arg_t, dummy;
    begin
      case type(t)
      of "ln" do
        arg_t := op(t);
        if type(arg_t) = "_mult" then
          [arg_t, fac, dummy] := split(arg_t, has, [x]);
          t := ln(arg_t);
        end_if;
        c := lcoeff(op(t), [x]);
        if c<>FAIL and not has(c, [x]) then
          //c2 := intlib::Simplify(op(t)/c, options, Steps=5);
          c2 := simplify(op(t)/c, if options[IgnoreAnalyticConstraints]=TRUE then IgnoreAnalyticConstraints end_if);
          if c2 <> FAIL and c2 <> undefined then
            if options[IgnoreAnalyticConstraints]<>TRUE then assert(testeq(c2, op(t)/c) <> FALSE) end_if;
            if intlib::Simplify::defaultValuation(c2) <
              intlib::Simplify::defaultValuation(op(t)) then
              // recursive, to simplify ln(a^5*x + a^4) to ln(a*x+1), not ln((a*x+1)/a)
              t := removeConstFromLn(ln(c2));
            end_if;
          end_if;
        end_if;
        c := content(op(t), [x]);
        if c<>FAIL and not has(c, [x]) then
          //c2 := intlib::Simplify(op(t)/c, options, Steps=5);
          c2 := simplify(op(t)/c, if options[IgnoreAnalyticConstraints]=TRUE then IgnoreAnalyticConstraints end_if);
          if c2 <> FAIL and c2 <> undefined then
            if options[IgnoreAnalyticConstraints]<>TRUE then assert(testeq(c2, op(t)/c) <> FALSE) end_if;
            if intlib::Simplify::defaultValuation(c2) <
              intlib::Simplify::defaultValuation(op(t)) then
              // recursive, to simplify ln(a^5*x + a^4) to ln(a*x+1), not ln((a*x+1)/a)
              t := removeConstFromLn(ln(c2));
            end_if;
          end_if;
        end_if;
        break;
      of "_mult" do
        c := select(t, has, [x]);
        if type(c)<>"_mult" then
          t := select(t, _not@has, [x])*removeConstFromLn(c);
        end_if;
        break;
      of "_plus" do
        t := map(t, removeConstFromLn);
        if type(t)="_plus" then
          t := select(t, has, [x]);
        end_if;
//// Disabled, to allow fixes for g477253 in intlib::ratSinCos
//      of "arctan" do
//        c := op(t);
//        if type(c)="tan" and has(c, [x]) then
//          t := op(c);
//        end_if;
      end_case;
      t;
    end:

    // first, look for "obvious" linear transformations,
    // as in int((x-y)^100, x)
    xpos := {prog::find(f, x)};
    if xpos={} then
      return(f*x);
    end_if;
    xexpr := map(xpos, p -> op(f, p[1..-2]));
    if nops(xexpr)=1 then
      xexpr := op(xexpr);
      case type(xexpr)
      of "_mult" do
        fac := select(xexpr, _unequal, x);
        if not has(fac, x) and is(fac<>0, Goal=TRUE)
          and (has(f, [hold(abs), hold(sign)]) = FALSE or
            is(fac in R_, Goal=FALSE) <> FALSE) then
          proc() // for local variable
            local t;
          begin
            t := solvelib::getIdent(Any, indets(f));
            proc() // for local assumption
            begin
              eval(hold(assumeAlso)(t=xexpr));
              F := intlib::int(subs(f, xexpr=t), t, table(options, NoWarning=TRUE))/fac;
            end_proc();
            F := subs(F, hold(int)=hold(intlib::frozenInt), Unsimplified);
            F := subs(F, t=xexpr);
            F := piecewise::extmap(F, misc::maprec,
              (ex -> _lazy_and(ex::dom=DOM_EXPR, op(ex,0)=hold(intlib::frozenInt)))
               = (i -> if op(i, 2) = xexpr then
                                fac*subsop(i, 2=x)
                              else i end_if));
          end_proc():
          F := intlib::Simplify(removeConstFromLn(F), options, IsSimple = (a -> not has(a, x)));
          if options[IgnoreSpecialCases]=TRUE then
            F := piecewise::disregardPoints(F);
          end_if;
          F := subs(F, hold(intlib::frozenInt)=hold(int), Unsimplified);
          return(F);
        end_if;
        break;
      of "_plus" do
        fac := select(xexpr, _not@has, x);
        if not iszero(fac)
          and is(fac in R_, Goal=FALSE) <> FALSE then
          proc() // for local variable
            local t;
          begin
            t := solvelib::getIdent(Any, indets(f));
            proc() // for local assumption
            begin
              eval(hold(assumeAlso)(t=xexpr));
              F := intlib::int(subs(f, xexpr=t), t, table(options, NoWarning=TRUE));
            end_proc();
            F := subs(F, hold(int)=hold(intlib::frozenInt), Unsimplified);
            F := subs(F, t=xexpr);
            F := piecewise::extmap(F, misc::maprec,
              (ex -> _lazy_and(ex::dom=DOM_EXPR, op(ex,0)=hold(intlib::frozenInt)))
               = (i -> if op(i, 2) = xexpr then
                         subsop(i, 2=x)
                       else i end_if));
          end_proc();
          F := intlib::Simplify(removeConstFromLn(F), options, IsSimple = (a -> not has(a, x)));
          if options[IgnoreSpecialCases]=TRUE then
            F := piecewise::disregardPoints(F);
          end_if;
          F := subs(F, hold(intlib::frozenInt)=hold(int), Unsimplified);
          return(F);
        end_if;
        break;
      end_case;
    end_if;

    C:=solvelib::getIdent(Any, indets(f, All) union {_X});
    if property::hasprop(_X) then
      assume(C in getprop(_X))
    end_if;
    delete _X;
    if property::hasprop(x) then
      prop:=getprop(x);
      if prop=C_ then
        assume(_X,prop, _and)
      elif solvelib::isEmpty( (prop:=prop intersect R_) )<>TRUE then
        if domtype(prop) = DOM_SET then
          prop:=C_;
          if intlib::printWarningsFlag and options[NoWarning]<>TRUE then
            warning("Cannot integrate when ".strprint(NoNL, x).
                    " has property ".strprint(NoNL, getprop(x)).".\n".
                    "While integrating, we will assume ".strprint(NoNL, x).
                    " has property ".strprint(NoNL, prop).".");
          end_if;
        elif is(x in Q_)=TRUE then
          prop:=R_;
          if intlib::printWarningsFlag and options[NoWarning]<>TRUE then
            warning("Cannot integrate when ".strprint(NoNL, x).
                    " has property ".strprint(NoNL, getprop(x)).".\n".
                    "While integrating, we will assume ".strprint(NoNL, x).
                    " has property ".strprint(NoNL, prop).".");
          end_if;
        end_if;
        assume(_X in prop, _and);
      elif intlib::printWarningsFlag and options[NoWarning]<>TRUE then
        warning("Cannot assume ".strprint(NoNL, x).
               " is a real variable,\n"."since that would be inconsistent to ".
                "user given properties")
      end_if
    else
      assume(_X in R_)
    end_if;
    if x<>_X then
      fhasC := has(f, _X); // remember for back-substitution and aliasing avoiding
      f := subs(f,[_X=C,x=_X])
    else
      fhasC := FALSE;
    end_if;

    if options[IgnoreAnalyticConstraints] = TRUE
      and not has(f, [hold(int)]) then
      f := intlib::Simplify(f, options, Steps=50, IsSimple = (a -> not has(a, _X)));
    end_if;

    F := intlib::int_intern(f, _X, options);
    F := subs(F, hold(intlib::frozenInt)=hold(int), Unsimplified);
    if not hastype(F, "int") then
      traperror(
        (F := intlib::Simplify(F, options,
           RuleBase = intlib::Simplify::RulesAntiderivative, IsSimple = (a -> not has(a, _X)))),
        MaxSteps = intlib::simplifyMaxSteps(f, F, return));
    end_if;
    // aliasing problem avoiding
    F:= misc::maprec(F, {RootOf} = (rof -> solvelib::avoidAliasProblem(rof, {x})));
    if not fhasC and has(F, C) then
      F := subs(F, C=solvelib::getIdent(Any, indets({F, f, x, _X, C}, All)));
    end_if;
    [F, f] := subs([F, f], [_X=x,C=_X]);
    unassume(C);
    // remove unwanted additive constants
    traperror((F := removeConstFromLn(F)));
    if options[IgnoreSpecialCases]=TRUE and F::dom = piecewise then
      F := piecewise::disregardPoints(F);
    end_if;
    if F=FAIL or op(F, 0) = hold(int) then
      // As a last resort, try linear transformations which are only formally valid.
      // These have not been tried above, to avoid int(a*x+b, x) return a formula
      // not valid for a=0.
      xpos := {prog::find(f, x)};
      xexpr := map(xpos, p -> op(f, p[1..-2]));
      if nops(xexpr)=1 then
        xexpr := op(xexpr);
        case type(xexpr)
        of "_mult" do
          fac := select(xexpr, _unequal, x);
          if not has(fac, x) then
            proc() // for local assumptions
              local t;
            begin
              t := solvelib::getIdent(Any, indets(f));
              proc() begin
                eval(hold(assumeAlso)(t=xexpr));
                F := intlib::int(subs(f, xexpr=t), t, options)/fac;
              end_proc();
              F := subs(F, hold(int)=hold(intlib::frozenInt), Unsimplified);
              F := subs(F, t=xexpr);
              F := piecewise::extmap(F, misc::maprec,
                (ex -> _lazy_and(ex::dom=DOM_EXPR, op(ex,0)=hold(intlib::frozenInt)))
                 = (i -> if op(i, 2) = xexpr then
                                  fac*subsop(i, 2=x)
                                else i end_if));
            end_proc():
            F := intlib::Simplify(removeConstFromLn(F), options, IsSimple = (a -> not has(a, x)));
            if options[IgnoreSpecialCases]=TRUE then
              F := piecewise::disregardPoints(F);
            end_if;
            F := subs(F, hold(intlib::frozenInt)=hold(int), Unsimplified);
          end_if;
          break;
        end_case;
      end_if;
    end_if;
    return(F);
  end_proc, () -> [//Pref::experimentalInt(),
		 property::depends([args()])],
     PreventRecursion,
     ((f, x, options) -> hold(int)(f, x, intlib::printOptions(options)))):


intlib::int_intern:=
prog::remember(
proc(_F_,_x_,options=table())
  local integral,Float,_f_,F0, tmp, res, dummy, f_t, method, hasInt, hasDiff,
    pwIntegral, pwIntegralCond, addspecials, cond, i, j, removed, t, mem;
  save intlibDepthLevel, //make counter secure for error or exception handling
    MAXEFFORT;
  name intlib::int_intern;
begin
  // people input the weirdest stuff, and it's int's fault if it doesn't handle that ...
  // barf out if x is used as a function
  res := 0;
  misc::maprec(_F_,
    {"function"} =
    (f -> (if op(f, 0)=_x_ then res := FAIL; misc::breakmap(); end_if; f)));
  if res = FAIL then
    return(intlib::frozenInt(_F_, _x_, intlib::printOptions(options)));
  end_if;
  
  F0:=_F_;
  res := 0;

  if intlibDepthLevel = hold(intlibDepthLevel) then
    sysassign(intlib::tries,{});
    sysassign(intlibDepthLevel,0):
  end_if;
  sysassign(intlibDepthLevel,intlibDepthLevel+1);

  _F_ := misc::maprec(_F_, {DOM_POLY} = expr);

  // First, transform each floating point number to its
  // rational approximation
  _f_:=misc::maprec(_F_,
                    {DOM_FLOAT,DOM_COMPLEX}=
                    (x -> numeric::rationalize(x,Minimize)) );
  Float:=(if _f_ <> _F_ then float else id end_if)@(x->combine(x, exp));

  if has(_f_, hold(_power)) then
    _f_ := eval(subs(_f_, hold(_power)=
    proc(base, expo)
    begin
      if has(expo, _x_) then
        exp(ln(base)*expo)
      else base ^ expo end_if;
    end));
  end_if;

  if has(_f_, hold(arg)) then
    _f_:=subs(_f_,hold(arg)=(z->-I*ln(z/abs(z))),EvalChanges);
  end_if;

  if has(_f_, hold(log)) then
    _f_:=subs(_f_,hold(log)=((b,x) -> ln(x)/ln(b)),EvalChanges);
  end_if;

  // the assumptions, changes, and simplifications above can create piecewise objects    
  if _f_::dom::int <> FAIL then
    return(_f_::dom::int(_f_, _x_, options));
  end_if;


  // dirac must not reach some of the functions below
  if has(_f_, hold(dirac)) then
     tmp:= intlib::diracInt(_f_, _x_, options):
     if tmp <> FAIL then
        return(Float(tmp));
     else
        return(hold(int)(_f_, _x_, intlib::printOptions(options)));
     end_if;
  end_if;

  if testtype(_f_, Type::RatExpr(_x_, Type::IndepOf(_x_))) then
    // short circuit: rational functions are handled completely
    // by the Hermite reduction and the Lazard-Rioboo-Trager algorithm,
    // although the result returned there may not be in the
    // form desired. But that is something for postprocessing, really.
    userinfo(2,"rational expression, using Hermite/LRT integration");
    integral := intlib::algebraic::rational(_f_, _x_, options);
    
    if integral=FAIL then // no solution possible
      if stdlib::hasmsign(F0) then
        integral := -hold(int)(-F0, _x_, intlib::printOptions(options));
      else
        integral := hold(int)(F0, _x_, intlib::printOptions(options));
      end_if;
    else
      if intlib::Simplify::defaultValuation(integral) 
        > 5*intlib::Simplify::defaultValuation(_f_) then
        userinfo(2, "Hermite/LRT integration returned complicated result, trying lookup");
        f_t := intlib::lookup(_f_, _x_, options);
        if options[IgnoreSpecialCases]=TRUE then
          f_t := piecewise::disregardPoints(f_t);
        end_if;
        if domtype(f_t) = piecewise then
          f_t := piecewise::fillCases(f_t,
            intlib::frozenInt(_f_, _x_, intlib::printOptions(options)));
          f_t := piecewise::replaceOtherwise(f_t);
          f_t := piecewise::combineSpecialCases(f_t);
        end_if;
        if f_t <> FAIL and 
          intlib::Simplify::defaultValuation(f_t) 
          < intlib::Simplify::defaultValuation(integral) then
          userinfo(2, "... better result");
          integral := f_t;
        else
          userinfo(2, "... no luck");
        end_if;
      end_if;
      return(Float(integral))
    end_if;
  end_if;
  
  // symbolic derivatives involving x? The test is fast.
  hasInt := hastype(_f_, "int");

  hasDiff := FALSE;
  misc::maprec(rewrite(_f_, diff),
    {"diff"} = (ex -> (if has([op(ex, 2..nops(ex))], [_x_]) then
                         hasDiff := TRUE;
                         misc::breakmap();
                       end_if; ex)));
  if hasDiff then
    integral := FAIL;
    if not hasInt then
      integral := intlib::symbolicDiffs(_f_, _x_, options);
    end_if;
    if integral=FAIL then // no solution possible
      if stdlib::hasmsign(F0) then
        integral := -hold(int)(-F0, _x_, intlib::printOptions(options));
      else
        integral := hold(int)(F0, _x_, intlib::printOptions(options));
      end_if;
    end_if;
    return(Float(integral));
  end_if;

  // since not every of the following methods will really consume time,
  // giving one fifth of the effort to each should be ok

  MAXEFFORT:= MAXEFFORT/5;
  
  // for collecting piecewise results
  pwIntegral := FAIL;
  pwIntegralCond := FALSE;
  
////// For debugging/optimization: Log all indefinite integrals during lib test
////  fprint(Unquoted, 0, "Info: int("._f_.", "._x_.", ".options."):");

  for method in
    // 3rd entry contains options: "rekInt" for methods that can deal with nested
    // integrals, "checkResult" if the result needs to have some sanity checks performed.
    // "noRetry" is not re-entered for expanded integrals
      [// look for user-defined patterns
       ["checking user patterns", intlib::lookup_user, {"rekInt"}],
       // test if integrand contains special functions that can be treated
       ["looking for special functions", intlib::specialFunctionInt, {}],
       // test for patterns with known good substitutions
       // (and for hyperelliptic integrals)
       ["looking for known good substitutions", intlib::trafoLookup, {}],
       // treat elliptic integrals
       ["looking for elliptic integrals", intlib::elliptic, {}],
       // lookup method
       ["trying lookup method", intlib::lookup, {}],
       // special handling of rational function in trig. terms
       ["looking for rational function in trig. terms", intlib::ratSinCos, {}],
       // Risch-Norman 'parallel' integration
       ["trying \"parallel\" integration", intlib::algebraic::parallel, {"noRetry"}],
       // Risch Integration
       ["trying Risch integration", intlib::algebraic::int, {/*"checkResult", */ "noRetry"}],
       // using linearity of integration
       ["try to integrate term by term", intlib::termByTerm, {"rekInt"}],
       ["looking for rational function of linear or quadratic sqrt", intlib::ratOfSqrt, {"checkResult"}],
       ["searching for generic substitutions", intlib::findSubst, {}]
      ] do
    if hasInt and not "rekInt" in method[3] then
      next;
    end_if;
    if "noRetry" in method[3] and options[hold(RetryCall)] = TRUE then
      next;
    end_if;
    userinfo(2, method[1]." on ".expr2text(_f_));
    integral := FAIL;
    mem := [bytes()];
    if traperror((t := time((integral:=(method[2])(_f_,_x_,options))))) = 0 then
      userinfo(3, "took ".stringlib::formatTime(t));
    else
      userinfo(3, "had an error: ".getlasterror());
    end_if;
    userinfo(15, "allocation: ".zip([bytes()], mem, (a,b) -> "".(round(10*(a-b)/(1024^2))/10.0)." MB"));
    // eval(subs(...)) is intended, since several of the methods called return not completely evaluated expressions
    integral := eval(subs(integral, hold(sum::sum_fn)=sum::expand_sum_fn));
    if domtype(integral) = piecewise then
      integral := piecewise::selectExpressions(integral,
        _not@has, [hold(int), hold(intlib::frozenInt)]);
      if integral = undefined then
        integral := FAIL;
      end_if;
    end_if;
    // getting lots of special cases, but no generic result
    // is not of much use and, due to the explosion of number of cases
    // when combining partial results, slows everything down,
    // just to be discarded at the end.
    if domtype(integral) = piecewise then
      // integral := piecewise::disregardPoints(integral, {_x_});
      if piecewise::disregardPoints(integral) = undefined then
        integral := FAIL;
      end_if;
    end_if;
    integral := subs(integral, hold(intlib::frozenInt)=hold(int), Unsimplified);
    // bug avoidance
    if "checkResult" in method[3] and integral <> FAIL and
      testeq(diff(integral, _x_), _f_, NumberOfRandomTests=20, Steps=0) = FALSE then
      userinfo(10, "bad result! ignoring ...");
      integral := FAIL;
    end_if;
    // end of bug avoidance
    if integral<>FAIL then
      userinfo(2, method[1].": worked");
      if testtype(integral, "_plus") then
        [f_t, integral, dummy] := split(integral, testtype, "int");
      elif testtype(integral, "int") and op(integral, 2) = _x_ then
        f_t := integral;
        integral := 0;
      else
        f_t := 0;
      end;
      if domtype(integral) = piecewise then
        if pwIntegral = FAIL then
          pwIntegral := [op(integral)];
          pwIntegralCond := simplify::simplifyCondition(
            _or(op(map(pwIntegral, op, 1))));
        else
          pwIntegral := pwIntegral.[op(integral)];
          pwIntegralCond := simplify::simplifyCondition(
            _or(pwIntegralCond, op(map([op(integral)], op, 1))));
        end_if;
        if pwIntegralCond = TRUE then
          // piecewise with full information found.
          // simplify the result:
          // first, remove branches which are special cases of other branches
          i := 1;
          while i <= nops(pwIntegral) do
            removed := FALSE;
            for j from 1 to nops(pwIntegral) do
              if i=j then next; end_if;
              cond := simplify::simplifyCondition(pwIntegral[i][1] and pwIntegral[j][1]);
              if cond=pwIntegral[i][1] then
                removed := TRUE;
                delete pwIntegral[i];
                break;
              end_if;
            end_for;
            if not removed then i := i+1; end_if;
          end_while;
          // then, discard branches with complicated results and 
          // the same conditions as simpler branches
          pwIntegral := prog::sort(pwIntegral, b -> intlib::Simplify::defaultValuation(b[2]));
          cond := not pwIntegral[1][1];
          for i from 2 to nops(pwIntegral) do
            cond := simplify::simplifyCondition(cond);
            [pwIntegral[i][1], cond] := [pwIntegral[i][1] and cond, cond and not pwIntegral[i][1]];
          end_for;
          // finally, combine branches of the form
          // [a=2, f(2)], [a<>2, f(a)]
          return(piecewise::combineSpecialCases(Float(pwIntegral)));
        end_if;
      else // not piecewise result
        if iszero(f_t) then
          return(Float(res + intlib::expandExp(integral)));
        elif op(f_t, 0)=hold(int) and op(f_t, 2)=_x_ then
          res := res + intlib::expandExp(integral);
          _f_ := op(f_t, 1);
        end;
      end_if; // piecewise?
    end_if;
  end_for;

  if pwIntegralCond <> FALSE then
    // incomplete piecewise found.
    // simplify the result:
    // first, remove branches which are special cases of other branches
    i := 1;
    while i <= nops(pwIntegral) do
      removed := FALSE;
      for j from 1 to nops(pwIntegral) do
        if i=j then next; end_if;
        cond := simplify::simplifyCondition(pwIntegral[i][1] and pwIntegral[j][1]);
        if cond=pwIntegral[i][1] then
          removed := TRUE;
          delete pwIntegral[i];
          break;
        end_if;
      end_for;
      if not removed then i := i+1; end_if;
    end_while;
    // then, discard branches with complicated results and 
    // the same conditions as simpler branches
    pwIntegral := prog::sort(pwIntegral, b -> intlib::Simplify::defaultValuation(b[2]));
    cond := not pwIntegral[1][1];
    for i from 2 to nops(pwIntegral) do
      cond := simplify::simplifyCondition(cond);
      [pwIntegral[i][1], cond] := [pwIntegral[i][1] and cond, cond and not pwIntegral[i][1]];
    end_for;
    cond := simplify::simplifyCondition(cond);
    // Then, fill the remaining cases.
    // If we can detect a finite number of special cases,
    // as in "n in {0, 1, 2}", we compute the corresponding
    // integrals explicitly:
    if cond <> FALSE then
      addspecials :=
      proc(cond)
        local t, i;
      begin
        case type(cond)
        of "_or" do
          map([op(cond)], addspecials);
          return();
        of "_equal" do
          if domtype(op(cond, 1))=DOM_IDENT and op(cond, 1) <> _x_ then
            pwIntegral := pwIntegral.[[cond, int(_f_|cond, _x_|cond, options)]];
            return();
          end_if;
          break;
        of "_in" do
          if domtype(op(cond, 1))=DOM_IDENT and
            domtype(op(cond, 2))=DOM_SET then
            t := op(cond, 1);
            pwIntegral := pwIntegral.[[t=i, int(_f_|[t=i], _x_|[t=i], options)] $ i in op(cond, 2)];
            return();
          end_if;
          break;
        end_case;
        pwIntegral := pwIntegral.[[cond, hold(intlib::frozenInt)(_f_, _x_, intlib::printOptions(options))]];
        null();
      end_proc:
      addspecials(cond);
    end_if;
    return(piecewise::combineSpecialCases(Float(pwIntegral)));
  end_if;

  if iszero(_f_) then
    // can't really hapen, can it?
    return(Float(res));
  else
    // failure so far, try expanding
    // (e.g., int(int(exp(-x^2-y^2), x=-infinity..infinity), y=-infinity..infinity))
    if options[hold(RetryCall)] <> TRUE then
      if not has(_f_, hold(int)) and
        traperror((tmp := expand(_f_, MaxExponent = 10)),
          MaxSteps=intlib::simplifyMaxSteps(_f_, _x_, "retry")) = 0 and
        tmp <> _f_ and tmp <> _F_ then
        tmp := intlib::int_intern(tmp, _x_, table(options, hold(RetryCall)=TRUE));
        if type(tmp) <> "int" then
          return(Float(res+tmp));
        end_if;
      end_if;
    end;
    if stdlib::hasmsign(_f_) then
      Float(res)-hold(int)(Float(-_f_), _x_, intlib::printOptions(options))
    else
      Float(res)+hold(int)(Float(_f_), _x_, intlib::printOptions(options))
    end_if;
  end_if;
end_proc, () -> [//Pref::experimentalInt(),
		 property::depends([args()])],
     PreventRecursion,
     ((f, x, options) -> hold(int)(f, x, intlib::printOptions(options)))):

intlib::tries:={}:

intlib::expandExp:=
  proc(f)
  begin
    if has({f},exp) then
      misc::maprec(f,{"exp"}=proc() begin expand(exp(op(args()))) end_proc )
    else
      f
    end_if;
  end_proc:




/* if both the lookup method and Risch algorithm failed,
  and if the function is a sum, it can be that some
  terms can be integrated by the lookup method and some
  other by Risch algorithm, like for example int(diff(g(x),x)+x+2,x) */
intlib::termByTerm :=
proc(f,x, options)
  local f0, e, i, r, r2;
  save MAXEFFORT;
begin
  f0:=f;
  if type(f)="_mult" and contains(map({op(f)},type),"_plus") then
    f := [op(f)];
    // find the first sum in the operands, expand
    for i from 1 to nops(f) do
      if type(f[i]) = "_plus" then
        e := f[i];
        delete f[i];
        f := `*`(op(f));
        f := map(e, `*`, f);
        break;
      end_if;
    end_for;
   end_if;
  if type(f)="_plus" then
    r:=0;
    r2 := 0;
    MAXEFFORT:= MAXEFFORT/nops(f);
    for e in [op(f)] do
      i:=intlib::int(e,x, options);
      if domtype(i) <> piecewise and hastype(i,"int") then
        r2 := r2+e;
      else
        r:=r+i
      end_if
    end_for;
    if iszero(r2) then
      return(r);
    elif iszero(r) then
      return(FAIL);
    else
      return(r+hold(int)(r2, x, intlib::printOptions(options)));
    end_if;
  end_if;
  FAIL
end_proc:

