// frozen int which does not react to expand etc.
intlib::frozenInt := funcenv(x -> procname(args())):
intlib::frozenInt::dontSimplify := TRUE:

intlib::lookup :=
proc(f :Type::Arithmetical,
     x=hold(_X) :DOM_IDENT,
     options = table(),
     lookAt = FAIL)
  save _X;
  local C, F, noX, dummy, cond, i, j, removed, addspecials;
begin
  //if testargs() then f:=eval(f) end_if; // in case someone makes nonsense
  
  if not has(f, x) then // should not happen, but with intermediate simplifications etc., it does
    return(f*x);
  end_if;
  
  C:=solvelib::getIdent(Any, indets(f, All) union {_X});
  save C;
  if property::hasprop(_X) then 
    //assume(C,prop1)  // doesn't work due to an error in assume
    zip([C],[getprop(_X)],assume);
  end_if;
  if x <> _X then
    delete _X;
    if property::hasprop(x) then
      //assume(_X,prop) // doesn't work due to an error in assume
      zip([_X],[getprop(x)],assume);
    end_if;
    if x<>_X then f:=subs(f,[_X=C,x=_X],EvalChanges) end_if;
  elif _X <> hold(_X) then
    delete _X;
  end_if;
//  remove independent factors 
  if type(f)="_mult" then
    [f, noX, dummy] := split([op(f)], has, _X);
    assert(dummy = []);
    f := _mult(op(f));
    noX := _mult(op(noX));
  else
    noX := 1;
  end_if;
  
  // take care of sin(a*x^2+b*x^2) matching sin(t*x^2) etc.:
  f := misc::maprec(f,
    {"exp", "sin", "cos", "sinh", "cosh"} =
    (ex -> map(ex, collect, [_X])));
  
  F := FAIL;

  if intlib::userpatternsFSA <> FAIL then
    F := matchlib::addpatterns::handle_results
       (matchlib::evalFSA(f, intlib::userpatternsFSA));
  end_if;

  if F = FAIL then
    if lookAt <> [] and
      intlib::patterns <> FAIL then
      F := matchlib::einwohner(f, _X, op(intlib::patterns));
      F := matchlib::addpatterns::handle_results(F);
    end_if;
  end_if;

  if domtype(F) = piecewise then
    F := piecewise::selectConditions(F, _not@has, _X);
    if F = undefined then F := FAIL; end;
  end;
  
  if F<>FAIL then 
    F:=subs(noX * F, [_X=x,C=_X]);
    if domtype(F) = piecewise then
      // first, remove branches which are special cases of other branches
      F := [op(F)];
      i := 1;
      while i <= nops(F) do
        removed := FALSE;
        for j from 1 to nops(F) do
          if i=j then next; end_if;
          cond := simplify::simplifyCondition(F[i][1] and F[j][1]);
          if cond=F[i][1] then
            removed := TRUE;
            delete F[i];
            break;
          end_if;
        end_for;
        if not removed then i := i+1; end_if;
      end_while;
      // then, discard branches with complicated results and 
      // the same conditions as simpler branches
      F := prog::sort(F, b -> intlib::Simplify::defaultValuation(b[2]));
      cond := not F[1][1];
      for i from 2 to nops(F) do
        cond := simplify::simplifyCondition(cond);
        [F[i][1], cond] := [F[i][1] and cond, cond and not F[i][1]];
      end_for;
      cond := simplify::simplifyCondition(cond);
      // Then, fill the remaining cases.
      // If we can detect a finite number of special cases,
      // as in "n in {0, 1, 2}", we compute the corresponding
      // integrals explicitly:
      if cond <> FALSE then
        addspecials :=
        proc(cond)
          local t, i;
        begin
          case type(cond)
          of "_or" do
            map([op(cond)], addspecials);
            return();
          of "_equal" do
            if domtype(op(cond, 1)) = DOM_IDENT then
              F := F.[[cond, noX*int(f|([_X=x,C=_X, cond]), x|([_X=x,C=_X, cond]), options)]];
              return();
            end_if;
          of "_in" do
            if domtype(op(cond, 1)) = DOM_IDENT and domtype(op(cond, 2)) = DOM_SET then
              t := op(cond, 1);
              F := F.[[t=i, noX*int(f|[_X=x,C=_X,t=i], x|[_X=x,C=_X,t=i], options)] $ i in op(cond, 2)];
              return();
            end_if;
          end_case;
          F := F.[[cond, noX*intlib::frozenInt(f|[_X=x,C=_X], x|[_X=x,C=_X], intlib::printOptions(options))]];
          null();
        end_proc:
        addspecials(cond);
      end_if;
      F := piecewise(op(F));
    end;
    if F = undefined then
      F := FAIL;
    end_if;
  end_if;
  F
end_proc:

intlib::lookup_user := proc(f, x, opt=table())
begin intlib::lookup(f, x, opt, []) end:

// lookup involving substitution may cause intlib::intfn(f(g(x)), g(x)):
intlib::intfn :=
proc(ex, x)
  local t;
begin
  t := solvelib::getIdent(Any, indets(ex, All));
  subs(int(subsex(ex, x=t), t), t=x);
end:


