// Globale Annahmen:
// Integrationsvariable x
// a, b, c, ..., v, w, y, z  sind von x unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// fx, gx, f1x, g1x are unrestricted

// Diese Datei wird aus compile_patterns_indefinite.mu heraus gelesen.

// --------------------------------------------------
//                     ABKUERZUNGEN:
// --------------------------------------------------
// Bx : Bronstein, Semendjajew, 1991, Teubner,
//       Taschenbuch der Mathematik,  Integral Nr.x
// K : Kusch Rosenthal, Girardet,
//       Mathematik, Band 4, Integralrechnung
// L  : Integranden, die Mupad nur sehr langsam
//      integrieren kann
// GH: Wolfgang Gr"obner, Nikolaus Hofreiter, Integraltafel
//      1. Teil: Unbestimmte Integrale.  Springer 1965
// F  : Fatemans Pattern-Beispiele,
//      vgl. www.cs.berkeley.edu/~fateman
// BD : Herbert Bristol Dwight, Tables of Itegrals
//      and other mathematical data, MacMillan, 1961
// GR : Gradshteyn, Ryzhik
//      Table of Integrals, Series and Products,
//      Academic Press, 1965
//      
//---------------------------------------------------

//---------------------------------------------------
//                        ToDo:
//---------------------------------------------------        
/* 
 Bronstein:    B329
 
 Integranden, die bei der Lsung 
 von DGLn bentigt werden:
 
 according to Abramowitz and Stegun 
 int(airyAi(x),x) and
 int(airyBi(x), x)
 could be expressed in terms of hypergeometric functions.
 
 */
// Notation aus GH
// triprod := proc(m, d, v) save i; begin delete i; product((m+i*d), i=0..v-1) end:

if _parser_config() = null() or not contains(_parser_config()[2], hold(matchlib::block)) then
  alias(bl=matchlib::block);
end_if:

int_patterns :=
[ // Rationale Integranden:
 [x^a, x^(a+1)/(a+1), [bl(not iszero(a)), a<>-1]],
 [x^a, ln(x), [a=-1]],
 [x^m*(a+b*x^(mp1))^n3, (a+b*x^(mp1))^(n3+1)/b/(mp1)/(n3+1),
  [n3 <> -1,
   bl(not iszero(m) and
      not iszero(n3) and
      not iszero(a))]], //K9
 [x^m*(a*x^n+b)^n0,
  bl(x^(m+1)
     *sum::sum_fn(i -> n0!/(n0-i)!
          /product::product_fn(j -> m - j*n + n*n0 + 1, 0..i)
          *(b*n)^i*(a*x^n+b)^(n0-i), 0..n0)),
  [bl(not iszero(n0)),
   bl(not iszero(m)),
   bl(testtype(n0, DOM_INT))]], // GH16.1b
 [x^r*(a*x^s+b)^p,
  bl(intlib::tryChangeVar(hold(int)(x^r*(a*x^s+b)^p, x),
                          (a+b*x^s)^(1/denom(p)))),
  [p <> 0, p <> 1, r <> 0, s <> 0,
   bl(not iszero(a)), bl(not iszero(b)),
   bl(testtype(p, DOM_RAT)),
   bl(testtype(r, Type::Rational)),
   bl(testtype(s, Type::Rational)),
   bl(testtype((r+1)/s, DOM_INT))]], // Bug #632
 [x^r*(a*x^s+b)^p,
  bl(intlib::tryChangeVar(hold(int)(x^r*(a*x^s+b)^p, x),
                          (a/x^s+b)^(1/denom(p)))),
  [bl(not iszero(a)), bl(not iszero(b)),
   bl(not iszero(r)), bl(not iszero(p)), bl(not iszero(s)),
   bl(testtype(p, DOM_RAT)),
   bl(testtype(r, Type::Rational)),
   bl(testtype(s, Type::Rational)),
   bl(testtype((r+1)/s+p, DOM_INT))]], // Bug #632
 [(a+b*x)/(c+d*x^4),
  (-2*(2*b*c^(1/4)+sqrt(2)*a*d^(1/4))*arctan(1-sqrt(2)*d^(1/4)*x/c^(1/4))
   +(2*sqrt(2)*a*d^(1/4)-4*b*c^(1/4))*arctan(1+sqrt(2)*d^(1/4)*x/c^(1/4))
   +sqrt(2)*a*d^(1/4)*(ln((sqrt(c)+sqrt(2)*c^(1/4)*d^(1/4)*x+sqrt(d)*x^2)/
                          (sqrt(c)-sqrt(2)*c^(1/4)*d^(1/4)*x+sqrt(d)*x^2))))/
  (8*c^(3/4)*sqrt(d)), [c<>0]],

 [sqrt((b*x+a)^n), 2/b/(2+n)*(a+b*x)^((n+2)/2),
  [bl(not iszero(b)), b*x+a>=0]], //K71
 [sqrt(a+b/x+c/x^2),
  1/2*((a*x^2+b*x+c)/x^2)^(1/2)*x*(2*(a*x^2+b*x+c)^(1/2)*a^(1/2)
  +b*ln(1/2*(b+2*a*x+2*(a*x^2+b*x+c)^(1/2)*a^(1/2))/a^(1/2))
  -2*c^(1/2)*ln((2*c+b*x+2*c^(1/2)*(a*x^2+b*x+c)^(1/2))/x)*a^(1/2))
  /(a*x^2+b*x+c)^(1/2)/a^(1/2)],

 [x*sqrt(x+1)/sqrt(1-x^2), -2/3*(x+2)*sqrt(1-x^2)/sqrt(1+x)],

 [sqrt(b*x^2+a), 1/2*x*(b*x^2 + a)^(1/2) + 1/2*a/sqrt(-b)*arctan(sqrt(-b)*x/(b*x^2 + a)^(1/2)), [b < 0, a<>0]], 
 [sqrt(b*x^2+a), 1/2*x*(b*x^2 + a)^(1/2) + 1/2*a/sqrt(b)*ln(sqrt(b)*x + (b*x^2 + a)^(1/2)), 
   [bl(not iszero(b))]], 

 [sqrt(x^2+a)/x, -sqrt(a)*ln((sqrt(a)+sqrt(x^2+a))/x)+sqrt(x^2+a)],//K95
/* [sqrt(x^2+a)/x, sqrt(a)*arcsin(sqrt(a)/x)+sqrt(x^2-a),
  [a<0]], //K96, inversion  */
 [sqrt(a*x^2+b)/(c*x^2+d),
  sqrt(a)/c*ln(2*sqrt(a*x^2 + b) + 2*sqrt(a)*x)
  + 1/c/sqrt(d)*arctan(x*sqrt(b*c - a*d)/(sqrt(d)*sqrt(a*x^2 + b)))
		       *sqrt(b*c - a*d), [b<>0]],
 [x^2/sqrt(b*x^2+a), x/2/b*sqrt(a+b*x^2)
  -a/2/b^(3/2)*ln(2*sqrt(b)*x+2*sqrt(a+b*x^2)),
  [b<>0]], //integrals.com
 [sqrt(1-x)/sqrt(1+x), sqrt(1-x^2)+arcsin(x)], //K106, korr. (ccr)
 [sqrt(1+x)/sqrt(1-x), -sqrt(1-x^2)+arcsin(x)], //K107, korr. (ccr)
 
 [sqrt((1-x)/(1+x)), sqrt(1-x^2)+arcsin(x),
  [x>=-1]], // K106, korr. (ccr)
 [sqrt((1+x)/(1-x)), -sqrt(1-x^2)+arcsin(x),
  [x<=1]], //K107, korr. (ccr)
 
 [1/(a+b*sqrt(c+d*x^2)),
   (-a*arctan(b*sqrt(d)*x/sqrt(b^2*c-a^2))
   +a*arctan(a*sqrt(d)*x/sqrt(b^2*c-a^2)/sqrt(c+d*x^2))
   +sqrt(b^2*c-a^2)*ln(2*(sqrt(c+d*x^2)+sqrt(d)*x)))/
   (b*sqrt(d)*sqrt(b^2*c-a^2))],
 
 [1/sqrt(x)/(a-sqrt(x))^2, 2/(a-sqrt(x))], //K113
 [(1+sqrt(x))/(1-sqrt(x)), -x-4*sqrt(x)-4*ln(1-sqrt(x))], //K114, korr. (ccr)
 [x*sin(a*x), sin(a*x)/a^2 - x/a*cos(a*x),
  [bl(not iszero(a))]], //K267
 [x*cos(a*x), cos(a*x)/a^2 + x/a*sin(a*x),
  [bl(not iszero(a))]], //K268
 [(x+sin(x))/(1+cos(x)), x*tan(x/2)], //K272
 [x/sin(a*x)^2, ln(sin(a*x))/a^2 - x/a*cot(a*x),
  [bl(not iszero(a))]], //K273, L, B291
 [x/cos(a*x)^2, ln(cos(a*x))/a^2 + x/a*tan(a*x),
  [bl(not iszero(a))]], //K274, L, B330 korr. (ccr)
 [1/(sin(x)^3+1),
  (-1)^(1/4)*sqrt(2)*(sqrt(3)-I)*
  arctan((-1)^(3/4)*sec(x/2)*(2*cos(x/2)-sin(x/2)-I*sqrt(3)*
                              sin(x/2))/
         sqrt(2*(3*I+sqrt(3))))/3/sqrt(3*I+sqrt(3)) +
  (-1)^(3/4)*(I+sqrt(3))*
  arctan((-1)^(1/4)*sec(x/2)*
         (2*cos(x/2)-sin(x/2)+I*sqrt(3)*sin(x/2))/
         sqrt(2*(sqrt(3)-3*I)))/3/sqrt(1/2*(sqrt(3)-3*I)) +
  2*sin(x/2)/(3*(cos(x/2)+sin(x/2)))], // integrals.com, added for bug #451
 [x*sin(x)/(1+cos(x))^2, x/(1+cos(x))-tan(x/2)], //K284
 [x*sin(x)/(1-cos(x))^2, -x/(1-cos(x))-cot(x/2)], //K285
 [x*cos(x)/(1+sin(x))^2, -x/(1+sin(x))-tan(PI/4-x/2)], //K286
 [x*cos(x)/(1-sin(x))^2, x/(1-sin(x))-cot(PI/4-x/2)], //K289
 [x/tan(x)^2, ln(sin(x)) - x*cot(x) - x^2/2], //K306
 [x/cot(x)^2, ln(cos(x)) + x*tan(x) - x^2/2], //K307
 [x*sin(x)/cos(x)^2, x/cos(x)+ln(tan(PI/4-x/2))], //K309, korr. (ccr)
 [x*cos(x)/sin(x)^2, ln(tan(x/2))-x/sin(x)], //K310

 [tan(x), -ln(cos(x))], // F
 
// [tan(x)^c,
//   tan(x)^(c+1)/(c+1)*hypergeom([1, (c+1)/2], [(c+3)/2], -tan(x)^2),
//   [bl(not testtype(c, DOM_INT))]],
// [sin(x)^c/cos(x)^c,
//   sin(x)^(c+1)/(c-1) * (sin(x)^2)^(-c/2-1/2)*cos(x)^(1-c) *
//    hypergeom([(1-c)/2, (1-c)/2], [(3-c)/2], cos(x)^2),
//   [bl(not testtype(c, DOM_INT))]],
//
// [cot(x)^c,
//   -cot(x)^(c+1)/(c+1)*hypergeom([1, (c+1)/2], [(c+3)/2], -cot(x)^2),
//   [bl(not testtype(c, DOM_INT))]],
// [cos(x)^c/sin(x)^c,
//   -sin(x)^(1-c)/(c+1) * (sin(x)^2)^((c-1)/2)*cos^(c+1)(x) *
//    hypergeom([(c+1)/2, (c+1)/2], [(c+3)/2], cos(x)^2),
//   [bl(not testtype(c, DOM_INT))]],
 
 [x*tan(a*x+b),
  -1/(2*a^2)*(a^2*I*x^2+2*I*a*b*x+2*a*ln(1+exp(-2*I*(a*x+b)))*x
  -PI*ln(1+exp(2*I*a*x))+2*b*ln(1+exp(-2*I*(a*x+b)))
  -PI*ln(1+exp(-2*I*(a*x+b)))+PI*ln(cos(a*x))
  -(2*b-PI)*ln(cos(a*x+b))+I*polylog(2,-exp(-2*I*(a*x+b)))),
  [bl(not iszero(b))]], // F
 [x^n*tan(a*x),
  bl(I*x^(n+1)/(n+1)-2*I*exp(2*I*a*x)*n!
  *sum::sum_fn(j -> (-1)^j*2^(-j-1)*(I*a)^(-j-1)*x^(n-j)/(n-j)!
                     *hypergeom([1$(j+2)], [2$(j+1)], -exp(2*I*a*x)),
                  0..n)),
  [bl(not iszero(n-1)), bl(testtype(n, DOM_INT))]], // F
 [x*tan(x),
  I/2*(x*(x+2*I*ln(1+exp(2*I*x)))
   +polylog(2,-exp(2*I*x)))], // F
 [x^2*tan(x),
  1/3*I*x^3-x^2*ln(1+exp(2*I*x))+
  I*x*polylog(2,-exp(2*I*x))-1/2*polylog(3,-exp(2*I*x))],
 [a^(b*x)*tan(c*x),
  (a^(b*x)*(b*exp(2*I*c*x)*ln(a)
     *hypergeom([1-I*b*ln(a)/(2*c),1], [2-I*b*ln(a)/(2*c)],
                -exp(2*I*c*x))
    -(2*I*c+b*ln(a))*hypergeom([-I*b*ln(a)/(2*c),1],
             [1-I*b*ln(a)/(2*c)], -exp(2*I*c*x))))/
  (b*ln(a)*(I*b*ln(a)-2*c))], // F
 [exp(-I*x)*tan(x), 2*arctan(exp(-I*x))-exp(-I*x)], // F
 [exp(I*x)*tan(x), 2*arctan(exp(I*x))-exp(I*x)], // F

 [x^(l-1)*exp(a*x^p),
  x^l/l*exp(a*x^p)*hypergeom([1], [1+l/p], -a*x^p)], // <4B843262.9B56F4A4@freenet.de>, sci.math.symbolic

 [x^n/(a+b*exp(c*x)),
  (x^(n+1)/(n+1) - x^n*ln(1+b/a*exp(c*x))/c + 
  sum::sum_fn(i -> (-1)^i*diff(x^n,x$i)*
    polylog(i+1,-b/a*exp(c*x))/c^(i+1), 1..n))/a],
 
 [cos(x)^2/(a*cos(x)^2+b*sin(x)^2),
  (x-sqrt(b)/sqrt(a)*arctan(sqrt(b)/sqrt(a)*tan(x)))/(a-b), [a<>b]], 
 [1/(a+b*tan(x)^2),
  (x-sqrt(b)/sqrt(a)*arctan(sqrt(b)/sqrt(a)*tan(x)))/(a-b), [a<>b]], 
 [sin(x)^2/(a*cos(x)^2+b*sin(x)^2),
  (x-sqrt(a)/sqrt(b)*arctan(sqrt(b)/sqrt(a)*tan(x)))/(b-a), [a<>b]], 
 [tan(x)^2/(a+b*tan(x)^2),
  (x-sqrt(a)/sqrt(b)*arctan(sqrt(b)/sqrt(a)*tan(x)))/(b-a), [a<>b]], 
 [1/(a*cot(x)^2+b),
  (x-sqrt(a)/sqrt(b)*arctan(sqrt(b)/sqrt(a)*tan(x)))/(b-a), [a<>b]], 
 [cos(x)/(1+t*cos(x)),
  (x-2/sqrt(t^2-1)*arctanh((t-1)/sqrt(t^2-1)*tan(x/2)))/t,
  [t <> 0, t <> 1, t <> -1]],
 [cos(x)/(1+t*cos(x)), sin(x), [t = 0]],
 [cos(x)/(1+t*cos(x)), x-tan(x/2), [t = 1]],
 [cos(x)/(1+t*cos(x)), -x-cot(x/2), [t = -1]],
 [x*arctan(x/a), (x^2+a^2)/2*arctan(x/a)-a*x/2], // integrals.com
 [sinh(x), cosh(x)], //K360, B426
 [cosh(x), sinh(x)], //K361, B427
 [tanh(x), ln(cosh(x))], //K362, B436
 [coth(x), ln(sinh(x))], //K363, B437
 [1/(sinh(x)*cosh(x)), ln(tanh(x))], //K367
 [1/sinh(x)^2, -coth(x)], //K370
 [1/cosh(x)^2,  tanh(x)], //K371
 [sinh(a*x)/x, Shi(a*x)],
 [sqrt(tan(x)),
  - 1/2*2^(1/2)*arctan((2*tan(x))^(1/2)/(tan(x) - 1))
  - 1/4*2^(1/2)*ln(1/(tan(x) - (2*tan(x))^(1/2) + 1)
                   *(tan(x) + (2*tan(x))^(1/2) + 1))], // Bug#1062
 
 [sqrt(a+b*sin(x)^2),
  sqrt(a)*ellipticE(x, -b/a), [a>0]], // by definition
 [sqrt(1+cos(x)^2), sqrt(2)*ellipticE(x, 1/2)], // special case
 [(1 - b*sin(a*x)^2)^(1/2), ellipticE(a*x, b)/a],
 [(b*cos(a*x)^2 - b + 1)^(1/2), ellipticE(a*x, b)/a],
 
 [1/x/(a*x+b)^n,
  bl(-(ln((a*x+b)/x)
       -sum::sum_fn(i -> binomial(n-1,i)*
            (-a*x/(a*x+b))^i/i, 1..n-1))/b^n),
  [n>1, bl(not iszero(b)), bl(testtype(n, DOM_INT))]], //B21
/** plain wrong and I don't see how to correct it
 [1/x^2/(a*x+b)^n,
  bl((sum::sum_fn(i -> binomial(n,i)*(-a)^i*x^(i-1)/(i-1)
          /(a*x+b)^(i-1),2..n) 
      - a - b/x + n*a*ln(a+b/x))/b^(n+1)),
  [n>=2, bl(not iszero(b)), bl(testtype(n, DOM_INT))]], //B25
  */
 [1/x^2/(a*x^2+b*x+c),
  1/2/c^2*b*ln(a*x^2+b*x+c)+1/c^2/(4*a*c-b^2)^(1/2)
  *arctan((2*a*x+b)/(4*a*c-b^2)^(1/2))*b^2-2/c/(4*a*c-b^2)^(1/2)
  *arctan((2*a*x+b)/(4*a*c-b^2)^(1/2))*a-1/c/x-1/c^2*b*ln(x),
  [a<>0, c<>0, c<>b^2/(4*a)]],
 [1/x/(a*x^2+b*x+c),
  ln(x)/c-ln(a*x^2+b*x+c)/(2*c)
  -b/c/sqrt(4*a*c-b^2)*arctan((2*a*x+b)/sqrt(4*a*c-b^2)),
  [a<>0, c<>0, c<>b^2/(4*a)]],
 [1/x/(a*x^2+b*x+c),
  2/(b*x+2*c)-2/c*arctanh(b/c*x+1),
  [a=b^2/(4*c)]],
 
 [x/(a+b*x)^n,
  (a/((n-1)*(a+b*x)^(n-1))-1/((n-2)*(a+b*x)^(n-2)))/b^2,
  [bl(testtype(n, DOM_INT)), n>2, bl(not iszero(a))]], // BD91
 [x^m/(a+b*x)^n,
  bl(sum::sum_fn(i -> m!*(-a)^i*(a+b*x)^(m-n-i+1)/
         ((m-i)!*i!*(m-n-i+1)),
         0..m)/b^(m+1)),
  [m-n+1<0,
   bl(not iszero(a)), bl(not iszero(b)),
   bl(not iszero(m)), bl(not iszero(n)),
   bl(testtype(m, DOM_INT))]], // BD89
 [x^m/(a+b*x)^n,
  bl((sum::sum_fn(i -> m!*(-a)^i*(a+b*x)^(m-n-i+1)/
          ((m-i)!*i!*(m-n-i+1)), 1..m)+
      ln(a+b*x))/b^(m+1)),
  [m-n+1=0,
   bl(not iszero(a)), bl(not iszero(b)),
   bl(not iszero(m)), bl(not iszero(n)),
   bl(testtype(m, DOM_INT))]], // BD89
 [x^m/(a+b*x)^n,
  bl((sum::sum_fn(i -> m!*(-a)^i*(a+b*x)^(m-n-i+1)/
         ((m-i)!*i!*(m-n-i+1)), 0..m-n)
      + m!*(-a)^(m-n+1)/((m-n+1)!*(n-1)!) * ln(a+b*x)
      + sum::sum_fn(i -> m!*(-a)^i*(a+b*x)^(m-n-i+1)/
            ((m-i)!*i!*(m-n-i+1)), m-n+2..m))
     /b^(m+1)),
  [m-n+1>0, n>2,
   bl(not iszero(a)), bl(not iszero(b)),
   bl(not iszero(m)), bl(not iszero(n)),
   bl(testtype(m, DOM_INT)), bl(testtype(n, DOM_INT))]], // BD89
 
 [1/(a*x^2+b*x+c)^n,
  bl((-1)^n*2*binomial(2*n-3,n-2)*
     ((a*x+b/2)/a*sum::sum_fn(i -> (-1)^i*(i-1)!*(i-1)!/(2*i-1)!
                      *(a/(b^2-4*a*c))^(n-i)/
                      (a*x^2+b*x+c)^i, 1..n-1)
      -(a/(b^2-4*a*c))^(n-1)*arctan((a*x+b/2)/sqrt(a*c-b^2/4))
      /sqrt(a*c-b^2/4))),
  [bl(not iszero(a)), b^2-4*a*c<0, n > 1,
   bl(testtype(n, DOM_INT))]], // GH 15.9b, 15.10/1
 [1/(a*x^2+b*x+c),
  arctan((a*x+b/2)/sqrt(a*c-b^2/4))/sqrt(a*c-b^2/4),
  [bl(not iszero(a)), b^2-4*a*c<>0]], // GH 15.10/1
/** seems to be wrong
 [1/(a*x^2+b*x+c)^n,
  bl((-1)^n*2*binomial(2*n-3,n-2)*
     ((a*x+b/2)/a*sum::sum_fn(i -> (-1)^i*(i-1)!*(i-1)!/(2*i-1)!
                      *(a/(b^2-4*a*c))^(n-i)
                      /(a*x^2+b*x+c)^i, 1..n-1)
      +(a/(b^2-4*a*c))^(n-1)/(a*x+b/2))),
  [bl(not iszero(a)), b^2-4*a*c=0,
   bl(testtype(n, DOM_INT))]], // GH 15.9b, 15.10/2
  */
 [1/(a*x^2+b*x+c)^n,
  bl((-1)^n*2*binomial(2*n-3,n-2)*
     ((a*x+b/2)/a*sum::sum_fn(i -> (-1)^i*(i-1)!*(i-1)!/(2*i-1)!
                      *(a/(b^2-4*a*c))^(n-i)
                      /(a*x^2+b*x+c)^i, 1..n-1)
      -(a/(b^2-4*a*c))^(n-1)
      *ln((a*x+b/2-sqrt(b^2/4-a*c))/
          (a*x+b/2+sqrt(b^2/4-a*c)))
      /sqrt(b^2-4*a*c))),
  [bl(not iszero(a)), b^2-4*a*c>0,
   bl(testtype(n, DOM_INT))]], // GH 15.9b, 15.10/3
 
 [x/(a*x^2+b*x+c)^n, 
  bl(-(2*c+b*x)/((n-1)*(4*a*c-b^2)*(a*x^2+b*x+c)^(n-1))
     -(2*n-3)*b/(n-1)/(4*a*c-b^2)*int(1/(a*x^2+b*x+c)^(n-1),x)),
  [bl(not iszero(a)), n>1]], //B46
 
 [x^m/(a*x^2+b*x+c)^n,  
  bl(-x^(m-1)/((2*n-m-1)*a*(a*x^2+b*x+c)^(n-1))
     +(m-1)*c/(2*n-m-1)/a*int(x^(m-2)/(a*x^2+b*x+c)^(n),x)
     -(n-m)*b/(2*n-m-1)/a*int(x^(m-1)/(a*x^2+b*x+c)^n,x)),
  [bl(testtype(m, DOM_INT)), m<>2*n-1, bl(not iszero(a)), m<>1, m<>0, n>1]],//B50
 [x^m/(a*x^2+b*x+c)^n,
  bl(1/a*int(x^(2*n-3)/(a*x^2+b*x+c)^(n-1),x)
     -c/a*int(x^(2*n-3)/(a*x^2+b*x+c)^n,x)
     -b/a*int(x^(2*n-2)/(a*x^2+b*x+c)^n,x)),
  [bl(testtype(n, DOM_INT)), bl(not iszero(a)), m=2*n-1, n>1]], //B51
 [1/(a*x^2+b*x+c)^n/x, 
  bl(1/(2*c*(n-1)*(a*x^2+b*x+c)^(n-1))
     -b/(2*c)*int(1/(a*x^2+b*x+c)^n,x)
     +1/c*int(1/x/(a*x^2+b*x+c)^(n-1),x)),
  [bl(testtype(n, DOM_INT)), bl(not iszero(a)), n>1]], //B53
 [1/(a*x^2+b*x+c)^n/x^m, 
  bl(-1/(c*(m-1)*(a*x^2+b*x+c)^(n-1)*x^(m-1))
     -(2*n+m-3)*a/((m-1)*c)*int(1/x^(m-2)/(a*x^2+b*x+c)^n,x)
     -(n+m-2)*b/((m-1)*c)*int(1/x^(m-1)/(a*x^2+b*x+c)^n,x)),
  [bl(testtype(m, DOM_INT)), m>1, bl(not iszero(a)), n>1]], //B55
 [1/((d*x+e)*(a*x^2+b*x+c)),
  d*ln(((d*x+e)^2/(a*x^2+b*x+c)))/(2*(c*d^2-e*b*d+e^2*a))
  +(2*e*a-b*d)/(2*(c*d^2-e*b*d+e^2*a))
  *ln(((2*a*x+b-sqrt(b^2-4*a*c))/(2*a*x+b+sqrt(b^2-4*a*c))))
  /sqrt(b^2-4*a*c),
  [bl(not iszero(a)), bl(not iszero(d)), bl(not iszero(e))]], //B56
 [1/(a+x^2)^n,
  bl(x*sum::sum_fn(i -> (-2)^(i - 1)/gamma(3/2 - n)*gamma(i - n + 1/2)/
           (fact(n - 1)/fact(n - i - 1)*(2*a)^i*(x^2+a)^(n - i)),
           1..n-1)+
     2^(n - 1)/PI^(1/2)*gamma(n - 1/2)/(n-1)!/(2*a)^(n-1)/sqrt(a)
     *arctan(x/sqrt(a))),
  [a>0, n>1, bl(testtype(n, DOM_INT))]],

/* [(a*x+b)^c+(d*x+e)^f,
  (a*x+b)^c*(d*(a*x+b)/(b*d-a*e))^(-c)*(d*x+e)^(1+f)*
   hypergeom([1+f, -c], [2+f],a*(d*x+e)/(a*e-b*d))/(d*(1+f))],
*/ 

 [1/(a+x^2),
  1/sqrt(a)*arctan(x/sqrt(a)), [a>0]], // GH 15.15b
 [1/(a+b*x^2),
  1/sqrt(a*b)*arctan(sqrt(b)*x/sqrt(a)),
  [a>0, b>0]], // GH 15.12
 [1/(-a+x^2),
  1/sqrt(-a)*arctan(x/sqrt(-a)), [a<0]], // GH 15.15b, Inv.
 [1/(-a+b*x^2),
  1/sqrt(-a*b)*arctan(sqrt(b)*x/sqrt(-a)),
  [a<0, b>0]], // GH 15.12, Inv.
 [1/(-a-b*x^2),
  1/sqrt(a*b)*arctan(sqrt(-b)*x/sqrt(-a)),
  [a<0, b<0]], // GH 15.12, Inv.
 [1/(a-b*x^2),
  I/sqrt(a*b)*arctan(sqrt(-b)*x/sqrt(a)),
  [a>0, b<0]], // GH 15.12, Inv.
 
 [1/(a^2-x^2)^n, 
  bl(x/(2*(n-1)*a^2*(a^2-x^2)^(n-1))
     +(2*(n-1)-1)/(2*(n-1)*a^2)*int(1/(a^2-x^2)^(n-1),x)),
  [bl(testtype(n, DOM_INT)), n>=2]], //B60b
 [x^2/(a^2+x^2)^n, 
  bl(-x/(2*(n-1)*(a^2+x^2)^(n-1))
     +1/(2*(n-1))*int(1/(a^2+x^2)^(n-1),x)),
  [bl(testtype(n, DOM_INT)), n>1]], //B68a
 [x^2/(a^2-x^2)^n, 
  bl(+x/(2*(n-1)*(a^2-x^2)^(n-1))
     -1/(2*(n-1))*int(1/(a^2-x^2)^(n-1),x)),
  [bl(testtype(n, DOM_INT)), n>1]], //B68b
 
 [1/(a*x+b)/(c*x+d),
  1/(a*d-b*c)*ln((a*x+b)/(c*x+d)),
  [bl(not iszero(a)), bl(not iszero(c)),
   bl(not (iszero(b) and iszero(d)))]], // GH12.8a
 [1/(a*x+b)^2/(c*x+d),
  -1/(a*d-b*c)/(a*x+b)-c/(a*d-b*c)^2*ln((a*x+b)/(c*x+d)),
  [bl(not iszero(a)), bl(not iszero(c)),
   bl(not (iszero(b) and iszero(d)))]], // GH12.8b
 [1/(a*x+b)^2/(c*x+d)^2,
  1/(a*d-b*c)/(a*x+b)/(c*x+d)
  -2*a/(a*d-b*c)^2/(a*x+b)
  -2*a*c/(a*d-b*c)^3*ln((a*x+b)/(c*x+d)),
  [bl(not iszero(a)), bl(not iszero(c)),
   bl(not (iszero(b) and iszero(d)))]], // GH12.8c
/*
 [1/((a+b*x)^r*(c+d*x)^s),
  -1/d/(s-1)*((d*(a+b*x)/(a*d-b*c))^r*(c+d*x)^(1-s)/(a+b*x)^r
             *hypergeom([1-s, r], [2-s], b*(c+d*x)/(b*c-a*d))),
  [r<>0, s<>0, r+s<>1, r+s<>0]], 
*/
 
 [x/((a*x+b)*(c*x+d)),
  d/c/(a*d-b*c)*ln(c*x+d)-b/a/(a*d-b*c)*ln(a*x+b),
  [bl(not iszero(a)), bl(not iszero(b)),
   bl(not iszero(c)), bl(not iszero(d))]], // GH14.2a
 [x^2/((a*x+b)*(c*x+d)),
  x/a/c + b^2/a^2/(a*d-b*c)*ln(a*x+b)
  - d^2/c^2/(a*d-b*c)*ln(c*x+d),
  [bl(not iszero(a)), bl(not iszero(b)),
   bl(not iszero(c)), bl(not iszero(d))]], // GH14.2b
 [x/((a*x+b)^2*(c*x+d)),
  d/(a*d-b*c)^2*ln((a*x+b)/(c*x+d))+b/a/(a*d-b*c)*1/(a*x+b),
  [bl(not iszero(a)), bl(not iszero(c)),
   bl(not iszero(b)), bl(not iszero(d))]], // GH14.2c
 [x^2/(a*x+b)^2/(c*x+d),
  -b*(2*a*d-b*c)/a^2/(a*d-b*c)^2*ln(a*x+b)
  +d^2/c/(a*d-b*c)^2*ln(c*x+d)
  -b^2/a^2/(a*d-b*c)/(a*x+b),
  [bl(not iszero(a)), bl(not iszero(b)),
   bl(not iszero(c)), bl(not iszero(d))]], // GH14.2d
 
 [(a*x+b)/(c*x+d),
  a/c*x-(a*d-b*c)/c^2*ln(c*x+d),
  [bl(not iszero(a)), bl(not iszero(c))]], // GH13.5c
 [(a*x+b)^2/(c*x+d)^2,
  a^2/c^2*x-2*a/c^3*(a*d-b*c)*ln(c*x+d)
  -(a*d-b*c)^2/c^3/(c*x+d),
  [bl(not iszero(a)), bl(not iszero(c))]], // GH13.5d
/** sorry, wrong
 [(a*x+b)^n/(c*x+d)^n,
  bl(a^n/c^n*x-n*a^(n-1)*(a*d-b*c)/c^(n+1)*ln(c*x+d)
     -sum::sum_fn(i -> binomial(n,i+1)
          *a^(n-i-1)*(-a*d+b*c)^(i+1)/i/c^(i+1)/
          (c*x+d)^i, 1..n-1)),
  [n>2, bl(not iszero(a)), bl(not iszero(c)), bl(testtype(n, DOM_INT))]], // GH13.5b
  */
 
 [(a*x+b)^n/(c*x+d)^m,
  (a*x+b)^(n+1)*(a*c*x+(n+2)*a*d-(n+1)*b*c)/
  ((n+1)*(n+2)*(a*d-b*c)^2*(c*x+d)^(n+2)),
  [bl(not iszero(a)), bl(not iszero(c)),
   m=n+3, bl(not iszero(n))]], // GH 14.4
 
 [x^m*(a*x^n+b)^n0,
  bl(x^(m+1)*sum::sum_fn(i -> n0!/(n0-i)!*(b*n)^i
                 /((-1)^(i + 1)*n^(i + 1)*
                   gamma(i - 1/n*(m+n*n0+1)+1)
                   /gamma(-1/n*(m+n*n0+1)))
                 *(a*x^n+b)^(n0-i), 0..n0)),
  [not 1/n*(m + n0*n + 1) in Z_,
   bl(not iszero(a) and not iszero(b)),
   bl(testtype(n0, DOM_INT))]], // GH16.1b
 [x^(n-1)/(a*x^n+b),
  1/(a*n)*ln(a*x^n+b),
  [bl(not iszero(a) and
      not iszero(b))]], //GH16.8b
 [1/(x^3+1),
  1/3*ln(x + 1) - 1/6*ln((x - 1/2)^2 + 3/4) + 
       1/3^(1/2)*arctan(2/3^(1/2)*(x - 1/2))], // 3.0
// [1/(x^n+a),
//  x/a*hypergeom([1/n, 1], [1+1/n], -x^n/a)], 
 
 ///////////////////////////////////////////////////////
// Irrationale Integranden :
 [sqrt(x)/(a+b*x),
  2*sqrt(x)/b - 2*sqrt(a)/b^(3/2)*arctan(sqrt(b*x/a)),
  [a>=0,b>=0]], //B109a
 [sqrt(x)/(a-b*x), 
  - 2*sqrt(x)/b
  + sqrt(a/b^3)*ln((sqrt(a)+sqrt(b*x))/(sqrt(a)-sqrt(b*x))),
  [a>=0,b>=0]], //B109b
 [sqrt(x^3)/(a+b*x),
  2/3/b*(x^3)^(1/2) - 1/b^3/x*(2*a*b - 
    2*a/x^(1/2)*arctan(b*x^(1/2)/(a*b)^(1/2))*(a*b)^(1/2))*(x^3)^(1/2)], //B110a, corrected
 [sqrt(x)/(a+b*x)^2,
  - sqrt(x)/(b*(a+b*x)) 
  + arctan(sqrt(b*x/a))/sqrt(a*b^3),
  [a>=0,b>=0]],//B111a
 [sqrt(x)/(a-b*x)^2,
  + sqrt(x)/(b*(a-b*x)) 
  - ln((sqrt(a)+sqrt(b*x))/(sqrt(a)-sqrt(b*x)))/2/sqrt(a*b^3),
  [a>=0,b>=0]], //B111b
/** sorry, wrong
 [sqrt(x^3)/(a+b*x)^2, 
  + 2*sqrt(x^3)/(b*(a+b*x)) 
  + 3*a*sqrt(x)/(b^2*(a+b*x)) 
  - 3*sqrt(a/b^5)*arctan(sqrt(b*x/a)),
  [a>=0,b>=0]], //B112a
 [sqrt(x^3)/(a-b*x)^2, 
  - 2*sqrt(x^3)/(b*(a-b*x)) 
  + 3*a*sqrt(x)/(b^2*(a-b*x)) 
  - 3*sqrt(a/b^5)*ln((sqrt(a)+sqrt(b*x))/(sqrt(a)-sqrt(b*x)))/2,
  [a>=0,b>=0]], //B112b
  */
/** sorry, wrong
 [1/(sqrt(x^3)*(a+b*x)),
  - 2/(a*sqrt(x)) - 2*sqrt(b/a^3)*arctan(sqrt(b*x/a)),
  [a>=0,b>=0]], //B114a
 [1/(sqrt(x^3)*(a-b*x)),
  - 2/(a*sqrt(x)) 
  + sqrt(b/a^3)*ln((sqrt(a)+sqrt(b*x))/(sqrt(a)-sqrt(b*x))),
  [a>=0,b>=0]], //B114b
  */
 [1/(sqrt(x)*(a+b*x)^2), 
  sqrt(x)/(a*(a+b*x)) + arctan(sqrt(b*x/a))/sqrt(a^3*b),
  [a>=0,b>=0]], //B115a
 [1/(sqrt(x)*(a-b*x)^2), 
  sqrt(x)/(a*(a-b*x)) 
  + ln((sqrt(a)+sqrt(b*x))/(sqrt(a)-sqrt(b*x)))/2/sqrt(a^3*b),
  [a>=0,b>=0]], //B115b
/** sorry, wrong
 [1/(sqrt(x^3)*(a+b*x)^2), 
  - 2/(a*(a+b*x)*sqrt(x)) 
  - 3*b* sqrt(x)/(a^2*(a+b*x)) 
  - 3*sqrt(b)*arctan(sqrt(b*x/a))/sqrt(a^5),
  [a>=0,b>=0]], //B116a
 [1/(sqrt(x^3)*(a-b*x)^2), 
  - 2/(a*(a-b*x)*sqrt(x)) 
  + 3*b* sqrt(x)/(a^2*(a-b*x)) 
  + 3*sqrt(b/a^5)*ln((sqrt(a)+sqrt(b*x))/(sqrt(a)-sqrt(b*x)))/2,
  [a>=0,b>=0]], //B116b
  */
 [sqrt(x)/(a+x^2),
  - ln((x+a^(1/4)*sqrt(2*x)+a^(1/2))
       /(x-a^(1/4)*sqrt(2*x)+a^(1/2)))/(2*a^(1/4)*sqrt(2)) 
  + arctan((a^(1/4)*sqrt(2*x))/(a^(1/2)-x))/(a^(1/4)*sqrt(2)),
  [a>=0]], //B117
 [1/sqrt(x)/(a+x^2),
  ln((x+a^(1/4)*sqrt(2*x)+a^(1/2))
     /(x-a^(1/4)*sqrt(2*x)+a^(1/2)))/(2*a^(3/4)*sqrt(2)) 
  + arctan((a^(1/4)*sqrt(2*x))/(a^(1/2)-x))/(a^(3/4)*sqrt(2)),
  [a>=0]], //B118
 [sqrt(x)/(a-x^2),
  ln((a^(1/4)+sqrt(x))/(a^(1/4)-sqrt(x)) )/(2*a^(1/4)) 
  - arctan(sqrt(x)/a^(1/4))/a^(1/4),
  [a>=0]], //B119
 [1/sqrt(x)/(a-x^2),
  ln((a^(1/4)+sqrt(x))/(a^(1/4)-sqrt(x) ))/(2*a^(3/4)) 
  + arctan(sqrt(x)/a^(1/4))/a^(3/4),
  [a>=0]], //B120
 [1/(x^2+1)^(1/2), arcsinh(x)],
 [1/sqrt(x^2-1), arccosh(x)],
 [1/sqrt(a-x^2), -arctan(x*sqrt(a-x^2)/(x^2-a))], 
 [1/sqrt(a+x^2), ln(x+sqrt(x^2+a)),
   [a <> 0 or x > 0]], // formally correct without restriction, but for x<0, we have ln(0) as the result ...
 [1/sqrt(a*x^2+b*x+c), arcsinh(sqrt(a)*x+b/(2*sqrt(a))),
   [a>0, b = 4*a*(c-1)]],
 [1/sqrt(a*x^2+b*x+c),
   1/sqrt(a)*ln((a*x+b/2)/sqrt(a)+sqrt(a*x^2+b*x+c))
   /* ,[a>0] */
   , [bl(not(iszero(b) and iszero(c)))]], // GH231.8a
 [1/sqrt(a*x^2+b*x+c),
   -1/sqrt(-a) * arcsin((2*a*x+b)/sqrt(b^2-4*a*c)),
   [a<0, bl(not(iszero(b) and iszero(c)))]], // GH231.8b
 [1/sqrt(a*x^2+b*x+c),
   1/sqrt(a)*ln(a*x+b/2), [b^2/4-a*c=0, bl(not(iszero(b) and iszero(c)))]], // GH231.8c
 [x/(a*x^2+b*x+c)^(1/2),
   1/a*(a*x^2 + b*x + c)^(1/2) -
   1/2/a^(3/2)*b*ln(1/a^(1/2)*(1/2*b + a*x) + (a*x^2 + b*x + c)^(1/2))], // GH231.7b
 [x/(a*x^2+b*x+c)^(3/2),
   -1/(a*c-b^2/4)*(b/2*x+c)/sqrt(a*x^2+b*x+c)], // GH231.20a
 [1/(a*x^2+b*x+c)^(3/2),
   1/(a*c-b^2/4)*(a*x+b/2)/sqrt(a*x^2+b*x+c)], // GH231.20b, B242
 [x^2/(a*x^2+b*x+c)^(3/2),
   bl(1/a*int(1/sqrt(a*x^2+b*x+c), x) 
     + 1/(a*(a*c-b^2/4)) * ((b^2/2-a*c)*x+b/2*c)/sqrt(a*x^2+b*x+c))],
     // GH231.17c
 [(a*x^2+b*x+c)^d,
  bl((a*x+b/2)/((d+1/2)*2*a)*(a*x^2+b*x+c)^d
     + 2*d*(a*c-b^2/4)/((d+1/2)*2*a)*int((a*x^2+b*x+c)^(d-1), x)),
  [bl(testtype(d-1/2, DOM_INT)), bl((d-1/2) >0)]], // GH231.13a
 [1/sqrt(a*x^2+c), arcsinh(sqrt(a)*x),
   [a>0, 0 = 4*a*(c-1), bl(not(iszero(c)))]],
 [1/sqrt(a*x^2+c),
   1/sqrt(a)*ln((a*x)/sqrt(a)+sqrt(a*x^2+c)),
   [a>0, bl(not(iszero(c)))]], // GH231.8a
 [1/sqrt(a*x^2+c),
   -1/sqrt(-a) * arcsin(a*x/sqrt(-a)/sqrt(c)),
   [a<0, c>0]], // GH231.8b
 [1/sqrt(a*x^2+c),
   arctan(sqrt(-a)*x/sqrt(a*x^2+c))/sqrt(-a),
   [a<0, bl(not(iszero(c)))]],
 [x/(a*x^2+c)^(3/2),
   -1/a/sqrt(a*x^2+c),
   [bl(not(iszero(c)))]], // GH231.20a
 [1/(a*x^2+c)^(3/2),
   x/c/sqrt(a*x^2+c)], // GH231.20b
 [x^2/(a*x^2+c)^(3/2),
   bl(1/a*int(1/sqrt(a*x^2+c), x) 
     + 1/(a*(a*c)) * (-a*c)*x/sqrt(a*x^2+c))],
     // GH231.17c
 [1/sqrt(a*x^2), sign(x)*ln(a*x)/sqrt(a)],
     
 [1/sqrt(a*exp(x)+c),
  -2/sqrt(c)*arctanh(sqrt(a*exp(x)+c)/sqrt(c))],

 [sqrt(-b*x^2+a)/(c-d*x^2),(b/c)/sqrt(b)*arcsin(x*sqrt(b/a)),
  [b>0 /* , a>=0 */,c=a*d/b]], // erweiterte Fassung
 [sqrt(x^2+a)/(b*x^2+c), 1/b*ln(x+sqrt(a+x^2)), [c=b/a, b<>0, c<>0]], // erweiterte Fassung
 [sqrt(b*x^2+a)/(c*x^2+d),(b/c)/sqrt(b)*ln(b*x+sqrt(b)*sqrt(a+b*x^2)),
  [d=a*c/b]], // erweiterte Fassung des gleichen Patterns
 [sqrt(a*x^2+c)/(b*x^2+d), sqrt(a)/b*ln(sqrt(a)*x+sqrt(a*x^2+c)),
  [a>0, d=c*b/a]], // GH233.15a, erweitert
 [1/x/(a-x^2)^(3/2),
  1/a/sqrt(a-x^2)-1/a^(3/2)*ln((sqrt(a-x^2)+sqrt(a))/x),
  [a>0]], // GH236.16c
 [1/(a-x^2)^(3/2),
  1/a * x/sqrt(a-x^2),
  [a>0]], // GH236.17c
 [1/sqrt(a-x^2)/(c-x^2),
  1/2/sqrt(c)/sqrt(a-c)*ln((sqrt(c)*sqrt(a-x^2)+x*sqrt(a-c))/
                           sqrt(c)*sqrt(a-x^2)-x*sqrt(a-c)),
  [a>0, c>0, a>c]], //GH236.19a
 [1/sqrt(a-x^2)/(c+x^2),
  -1/2/sqrt(-c)/sqrt(a+c)*ln((sqrt(-c)*sqrt(a-x^2)+x*sqrt(a+c))/
                             sqrt(-c)*sqrt(a-x^2)-x*sqrt(a+c)),
  [a>0, c<0, a>-c]], //GH236.19a
 [1/sqrt(a-x^2)/(c-x^2),
  1/sqrt(c)/sqrt(c-a)*arctan((x*sqrt(c-a))/
                              (sqrt(c)*sqrt(a-x^2))),
  [a>0, c>0, c>a]], //GH236.19b
 [1/sqrt(a-x^2)/(c+x^2),
  -1/sqrt(-c)/sqrt(-c-a)*arctan((x*sqrt(-c-a))/
                              (sqrt(-c)*sqrt(a-x^2))),
  [a>0, c<0, -c>a]], //GH236.19b
 [1/sqrt(a-x^2)/(c+x^2),
  1/sqrt(c)/sqrt(a+c)*arctan((x*sqrt(a+c))/(sqrt(c)*sqrt(a-x^2))),
  [a>0, c>0]], //GH236.20

 [1/((x+b)*sqrt(x^2+a)),
  // -1/sqrt(-a-b^2)*arcsin(((-b*x+a)/(sqrt(-a)*x+sqrt(-a)*b))),
  // [a<0, x>0], //K124
  1/sqrt(b^2+a)*(ln(b+x)-ln(a-b*x+sqrt(b^2+a)*sqrt(x^2+a)))],
 [1/(x*sqrt(x^2-a)),
  -arcsin(sqrt(a)/x)/sqrt(a),
  [a>0, x>0]], //K124
 [1/(x*sqrt(x^2+a)),
  -arcsin(sqrt(-a)/x)/sqrt(-a),
  [a<0, x>0]], //K124
 
 [1/(x*sqrt(x^a+b)),
  2/a/(-b)^(1/2)*arctan(1/(-b)^(1/2)*(b + x^a)^(1/2))], // 30

/// This pattern breaks an ode example (although the result is correct): 
// [1/(sqrt(a*x+b)*sqrt(c*x+d)),
//  ln(b*c+a*d+2*a*c*x+2*sqrt(a)*sqrt(c)*sqrt(a*x+b)*sqrt(c*x+d))/(sqrt(a)*sqrt(c))],

/// Use this one instead:
 [1/(sqrt(a*x+b)*sqrt(c*x+d)),
  -4*arctan(c/(-a*c)^(1/2)*((b + a*x)^(1/2) - b^(1/2))/
    ((d + c*x)^(1/2) - d^(1/2)))/(-a*c)^(1/2)],
 
 [1/(x*sqrt(a*x^2+c)),
  -1/sqrt(c)*ln((sqrt(c)+sqrt(a*x^2+c))/x),
  [a>0]], // GH 233.14a
 [1/(x*sqrt(a*x^2+c)),
  -1/sqrt(-c)*arcsin(sqrt(-c/a)*1/abs(x)),
  [a<0, abs(x)>=sqrt(-c/a)]], // GH 233.14b
 
 [1/(x*sqrt(a+b*x+c*x^2)),
  -1/sqrt(a)*ln(b/2+a/x+sqrt(a)/x*sqrt(a+b*x+c*x^2))], //K125

 [1/((x^2+a)*sqrt(b*x^2+c)),
  arctan(sqrt(c-a*b)*x/(sqrt(a)*sqrt(b*x^2+c)))/(sqrt(a)*sqrt(c-a*b))], 
 [1/((x^2+a)*sqrt(b*x^2+c)),
  1/(a*sqrt(c-a*b))*(arctan(sqrt(a)/x)+
                     arctan(sqrt(a)*b*x/
                            (c-sqrt(c-a*b)*sqrt(b*x^2+c)))),
  [a>0, a*b<c]], // GH 233.16b
 [1/((x^2+a)*sqrt(b*x^2+c)),
  1/a*x/sqrt(b*x^2+c),
  [a>0, a*b=c]], // GH 233.16c
 
 [(1/sqrt(x^2 - 1))/(1 + x^2),
  arctanh(sqrt(2)*x/sqrt(x^2-1))/sqrt(2)],
 
 [sqrt(x)/(1+sqrt(x)),x-2*sqrt(x)+2*ln(1+sqrt(x))], //K127
 [sqrt(x)/(1-sqrt(x)),-x-2*sqrt(x)-2*ln(1-sqrt(x))], //K129
 [1/(sqrt(x+a)-sqrt(x-a)),((x+a)^(3/2)+(x-a)^(3/2))/3/a],//K130
 [1/(sqrt(x+a)-sqrt(x-b)),((x+a)^(3/2)+(x-a)^(3/2))/3/a, [a=b]],//K130
 [1/sqrt(1+exp(x)), ln((sqrt(1+exp(x))-1)/((sqrt(1+exp(x))+1)))], //K147
 [1/(a^x+a^(-x)),arctan(a^x)/ln(a)], //K149
 
 [sin(x)/(c*sin(x)^2+d*cos(x)^2+e)^(3/2),
  -cos(x)/(c+e)/sqrt((d-c)*cos(x)^2+c+e)],
 [cos(x)/(c*sin(x)^2+d*cos(x)^2+e)^(3/2),
  (1-cos(x)^2)/(d+e)/sin(x)/sqrt((d-c)*cos(x)^2+c+e)],
 
 // GR 2.584
 [1/sqrt(1+a*sin(x)^2),
  ellipticF(x,-a)], // by definition
 [sin(x)/sqrt(1+a*sin(x)^2),
  -1/sqrt(-a)*ln(sqrt(-a)*cos(x)+sqrt(1+a*sin(x)^2))],
 [cos(x)/sqrt(1+a*sin(x)^2),
  1/sqrt(-a)*arcsin(sqrt(-a)*sin(x))],
 [sin(x)^2/sqrt(1+a*sin(x)^2),
  (ellipticE(x, -a)-ellipticF(x, -a))/a],
 [cos(x)^2/sqrt(1+a*sin(x)^2),
  (1+a)/a*ellipticF(x, -a)-1/a*ellipticE(x, -a)],

 [sqrt(a+b*sin(x)),
  -2 * ellipticE((PI/2-x)/2, 2*b/(a+b)) * sqrt(a+b*sin(x))/
      sqrt((a+b*sin(x))/(a+b))], 
 [1/sqrt(a+b*sin(x)),
  -2*ellipticF((PI-2*x)/4, 2*b/(a+b))*sqrt((a+b*sin(x))/(a+b))/
    sqrt(a+b*sin(x))], 
  
 [sqrt(sin(x)^2),
  -sin(2*x)/(2*sqrt(sin(x)^2))],
 [sqrt(sin(x)^2-cos(x)^2+1),
  -sin(2*x)/(sqrt(2*sin(x)^2))],
 
 // GR 2.578
 [tan(x)/sqrt(a+b*tan(x)^2),
  1/sqrt(b-a)*arccos(sqrt(b-a)/sqrt(b)*cos(x)),
  [b>a, b>0]],

 [1/ln(x), Li(x)], // pattern, to get more complete results for ln(x)^a etc. 
 [1/ln(x)^2, Li(x) - x/ln(x)], // pattern, to get more complete results for ln(x)^a etc. 
 [x/ln(x)^3, 2*Ei(2*ln(x)) - x^2/ln(x)^2*(ln(x) + 1/2)],
 [ln(x)/sqrt(a*x+b),
  2/a*(b + a*x)^(1/2)*(ln(x) - 2) +
  2/a*b^(1/2)*ln(((b + a*x)^(1/2) + b^(1/2))/
                 ((b + a*x)^(1/2) - b^(1/2))),
  [bl(not iszero(a))]], // GH322.5a, conds simplified
 [ln(a+b*x)/(a-b*x), 
  -(ln(a+b*x)*ln(1-(a+b*x)/2/a)+polylog(2,(a+b*x)/2/a))/b], 
 [ln(a+b*exp(c*x)),
  -c*x^2/2+x*ln(a+b*exp(c*x))
  +c*x^2/2-x*ln(1+b/a*exp(c*x))-polylog(2,-b/a*exp(c*x))/c], 
 [ln(x)/(x+a)^n,
  bl(-1/(n-1)*ln(x)/(x+a)^(n-1)+(-1)^(n-1)/((n-1)*(-a)^(n-1))*
    (ln(x/(x+a))+sum::sum_fn(v -> (a/(a+x))^v/v, 1..n-2))),
  [bl(testtype(n, DOM_INT)), n > 1, a <> 0]], // GH322.6b
 [ln(x)/(x+a), ln(x)*ln((a+x)/a)+polylog(2, -x/a)], // GH322.6c
 [ln(x)/(x^2+a^2),
  ln(x)/a*arctan(x/a)+I/(2*a)*(polylog(2, I*x/a)-polylog(2, -I*x/a))], // GH322.9
 [ln(x)/(x^2-a^2),
  ln(x)/(I*a)*arctan(x/(I*a))+1/(2*a)*(polylog(2, x/a)-polylog(2, -x/a))], // GH322.9
 [ln(x)/(x^2+a),
  ln(x)/sqrt(a)*arctan(x/sqrt(a))+I/(2*sqrt(a))*(polylog(2, I*x/sqrt(a))-polylog(2, -I*x/sqrt(a)))], // GH322.9

 [ln(x)/x^a,-(ln(x)+1/(a-1))/(a-1)/x^(a-1), [a <> 1]], //K168
 [(ln(x)^2+1)*x, x^2/2*(ln(x)^2-ln(x)+3/2)], //K173
 [sqrt(ln(x)),
  x*sqrt(ln(x))+1/2*sqrt(PI)*I*erf(I*sqrt(ln(x)))],
 [ln(a+b*x)*ln(a-b*x),
  (x*ln(a+b*x)-(b*x-ln(a+b*x)*a)/b)*ln(a-b*x)-1/b*(a+b*x)*ln(a+b*x)+
  2/b*a+2*x-2/b*a*dilog(-1/2*(-a+b*x)/a)-
  2/b*a*ln(a+b*x)*ln(-1/2*(-a+b*x)/a)+1/b*a*ln(-a+b*x)],
  
 [1/cot(x)^m,
  bl(sin(x)/((m-1)*cos(x)^(m-1))+(m-2)/(m-1)*int(1/cos(x^(m-2)),x)),
  [bl(testtype(m, DOM_INT)), m > 1]], //K329
 [1/sqrt(a*x+b)/x^2, 
  - sqrt(a*x+b)/(b*x) 
  - a/(2*b)/sqrt(b)*ln((sqrt(a*x+b)-sqrt(b))/((sqrt(a*x+b)+sqrt(b)))),
  [b>0]], //B129a
 [1/sqrt(a*x+b)/x^2, 
  - sqrt(a*x+b)/(b*x) - a/(b*sqrt(-b))*arctan(sqrt((a*x+b)/(-b))),
  [b<0]], //B129b
 [sqrt(a*x+b)/x^2, 
  - sqrt(a*x+b)/x 
  + a/2/sqrt(b)*ln((sqrt(a*x+b)-sqrt(b))/((sqrt(a*x+b)+sqrt(b)))),
  [b>0]], //B130a
 [sqrt(a*x+b)/x^2, 
  - sqrt(a*x+b)/x 
  + a/sqrt(-b)*arctan(sqrt((a*x+b)/(-b))),
  [b<0]], //B130b
 [1/(x^n*sqrt(a*x+b)), 
  bl(-sqrt(a*x+b)/((n-1)*b*x^(n-1))
     -(2*n-3)*a/(2*n-2)/b*int(1/(x^(n-1)*sqrt(a*x+b)),x)), 
  [bl(testtype(n, DOM_INT)), n>1]], //B131
////// WRONG
//// [sqrt((a*x+b)^3)/x,
////  2/3*sqrt((a*x+b)^3) + 2*b*sqrt(a*x+b)
////  + b^2/sqrt(b)*ln((sqrt(a*x+b)-sqrt(b))/((sqrt(a*x+b)+sqrt(b)))),
////  [b>0]], //B135a
//// [sqrt((a*x+b)^3)/x,
////  2/3*sqrt((a*x+b)^3) + 2*b*sqrt(a*x+b)
////  + b^2/sqrt(-b)*arctan(sqrt((a*x+b)/(-b))),
////  [b<0]], //B135b
//// [1/x/sqrt((a*x+b)^3),
////  2/(b*sqrt(a*x+b)) 
////  + ln((sqrt(a*x+b)-sqrt(b))/((sqrt(a*x+b)+sqrt(b))))/sqrt(b)/b,
////  [b>0]], //B138a
//// [1/x/sqrt((a*x+b)^3),
////  2/(b*sqrt(a*x+b))
////  + 2*arctan(sqrt((a*x+b)/(-b)))/b/sqrt(-b),
////  [b<0]], //B138b
//// [1/x^2/sqrt((a*x+b)^3),
////  - 1/(x*b*sqrt(a*x+b)) - 3*a/(b^2*sqrt(a*x+b)) 
////  - 3*a/(2*b^2)*ln((sqrt(a*x+b)-sqrt(b))
////                   /((sqrt(a*x+b)+sqrt(b))))/sqrt(b),
////  [b>0]], //B139a
//// [1/x^2/sqrt((a*x+b)^3),
////  - 1/(x*b*sqrt(a*x+b)) - 3*a/(b^2*sqrt(a*x+b)) 
////  - 3*a/b^2*arctan(sqrt((a*x+b)/(-b)))/sqrt(-b),
////  [b<0]], //B139b
 [x*(a*x+b)^p, 
  2/a^2*((b+a*x)^(2+p)/(4+2*p) - b*(b+a*x)^(p+1)/(2*p+2)), [p<>-1, p<>-2]], //B141, extended
 [x^2*(a*x+b)^p,
  2/a^3*(b+a*x)^(p+1)/(88*p+48*p^2+8*p^3+48)
  *(8*a^2*x^2+8*b^2+4*a^2*p^2*x^2+12*a^2*p*x^2-8*a*b*x-8*a*b*p*x), [p<>-1, p<>-2, p<>-3]], //B142, extended
 [(a*x+b)^c/x,
  bl(2*(a*x+b)^c/(2*c)+b*int((a*x+b)^(c-1)/x,x)),
  [bl(testtype(2*c, DOM_INT)), c>0, c<>1]], //B143
 [1/(a*x+b)^(n/2)/x, 
  bl(2/(n-2)/b/(a*x+b)^((n-2)/2)
     +1/b*int(1/(a*x+b)^((n-2)/2)/x,x)), [bl(testtype(n, DOM_INT)), n>1]], //B144
 [1/(a*x+b)^(n/2)/x^2, 
  bl(1/x/b/(a*x+b)^((n-2)/2)
     -n*a/2/b*int(1/(a*x+b)^(n/2)/x,x)), [bl(testtype(n, DOM_INT)), n>1]], //B145
////// WRONG
//// [1/sqrt((a*x+b)*(d*x+e)),
////  2*sign(a)*sign(a*x+b)/sqrt(-a*d)*arctan(sqrt(-d*(a*x+b)/a/(d*x+e))),
////  [a*d < 0, a in R_, b in R_, d in R_, e in R_]], // B146
//// [1/sqrt((a*x+b)*(d*x+e)),
////  2*sign(a)*sign(a*x+b)/sqrt(a*d)*arctanh(sqrt(d*(a*x+b)/a/(d*x+e))),
////  [a*d>0, a in R_, b in R_, d in R_, e in R_, abs(d*(a*x+b)) < abs(a*(d*x+e))]], // B146
 [x/sqrt((a*x+b)*(d*x+e)),
  sqrt((a*x+b)*(d*x+e))/(a*d) 
  - (a*e+b*d)/(2*a*d)*arccosh(1/a/d*(a*e + b*d + 2*a*d*x)
                              /sqrt(1/a^2/d^2*(a*e - b*d)^2))/sqrt(a*d),
  [bl(not (iszero(b) and iszero(e))), a>0, d>0]], //B147
 [1/sqrt((a*x+b)*(d*x+e)^3),
  2/sqrt((b+a*x)*(e+d*x)^3)*(b+a*x)*(e+d*x)/(a*e-b*d),
  [bl(not iszero(a) and
      not iszero(d)),
   bl(not (iszero(b) and iszero(e)))]], //B148
 /* definitely incorrect, cf. 
  * diff(int(sqrt(x/(1-x)), x), x) - sqrt(x/(1-x)) | x=2 <> 0
 [sqrt((d*x+e)/(a*x+b)), 
  sign(a*x+b)*(sqrt((a*x+b)*(d*x+e))/a-(b*d-a*e)
               /(2*a)*arccosh(1/a/d*(a*e + b*d + 2*a*d*x)
                              /sqrt(1/a^2/d^2*(a*e - b*d)^2))/sqrt(a*d)),
  [bl(not(iszero(e) and iszero(b)))]], //B151
  */
 [sqrt(a*x+b)/(d*x+e),
  2*sqrt(a*x+b)/d 
  + (b*d-a*e)/d*2/sqrt((a*e-b*d)*d)
  *arctan(d*sqrt(a*x+b)/sqrt((a*e-b*d)*d)),
  [(b*d-a*e)*d < 0,
   bl(not(iszero(e) and iszero(b)))]], //B152a
 [sqrt(a*x+b)/(d*x+e),
  2*sqrt(a*x+b)/d + (b*d-a*e)/d
  *ln((d*sqrt(a*x+b)-sqrt(d*(b*d-a*e)))
      /(d*sqrt(a*x+b)+sqrt(d*(b*d-a*e))))
  /sqrt((b*d-a*e)*d),
  [(b*d-a*e)*d > 0,
   bl(not(iszero(e) and iszero(b)))]], //B152b
 [(d*x+e)^n/sqrt(a*x+b),
  bl(2/(2*n+1)/a*(sqrt(a*x+b)*(d*x+e)^n
                  -n*(b*d-a*e)*int((d*x+e)^(n-1)/sqrt(a*x+b),x))),
  [bl(testtype(n, DOM_INT)), n>1, bl(not(iszero(e) and iszero(b)))]], //B153
  [(d*x+e)/sqrt(a*x+b),
   2/a^2*(1/3*d*(a*x+b)^(3/2)-d*b*sqrt(a*x+b)+e*a*sqrt(a*x+b)),
   [bl(not (iszero(b) and iszero(e)))]],
  [1/((d*x+e)^n*sqrt(a*x+b)),
  bl(1/(n-1)/(b*d-a*e)*(sqrt(a*x+b)/(d*x+e)^(n-1)
                        +(n-3/2)*a*int(1/((d*x+e)^(n-1)*sqrt(a*x+b)),x))),
   [bl(testtype(n, DOM_INT)), n>1, bl(not(iszero(e) and iszero(b)))]], //B154
 [(d*x+e)^n*sqrt(a*x+b),
  bl(1/(2*n+3)/d*(2*sqrt(a*x+b)*(d*x+e)^(n+1)
                  +(b*d-a*e)*int((d*x+e)^n/sqrt(a*x+b),x))),
  [bl(testtype(n, DOM_INT)), n>1, bl(not(iszero(e) and iszero(b)))]], //B155
 [sqrt(a*x+b)/(d*x+e)^n,
  bl(1/(n-1)/d*(-sqrt(a*x+b)/(d*x+e)^(n-1)
                +a/2*int(1/(d*x+e)^(n-1)/sqrt(a*x+b),x))),
  [bl(testtype(n, DOM_INT)), n>1, bl(not(iszero(e) and iszero(b)))]], //B156
 
 [1/sqrt(a*x+b)/(c*x+d),
  1/c/sqrt(b-a*d/c)*ln((sqrt(a*x+b)-sqrt(b-a*d/c))/
                       (sqrt(a*x+b)+sqrt(b-a*d/c))),
  [b-a*d/c>0,
   bl(not (iszero(b) and iszero(d)))]], // GH212.9a
 [1/sqrt(a*x+b)/(c*x+d),
  -2/c/sqrt(a*d/c-b)*arctan(sqrt((a*d/c-b)/(a*x+b))),
  [b-a*d/c<0,
   bl(not (iszero(b) and iszero(d)))]], // GH212.9b
 [1/sqrt(x-1)/x,
  2*arctan(sqrt(x-1))], // Spezialfall in schoenerer Form
 [1/sqrt(a*x+b)/(c*x+d),
  -2/c/sqrt(a)*1/sqrt(x+d/c),
  [b-a*d/c=0,
   bl(not (iszero(b) and iszero(d)))]], // GH212.9c
 
 [(t+u*sqrt(x))/(v+w*sqrt(x)),
  u/w*x+2*(t*w-u*v)/(w^2)*(sqrt(x)
			   -v/w*ln(sqrt(x)+v/w)),
  [bl(not iszero(v)), bl(not iszero(u))]], // GH212.19
 [1/(v+w*sqrt(x)),
  2/w*(sqrt(x)
       -v/w*ln(sqrt(x)+v/w)),
  [bl(not iszero(v))]], // GH212.19, u=0, t=1
 
 [sqrt(a-x^2), (x*sqrt(a-x^2) + a*arcsin(x/sqrt(a)))/2,
  [bl(not iszero(a)), a>=0]], //B157,K76
////// Wrong
//// [x^2*sqrt(a-x^2),
////  -x*sqrt((a-x^2)^3)/4 
////  + a/8*(x*sqrt(a-x^2)+a*arcsin(x/sqrt(a))), 
////  [bl(not iszero(a)), a>=0]], //B159, K79
 [1/(a^2-x^2)^(1/2), arcsin(x/abs(a)), 
  [bl(not iszero(a)), a in R_]], //K84, B164b
 [sqrt(-x^2+a)/x, -sqrt(a)*ln((sqrt(a)+sqrt(a-x^2))/x)+sqrt(-x^2+a),
  [bl(not iszero(a)), a>0]], //B161, K99
 [sqrt(a-x^2)/x^2, -sqrt(a-x^2)/x - arcsin(x/sqrt(a)), [a>=0]], //B162
 [sqrt(-x^2+a)/x^3, (1/sqrt(a)*ln((sqrt(a)+sqrt(a-x^2))/x)-sqrt(-x^2+a)/x^2)/2,
  [bl(not iszero(a)), a>0]], //B163, K101
 [1/x^3/sqrt(a-x^2),
  - sqrt(a-x^2)/(2*a*x^2) 
  - ln((sqrt(a)+sqrt(a-x^2))/x)/(2*a^(3/2)),
  [bl(not iszero(a)), a>=0]], //B170
////// WRONG
//// [sqrt((a-x^2)^3),
////  (x*sqrt((a-x^2)^3) +  3*a*x*sqrt(a-x^2)/2 
////   + 3*a^2*arcsin(x/sqrt(a))/2)/4, [bl(not iszero(a)), a>=0]], // B171
//// [x^2*sqrt((a-x^2)^3),
////  - x*sqrt((a-x^2)^5)/6 + a*x*sqrt((a-x^2)^3)/24
////  + a^2*x*sqrt(a-x^2)/16 + a^3*arcsin(x/sqrt(a))/16,
////  [bl(not iszero(a)), a>=0]], //B173
//// [sqrt((a-x^2)^3)/x,
////  sqrt((a-x^2)^3)/3 + a*sqrt(a-x^2) 
////  - a^(3/2)*ln((sqrt(a)+sqrt(a-x^2))/x),
////  [bl(not iszero(a)), a>=0]], //B175
//// [sqrt((a-x^2)^3)/x^2,
////  - sqrt((a-x^2)^3)/x - 3/2*x*sqrt(a-x^2) 
////  - 3/2*a*arcsin((x/sqrt(a))), [bl(not iszero(a)), a>=0]], //B176
//// [sqrt((a-x^2)^3)/x^3,
////  - sqrt((a-x^2)^3)/(2*x^2) - 3/2*sqrt(a-x^2) 
////  + 3/2*sqrt(a)*ln((sqrt(a)+sqrt(a-x^2))/x),
////  [bl(not iszero(a)), a>=0]], //B177
//// [x^2/sqrt((a-x^2)^3), x/sqrt(a-x^2) - arcsin(x/sqrt(a)),
////  [bl(not iszero(a)), a>=0]], //B180
//// [1/sqrt((a-x^2)^3)/x, 
////  1/(a*sqrt(a-x^2)) - ln((sqrt(a)+sqrt(a-x^2))/x)/a^(3/2),
////  [bl(not iszero(a)), a>=0]], //B182
//// [1/sqrt((a-x^2)^3)/x^3,
////  -1/(2*a*x^2*sqrt(a-x^2)) +3/(2*a^2*sqrt(a-x^2))
////  - 3/(2*a^(5/2))*ln((sqrt(a)+sqrt(a-x^2))/x),
////  [bl(not iszero(a)), a>=0]], //B184
 [1/sqrt((a+x^2))/x^3,
  - sqrt(a+x^2)/(2*a*x^2) 
  + ln(((sqrt(a)+sqrt(a+x^2))/x))/(2*a^(3/2)),
  [bl(not iszero(a)), a>=0]], //B198
 [sqrt((a+x^2)^3),
  (x*sqrt((x^2+a)^3) + (3*a*x*sqrt(a+x^2) 
			+ 3*a^2*ln(x+sqrt(a+x^2)))/2)/4,
  [bl(not iszero(a)), a>=0]], //B199
 [x^2*sqrt((a+x^2)^3), 
  x*sqrt((a+x^2)^5)/6 - a*x*sqrt((a+x^2)^3)/24 
  - a^2*x*sqrt(a+x^2)/16 - a^3*ln(x+sqrt(a+x^2))/16,
  [bl(not iszero(a)), a>=0]], //B201
 [sqrt((a+x^2)^3)/x,
  sqrt((a+x^2)^3)/3 + a*sqrt(a+x^2) 
  - a^(3/2)*ln((sqrt(a)+sqrt(a+x^2))/x),
  [bl(not iszero(a)), a>=0]], //B203
////// WRONG
//// [sqrt((a+x^2)^3)/x^2,
////  - sqrt((a+x^2)^3)/x + 3/2*x*sqrt(a+x^2) 
////  - 3/2*a*ln(x+sqrt(a+x^2)), [bl(not iszero(a)), a>=0]], //B204
 [sqrt((a+x^2)^3)/x^3,
  - sqrt((a+x^2)^3)/(2*x^2) + 3/2*sqrt(a+x^2) 
  - 3/2*sqrt(a)*ln((sqrt(a)+sqrt(a+x^2))/x),
  [bl(not iszero(a)), a>=0]], //B205
 [x^2/sqrt((a+x^2)^3),
  -x/sqrt(a+x^2) +ln(x+sqrt(a+x^2)),
  [bl(not iszero(a)), a>=0]], //B208
 [1/sqrt((a+x^2)^3)/x,
  1/(a*sqrt(a+x^2)) 
  - ln((sqrt(a)+sqrt(a+x^2))/x)/a^(3/2),
  [bl(not iszero(a)), a>=0]], //B210
 [1/sqrt((a+x^2)^3)/x^3,
  -1/(2*a*x^2*sqrt(a+x^2)) - 3/(2*a^2*sqrt(a+x^2)) 
  + 3/(2*a^(5/2))*ln((sqrt(a)+sqrt(a+x^2))/x),
  [bl(not iszero(a)), a>=0]], //B212
////// WRONG
//// [sqrt((x^2-a))/x,
////  sqrt(x^2-a)-sqrt(a)*arccos(sqrt(a)/x), [bl(not iszero(a)), a>0]], //B217
//// [sqrt(x^2-a)/x^3,
////  -sqrt(x^2-a)/(2*x^2) + arccos(sqrt(a)/x)/2/sqrt(a),
////  [bl(not iszero(a)), a>0]], //B219
//// [1/sqrt(x^2-a)/x^3,
////  sqrt(x^2-a)/(2*a*x^2) + arccos(sqrt(a)/x)/2/a^(3/2),
////  [bl(not iszero(a)), a>0]], //B226
//// [sqrt((x^2-a)^3),
////  (x*sqrt((x^2-a)^3) - 3*a*x/2*sqrt(x^2-a) 
////   + 3*a^2/2*ln(x+sqrt(x^2-a)))/4,
////  [bl(not iszero(a)), a>=0]], //B227
//// [x^2*sqrt((x^2-a)^3),
////  x*sqrt((x^2-a)^5)/6 + a*x*sqrt((x^2-a)^3)/24
////  - a^2*x*sqrt(x^2-a)/16 + a^3/16*ln(x+sqrt(x^2-a)), 
////  [bl(not iszero(a)), a>=0]], //B229
//// [sqrt((x^2-a)^3)/x, 
////  sqrt((x^2-a)^3)/3-a*sqrt(x^2-a) + a^(3/2)*arccos(sqrt(a)/x), 
////  [bl(not iszero(a)), a>=0]], //B231
//// [sqrt((x^2-a)^3)/x^2,
////  - sqrt((x^2-a)^3)/2 + 3*x/2*sqrt(x^2-a) 
////  - 3/2*a*ln(x+sqrt(x^2-a)), [bl(not iszero(a)), a>0]], //B232
//// [sqrt((x^2-a)^3)/x^3,
////  - sqrt((x^2-a)^3)/(2*x^2) + 3/2*sqrt(x^2-a) 
////  - 3/2*sqrt(a)*arccos(sqrt(a)/x), [bl(not iszero(a)), a>0]], //B233
//// [x^2/sqrt((x^2-a)^3),
////  - x/sqrt(x^2-a) + ln(x+sqrt(x^2-a)), [bl(not iszero(a)), a>0]], //B236
//// [1/sqrt((x^2-a)^3)/x,
////  - 1/(a*sqrt(x^2-a)) - sign(x)/a^(3/2)*arccos(sqrt(a)/x),
////  [bl(not iszero(a)), a>0]], //B238
//// [1/sqrt((x^2-a)^3)/x^2,
////  - 1/a^2*(sqrt(x^2-a)/x + x/sqrt(x^2-a)), [bl(not iszero(a)), a>0]], //B239
//// [1/sqrt((x^2-a)^3)/x^3,
////  1/(2*a*x^2*sqrt(x^2-a)) - 3/(2*a^2*sqrt(x^2-a))
////  - 3/(2*a^(5/2))*arccos(sqrt(a)/x), [bl(not iszero(a)), a>0]], //B240
 [1/sqrt(a*x^2+b*x+c)/(a*x^2+b*x+c)^2,
  2*(b + 2*a*x)/(b^2 - 4*a*c)^2/(c + a*x^2 + b*x)^(3/2)
  *(8*a^2*x^2 + 12*a*c - b^2 + 8*a*b*x)/3,
  [bl(not iszero(a))]], //B243
////// WRONG
//// [(a*x^2+b*x+c)^2*sqrt(a*x^2+b*x+c),
////  (2*a*x+b)*sqrt(a*x^2+b*x+c)/(12*a)
////  *((a*x^2+b*x+c)^2 + 5*(a*x^2+b*x+c)/(4*(4*a/(4*a*c-b^2))) 
////    + 15/(8*(4*a/(4*a*c-b^2))^2) ) 
////  + 5/(16*(4*a/(4*a*c-b^2))^3)*(1/a^(1/2)
////                                *arccosh(1/a*(b + 2*a*x)/
////                                         (1/a^2*(b^2 - 4*a*c))^(1/2))),
////  [bl(not iszero(a))]], //B247
 [x/sqrt(a*x^2+b*x+c)/(a*x^2+b*x+c),
  2*(2*c+b*x)/((b^2-4*a*c)*sqrt(a*x^2+b*x+c)),
  [bl(not iszero(a))]], //B250
 [sqrt(a*x^2+b*x+c),
  (x/2+b/(4*a))*sqrt(a*x^2+b*x+c)+
   (a*c-b^2/4)/(2*a*sqrt(a))*
  ln((a*x+b/2)/sqrt(a)+sqrt(a*x^2+b*x+c)),
  [bl(not iszero(a))]], // GH231.4a
 [x*sqrt(a*x^2+b*x+c),
  sqrt(a*x^2+b*x+c)*(8*a*(c+a*x^2)+2*a*b*x-3*b^2)/(24*a^2) +
  3*(b^3-4*a*b*c)*ln((b+2*a*x)/sqrt(a)+
                     2*sqrt(a*x^2+b*x+c))/(48*a^(5/2)),
  [bl(not iszero(a))]], 
 [x^m*sqrt(a*x^2+b*x+c),
  bl(x^(m-1)/((m+2)*a)*(a*x^2+b*x+c)^(3/2) -
      (2*m+1)*b/((2*m+4)*a)*int(x^(m-1)*sqrt(a*x^2+b*x+c),x) -
      (m-1)*c/((m+2)*a)*int(x^(m-2)*sqrt(a*x^2+b*x+c), x)),
  [bl(testtype(m, DOM_INT)), m>1, bl(not iszero(a))]], // GH231.3
 [x*sqrt(a*x^2+b*x+c)*(a*x^2+b*x+c),
  (a*x^2+b*x+c)^2*sqrt(a*x^2+b*x+c)/(5*a) 
  - b/(2*a)*(1/4*x*(c + a*x^2 + b*x)^(3/2) 
             + 3/4*c*(ln(1/a^(1/2)*(1/2*b + a*x) 
                         + (c + a*x^2 + b*x)^(1/2))*(1/2/a^(1/2)*c 
                                                     - 1/8/a^(3/2)*b^2) + 1/4/a*(b + 2*a*x)*(c + a*x^2 + b*x)^(1/2)) 
             - 3/16/a*b^2*(ln(1/a^(1/2)*(1/2*b + a*x) 
                              + (c + a*x^2 + b*x)^(1/2))*(1/2/a^(1/2)*c - 1/8/a^(3/2)*b^2) 
                           + 1/4/a*(b + 2*a*x)*(c + a*x^2 + b*x)^(1/2)) 
             + 1/8/a*b*(c + a*x^2 + b*x)^(3/2)),
  [bl(not iszero(a))]], //B255
 [1/x^2/sqrt(a*x^2+b*x+c),
  -sqrt(a*x^2+b*x+c)/(c*x)-b/(2*c)*(-1/c^(1/2)
                                    *arctanh(1/c^(1/2)*(c + 1/2*b*x)/
                                             (c + a*x^2 + b*x)^(1/2))),
  [bl(not iszero(a))]], //B259
 [1/x^2/sqrt(a*x^2+c),
  -sqrt(a*x^2+c)/(c*x),
  [bl(not iszero(a))]], //B259
 [sqrt(a*x^2+b*x+c),
  (x/2+b/(4*a))*sqrt(a*x^2+b*x+c)
   + (b^2/4-a*c)/(2*a*sqrt(-a))*arcsin((a*x+b/2)/sqrt(b^2/4-a*c)),
   [a<0, b in R_, c in R_]], // GH231.4b
 [sqrt(a*x^2+b*x+c),
  (x/2+b/(4*a))*sqrt(a*x^2+b*x+c)
   + (b^2/4-a*c)/(2*a*sqrt(-a))*arcsin((a*x+b/2)/sqrt(b^2/4-a*c)),
   [a in R_, b in R_, c > 0]], // GH231.4b
 [sqrt(a*x^2+b*x+c)/x,
  sqrt(a*x^2+b*x+c)+b/2*1/a^(1/2)*arccosh(2*x/(1/a^2*b^2-4/a*c)^(1/2)
                                          + 1/a*b/(1/a^2*b^2 - 4/a*c)^(1/2)) + c*-1/c^(1/2)
  *arctanh(1/c^(1/2)*(c + 1/2*b*x)/(c + a*x^2 + b*x)^(1/2)),
  [bl(not iszero(a))]], //B260
 [sqrt(a*x^2+b*x+c)/x^2, -sqrt(a*x^2+b*x+c)/x 
  +a*(1/sqrt(a)
      *arccosh(2*x/sqrt(1/a^2*b^2-4/a*c)+b/a/sqrt(b^2/a^2-4/a*c))) 
  -b*(1/sqrt(c)*arctanh((c+b*x/2)/sqrt(c)/sqrt(c+a*x^2+b*x)))/2,
  [bl(not iszero(a))]], //B261
 [1/(sqrt(a*x-x^2)), sign(a)*arcsin(2*(x-a/2)/a), [a <> 0, a in R_]], //B264, corr
 [x/(sqrt(a*x-x^2)), abs(a)/2*arcsin(2*(x-a/2)/a)- sqrt(a*x-x^2),
  [a <> 0, a in R_]], //B265, corr
////// WRONG
//// [sqrt(a*x-x^2), (x-a/2)/2*sqrt(a*x-x^2)+2*a^2*arcsin(2*(x-a/2)/a),
////  [bl(not iszero(a))]], //B266
 [1/((a*x^2+b)*sqrt(d*x^2+e)),
  1/(sqrt(b*(a*e-b*d)))
  *arctan((x*sqrt(a*e-b*d))/(sqrt(b)*sqrt(d*x^2+e))), 
  [a*e-b*d>0, bl(not iszero(a)), bl(not iszero(d))]], //B267a
 [1/((a*x^2+b)*sqrt(d*x^2+e)), 1/(2*sqrt(b*(b*d-a*e)))
  *ln((sqrt(b*(d*x^2+e)) + x*sqrt(b*d-a*e))
      /((sqrt(b*(d*x^2+e)) - x*sqrt(b*d-a*e)))), 
  [a*e-b*d<0, bl(not iszero(a)), bl(not iszero(d))]], //B267b
 [sqrt(x)/sqrt(a-x^3), 2/3*arcsin(sqrt(x^3/a)), 
  [a>0, x>0]], //B272
 [1/(sqrt(x-1)+sqrt(x+1)),
  1/3*(x + 1)^(3/2) - 1/3*(x - 1)^(3/2)], // #628
 
////// WRONG
//// [1/(sqrt(x+1)*sqrt(x-1)*sqrt(x^2+x+1)),
////  -(sqrt(3*I+sqrt(3)+6*I/(x-1))*sqrt(I*(2/(x-1)))
////    *(3+sqrt(3)*I+6/(x-1))*(x-1)^(3/2)
////    *ellipticF(arcsin(sqrt(sqrt(3)-3*I-6*I/(x-1))/(sqrt(2)*3^(1/4))), 2))/
////    (3^(1/4)*sqrt(sqrt(3)-3*I-6*I/(x-1))*sqrt(x^2+x+1)*sqrt(x+1))], 

/* [1/(sqrt(a*x+b)*sqrt(c*x+d)*sqrt(e*x^2+f*x+g)),
  (sqrt(a*x+b)*sqrt((c/(a*d-b*c)+1/(a*x+b))/
                    (c/(a*d-b*c)+(2*b*e-a*f+sqrt(a^2*(f^2-d*e*g)))/
                                 (2*(b^2*e-a*b*f+a^2*g))))
   *sqrt((a*f+sqrt(a^2*(f^2-4*e*g))+2*b^2*e/(a*x+b)
          +2*a^2*g/(a*x+b)-2*b*(e+a*f/(a*x+b)))/
          sqrt(a^2*(f^2-4*e*g)))
   *(b*sqrt(a^2*(f^2-4*e*g))-a^2*(2*g+f*x)
     +a*(sqrt(a^2*(f^2-4*e*g))*x+b*(e*x+f)))
   *ellipticF(arcsin(sqrt((2*b*(a*f/(a*x+b)+e)-a*f
                          +sqrt(a^2*(f^2-d*e*g))
                          -2*b^2*e/(a*x+b)-2*a^2*g/(a*x+b))/
                          sqrt(a^2*(f^2-d*e*g)))/sqrt(2)),
              (2*(a*d-b*c)*sqrt(a^2*(f^2-4*e*g)))/
              (a^2*(2*c*g-d*f)-b*c*sqrt(a^2*(f^2-4*e*g))
               +a*(2*b*d*e-b*c*f+d*sqrt(a^2*(f^2-4*e*g))))))/
   (a*(b^2*e-a*b*f+a^2*g)*sqrt(c*x+d)*sqrt((e*x+f)*x+g)
    *sqrt((sqrt(a^2*(f^2-e*g))-a*f-2*b^2*e/(a*x+b)-2*a^2*g/(a*x+b)
          +2*b*(e+a*f/(a*x+b)))/sqrt(a^2*(f^2-4*e*g))))], 
*/
///////////////////////////////////////////////////////
// Integranden, die bei der Lsung 
// von DGLn bentigt werden:
 [cos(sqrt(x))/sqrt(x), 2*sin(sqrt(x))],
 [1/(x+1)^(3/2)/(x^(3/2)+x^(5/2)), 2/3/((x+1)^(3/2)*sqrt(x))
  +8/3/sqrt(x)/sqrt(x+1)-16/3*sqrt(x+1)/sqrt(x)],
 [1/sqrt(x)/(x-1)^2, -1/2/(sqrt(x)-1)-1/2*ln(sqrt(x)-1)
  -1/2/(sqrt(x)+1)+1/2*ln(sqrt(x)+1)],
 [sqrt(x*(x-1))/(2*x-1)^2,((x-1/2)^2-1/4)^(3/2)/(x-1/2)-(x-1/2)
  *sqrt((x-1/2)^2-1/4)+1/4*ln(x-1/2+sqrt((x-1/2)^2-1/4))],
 [x^(n-1)/exp(c*x^(2*n)),sqrt(PI)*erf(sqrt(c)*x^n)/n/sqrt(c)/2],
 [x^(n-1)*exp(c*x^(2*n)),sqrt(PI)*erf(sqrt(-c)*x^n)/n/sqrt(-c)/2],
 [(2*sin(x)-x*cos(x))/x^3, -sin(x)/x^2],
 [1/sqrt(x)/sqrt(x-1), ln(-1/2+x+sqrt(x)*sqrt(x-1))],
 [1/(sqrt(1+x^2)-1),-1/x-(1+x^2)^(3/2)/x+x*sqrt(1+x^2)+arcsinh(x)],
 [x*tan(x)/(x-tan(x)), -ln(x*cos(x)-sin(x))],
 [x/sqrt(x*(c-x)), -sqrt(-x^2+c*x)+c*arctan((x-c/2)/sqrt(-x^2+c*x))/2],
 [1/sqrt(x^3-c*x^(5/2)), 4*sqrt(x)*sqrt(-sqrt(x)*(c-sqrt(x)))
  *sqrt(x-c*sqrt(x))/sqrt(x^3-c*x^(5/2))/c,
  [bl(not iszero(c))]],
 [1/sqrt(exp(x)-c),2*arctan(sqrt(exp(x)-c)/sqrt(c))/sqrt(c),
  [bl(not iszero(c))]],
 
 [x/sqrt(c-x^4), arctan(x^2/sqrt(c-x^4))/2],
 [x/sqrt(x^4+a), ln(x^2+sqrt(x^4+a))/2],
 [x/sqrt(x^4+a), arcsinh(x^2/sqrt(a))/2, [a>0]],
 [exp(x^2)/x^2, I*sqrt(PI)*erfc(I*x) - exp(x^2)/x],
 [exp(a*x^2)^b, sqrt(PI)*erf(sqrt(-a*b)*x)/(2*sqrt(-a*b)), [a in R_ or b in Z_]],
 [exp(a*x^2+b*x+c),
  -I*exp(c-b^2/4/a)*erf(I*(b+2*a*x)/(2*sqrt(a)))*sqrt(PI)/(2*sqrt(a))],
 [exp(a*x^2)*exp(b*x+c),
  -I*exp(-b^2/4/a)*erf(I*(b+2*a*x)/(2*sqrt(a)))*sqrt(PI)/(2*sqrt(a))*exp(c)],
 [x*exp(a*x^2 + b*x),
  -1/4/(-a)^(5/2)*(2*(-a)^(3/2)*exp(x*(b + a*x)) 
  - PI^(1/2)*a*b*exp(-1/4/a*b^2)*erf(1/2/(-a)^(1/2)*(b + 2*a*x)))],
 [x^2*exp(a*x^2 + b*x),
  -1/8/(-a)^(7/2)*(2*(-a)^(3/2)*b*exp(x*(b + a*x)) 
  + 4*(-a)^(5/2)*x*exp(x*(b + a*x)) 
  + 2*PI^(1/2)*a^2*exp(-1/4/a*b^2)*erf(1/2/(-a)^(1/2)*(b + 2*a*x)) 
  - PI^(1/2)*a*b^2*exp(-1/4/a*b^2)*erf(1/2/(-a)^(1/2)*(b + 2*a*x)))],
 [x^3*exp(a*x^2 + b*x),
 -1/16/(-a)^(9/2)*(8*(-a)^(5/2)*exp(x*(b + a*x)) 
 + 2*(-a)^(3/2)*b^2*exp(x*(b + a*x)) + 8*(-a)^(7/2)*x^2*exp(x*(b + a*x)) 
 + 4*(-a)^(5/2)*b*x*exp(x*(b + a*x)) 
 + 6*PI^(1/2)*a^2*b*exp(-1/4/a*b^2)*erf(1/2/(-a)^(1/2)*(b + 2*a*x)) 
 - PI^(1/2)*a*b^3*exp(-1/4/a*b^2)*erf(1/2/(-a)^(1/2)*(b + 2*a*x)))],
 [x^a*(x^b)^c*exp(d*x^2),
  1/2*x^(a + 1)*(x^b)^c/(-d*x^2)^(1/2*a + 1/2*b*c + 1/2)*
  (gamma(1/2*a + 1/2*b*c + 1/2) 
  - igamma(1/2*a + 1/2*b*c + 1/2, -d*x^2))],
 [sqrt(x*exp(-x)),
  (sqrt(x/exp(x))*(-2*sqrt(x)+exp(x/2)
                   *sqrt(2*PI)*erf(sqrt(x/2))))/sqrt(x)],
 [exp(r*x)^s*(a*x+b)/(c*x+d),
  a/(s*r*c)*exp(s*r*x)
  -a*d/c^2*exp(-s*r*d/c)*Ei(s*r*x+s*r*d/c)
  +b/c*exp(-s*r*d/c)*Ei(s*r*x+s*r*d/c),
  [bl(not (iszero(r))), bl(not iszero(s)),
   bl(not iszero(a*d-b*c)),
   (r in R_) or (s in Z_)]],
///////////////////////////////////////////////////////
// Integranden, 
// die trigonometrische Ausdrcke enthalten:

// temp solution, needs to be done by Risch:
 [sin(a*ln(b*x+c)+d),
   (c + b*x)/(b*a^2 + b)*(sin(d + a*ln(c + b*x)) - a*cos(d + a*ln(c + b*x))),
   [b<>0, a^2<>-1]],
 [sin(a*ln(b*x+c)+d),
   a/I*1/4/b*exp(d*(-I))*(b^2*x^2*I - ln(1/b*(c + b*x))*exp(d*2*I)*2*I + b*c*x*2*I),
   [b<>0, a^2=-1]],

 [sin(a*x^2), sqrt(PI/2)/sqrt(a)*fresnelS(sqrt(a)*sqrt(2/PI)*x)],
 [sqrt(x)*sin(x),
  sqrt(PI/2)*fresnelC(sqrt(2/PI*x))-sqrt(x)*cos(x)], //M
 [sin(a*x)/sqrt(a*x),
  2^(1/2)*PI^(1/2)/a*fresnelS(2^(1/2)/PI^(1/2)*(a*x)^(1/2))],
 [x^2*sin(x^2), -x/2*cos(x^2)+1/2*sqrt(PI/2)*fresnelC(sqrt(2/PI)*x)], // GH 336.4c
 [sin(x+a)/x, Si(x)*cos(a)+Ci(x)*sin(a)],
 [sin(x)/x^2, Ci(x) - sin(x)/x], //B284
 [sin(x+a)/x^2, Ci(x)*cos(a)-Si(x)*sin(a)-sin(x+a)/x, [bl(not iszero(a))]],
 [arcsin(x)/x, arcsin(x)*ln(1-exp(2*I*arcsin(x)))
  -I/2*(arcsin(x)^2+polylog(2, exp(2*I*arcsin(x))))], 
 [sin(a*x^2+b*x+c),
  sqrt(PI/(2*a))
  *(cos((a*c-(b/2)^2)/a)*fresnelS(sqrt(2/(a*PI))*(a*x+b/2))
    + sin((a*c-(b/2)^2)/a)*fresnelC(sqrt(2/(a*PI))*(a*x+b/2)))], // GH 336.2a
 [sin(a*x)^2*sin(b*x)^2/x^2,
  (cos(2*a*x) + 2*a*x*Si(2*a*x))/(4*x) - 
    ((Si(x*(2*a + 2*b)) + cos(2*x*(a + b))/(2*x*(a + b)))*(2*a + 2*b))/8 - 
    1/(4*x) - ((Si(x*(2*a - 2*b)) + cos(2*a*x - 2*b*x)/(2*a*x - 2*b*x))*(2*a - 2*b))/8 + 
    (cos(2*b*x) + 2*b*x*Si(2*b*x))/(4*x)],
 [cos(a*x)^2*sin(b*x)^2/x^2,
  (a*Si(2*x*(a + b)))/4 + (b*Si(2*x*(a + b)))/4 - 
  (sin(x*(a + b))^2 + sin(x*(a - b))^2 + cos(2*a*x) - cos(2*b*x))/(4*x) - 
  (a*Si(2*a*x))/2 + (b*Si(2*b*x))/2 + (a*Si(2*x*(a - b)))/4 - 
  (b*Si(2*x*(a - b)))/4],
 [cos(a*x)^2*cos(b*x)^2/x^2,
  (b*Si(2*x*(a - b)))/4 - (b*Si(2*x*(a + b)))/4 - (a*Si(2*a*x))/2 - 
  (b*Si(2*b*x))/2 - (a*Si(2*x*(a - b)))/4 - (a*Si(2*x*(a + b)))/4 - 
  (cos(2*x*(a + b)) + 2*cos(2*a*x) + 2*cos(2*b*x) + 
  cos(2*x*(a - b)) + 2)/(8*x)],
 [cos(a*x^2), sqrt(PI/2)/sqrt(a)*fresnelC(sqrt(a)*sqrt(2/PI)*x)],
 [sqrt(x)*cos(x),
  sqrt(x)*sin(x)-sqrt(PI/2)*fresnelS(sqrt(2/PI*x))], //M
 [cos(a*x)/sqrt(a*x),
  2^(1/2)*PI^(1/2)/a*fresnelC(2^(1/2)/PI^(1/2)*(a*x)^(1/2))],
 [cos(x+a)/x, Ci(x)*cos(a)-Si(x)*sin(a)],
 [cos(x)/x^2, - Si(x) - cos(x)/x],  //B323
 [cos(x+a)/x^2, -Ci(x)*sin(a)-Si(x)*cos(a)-cos(x+a)/x, [bl(not iszero(a))]],
 [cos(a*x^2+b*x+c),
  sqrt(PI/(2*a))
  *(cos((a*c-(b/2)^2)/a)*fresnelC(sqrt(2/(a*PI))*(a*x+b/2))
    - sin((a*c-(b/2)^2)/a)*fresnelS(sqrt(2/(a*PI))*(a*x+b/2)))], // GH 336.3a
 [(sin(x)-x*cos(x))/x^2, -sin(x)/x],
 [y*x/sqrt(-x^4*y^2-2*x^2*y-1),
  1/2*ln(2*y*x^2 + 2)*(1+x^2*y)/sqrt(-(1+x^2*y)^2)],
 [sqrt(x*(b-x))/x, sqrt(x*(b-x)) - b/2*arcsin((b-2*x)/sqrt(b^2)),
  [bl(not iszero(b)), b in R_]],    
 [sin(x), -cos(x)],
 /*
 [sin(x)^n,
  bl(-(sin(x)^(n-1)*cos(x))/(n)
     +(n-1)/(n)*int(sin(x)^(n-2),x)), 
  [bl(testtype(n, DOM_INT)), n>1]], //B278
  */
 [sin(x)^n2,
  bl(binomial(n2, n2/2)/2^n2*x +
    (-1)^(n2/2)/2^(n2-1)*sum::sum_fn(k ->
      (-1)^k*binomial(n2, k)*sin((n2-2*k)*x)/(n2-2*k), 0..n2/2-1)),
    [n2>0, bl(testtype(n2, DOM_INT))]], // G2.513.1
 [sin(x)^n1,
  bl((-1)^((n1-1)/2+1)/2^(n1-1)*sum::sum_fn(k ->
    (-1)^k*binomial(n1,k)*cos((n1-2*k)*x)/(n1-2*k), 0..(n1-1)/2)),
    [n1>1, bl(testtype(n1, DOM_INT))]], // G2.513.2
 [sin(x)^n, -cos(x), [n=1]],
 [cos(x)^n2,
  bl(binomial(n2, n2/2)/2^n2*x +
    1/2^(n2-1)*sum::sum_fn(k ->
      binomial(n2, k)*sin((n2-2*k)*x)/(n2-2*k), 0..n2/2-1)),
    [n2>0, bl(testtype(n2, DOM_INT))]], // G2.513.3
 [cos(x)^n1,
  bl(1/2^(n1-1)*sum::sum_fn(k ->
    binomial(n1,k)*sin((n1-2*k)*x)/(n1-2*k), 0..(n1-1)/2)),
    [n1>1, bl(testtype(n1, DOM_INT))]], // G2.513.4
 [cos(x)^n, sin(x), [n=1]],
 [x^n*sin(x), bl(-x^n*cos(x)+n*int(x^(n-1)*cos(x),x)), 
  [bl(testtype(n, DOM_INT)), n>1]], //B282
 [sin(x)/x^n,
  bl(-sin(x)/x^(n-1)/(n-1)+1/(n-1)*int(cos(x)/x^(n-1),x)), 
  [bl(testtype(n, DOM_INT)), n>2]], //B285
 [1/sin(x), ln(tan(x/2))], //B286, K186
 [1/sin(x)^2, -cot(x)], // GH331.6d
 [1/sin(x)^3, 
  -cos(x)/(2*sin(x)^2)+ ln(tan(x/2))/2], //B288
 [1/sin(x)^n,
  bl(-cos(x)/(n-1)/sin(x)^(n-1)
     +(n-2)/(n-1)*int(1/sin(x)^(n-2),x)),
  [bl(testtype(n, DOM_INT)), n>1]], //B289
 [x/sin(a*x)^n,
  bl(-x*cos(a*x)/(n-1)/sin(x)^(n-1)
     -1/((n-1)*(n-2)*sin(x)^(n-2))
     +(n-2)/(n-1)*int(x/sin(x)^(n-2),x)),
  [bl(testtype(n, DOM_INT)), n>2]], //B292
 [x/sin(x),
  2*x*arctanh(-exp(I*x))
  +I*(polylog(2,-exp(I*x))-polylog(2,exp(I*x)))], //M, mod.
 [x/(1-sin(x)),
  x*cot(PI/4-x/2) + 2*ln(sin(PI/4-x/2))], //B296
 [x*cos(x)/(1+sin(x))^2, -x/(1+sin(x))+tan(x/2-PI/4)], // GR 2.647.7
////// WRONG
//// [x*cos(x)/(1-sin(x))^2, x/(1-sin(x))+tan(x/2+PI/4)], // GR 2.647.8
 [x*cos(x)/(1-sin(x))^2, x + (tan(1/2*x)*(2*x + 2) - 2)/(tan(1/2*x) - 1)^2],
 [1/(1+sin(x))^2,
  (4*sin(x)-sin(2*x)-4*cos(x)-cos(2*x)+3)/(6*(1+sin(x))^2)],
 [cos(x)*x^n,
  bl(x^n*sin(x)
     -n*int(sin(x)*x^(n-1),x)), 
  [bl(testtype(n, DOM_INT)), n>1]], //B321
 [cos(x)/x^n,
  bl(-cos(x)/(n-1)/x^(n-1)
     -1/(n-1)*int(sin(x)/x^(n-1),x)),
  [bl(testtype(n, DOM_INT)), n>2]], //B324
 [1/cos(x),ln(1/cos(x)+tan(x))], //B325, K187, L
 [1/cos(x)^3, 
  sin(x)/(2*cos(x)^2)+ ln(tan(PI/4+x/2))/2], //B327
 [1/cos(x)^n,
  bl(sin(x)/(n-1)/cos(x)^(n-1)
     +(n-2)/(n-1)*int(1/cos(x)^(n-2),x)),
  [bl(testtype(n, DOM_INT)), n>3]], //B328, GH331.9a
 [x/cos(x)^n,
   bl(x*sin(x)/(n-1)/cos(x)^(n-1)
      -1/(n-2)/(n-1)/cos(x)^(n-2)
      +(n-2)/(n-1)*int(x/cos(x)^(n-2),x)),
   [bl(testtype(n, DOM_INT)), n>2]], //B331
 [x/cos(x),
  2*x*arctanh(-I*exp(I*x))
  + I*(polylog(2, -I*exp(I*x))-polylog(2,I*exp(I*x)))],
 [x/(1+cos(a*x)), x/a*tan(a*x/2)+2/a^2*ln(cos(a*x/2))], //B334,K256
 [x/(1-cos(a*x)), -x/a*cot(a*x/2)+2/a^2*ln(sin(a*x/2))],//B335,K257

 [sin(x)^n2/x,
  binomial(n2, n2/2)*ln(x)/2^n2 +
  (-1)^(n2/2)/2^(n2-1)*sum::sum_fn(
    k -> (-1)^k*binomial(n2,k)*Ci((n2-2*k)*x), 0..n2/2-1),
  [bl(testtype(n2, DOM_INT))]], // GR2.642.1
 [sin(x)^n1/x,
  (-1)^((n1-1)/2)/2^(n1-1)*sum::sum_fn(
    k -> (-1)^k*binomial(n1, k)*Si((n1-2*k)*x), 0..(n1-1)/2),
  [n1 > 1, bl(testtype(n1, DOM_INT))]], // GR2.642.2
 [cos(x)^n2/x,
  binomial(n2, n2/2)*ln(x)/2^n2 +
  1/2^(n2-1)*sum::sum_fn(
    k -> binomial(n2,k)*Ci((n2-2*k)*x), 0..n2/2-1),
  [bl(testtype(n2, DOM_INT))]], // GR2.642.3
 [cos(x)^n1/x,
  1/2^(n1-1)*sum::sum_fn(
    k -> binomial(n1, k)*Ci((n1-2*k)*x), 0..(n1-1)/2),
  [n1 > 1, bl(testtype(n1, DOM_INT))]], // GR2.642.4
 [sin(x)^n2/x^2,
  -binomial(n2, n2/2)/(2^n2*x) + (-1)^(n2/2)/(2^(n2-1))*sum::sum_fn(
    k -> (-1)^(k+1)*binomial(n2, k)*
      (cos((n2-2*k)*x)/x + (n2-2*k)*Si((n2-2*k)*x)), 0..n2/2-1),
  [bl(testtype(n2, DOM_INT))]], // GR2.642.5
 [sin(x)^n1/x^2,
  (-1)^((n1-1)/2)/(2^(n1-1))*sum::sum_fn(k -> (-1)^(k+1)*binomial(n1, k)*
    (sin((n1-2*k)*x)/x - (n1-2*k)*Ci((n1 - 2*k)*x)), 0..(n1-1)/2),
  [n1 > 1, bl(testtype(n1, DOM_INT))]], // GR2.642.6
 [cos(x)^n2/x^2,
  -binomial(n2, n2/2)/(2^n2*x) - 1/(2^(n2-1))*sum::sum_fn(
    k -> binomial(n2, k)*
      (cos((n2-2*k)*x)/x + (n2-2*k)*Si((n2-2*k)*x)), 0..n2/2-1),
  [bl(testtype(n2, DOM_INT))]], // GR2.642.7
 [cos(x)^n1/x^2,
  -1/(2^(n1-1))*sum::sum_fn(k -> binomial(n1, k)*
    (cos((n1-2*k)*x)/x + (n1-2*k)*Si((n1 - 2*k)*x)), 0..(n1-1)/2),
  [n1 > 1, bl(testtype(n1, DOM_INT))]], // GR2.642.6

 [x*sin(x)/(1+cos(x))^2, x/(1+cos(x))-tan(x/2)], // GR 2.647.9
 [x*sin(x)/(1-cos(x))^2, -x/(1-cos(x))-cot(x/2)], // GR 2.647.10
 [x^2/(cos(x)-1), 
  x*(I*x+x*cot(x/2)-4*ln(1-exp(I*x)))+4*I*polylog(2, exp(I*x))],
 [cos(x)/(1-cos(x)), -x-cot(x/2)], //B337
 [(c+d*cos(x))/(a+b*cos(x)),
  d/b*x+(b*c-a*d)/b*
  1/sqrt(b^2-a^2)*ln((b+a*cos(x)+sqrt(b^2-a^2)*sin(x))/
                     (a+b*cos(x))),
  [bl(not iszero(d)), bl(not iszero(b)),
   bl(not(iszero(c) and iszero(a)))]], // GH331.17

 [(c+d*cos(x))/(a+b*cos(x)),
  d/b*x+(b*c-a*d)/b*
  2/sqrt(a^2-b^2)*arctan((sqrt(a^2-b^2)*tan(x/2))/(a+b)),
  [b^2<a^2, bl(not iszero(d), not iszero(b),
               not(iszero(c) and iszero(a)))]], // GH331.17d
 [(c+d*cos(x))/(a+b*cos(x)),
  d/b*x+(b*c-a*d)/b* tan(x/2)/a,
  [a=b, bl(not iszero(d), not iszero(b),
           not(iszero(c) and iszero(a)))]],
 [(c+d*cos(x))/(a+b*cos(x)),
  d/b*x-(b*c-a*d)/b* cot(x/2)/a,
  [a=-b, bl(not iszero(d), not iszero(b),
            not(iszero(c) and iszero(a)))]],

 [sin(a*x+b)*sin(c*x+d),
  sin((a-c)*x+b-d)/(2*(a-c))-sin((a+c)*x+b+d)/(2*(a+c)),
  [a<>c, a<>-c]], // GH332.3a
 [cos(a*x+b)*cos(c*x+d),
  sin((a-c)*x+b-d)/(2*(a-c))+sin((a+c)*x+b+d)/(2*(a+c)),
  [a<>c, a<>-c]], // GH332.3b
 [sin(a*x+b)*cos(c*x+d),
  -cos((a-c)*x+b-d)/(2*(a-c))-cos((a+c)*x+b+d)/(2*(a+c)),
  [a<>c, a<>-c]], // GH332.3c
 [sin(a*x+b)*sin(c*x+d),
  x/2*cos(b-d)-sin(2*a*x+b+d)/(4*a), [a=c]], // GH332.3d
 [sin(a*x+b)*sin(c*x+d),
  -x/2*cos(b+d)+sin(2*a*x+b-d)/(4*a), [a=-c]], // GH332.3d
 [cos(a*x+b)*cos(c*x+d),
  x/2*cos(b-d)+sin(2*a*x+b+d)/(4*a), [a=c]], // GH332.3e
 [cos(a*x+b)*cos(c*x+d),
  x/2*cos(b+d)+sin(2*a*x+b-d)/(4*a), [a=-c]], // GH332.3e
 [sin(a*x+b)*cos(c*x+d),
  x/2*sin(b-d)-cos(2*a*x+b+d)/(4*a), [a=c]], // GH332.3f
 [sin(a*x+b)*cos(c*x+d),
  x/2*sin(b+d)-cos(2*a*x+b-d)/(4*a), [a=-c]], // GH332.3f
 [sin(a*x+b)*sin(c*x+d)*sin(e*x+f),
  cos((a-c-e)*x+b-d-f)/(4*(a-c-e))
  - cos((a+c-e)*x+b+d-f)/(4*(a+c-e))
  - cos((a-c+e)*x+b-d+f)/(4*(a-c+e))
  + cos((a+c+e)*x+b+d+f)/(4*(a+c+e)),
  [a-c-e<>0, a+c-e<>0, a-c+e<>0, a+c+e<>0,
   bl(not iszero(a-c) and iszero(c-e))]], 
 [sin(a*x+b)*sin(c*x+d)*cos(e*x+f),
  sin((a-c-e)*x+b-d-f)/(4*(a-c-e))
  - sin((a+c-e)*x+b+d-f)/(4*(a+c-e))
  + sin((a-c+e)*x+b-d+f)/(4*(a-c+e))
  - sin((a+c+e)*x+b+d+f)/(4*(a+c+e)),
  [a-c-e<>0, a+c-e<>0, a-c+e<>0, a+c+e<>0,
   bl(not iszero(a-c) and iszero(c-e))]], 
 [sin(a*x+b)*cos(c*x+d)*cos(e*x+f),
  -1/4*(cos((a-c-e)*x+b-d-f)/(a-c-e)
        + cos((a+c-e)*x+b+d-f)/(a+c-e)
        + cos((a-c+e)*x+b-d+f)/(a-c+e)
        + cos((a+c+e)*x+b+d+f)/(a+c+e)),
  [a-c-e<>0, a+c-e<>0, a-c+e<>0, a+c+e<>0,
   bl(not iszero(a-c) and iszero(c-e))]], 
 [cos(a*x+b)*cos(c*x+d)*cos(e*x+f),
  sin((a-c-e)*x+b-d-f)/(4*(a-c-e))
  + sin((a+c-e)*x+b+d-f)/(4*(a+c-e))
  + sin((a-c+e)*x+b-d+f)/(4*(a-c+e))
  + sin((a+c+e)*x+b+d+f)/(4*(a+c+e)),
  [a-c-e<>0, a+c-e<>0, a-c+e<>0, a+c+e<>0,
   bl(not iszero(a-c) and iszero(c-e))]], 

/* buggy, cf. x^13*sin(x)
 [x^a*sin(b*x),
  I/2*(I*b)^(-a-1)*(gamma(I*b*x)-igamma(a-1,I*b*x))
              -I/2*(gamma(-I*b*x)-igamma(a-1,-I*b*x)),
  [Re(a)>-2, x>0]], // GR 2.632.1
 [x^a*sin(b*x),
  -1/(2*b^(a+1))*(exp(I*PI/2*a)*igamma(a+1, -I*b*x)
                 +exp(-PI*I/2*a)*igamma(a+1,I*b*x)),
  [Re(a)<0, b>0, x>0]], // GR 2.632.2
  */
  
 [exp(a*x)*sin(b*x)*cos(c*x),
  exp(a*x)/2*(((c-b)*cos((b-c)*x)+a*sin((b-c)*x))/(a^2+(b-c)^2)
              +(a*sin((b+c)*x)-(b+c)*cos((b+c)*x))/(a^2+(b+c)^2))], 

 [1/cos(x)/(1-cos(x)), 
  ln(tan(PI/4+x/2))-cot(x/2)], //B339, L
 [cos(x)/(b+c*cos(x)), 
  x/c-b/c*2/(sqrt(b^2-c^2))*arctan(((b-c)*tan(x/2))/(sqrt(b^2-c^2))),
  [b^2>c^2, bl(not iszero(b))]], //B348a
 [cos(x)/(b+c*cos(x)), 
  x/c-b/c*1/(sqrt(c^2-b^2))*ln(((c-b)*tan(x/2)+sqrt(c^2-b^2))
                               /((c-b)*tan(x/2)-sqrt(c^2-b^2))),
  [b^2<c^2, bl(not iszero(b))]], //B348b
 [1/cos(x)/(b+c*cos(x)),
  ln(tan(x/2+PI/4))/b 
  - c/b*2/(sqrt(b^2-c^2))*arctan(((b-c)*tan(x/2))/(sqrt(b^2-c^2))),
  [b^2>c^2, bl(not iszero(b))]], //B349a
 [1/cos(x)/(b+c*cos(x)),
  ln(tan(x/2+PI/4))/b 
  - c/b*1/(sqrt(c^2-b^2))*ln(((c-b)*tan(x/2)+sqrt(c^2-b^2))
                             /((c-b)*tan(x/2)-sqrt(c^2-b^2))),
  [b^2<c^2, bl(not iszero(b))]], //B349b
 [cos(x)/(b+c*cos(x))^2, 
  b*sin(x)/((b^2-c^2)*(b+c*cos(x))) 
  -c/(b^2-c^2)
  *2/(sqrt(b^2-c^2))*arctan(((b-c)*tan(x/2))/(sqrt(b^2-c^2))),
  [b^2>c^2, bl(not iszero(b))]], //B351a
 [cos(x)/(b+c*cos(x))^2, 
  b*sin(x)/((b^2-c^2)*(b+c*cos(x))) 
  -c/(b^2-c^2)
  *1/(sqrt(c^2-b^2))*ln(((c-b)*tan(x/2)+sqrt(c^2-b^2))
                        /((c-b)*tan(x/2)-sqrt(c^2-b^2))),
  [b^2<c^2, bl(not iszero(b))]], //B351b
 [sin(x)^n*cos(x)^m,
  bl(-sin(x)^(n-1)/(n+m)*cos(x)^(m+1)
     +(n-1)/(n+m)*int(sin(x)^(n-2)*cos(x)^m,x)),
  [bl(testtype(n, DOM_INT)), bl(testtype(m, DOM_INT)), m>1, n>1]], //B358
 [1/(sin(x)^2*cos(x)), ln(tan(PI/4+x/2))-1/sin(x)], //B360
 [1/(sin(x)*cos(x)^2), ln(tan(x/2))+1/cos(x)], //B361
 [1/(sin(x)^2*cos(x)^2), -2*cot(2*x)], //B364
 [1/(sin(x)^2*cos(x)^3),
  (sin(x)/(2*cos(x)^2) - 1/sin(x) 
   + 3/2*ln(tan(PI/4+x/2)))], //B365, L
 [1/(sin(x)^3*cos(x)^2),
  -cos(x)/(2*sin(x)^2) + 1/cos(x) 
  + 3/2*ln(tan(x/2))], //B366, L
 [1/sin(x)/cos(x)^n,
  bl(1/(n-1)/cos(x)^(n-1)+int(1/sin(x)/cos(x)^(n-2),x)),
  [bl(testtype(n, DOM_INT)), n<>1, n<>0]], //B367
 [1/sin(x)^n/cos(x),
  bl(-1/(n-1)/sin(x)^(n-1)+int(1/sin(x)^(n-2)/cos(x),x)),
  [bl(testtype(n, DOM_INT)), n<>1, n<>0]], //B368
 [1/sin(x)^n/cos(x)^m,
  bl(-1/(n-1)/sin(x)^(n-1)/cos(x)^(m-1)
     +(n+m-2)/(n-1)*int(1/sin(x)^(n-2)/cos(x)^m,x)),
  [bl(testtype(n, DOM_INT)), bl(testtype(m, DOM_INT)), n>1, m<>0]], //B369a
 [1/sin(x)^n/cos(x)^m,
  bl(1/(m-1)/sin(x)^(n-1)/cos(x)^(m-1)
     +(n+m-2)/(m-1)*int(1/sin(x)^n/cos(x)^(m-2),x)),
  [bl(testtype(n, DOM_INT)), bl(testtype(m, DOM_INT)), m>1, n<>0]], //B369b
 [sin(x)/cos(x)^n,
  1/((n-1)*cos(x)^(n-1)), [n>0]], //B372
 [sin(x)^2/cos(x),
  -sin(x) + ln(tan(PI/4+x/2))], //B373, L
 [sin(x)^2/cos(x)^3,
  (sin(x)/cos(x)^2 - ln(tan(PI/4+x/2)))/2], //B374
 [sin(x)^2/cos(x)^n, 
  bl(sin(x)/(n-1)/cos(x)^(n-1)-1/(n-1)*int(1/cos(x)^(n-2),x)),
  [bl(testtype(n, DOM_INT)), n<>1, n>0]], //B375
 [sin(x)^3/cos(x),
  -(sin(x)^2/2 + ln(cos(x)))], //B376
 [sin(x)^3/cos(x)^2,
  cos(x) + 1/cos(x)], //B377
 [sin(x)^3/cos(x)^n,
  1/((n-1)*cos(x)^(n-1))-1/((n-3)*cos(x)^(n-3)),
  [n <> 1, n <> 3, n <> 0]], //B378
 [sin(x)^n/cos(x), 
  bl(-sin(x)^(n-1)/(n-1)+int(sin(x)^(n-2)/cos(x),x)),
  [bl(testtype(n, DOM_INT)), n>1]], //B379
 [sin(x)^n/cos(x)^m, 
  bl(sin(x)^(n+1)/(m-1)/cos(x)^(m-1)
     -(n-m+2)/(m-1)*int(sin(x)^n/cos(x)^(m-2),x)),
  [bl(testtype(n, DOM_INT)), bl(testtype(m, DOM_INT)), m>1, n<>0]], //B380a
 [sin(x)^n/cos(x)^m, 
  bl(-sin(x)^(n-1)/(n-m)/cos(x)^(m-1)
     +(n-1)/(n-m)*int(sin(x)^(n-2)/cos(x)^m,x)),
  [bl(testtype(n, DOM_INT)), bl(testtype(m, DOM_INT)), m <> n]], //B380b
 [cos(x)^2/sin(x),
  (cos(x)+ln(tan(x/2)))], //B384
 [cos(x)^2/sin(x)^3,
  -(cos(x)/sin(x)^2+ln(tan(x/2)))/2], //B385
 [cos(x)^2/sin(x)^n, 
  bl(-1/(n-1)*(cos(x)/sin(x)^(n-1)+int(1/(sin(x)^(n-2)),x))),
  [bl(testtype(n, DOM_INT)), n<>1]], //B386
 [cos(x)^3/sin(x),
  (cos(x)^2/2+ln(sin(x)))], //B387
 [cos(x)^3/sin(x)^2,
  -(sin(x)+1/sin(x))], //B388
 [cos(x)^n/sin(x), 
  bl(cos(x)^(n-1)/(n-1)+int(cos(x)^(n-2)/(sin(x)),x)),
  [bl(testtype(n, DOM_INT)), n>1]], //B390
 [cos(x)^n/sin(x)^m, 
  bl(cos(x)^(n+1)/(m-1)/sin(x)^(m-1)-(n-m+2)/(m-1)
     *int(cos(x)^n/sin(x)^(m-2),x)),
  [bl(testtype(n, DOM_INT)), bl(testtype(m, DOM_INT)), m > 1, n>1]], //B391a
 [cos(x)^n/sin(x)^m,
  bl(cos(x)^(n-1)/(n-m)/sin(x)^(m-1)
     +(n-1)/(n-m)*int(cos(x)^(n-2)/sin(x)^m,x)),
  [bl(testtype(n, DOM_INT)), bl(testtype(m, DOM_INT)), m <> n, m>1, n>1]], //B391b
 [1/sin(x)/(1+cos(x)),
  (1/(cos(x)+1)+ln(tan(x/2)))/2], //B392a
 [1/sin(x)/(1-cos(x)),
  (-1/(-cos(x)+1)+ln(tan(x/2)))/2], //B392b
 [1/cos(x)/(1+sin(x)),
  (-1/(sin(x)+1)+ln(tan(PI/4+x/2)))/2], //B393a
 [1/cos(x)/(1-sin(x)),
  (1/(-sin(x)+1)+ln(tan(PI/4+x/2)))/2], //B393b
 [sin(x)/(sin(x)+cos(x)),
  x/2-(ln(sin(x)+cos(x)))/2], //B398a
 [sin(x)/(sin(x)-cos(x)),
  x/2+(ln(sin(x)-cos(x)))/2], //B398b
 [cos(x)/(sin(x)+cos(x)),
  x/2+(ln(sin(x)+cos(x)))/2], //B399a
 [cos(x)/(sin(x)-cos(x)),
  -x/2+(ln(sin(x)-cos(x)))/2], //B399b
 [tan(x)^n, bl(tan(x)^(n-1)/(n-1)-int(tan(x)^(n-2),x)), 
  [bl(testtype(n, DOM_INT)), n>3]], //B412
 [tan(x)^n/cos(x)^2,
  tan(x)^(n+1)/(n+1), [n <> -1]], //B415
 [1/(tan(x)+1),  x/2+ln(sin(x)+cos(x))/2], //B416a
 [1/(tan(x)-1), -x/2+ln(sin(x)-cos(x))/2], //B416b
 [tan(x)/(tan(x)+1), x/2-ln(sin(x)+cos(x))/2], //B417a
 [tan(x)/(tan(x)-1), x/2+ln(sin(x)-cos(x))/2], //B417b
 [sqrt(tan(x)), 
  (ln(sqrt(2*tan(x))-tan(x)-1)-ln(sqrt(2*tan(x))+tan(x)+1))/sqrt(8)
  + (arctan(sqrt(2*tan(x))+1)-arctan(1-sqrt(2*tan(x))))/sqrt(2)], 
 [cot(x), ln(sin(x))], //B418, K85 M
 [cot(x)^2, -cot(x)-x], //B419
 [cot(x)^3, -cot(x)^2/2-ln(sin(x))], //B420
 [cot(x)^n, 
  bl(-cot(x)^(n-1)/(n-1)-int(cot(x)^(n-2),x)),
  [bl(testtype(n, DOM_INT)), n>3]], //B421
 [cot(x)^n/sin(x)^2,
  -cot(x)^(n+1)/(n+1),
  [n <> 1]], //B424
 [1/(1+cot(x)), x/2-ln(sin(x)+cos(x))/2], //B425a
 [1/(1-cot(x)), x/2+ln(sin(x)-cos(x))/2], //B425b
 [sinh(x)^2, sinh(x)*cosh(x)/2-x/2], //B428
 [cosh(x)^2, sinh(x)*cosh(x)/2+x/2], //B429
 [sinh(x)^n, 
  bl(sinh(x)^(n-1)*cosh(x)/n-(n-1)/n*int(sinh(x)^(n-2),x)),
  [bl(testtype(n, DOM_INT)), n>0]], //B430a
 [sinh(x)^p, 
  bl(sinh(x)^(p+1)*cosh(x)/(p+1)
     -(p+2)/(p+1)*int(sinh(x)^(p+2),x)),
  [bl(testtype(float(p), DOM_FLOAT)), p<0, p <> -1]], //B430b
 [cosh(x)^n, 
  bl(cosh(x)^(n-1)*sinh(x)/n+(n-1)/n*int(cosh(x)^(n-2),x)),
  [bl(testtype(n, DOM_INT)), n>0]], //B431a
 [cosh(x)^p, 
  bl(-cosh(x)^(p+1)*sinh(x)/(p+1)
     +(p+2)/(p+1)*int(cosh(x)^(p+2),x)),
  [bl(testtype(float(p), DOM_FLOAT)), p<0, p <> -1]], //B431b
 [1/sinh(x),ln(tanh(x/2))], //B432
 [1/cosh(x), 2*arctan(exp(x))], //B433
 [x*sinh(x), x*cosh(x)-sinh(x)], //B434
 [x*cosh(x), x*sinh(x)-cosh(x)], //B435
 [exp(x)^a, exp(a*x)/a],
 [exp(a/x), x*exp(a/x)-a*Ei(a/x)],
 [exp(x^a), -(x*Ei((a - 1)/a, -x^a))/a,
  [bl(not iszero(a-2))]], // not wrong for a=2, but we want the special case
 [exp(x^2), sqrt(PI)/2*erfi(x)], // important special case
 [exp(b*x^2)*(a - x)^2,
  -(2*b^(1/2)*exp(b*x^2)*(2*a - x) - PI^(1/2)*erfi(b^(1/2)*x)*(2*a^2*b - 1))/(4*b^(3/2))],
 [a^x, a^x/ln(a)],
 [exp(-x^2), sqrt(PI)/2*erf(x)],
 [a^(-x^2), sqrt(PI)/2*erf(sqrt(ln(a))*x)/sqrt(ln(a))],
 [x^(2*n-1)*exp(a*x^2),
   bl(-exp(a*x^2)*sum::sum_fn(v -> 
     (n-1)!/(2*(n-v-1)!)*(-a)^(n-v-1)*x^(2*n-2*v-2),
     0..n-1)/(-a)^n),
  [bl(testtype(n, DOM_INT))]], //GH313.3b
 [x^(2*n)*exp(a*x^2),
   bl(1/2*(1/4)^n*PI^(1/2)*(2*n)!/n!*erf(sqrt(-a)*x)/((-a)^(n+1/2)) -
     exp(a*x^2)*sum::sum_fn(v ->
       1/2*(-1)^v*(-a)^(n - v - 1)*x^(2*n - 2*v - 1)*gamma(v - n + 1/2)/gamma(1/2 - n),
       0..n - 1)/((-a)^n)),
  [bl(testtype(n, DOM_INT))]], //GH313.3b
 [exp(a*x)*ln(x), exp(a*x)*ln(x)/a - Ei(a*x)/a], //B458, B487
 [exp(a*x)*sin(b*x)^m2,
  bl(binomial(m2, m2/2)*exp(a*x)/(2^m2*a) +
     exp(a*x)/2^(m2-1)*
      sum::sum_fn(i -> (-1)^i*binomial(m2,m2/2-i)/(a^2+4*b^2*i^2)
          *(a*cos(2*b*i*x)+2*b*i*sin(2*b*i*x)), 1..m2/2)),
  [m2>1, bl(not iszero(a)), bl(not iszero(b)), bl(testtype(m2, DOM_INT))]], // GH334.2c
 [exp(a*x)*sin(b*x)^m1,
  bl(exp(a*x)/(a^2+b^2)*
     sum::sum_fn(i -> (-1)^i*binomial(m1,(m1-1)/2-i)/(a^2+(2*i+1)^2*b^2)
          * (a*sin((2*i+1)*b*x)-(2*i+1)*b*cos((2*i+1)*b*x)), 0..(m1-1)/2)),
  [m1>1,
   bl(not iszero(m1)), bl(not iszero(a)), bl(not iszero(b)),
   bl(testtype(m1, DOM_INT))]], // GH334.2d
 [exp(a*x)*sin(b*x),
  exp(a*x)/(a^2+b^2)*(a*sin(b*x)-b*cos(b*x))], // GH334.2e
/// Vorzeichenfehler bei exp(2*x)*sin(x)
// ((exp(a*x)*sin(x)^n,
//  bl(exp(a*x)*sin(x)^(n-1)/(a^2+n^2)*(a*sin(x)+n*cos(x))
//     +n*(n-1)/(a^2+n^2)*int(exp(a*x)*sin(x)^(n-2),x)))), //B461
 [exp(a*x)*cos(b*x)^n2,
  bl(binomial(n2, n2/2) * exp(a*x)/(2^n2*a)
     + exp(a*x)/2^(n2-1) *
      sum::sum_fn(i -> binomial(n2, n2/2-i)/(a^2+4*i^2*b^2) *
          (a*cos(2*i*b*x) + 2*i*b*sin(2*i*b*x)),
          1..n2/2)),
  [n2>1, bl(not iszero(n2)), bl(testtype(n2, DOM_INT))]], // GH334.3c, corrected
 [exp(a*x)*cos(b*x)^n1,
  bl(exp(a*x)/2^(n1-1) *
     sum::sum_fn(i -> binomial(n1, (n1-1)/2-i)/(a^2+(2*i+1)^2*b^2)
         * (a*cos((2*i+1)*b*x)+(2*i+1)*b*sin((2*i+1)*b*x)),
         0..(n1-1)/2)),
  [n1>1, bl(not iszero(n1)), bl(testtype(n1, DOM_INT))]], // GH334.3d
 [exp(a*x)*cos(b*x),
  exp(a*x)/(a^2+b^2)*(a*cos(b*x)+b*sin(b*x))], // GH334.3e
/// Vorzeichen?
// ((exp(a*x)*cos(x)^n,
//  bl(exp(a*x)*cos(x)^(n-1)/(a^2+n^2)*(a*cos(x)+n*sin(x))
//     +n*(n-1)/(a^2+n^2)*int(exp(a*x)*cos(x)^(n-2),x)))), //B462
 [ln(x)^n, 
  bl(x*sum::sum_fn(k -> (-1)^(k+1)*n!/k!*ln(x)^k, 0..n)),
  [bl(testtype(n, DOM_INT))]],
 [1/ln(x)^n,
  bl(Li(x)/product::product_fn(j -> n-j, 1..n-1) - 
    x*sum::sum_fn(k -> ln(x)^(k-n)/product::product_fn(j -> n-j, 1..k), 1..n-1)),
  [bl(testtype(n, DOM_INT)), /*n <> 1,*/ bl(not iszero(n))]], //B470
 [ln(x)^a,
  igamma(a+1, -ln(x))*(ln(x))^a/(-ln(x))^a],
 [x^m*ln(x)^n,
  bl((x^(m+1)*ln(x)^n)/(m+1)-n/(m+1)*int(x^m*ln(x)^(n-1),x)),
  [bl(testtype(n, DOM_INT)), m <> -1, n <> -1, bl(not iszero(m)), bl(not iszero(n))]], //B472
 [1/x^m*ln(x)^n, 
  bl(-ln(x)^n/(m-1)/x^(m-1)+n/(m-1)*int(1/x^m*(ln(x)^(n-1)),x)),
  [bl(testtype(n, DOM_INT)), m <> 1, bl(not iszero(m)), bl(not iszero(n))]], //B475
 [x^m*1/ln(x)^n, 
  bl(-x^(m+1)/((n-1)*ln(x)^(n-1))+(m+1)/(n-1)*int(x^m/(ln(x)^(n-1)),x)),
  [bl(testtype(n, DOM_INT)), n <> 1, bl(not iszero(m)), bl(not iszero(n))]], //B477
 [1/(x^p*ln(x)^n), 
  bl(-1/(x^(p-1)*(n-1)*ln(x)^(n-1))-(p-1)/(n-1)
     *int(1/(x^p*ln(x)^(n-1)),x)),
  [bl(testtype(n, DOM_INT)), n <> 1, bl(not iszero(p)), bl(not iszero(p+1)), bl(not iszero(n))]], //B481
 [x^2*arcsin(x/a), x^3/3*arcsin(x/a)+(x^2+2*a^2)*sqrt(a^2-x^2)/9, [a > 0]], //B490
 [x^2*arccos(x/a), x^3*arccos(x/a)/3-(x^2+2*a^2)*sqrt(a^2-x^2)/9, [a > 0]], //B495
////// WRONG
//// [arccos(x)/x,
////  ln(x)*arccos(x)-ln(x/2*(1+sqrt(1-x^2))/x)*arctan((1+sqrt(1-x^2))/x)
////  - I*(dilog(I*(1+sqrt(1-x^2))/x)-dilog(-I*(1+sqrt(1-x^2))/x))
////  + I*(dilog((1+I*(1+sqrt(1-x^2))/x)/2)
////       -dilog((1-I*(1+sqrt(1-x^2))/x)/2)),
////  [abs(x)<=1]], // GH341.4b  
 [x^r*arctan(x/a),
  bl(x^(r+1)/(r+1)*arctan(x/a)-a/(r+1)*int(x^(r+1)/(a^2+x^2),x)),
  [r <> -1, bl(not iszero(r))]], //B501, generalized
 [arctan(x)*x/sqrt(1-x^2),
  -sqrt(1-x^2)*arctan(x)-arcsin(x)
  +sqrt(2)*arctan(sqrt(2)*x/sqrt(1-x^2))], // GH342.9
//// This seems to be wrong:
///  [arctan(x)^2,
///   x*arctan(x)^2-ln(sqrt(x^2+1)/2)*arctan(x)+
///   I/2*(dilog((1+I*x)/2)-dilog((1-I*x)/2))], // GH342.5
/* [arctan(x^n),
  x*arctan(x^n)
  - n*x^(1+n)*hypergeom([(1+n)/(2*n), 1],
			[1+(1+n)/(2*n)], -x^(2*n))/(1+n)],  */
// unser hypergeom ist viel zu schwach in seinen Vereinfachungen, 
// deshalb hier noch ein Spezialfall:
 [arctan(x^3),
  x*arctan(x^3) +
  sqrt(3)/2*(arctan(sqrt(3)-2*x) + arctan(sqrt(3)+2*x)) +
  ln(x^2+1)/2 +
  -1/4 * (ln(x^2+sqrt(3)*x+1)+ln(-x^2+sqrt(3)*x-1))], 
 [1/((1+x^2)*arctan(x)), ln(arctan(x))], // GH342.10

 [x*arctan(c*tan(x)),
  PI/24*(12*x^2+PI^2)*floor(1/2-x/PI)-PI^3/6*floor(1/2-x/PI)^3+x^3/3, [c=1]], // vvb in s.m.s
 [x*arctan(c*tan(x)),
  1/2*x^2*arctan(c*sin(x)/cos(x))+
  1/4*x*polylog(2,2*(-1/2+I*cos(x)*sin(x)+cos(x)^2)*(1+c)/(c-1))+
  1/4*I*x^2*ln(((-cos(x)-I*sin(x))*(c^2-1)^(1/2)+c-1)/(c-1))-
  1/4*I*x^2*ln(((-cos(x)-I*sin(x))*(c^2-1)^(1/2)+1+c)/(1+c))-
  1/4*x*polylog(2,2*(-1/2+I*cos(x)*sin(x)+cos(x)^2)*(c-1)/(1+c))+
  1/4*I*x^2*ln(((cos(x)+I*sin(x))*(c^2-1)^(1/2)+c-1)/(c-1))-
  1/4*I*x^2*ln(((cos(x)+I*sin(x))*(c^2-1)^(1/2)+1+c)/(1+c))+
  1/8*I*polylog(3,2*(-1/2+I*cos(x)*sin(x)+cos(x)^2)*(1+c)/(c-1))-
  1/8*I*polylog(3,2*(-1/2+I*cos(x)*sin(x)+cos(x)^2)*(c-1)/(1+c)), [c<>1]], // vvb in s.m.s

 [x^n*arccot(x/a),
  bl(x^(n+1)/(n+1)*arccot(x/a)+a/(n+1)*int(x^(n+1)/(a^2+x^2),x)),
  [n <> -1, bl(not iszero(n))]], //B508
 [arccot(x)*x/sqrt(1-x^2),
  -sqrt(1-x^2)*arccot(x)+arcsin(x)
  +sqrt(2)*arccot(sqrt(2)*x/sqrt(1-x^2))], // GH342.9
 [arccot(x/a)/x^n, 
  bl(-1/(n-1)/x^(n-1)*arccot(x/a)-a/(n-1)*int(1/(x^(n-1)*(a^2+x^2)), x)),
  [n <> 1, bl(not iszero(n))]], //B511
////// WRONG
//// [arccot(x)^2,
////  x*arccot(x)^2-ln(sqrt(x^2+1)/2)*arctan(x)+
////  I/2*(polylog(2, (1+I*x)/2)-polylog(2, (1-I*x)/2)) +
////  PI*ln(sqrt(x^2+1)/2)], // GH342.5
 [arccot(x)^2,
  x*arccot(x)^2 + polylog(2, exp(arccot(x)*2*I))*I -
  2*ln(1 - exp(2*I*arccot(x)))*arccot(x) + arccot(x)^2*I],

/*
 [cos(x)^m2,
  bl(binomial(m2,m2/2)/4^(m2/2)*x
     +sum::sum_fn(i -> sin((m2-2*i)*x)*
	  binomial(m2,i)/(m2-2*i), 0..m2/2-1)*2^(1-m2)),
  [m2>1, bl(not iszero(m2)), bl(testtype(m2, DOM_INT))]],
 
 [cos(x)^m1, 
  bl(sum::sum_fn(i -> (-1)^i*binomial((m1-1)/2,i)*sin(x)^(2*i+1)/(2*i+1),
	         0..(m1-1)/2)),
  [m1>1, bl(not iszero(m1)), bl(testtype(m1, DOM_INT))]],
*/
 
 // Kurzform fuer den als Eingabe hereingekommenen Ausdruck?
 [sqrt(1+cos(a*x)),  2*sin(a*x)/(a*sqrt(1+cos(a*x)))],
 [sqrt(1-cos(a*x)), -2*sin(a*x)/(a*sqrt(1-cos(a*x)))],
 

 [(1-cos(x))^(-1/2), -2^(1/2)*arctanh(((1+cos(x))/2)^(1/2))
  *sin(x)/(sin(x)^2)^(1/2)],
 [(1+cos(x))^(-1/2), 2^(1/2)*arcsinh(sin(x)/(1+cos(x)))],
 [(1-cos(x)^2)^(1/2), -cos(x)/sin(x)*(sin(x)^2)^(1/2)],

 [1/(a+b*sin(x)),
  -2/a/(b/a+tan(x/2)),
  [bl(iszero(a^2-b^2)),
   bl(not iszero(a) and not iszero(b))]],

 [sin(x)/(1+b*sin(x))^m,
  bl(int(1/(1+b*sin(x))^(m-1),x)
     -int(1/(1+b*sin(x))^m,x)),
  [bl(testtype(n, DOM_INT)), m>1]],

 [x^m*sin(a*x),
  bl(sin(a*x)*(sum::sum_fn(i -> (-1)^i*a^(-2-2*i)*x^(m-1-2*i)*fact(m)/
                                  fact(m-1-2*i), 0..(m-1) div 2))
    -cos(a*x)*(sum::sum_fn(i -> (-1)^i*a^(-1-2*i)*x^(m-2*i)*fact(m)/
                   fact(m-2*i), 0..m div 2))),
  [m>1, bl(testtype(m, DOM_INT))]],

 [tan(x)/(1+sin(x)),
  (ln(tan(PI/4+x/2))+1/(1+sin(x)))/2],
 [tan(x)/(1-sin(x)),
  (-ln(tan(PI/4+x/2))+1/(1-sin(x)))/2],
 
 [x/(b+b*sin(a*x)),
  1/b*(-x/(1+sin(a*x))*cos(a*x)/a+ln(1+sin(a*x))/a^2)],
 [x/(b-b*sin(a*x)),
  1/b*(x/(1-sin(a*x))*cos(a*x)/a+ln(1-sin(a*x))/a^2)],
 
 [(1+sin(x))^(1/2), 2*(sin(x)-1)*(1+sin(x))^(1/2)/cos(x)],
 [(1-sin(x))^(1/2), 2*(sin(x)+1)*(1-sin(x))^(1/2)/cos(x)],
 [(1-sin(x))^(-1/2), arctanh((1+sin(x)+cos(x))/2/
                             (1+cos(x))^(1/2))*(sin(x)+cos(x)-1)/sin(x)
  *((1+cos(x))/(1-sin(x)))^(1/2)],
 [(1+sin(x))^(-1/2), arctanh((1-sin(x)+cos(x))/2/
                             (1+cos(x))^(1/2))*(-sin(x)+cos(x)-1)/sin(x)
  *((1+cos(x))/(1+sin(x)))^(1/2)],
 [(1-sin(x)^2)^(1/2), sin(x)/cos(x)*(cos(x)^2)^(1/2)],

 [1/(a+b*cos(x)+c*sin(x)),
  2/sqrt(a^2-b^2-c^2)*
  arctan(((a-b)*tan(x/2)+c)/sqrt(a^2-b^2-c^2)),
  [bl(not iszero(a) and not iszero(b) and not iszero(c))]], // GH331.18e
 [1/(a+a*cos(x)+c*sin(x)),
  1/c*ln(a+c*tan(x/2)),
  [bl(not iszero(a) and not iszero(c))]], // GH331.18f
 [1/(a+b*cos(x)+c*sin(x)),
  -2/((a-b)*tan(x/2)+c),
  [a^2=b^2+c^2,
   bl(not iszero(a) and not iszero(b) and not iszero(c))]], // GH331.18g

 [tan(x), -ln(cos(x))],
 [tan(x)^n,
  bl(sum::sum_fn(i -> (-1)^i/(n-1-2*i)*tan(x)^(n-1-2*i), 0..iquo(n-2,2))
     +(-1)^iquo(n-2,2)*((n-2*iquo(n,2))*(ln(cos(x))+x)-x)),
  [bl(testtype(n, DOM_INT)), n>1]],
 [1/sqrt(tan(x)^2+1), tan(x)/sqrt(tan(x)^2+1)],
 [1/sqrt(b*tan(x)^2+1),
  -b^2*arctan(b^2*(b-1)*tan(x)/(-b^4*(b-1))^(1/2)/
              sqrt(b*tan(x)^2+1))/(-b^4*(b-1))^(1/2),
  [b <> 1, bl(not iszero(b))]],

 [1/sqrt(b*tan(x)^2+a),
  arctan(tan(x)*(a-b)^(1/2)/sqrt(b*tan(x)^2+a))/(a-b)^(1/2),
  [a <> 1, b <> 1, bl(not iszero(a)), bl(not iszero(b))]],
 
//////////////////////////////////////////////////
 [x*arccos(a*x), 
  (-a*x*(1-a^2*x^2)^(1/2)+(2*a^2*x^2-1)*arccos(a*x))/4/a^2],
 [x*arccos(a/x),
  x/2*(x*arccos(a/x)-a*(1-a^2/x^2)^(1/2))],
 [arccos(a*x)/x^2,
  -arccos(a*x)/x+a*arctanh((1-a^2*x^2)^(-1/2))],
 [arccos(a/x)/x^2,
  -arccos(a/x)/x+(1-a^2/x^2)^(1/2)/a],
 [arccos(a*x),
  x*arccos(a*x)-(1-a^2*x^2)^(1/2)/a],
 [arccos(a/x),
   x*arccos(a/x)-a*arctanh((1-a^2/x^2)^(-1/2))],
 [arccos(a*x)^n,
   bl(fact(n)*
   (sum::sum_fn(i -> arccos(a*x)^(n-1-2*i)*(-1)^i*(1-a^2*x^2)^(1/2)
                 /a/fact(n-1-2*i), 0..(n-1)div 2)
    +sum::sum_fn(i -> x*(-1)^i*arccos(a*x)^(n-2*i)
                 /fact(n-2*i), 0..n div 2))),
  [n>1, bl(testtype(n, DOM_INT))]],

//////////////////////////////////////////////////
 [x*arcsin(a*x),
  (a*x*(1-a^2*x^2)^(1/2)+(2*a^2*x^2-1)*arcsin(a*x))/4/a^2],
 [x*arcsin(a/x),
  x/2*(x*arcsin(a/x)+(1-a^2/x^2)^(1/2)*a)],
 [arcsin(a*x)/x^2,
  -arcsin(a*x)/x-a*arctanh((1-a^2*x^2)^(-1/2))],
 [arcsin(a/x)/x^2,
  -arcsin(a/x)/x-(1-a^2/x^2)^(1/2)/a],
 [arcsin(x),
  x*arcsin(x)+(1-x^2)^(1/2)],
 [arcsin(1/x),
  x*arcsin(1/x)+arctanh((1-1/x^2)^(-1/2))],
 [arcsin(x)^n,
   bl(fact(n)*
  (sum::sum_fn(i -> arcsin(x)^(n-1-2*i)*(-1)^i*(1-x^2)^(1/2)/fact(n-1-2*i),
               0..(n-1)div 2)
   +sum::sum_fn(i -> x*(-1)^i*arcsin(x)^(n-2*i)
                 /fact(n-2*i), 0..n div 2))),
  [n>1, bl(testtype(n, DOM_INT))]],

//////////////////////////////////////////////////
 [arctan(x),
  -ln(x^2+1)/2+x*arctan(x)],
 [arctan(sqrt(x)),
  arctan((x)^(1/2))*x-x^(1/2)+
  arctan(x^(1/2))],
 [arctan(a*x)/x,
  I/2*(dilog(1+I*a*x)-dilog(1-I*a*x))],

////////////////////////////////////////
 [x*arccosh(a*x),
  (x/2-1/4/a^2/x)*x*arccosh(a*x)-x/4/a*(a^2*x^2-1)^(1/2)],
 [x*arccosh(a/x),
  x/2*(x*arccosh(a/x)-a*(a^2/x^2-1)^(1/2))],
 [arccosh(x),
  x*arccosh(x)-(x^2-1)^(1/2)],
 [arccosh(1/x),
  x*arccosh(1/x)+arctan((1/x^2-1)^(-1/2))],

////////////////////////////////////////
 [x*arcsinh(a*x),
  (1/4/a^2/x+x/2)*x*arcsinh(a*x)-x/4/a*(a^2*x^2+1)^(1/2)],
 [x*arcsinh(a/x),
  x/2*(x*arcsinh(a/x)+a*(1+a^2/x^2)^(1/2))],
 [arcsinh(x),
  x*arcsinh(x)-(x^2+1)^(1/2)],
 [arcsinh(1/x),
  x*arcsinh(1/x)+arctanh((1+1/x^2)^(-1/2))],

//////////////////////////////////////////////////
 [x^v*besselJ(w,x),
  x^v*besselJ(v,x),
  [v=w+1]],
 [x^v*besselJ(w,x),
  -x^v*besselJ(-v,x),
  [w=1-v]],
 [x*besselJ(v,a*x)^2,
  x^2/2*(besselJ(v,a*x)^2-besselJ(v-1,a*x)*besselJ(v+1,a*x))],
//////////////////////////////////////////////////
 [x^a*exp(b*x),
  igamma(a+1,-b*x)/(-b)^a/b*(-b)^a*x^a/(-b*x)^a,
  [bl(not iszero(a)), bl(not iszero(b))]],
 [sqrt(x*exp(x)), 
  sqrt(x*exp(x))*(2-(sqrt(2*PI)*erf(I*sqrt(x/2))/I)
                  /(exp(x/2)*sqrt(x)))],

// in intlib::lookupexp ist noch ein Teil drin, der nicht rein auf
// Pattern aufsetzt.

//////////////////////////////////////////////////
// pattern for Ei(n, x) // Release 5.0 and higher
// (c.f. functions.wolfram.com, ExpIntegralE)
//////////////////////////////////////////////////
 [x^b*Ei(c, a*x), 
  x^(b+1)/(b+c)*(Ei(c, a*x) - Ei(-b, a*x)),
  [bl(not iszero(b + c))]],

//////////////////////////////////////////////////
 [x^a*ln(b*x),
  x^(a+1)/(a+1)*(ln(b*x)-1/(a+1))/*+f(a,b)*/,
  [a<>-1]],
 [x^m*ln(b+c*x),
  bl(((x^(m+1)-(-b/c)^(m+1))*ln(b+c*x)
   -(-b/c)^(m+1)*sum::sum_fn(r -> (-c*x/b)^r/r, 1..m+1))/(m+1)),
  [b<>0, bl(testtype(m, DOM_INT))]],
 [x^a*ln(b+c*x),
  bl(-(1/(-1/b*c)^(a + 1)*(ln(c + b/x) + 
       sum::sum_fn(r -> 1/r*(-b/c/x)^r, 1..-a-2))
    - x^(a + 1)*ln(b + c*x))/(a + 1)),
  [a in Z_, a<-1, c<>0, bl(testtype(a, DOM_INT))]],
 // this is what the old int returns.  Is it correct?
 [x^m*ln((x+b)/(x-b)),
  bl(ln(x - b)*(b^(m + 1) - x^(m + 1))/(m + 1) 
  + ln(b + x)*(x^(m + 1) - (-b)^(m + 1))/(m + 1) 
  + 2*b^(m + 1)*sum::sum_fn(r -> (1/b*x)^(m - 2*r + 2)/(m - 2*r + 2),
                            1..m + 1 div 2)/(m + 1)),
  [bl(testtype(m, DOM_INT))]],
 [x * ln(x+sqrt(x^2+b)),
  x*ln(x + (b + x^2)^(1/2))*(1/2*x + 1/4*b/x)
  - 1/4*x*(b + x^2)^(1/2)],
 [x^(-2)*ln(x+sqrt(x^2+b)),
  - 1/x*ln(x + (b + x^2)^(1/2)) 
  - 1/b^(1/2)*ln(1/x*((b + x^2)^(1/2) + b^(1/2)))],
 [x^m*ln(x^2-b),
  bl(-(ln(x + b^(1/2))*(-b^(1/2))^(m + 1) 
    - x^(m + 1)*ln(x^2 - b) + ln(x - b^(1/2))*(b^(1/2))^(m + 1) 
    + 2*sum::sum_fn(i -> b^i*x^(m - 2*i + 1)/(m - 2*i + 1), 0..floor(1/2*m)))
       /(m+1)),
  [bl(testtype(m, DOM_INT))]],
 [x^a/ln(x), Ei((a+1)*ln(x)), [a <> -1, bl(not iszero(a))]], // GH322.4c, adapted
 [ln(x)^a/x,
  ln(x)^(a+1)/(a + 1), [a<>-1]],
 [ln(a*x+b)/x,
  dilog(-a/b*x)+ln(a*x+b)*ln(-a/b*x)],
 [ln(x)^m*x^a,
  bl((-1)^m*fact(m)*x^(a+1)/(a+1)^(m+1)*
     sum::sum_fn(i -> (-(a+1)*ln(x))^i/fact(i), 0..m)),
  [a <> -1, m<>0, bl(testtype(m, DOM_INT))]],
 [ln(x)^m,
  bl((-1)^m*fact(m)*x*sum::sum_fn(i -> (-ln(x))^i/fact(i), 0..m)),
  [m<>0, bl(testtype(m, DOM_INT))]],
 [ln(x*sqrt(x^2+a)),
  1/2*(-a)^(1/2)*ln(x + (-a)^(1/2)) - 1/2*(-a)^(1/2)*ln(x - (-a)^(1/2))
  - 2*x + 1/2*x*ln(a + x^2) + x*ln(x), [a>0]],
 [exp(a*x)/(x+b), exp(-a*b)*Ei(a*(b+x))],
 [exp(x)^a/(x+b), exp(-a*b)*Ei(a*(b+x))],
 [exp(a*x)*cos(b*x)/(c+x),
  1/2*exp(-(a+I*b)*c)*(exp(2*I*b*c)*Ei((a-I*b)*(c+x))+Ei((a+I*b)*(c+x)))],
 [exp(x)^a*cos(b*x)/(c+x),
  1/2*exp(-(a+I*b)*c)*(exp(2*I*b*c)*Ei((a-I*b)*(c+x))+Ei((a+I*b)*(c+x)))],
 [cos(b*x)/x, Ci(b*x)],
 [exp(a*x)*sin(b*x)/(c+x),
  1/2*I*exp(-(a+I*b)*c)*(exp(2*I*b*c)*Ei((a-I*b)*(c+x))-Ei((a+I*b)*(c+x)))],
 [exp(x)^a*sin(b*x)/(c+x),
  1/2*I*exp(-(a+I*b)*c)*(exp(2*I*b*c)*Ei((a-I*b)*(c+x))-Ei((a+I*b)*(c+x)))],
 [sin(b*x)/x, Si(b*x)],
// wrong for x<0
// [sqrt(x*exp(x)),
//  -2*I*2^(1/2)*(exp(1/2*x)*(-1/2*x)^(1/2)
//		+ 1/2*PI^(1/2)*erfc((-1/2*x)^(1/2)))],
 [ln(x)*sin(a*x)*sin(b*x),
  Si(x*(a + b))/(2*a + 2*b) - Si(x*(a - b))/(2*a - 2*b) +
   (sin(x*(a - b))*ln(x))/(2*a - 2*b) - (sin(x*(a + b))*ln(x))/(2*a + 2*b),
  [a <> b]],
 [ln(x)*sin(a*x)*sin(b*x),
  (x*(ln(x) - 1))/2 + Si(2*a*x)/(4*a) - (sin(2*a*x)*ln(x))/(4*a),
  [a=b]],
 [ln(x)*sin(a*x)^2,
  (x*(ln(x) - 1))/2 + Si(2*a*x)/(4*a) - (sin(2*a*x)*ln(x))/(4*a)],

 [abs(x), x*abs(x)/2],
 [exp(-abs(x)), 1+sign(x)*(1-exp(-abs(x)))], // #2287
 
 [psi(x), ln(gamma(x))],
 [gamma(x)*psi(x), gamma(x)],

// hypergeoms
 [hypergeom([a], [b], x),
  (b-1)/(a-1)*hypergeom([a-1], [b-1], x), [bl(not iszero(b-1))]],
 [hypergeom([a], [b], x)*x^c,
  x^(c+1)/(c+1)*hypergeom([a, c+1], [b, c+2], x)],
 [hypergeom([a], [b], x)*x^c*exp(-x),
  x^(c+1)/(c+1)*hypergeom([b-a, c+1], [b, c+2], -x)],
 [hypergeom([a, b], [c], x),
  (c-1)/((a-1)*(b-1))*hypergeom([a-1, b-1], [c-1], x), [bl(not iszero(c-1))]], // A&S 15.2.1
 [x^a*hypergeom([a+2, b], [c], x),
  x^(a+1)/(a+1)*hypergeom([a+1, b], [c], x)], // A&S 15.2.3
 [x^c*hypergeom([a, b], [c+1], x),
  x^(c+1)/(c+1)*hypergeom([a, b], [c+2], x)], // A&S 15.2.4
 [x^d*(1-x)^e*hypergeom([a, e+d+2], [d+a+2], x),
  x^(d+1)/(d+1)*(1-x)^(e+1)*hypergeom([a+1, e+d+2], [d+a+2], x)], // A&S 15.2.5
 [x^d*(x-1)^e*hypergeom([a, e+d+2], [d+a+2], x),
  (-1)^e*x^(d+1)/(d+1)*(1-x)^(e+1)*hypergeom([a+1, e+d+2], [d+a+2], x),
  [e in Z_]], // A&S 15.2.5
// ((1 - z)^(((a + b) - c) - 1)*hypergeom([a, b], [c + 1], z), z)
// --> (1-z)^(a+b-c)*hypergeom([a, b], [c], z)*c/((c-a)*(c-b))
// d = a + b - (c + 1) <=> c + 1 = a + b - d <=> c = a + b - d - 1
 [(1-x)^d*hypergeom([a, b], [a + b - d], x),
  (1-x)^(d+1)*(a+b-d-1)/((b-d-1)*(a-d-1))*hypergeom([a, b], [a+b-d-1], x)], // A&S 15.2.6
 [(x-1)^d*hypergeom([a, b], [a + b - d], x),
  (-1)^d*(1-x)^(d+1)*(a+b-d-1)/((b-d-1)*(a-d-1))*hypergeom([a, b], [a+b-d-1], x),
  [d in Z_]], // A&S 15.2.6
 [(1-x)^a*hypergeom([a+2, b], [c], x),
  -(1-x)^(a+1)*(c-1)/((a+1)*(c-b-1))*hypergeom([a+1, b], [c-1], x)], // A&S 15.2.7
 [(x-1)^a*hypergeom([a+2, b], [c], x),
  (-1)^(a+1)*(1-x)^(a+1)*(c-1)/((a+1)*(c-b-1))*hypergeom([a+1, b], [c-1], x),
  [a in Z_]], // A&S 15.2.7
 [x^c*(1-x)^d*hypergeom([a, d+c+2], [c+1], x),
  x^(c+1)*(1-x)^(d+1)/(c+1)*hypergeom([a+1, d+c+2], [c+2], x)], // A&S 15.2.8
 [x^c*(x-1)^d*hypergeom([a, d+c+2], [c+1], x),
  (-1)^d*x^(c+1)*(1-x)^(d+1)/(c+1)*hypergeom([a+1, d+c+2], [c+2], x),
  [d in Z_]], // A&S 15.2.8
 [x^c*(1-x)^d*hypergeom([d-b+c+1, b], [c+1], x),
  x^(c+1)*(1-x)^(d+1)/(c+1)*hypergeom([d-b+c+2, b+1], [c+2], x)], // A&S 15.2.9
 [x^c*(x-1)^d*hypergeom([d-b+c+1, b], [c+1], x),
  (-1)^d*x^(c+1)*(1-x)^(d+1)/(c+1)*hypergeom([d-b+c+2, b+1], [c+2], x),
  [d in Z_]], // A&S 15.2.9


 null()
 ]:
