// intlib::symbolicDiffs(f, x, options)
// look for symbolic diff expressions in f involving
// differentiation w.r.t. x and use linearity of
// differentiation to get rid of them, as outlined by
// Graham Campbell in 1987

intlib::symbolicDiffs :=
proc(f, x, options)
  local fx, dfx, ft, n, t, q, g;
begin
  // look for maximum diff level
  n := 0;
  f := rewrite(f, diff);
  misc::maprec(f,
    {"diff"} = proc(d)
      local cnt;
    begin
      cnt := nops(select([op(d, 2..nops(d))], _equal, x));
      if cnt>n then
        n := cnt;
        if nops(d) = n+1 then
          dfx := d;
          fx := op(d, 1);
        else
          dfx := d;
          fx := select(d, _unequal, x);
        end_if;
      end_if;
      d;
    end);
  if n = 0 then
    return(FAIL);
  else
    t := solvelib::getIdent(Any, indets([f, x]));
    ft := intlib::algebraic::poly(subsex(f, dfx = t), [t]);
    if has(poly2list(ft), [t]) then
      // int(sqrt(diff(x(t),t)^2+diff(y(t),t)^2),t) and similar
      return(FAIL);
    end_if;
    if ft <> FAIL and degree(ft) > 1 then
      ft := mapcoeffs(ft, normal);
      ft := mapcoeffs(ft, intlib::Simplify);
    end_if;
    if ft <> FAIL and iszero(degree(ft)) then
      // cancellation
      g := expr(ft);
      if n > 1 and has(g, {fx}) and has(g, {hold(diff)}) then
        g := intlib::symbolicDiffs(g, x, options);
      else
        g := int(g, x, options);
      end_if;
      return(g);
    end_if;
    if ft = FAIL or degree(ft) <> 1 then
      return(FAIL);
    end_if;
    q := coeff(ft, 1);
    dfx := if n = 1 then fx else hold(diff)(fx, x$(n-1)) end_if;
    q := subsex(q, dfx = t);
    q := intlib::int(q, t, options);
    if hastype(q, "int") then return(FAIL); end_if;
    q := evalAt(q, t=dfx);
    g := intlib::Simplify(f - diff(q, x), options, Steps=20);
    if iszero(g) then return(q); end_if;
    if has(g, {hold(diff)(fx, x$n)}) then
      g := eval(collect(g, hold(diff)(fx, x$n), simplify,
        if options[IgnoreAnalyticConstraints]=TRUE then IgnoreAnalyticConstraints end_if));
    end_if;
    if has(g, {hold(diff)(fx, x$n)}) then
      return(FAIL);
    end_if;
    if n > 1 and has(g, {fx}) and has(g, {hold(diff)}) then
      g := intlib::symbolicDiffs(g, x, options);
    else
      g := int(g, x, options);
    end_if;
    return(q+g);
  end_if;
end:
