
// intlib::trafoLookup -- examine integrand for fruitful transformation patterns

intlib::trafoLookup :=
proc(f, x, options)
  local power_pos, t, n, ft, sub, res,
        a, b, c, d, integral, num, den, ok, l;
begin
  f := combine(f);
  // rational expressions should not make it to here,
  // but are reasonably quick to check:
  if testtype(f, Type::RatExpr(x)) then
    return(intlib::algebraic::rational(f, x, options));
  end_if;
    
  // some dummy var not in f:
  t := solvelib::getIdent(Any, indets(f, All) union {x});
  
  res := 0;
  
  // nothing of the cases below can work with specfuncs.
  ok := TRUE;
  misc::maprec(f,
    {DOM_EXPR} = (ex ->
      (if has(ex, x) and
        not has({hold(_power), hold(_plus),
          hold(_mult), hold(_subtract), hold(_divide)}, op(ex, 0)) then
        ok := FALSE;
        misc::breakmap();
      end_if; ex)));
  if not ok then
    return(FAIL);
  end_if;
  
  // find fractional powers
  power_pos := map({prog::find(f, hold(_power))}, l -> l[1..-2]);
  power_pos := select(power_pos,
                      p -> has(op(f,p), x));
  power_pos := select(power_pos,
                      p -> not testtype(op(f, p.[2]), DOM_INT));
  
  // do some exist and are all of these identical?
  l := map(power_pos, pos -> op(f, pos));

  // test for Rat(x, (p(x))^(1/n))
  if map(l, domtype@op, 2) = {DOM_RAT} and nops(map(l, op, 1)) = 1 then
    n := lcm(op(map(l, denom@op, 2)));
    sub := poly(op(f, op(power_pos, 1).[1]), [x]);
    if sub <> FAIL and
       not(x in indets(sub)) then
    
      // rational function of x and (a*x+b)^(1/n)?
      if degree(sub) = 1 then
        a := lcoeff(sub);
        b := coeff(sub, 0);
        // Grbner/Hofreiter, 211.1a
        // int(R(x, (a*x+b)^(1/n)), x) =
        //  int(R((t^n-b)/a, t)*n/a*t^(n-1), t) | t = (a*x+b)^(1/n)
        if traperror((ft := subs(subsex(f, (a*x+b)^(1/n) = t),
                                 x = (t^n-b)/a)*n/a*t^(n-1))) = 0 then
          if testtype(ft, Type::RatExpr(t, Type::IndepOf({t,x}))) then
            userinfo(2, "detected integrand of the form Rat(x, (a*x+b)^(1/n))");
            integral := intlib::algebraic::rational(ft, t, options);
            if integral <> FAIL then
              return(res + evalAt(integral, t = (a*x+b)^(1/n)));
            end_if;
          end_if;
        end_if;
//      elif FALSE /* the formulas are buggy, sorry */
//           and degree(sub) = 2 then
//        // rational function of x and (a*x^2+b*x+c)^(1/2)?
//        // --> G&H 231.1a
//        a := coeff(sub, 2);
//        b := coeff(sub, 1);
//        c := coeff(sub, 0);
//        
//        ft := subsop(f, op(map(power_pos, p -> p=x)));
//        if testtype(ft, Type::RatExpr(x, Type::IndepOf(x))) then
//          userinfo(2, "detected integrand of the form Rat(x, sqrt(a*x^2+b*x+c))");
//          // look for some special cases first, for simpler results:
//          if FALSE and iszero(b) then
//            if traperror((ft := -subs(subsop(f,
//                                             op(map(power_pos,
//                                                    p -> p = sqrt(c/a)*(t^2+1)/(t^2-1)))),
//                                      x = 2*sqrt(c/a)*t/(t^2-1))
//                              * 2 * sqrt(c/a)*(t^2+1)/(t^2-1)^2)) = 0 then
//              assert(testtype(ft, Type::RatExpr(t, Type::IndepOf({t,x}))));
//              integral := intlib::algebraic::rational(ft, t, options);
//              if integral <> FAIL then
//                return(res + subs(integral, t = (sqrt(x^2+c/a)+sqrt(c/a))/x));
//              end_if;
//            end_if;
//          else
//            // d is alpha in G&H, e is beta
//            if traperror((d := ceil(-(b-sqrt(b^2-a*c))/(a))+1)) <> 0 then
//              d := 42;
//            end_if;
//            e := sqrt(a*d^2+2*b*d+c);
//            
//            if traperror((ft := subs(subsop(f, op(map(power_pos,
//                                                      p -> p = (a*e*t^2-2*(a*d+b)*t+e)/(a*t^2-1)))),
//                                     x = (-(a*d+2*b)*t^2+2*e*t-d)/(a*t^2-1))
//                              * (-2*a*e*t^2+4*(a*d+b)*t-2*e)/(a*t^2-1)^2)) = 0 then
//              assert(testtype(ft, Type::RatExpr(t, Type::IndepOf({t,x}))));
//              integral := intlib::algebraic::rational(ft, t, options);
//              if integral <> FAIL then
//                return(res + subs(integral, t = (x-d)/(sqrt(a*x^2+b*x+c)-e)));
//              end_if;
//            end_if;
//          end_if;
//        end_if;
      end_if;
    end_if;
  
    if sub=FAIL then
      // radicand not polynomial.
      // rational?
      sub := op(f, op(power_pos, 1).[1]);
      if testtype(sub, Type::RatExpr(x)) then
        num := poly(numer(sub), [x]);
        den := poly(denom(sub), [x]);
        
        if num <> FAIL and degree(num) = 1 and
           den <> FAIL and degree(den) = 1 /* and
           (options[IgnoreAnalyticConstraints] = TRUE or 
             is(sub>=0, Goal=TRUE) = TRUE) */ then
          // substitution GH 213.1
          a := lcoeff(num);
          b := coeff(num, 0);
          c := lcoeff(den);
          d := coeff(den, 0);
          if traperror((ft := subs(subsex(f, ((a*x+b)/(c*x+d))^(1/n) = t*a^(1/n)/c^(1/n)),
                                   x = (-a*d*t^n+b*c)/(a*c*(t^n-1)))
                            *n*(a*d-b*c)/(a*c)*t^(n-1)/(t^n-1)^2)) = 0 then
            
            if testtype(ft, Type::RatExpr(t, Type::IndepOf({t,x}))) then
              userinfo(2, "detected integrand of the form Rat(x, ((a*x+b)/(c*x+d))^(1/n)");
              integral := intlib::algebraic::rational(ft, t, options);
              if integral <> FAIL then
                return(res +
                       subsex(integral,
                              t^n = c/a*(a*x+b)/(c*x+d),
                              t = c^(1/n)/a^(1/n)*((a*x+b)/(c*x+d))^(1/n)));
              end_if;
            end_if;
          end_if;
        end_if;
      end_if;
    end_if;
  end_if;

  if iszero(res) then
    FAIL;
  else
    res + hold(int)(f,x);
  end;
end_proc:

// separated from the above, because it must be done
// *after* pattern matching and Risch integration failed.
intlib::ratOfSqrt :=
proc(f, x, options)
  local ok, power_pos, t, n, ft,
        a, b, c, d, integral, l, bases, base,
        alp, bet, gam,
        removeSqrt;
begin
  // nothing of the cases below can work with specfuncs.
  ok := TRUE;
  misc::maprec(f,
    {DOM_EXPR} = (ex ->
      (if has(ex, x) and
        not has({hold(_power), hold(_plus),
          hold(_mult), hold(_subtract), hold(_divide)}, op(ex, 0)) then
        ok := FALSE;
        misc::breakmap();
      end_if; ex)));
  if not ok then
    return(FAIL);
  end_if;

  // some dummy var not in f:
  t := solvelib::getIdent(Any, indets(f, All) union {x});
  
  // find fractional powers
  power_pos := map({prog::find(f, hold(_power))}, l -> l[1..-2]);
  power_pos := select(power_pos,
                      p -> has(op(f,p), x));
  power_pos := select(power_pos,
                      p -> not testtype(op(f, p.[2]), DOM_INT));
  // do some exist and how many are different?
  l := map(power_pos, pos -> op(f, pos));
  bases := map(l, op, 1);

  if nops(bases) = 1 and map(l, op, 2) minus (Z_ + 1/2) = {} then
    // Rat(x, sqrt(a*x^2+b*x+c)) --> Gradshteyn, 2.251
    base := op(bases, 1);
    base := poly(base, [x]);
    if base <> FAIL and degree(base)=2 and not has(poly2list(base), [x]) then
      a := coeff(base, 2);
      b := coeff(base, 1);
      c := coeff(base, 0);
      // TODO: Under which conditions may we split
      // sqrt(a*x^2+b*x) to sqrt(x)*sqrt(a*x+b)?
      // utility function, performing sqrt(a^2)->a. We only
      // look for piecewise continuous solutions anyway ...
      removeSqrt :=
      proc(ex)
        local base, expo;
      begin
        [base, expo] := [op(ex)];
        if testtype(expo, DOM_INT) or not testtype(2*expo, DOM_INT) then
          return(ex);
        end_if;
        case type(base)
        of "_mult" do
          return(map(base, b -> removeSqrt(b^expo)));
        of "_power" do
          return(op(base, 1)^(op(base, 2)*expo));
        end_case;
        ex;
      end_proc:
      // real solutions?
      alp := b^2 - 4*a*c;
      if options[IgnoreAnalyticConstraints] = TRUE then
        if is(alp = 0, Goal=TRUE) then
          // one solution, can take square root
          ft := subsex(f, sqrt(op(bases, 1)) = sqrt(a)*(x+b/(2*a)));
          assert(bool(ft <> f));
          return(int(ft, x));
        end_if;
      end_if;
      integral := hold(int)(f, x);
//      for try in [(op(bases, 1)-x*sqrt(a)),
//                  (op(bases, 1)+x*sqrt(a)),
//                  (op(bases, 1)-sqrt(c))/x,
//                  (op(bases, 1)+sqrt(c))/x,
//                  op(bases, 1)/(x+(b+sqrt(alp))),
//                  op(bases, 1)/(x+(b-sqrt(alp)))] do
//        if domtype(try) = DOM_IDENT then next; end_if;
//        ft := FAIL;
//        if traperror((
//          ft := intlib::changevar(integral, t = try, t, Unique);
//          ft := misc::maprec(ft, {"_power"} = removeSqrt))) = 0
//          and ft <> FAIL and not has(ft, x) then
//          userinfo(2, "Substituting ".(t = try));
//          ft := eval(ft);
//          if not hastype(ft, "int") then
//            return(intlib::Simplify(ft | t = try, options));
//          end_if;
//        end_if;
//      end_for;
    end_if;
  elif nops(bases) = 2 and map(l, op, 2) minus (Z_ + 1/2) = {} then
    // Rat(x, sqrt(a*x+b), sqrt(c*x+d)) --> G&H, 221.1
    n := map(l, op, 2);
    if n = {1/2} or n = {1/2, -1/2} or n = {-1/2} then
      a := op(l, [1,1]);
      c := op(l, [2,1]);
      if testtype(a, Type::PolyExpr(x)) and degree(a, x) = 1 and
         testtype(c, Type::PolyExpr(x)) and degree(c, x) = 1 then
        b := coeff(a, x, 0); a := coeff(a, x, 1);
        d := coeff(c, x, 0); c := coeff(c, x, 1);
        if not testtype(d, Type::Real) or is(d >= 0) then
          alp := 0;
        else
          alp := -d/c;
        end_if;
        bet := sqrt(a*alp+b);
        gam := sqrt(c*alp+d);
        if traperror((ft := subs(f,
                                 sqrt(a*x+b)=(-bet*c*t^2+2*gam*a*t-bet*a)/(c*t^2-a),
                                 sqrt(c*x+d)=(gam*c*t^2-2*bet*c*t+gam*a)/(c*t^2-a),
                                 1/sqrt(a*x+b)=1/((-bet*c*t^2+2*gam*a*t-bet*a)/(c*t^2-a)),
                                 1/sqrt(c*x+d)=1/((gam*c*t^2-2*bet*c*t+gam*a)/(c*t^2-a)),
                                 x=alp-4*bet*gam*t/(c*t^2-a)
                                   +(4*(2*alp*a*c+a*d+b*c)*t^2-8*bet*gam*a*t)/(c*t^2-a)^2))) = 0 then
          if testtype(ft, Type::RatExpr(t, Type::IndepOf({t,x}))) then
            userinfo(2, "detected integrand of the form R(x, sqrt(a*x+b), sqrt(c*x+d))");
            integral := intlib::int(ft*
                                    (4*bet*gam*c^2*t^4
                                     -8*(2*alp*a*c+a*d+b*c)*c*t^3
                                     +24*bet*gam*a*c*t^2
                                     -8*(2*alp*a*c+a*d+b*c)*a*t
                                     +4*bet*gam*a^2)/
                                    (c*t^2-a)^3, t, options);
            if integral <> FAIL then
              integral := subs(integral,
                               t=(sqrt(a*x+b)-bet)/(sqrt(c*x+d)-gam));
              traperror((integral := intlib::Simplify(integral, options, Steps=100)),
                         MaxSteps = intlib::simplifyMaxSteps(f, integral, return));
              return(integral);
            end_if;
          end_if;
        end_if;
      end_if;
    end_if;
  end_if;
  FAIL;
end_proc:

