//    
/*++
Cat -- a library of basic category constructors
++*/

domains: // force loading 'domains' 

Cat:= newDomain("Cat"):
Cat::info:= "Library 'Cat': basic category constructors":
Cat::interface:= {
    hold(AbelianGroup),
    hold(AbelianMonoid),
    hold(AbelianSemiGroup),
    hold(Algebra),
    hold(AlgebraWithBasis),
    hold(BaseCategory),
    hold(CancellationAbelianMonoid),
    hold(CommutativeRing),
    hold(DifferentialRing),
    hold(EntireRing),
    hold(EuclideanDomain),
    hold(FactorialDomain),
    hold(Field),
    hold(FiniteCollection),
    hold(GcdDomain),
    hold(Group),
    hold(HomogeneousFiniteCollection),
    hold(HomogeneousFiniteProduct),
    hold(IntegralDomain),
    hold(LeftModule),
    hold(Matrix),
    hold(Module),
    hold(Monoid),
    hold(OrderedSet),
//    hold(OrderedAbelianMonoid),
//    hold(OrderedMonoid),
    hold(PartialDifferentialRing),
    hold(Polynomial),
    hold(PrincipalIdealDomain),
    hold(QuotientField),
    hold(RightModule),
    hold(Ring),
    hold(Rng),
    hold(SemiGroup),
    hold(Set),
    hold(SkewField),
    hold(UnivariatePolynomial),
//    hold(UnivariateSkewPolynomial),
    hold(SquareMatrix),
    hold(VectorSpace)
}:

alias(path = pathname("DOMAINS", "CATEGORY")):

Cat::AbelianGroup:= loadproc(Cat::AbelianGroup, path, "AbGroup"):
Cat::AbelianMonoid:= loadproc(Cat::AbelianMonoid, path, "AbMonoid"):
Cat::AbelianSemiGroup:= loadproc(Cat::AbelianSemiGroup, path, "AbSemGrp"):
Cat::Algebra:= loadproc(Cat::Algebra, path, "Algebra"):

Cat::BaseCategory:= loadproc(Cat::BaseCategory, path, "BaseCat"):
Cat::CancellationAbelianMonoid:= loadproc(Cat::CancellationAbelianMonoid, path, "CanAbMon"):


Cat::CommutativeRing:= loadproc(Cat::CommutativeRing, path, "CommRing"):

Cat::DifferentialRing:= loadproc(Cat::DifferentialRing, path, "DiffRing"):


Cat::EntireRing:= loadproc(Cat::EntireRing, path, "EntRing"):
Cat::EuclideanDomain:= loadproc(Cat::EuclideanDomain, path, "EuclDom"):
Cat::FactorialDomain:= loadproc(Cat::FactorialDomain, path, "FactDom"):
Cat::Field:= loadproc(Cat::Field, path, "Field"):
Cat::FiniteCollection:= loadproc(Cat::FiniteCollection, path, "FinCollC"):
Cat::GcdDomain:= loadproc(Cat::GcdDomain, path, "GcdDom"):

Cat::Group:= loadproc(Cat::Group, path, "Group"):
Cat::HomogeneousFiniteCollection:= loadproc(Cat::HomogeneousFiniteCollection, path, "HFinColC"):
Cat::HomogeneousFiniteProduct:= loadproc(Cat::HomogeneousFiniteProduct, path, "HFiProdC"):

Cat::IntegralDomain:= loadproc(Cat::IntegralDomain, path, "IntegDom"):


Cat::LeftModule:= loadproc(Cat::LeftModule, path, "LeftMod"):
Cat::Matrix:= loadproc(Cat::Matrix, path, "MatCat"):
Cat::Module:= loadproc(Cat::Module, path, "Module"):

Cat::Monoid:= loadproc(Cat::Monoid, path, "Monoid"):

Cat::OrderedSet:= loadproc(Cat::OrderedSet, path, "OrdSet"):
Cat::PartialDifferentialRing:= loadproc(Cat::PartialDifferentialRing, path, "PDiffRng"):

Cat::Polynomial:= loadproc(Cat::Polynomial, path, "PolyCat"):
Cat::PrincipalIdealDomain:= loadproc(Cat::PrincipalIdealDomain, path, "PrIdDom"):
Cat::QuotientField:= loadproc(Cat::QuotientField, path, "QuoField"):
Cat::RightModule:= loadproc(Cat::RightModule, path, "RightMod"):
Cat::Ring:= loadproc(Cat::Ring, path, "Ring"):
Cat::Rng:= loadproc(Cat::Rng, path, "Rng"):
Cat::SemiGroup:= loadproc(Cat::SemiGroup, path, "SemiGrp"):
Cat::Set:= loadproc(Cat::Set, path, "Set"): 
Cat::SkewField:= loadproc(Cat::SkewField, path, "SkewFld"):

Cat::SquareMatrix:= loadproc(Cat::SquareMatrix, path, "SqMatCat"):
Cat::UnivariatePolynomial:= loadproc(Cat::UnivariatePolynomial, path, "UPolyCat"):
Cat::UnivariateSkewPolynomial:= loadproc(Cat::UnivariateSkewPolynomial, path, "OrePolyC"):

Cat::VectorSpace:= loadproc(Cat::VectorSpace, path, "Vspace"):

null():

// end of file 
