//    
/*++
Dom -- a library of basic domain constructors
++*/

domains: // force loading 'domains' 

Dom:= newDomain("Dom"):
Dom::info:= "Library 'Dom': basic domain constructors":
Dom::interface:= {
    hold(BaseDomain),
    hold(Expression),
    hold(ArithmeticalExpression),
    hold(Numerical),
    hold(Float),
    hold(FloatIV),
    hold(Rational),
    hold(Natural),
    hold(Integer),
    hold(IntegerMod),
    hold(ExpressionField),
    hold(Fraction),
    hold(Polynomial),
    hold(DistributedPolynomial),
    hold(Product),
    hold(/*Sparse*/Matrix),
    hold(DenseMatrix),
    hold(SquareMatrix),
    hold(AlgebraicExtension),
    hold(Interval),
    hold(GaloisField),
    hold(ImageSet),
    hold(Natural),
    hold(Multiset),
    hold(MatrixGroup),
    hold(SymmetricGroup),
    hold(DihedralGroup),
    hold(Real),
    hold(Complex),
    hold(Quaternion),
    hold(MultivariatePolynomial),
    hold(UnivariatePolynomial),
//    hold(UnivariateSkewPolynomial),
    hold(LinearOrdinaryDifferentialOperator),
    hold(SparseMatrixF2),
                  hold(MonomOrdering),
    //hold(Utilities::IntModInverse), // utility, not to be documented
      null()
}:

alias(path = pathname("DOMAINS", "DOMAIN")):

Dom::BaseDomain:= loadproc(Dom::BaseDomain, path, "BaseDom"):
Dom::Expression:= loadproc(Dom::Expression, path, "Expr"):
Dom::ArithmeticalExpression:= loadproc(Dom::ArithmeticalExpression, path, "AritExpr"):
Dom::Numerical:= loadproc(Dom::Numerical, path, "Numeric"):
Dom::Float:= loadproc(Dom::Float, path, "Float"):
Dom::FloatIV := loadproc(Dom::FloatIV, path, "FloatIV"):
Dom::Rational:= loadproc(Dom::Rational, path, "Rational"):
autoload(Dom::Natural):
Dom::Integer:= loadproc(Dom::Integer, path, "Integer"):
Dom::IntegerMod:= loadproc(Dom::IntegerMod, path, "IntMod"):
Dom::ExpressionField:= loadproc(Dom::ExpressionField, path, "ExprFld"):
Dom::Fraction:= loadproc(Dom::Fraction, path, "Fraction"):
Dom::Polynomial:= loadproc(Dom::Polynomial, path, "Polynom"):
Dom::DistributedPolynomial:=
      loadproc(Dom::DistributedPolynomial, path, "DistPoly"):
Dom::Product:= loadproc(Dom::Product, path, "Product"):
Dom::DenseMatrix:= loadproc(Dom::DenseMatrix, path, "DenseMatrix"):
Dom::SquareMatrix:= loadproc(Dom::SquareMatrix, path, "SqMatrix"):

Dom::AlgebraicExtension:= loadproc(Dom::AlgebraicExtension, path, "AlgebExt"):
Dom::Interval:= loadproc(Dom::Interval, path, "Interval"):
Dom::GaloisField:= loadproc(Dom::GaloisField, path, "GaloisF"):
Dom::SubSet:= loadproc(Dom::SubSet, path, "SubSet"):
Dom::ImageSet:= loadproc(Dom::ImageSet, path, "ImageSet"):
Dom::Multiset:= loadproc(Dom::Multiset, path, "Multiset"):
Dom::MatrixGroup:= loadproc(Dom::MatrixGroup, path, "Mat"):

Dom::DihedralGroup:= loadproc(Dom::DihedralGroup, path, "Dihedral"):
Dom::SymmetricGroup:= loadproc(Dom::SymmetricGroup, path, "SymmetricGroup"):

Dom::Real:= loadproc(Dom::Real, path, "Real"):
Dom::Complex:= loadproc(Dom::Complex, path, "Complex"):
Dom::Quaternion:= loadproc(Dom::Quaternion, path, "Quatern"):
Dom::MultivariatePolynomial:= loadproc(Dom::MultivariatePolynomial,path,"MultPoly"):
Dom::UnivariatePolynomial:=loadproc(Dom::UnivariatePolynomial,path,"UniPoly"):
Dom::UnivariateSkewPolynomial:= loadproc(Dom::UnivariateSkewPolynomial,path,"OrePoly"):
Dom::LinearOrdinaryDifferentialOperator:= loadproc(Dom::LinearOrdinaryDifferentialOperator,path,"Lodo"):
Dom::/*Sparse*/Matrix:=loadproc(Dom::/*Sparse*/Matrix,path,"Matrix"):
Dom::SparseMatrixOld:=loadproc(Dom::SparseMatrixOld,path,"Sparse"):
Dom::SparseMatrixF2:=loadproc(Dom::SparseMatrixF2, path, "SparseF2"):
Dom::PseudoTensor:=loadproc(Dom::PseudoTensor, path, "PseudoTensor"):

Dom::MonomOrdering:=loadproc(Dom::MonomOrdering, path, "MonomOrd"):
// Utilities
Dom::Utilities:= loadproc(Dom::Utilities, path, "Utilities"):

null():

// end of file 
