//   

// rules for 'simplify'
// 
// bij 2000/2001
// 
// Rule (internal parameters)
// 
//        PATTERN      - pattern (DOM_EXPR)
//        RESULT       - return expression (DOM_EXPR)
//        COND         - conditions (DOM_SET)
//                       set containing procedures or expressions (see match)
//        STRATEGY     - a table of eq.
//                       strategyname = priority


// examples
// Rule(sin(X)^2 + cos(X)^2, 1)
//
//

Rule:= newDomain("Rule"):
Rule::create_dom:=hold(Rule):

alias(ARGS = hold(["pattern", "result", "cond", "strategy"])):

Rule::DEBUG := FALSE:

Rule::new:=
  proc(PATTERN, RESULT, COND = {}, // :DOM_SET|DOM_PROC
       STRATEGY = table())         //: DOM_TABLE
    local ret;
  begin
    if testargs() then
      if args(0) < 1 then
        error("at least one expression required")
      end_if
    end_if;
    sysassign(Rule::COUNT, Rule::COUNT + 1);
    if testtype(PATTERN, Type::Function) then
      // procedure
      if testargs() then
        // 
      end_if;
      ret := new(Rule, PATTERN, FAIL,
                       (if args(0) > 1 then RESULT else {} end_if),
                       (if args(0) > 2 then COND else table() end_if))
    else
      // match rule
      if testargs() then
        if args(0) < 2 then
          error("at least two expressions required")
        end_if
      end_if;
      ret := new(Rule, PATTERN, RESULT, COND, STRATEGY)
    end_if;
    %if Rule::DEBUG = TRUE then
       if contains(Rule::VAL, ret) and Rule::result(ret) <> FAIL then
         // only for matching rules
         warning("rule exists: ".expr2text(ret))
       end_if;
     end_if;//%end
    sysassign(Rule::VAL[ret], [1, 0, 0, 0]);
    ret
  end_proc:

Rule::COUNT:= 0:

proc()
  local k;
begin
// create 4 similar procedures
//   from alias 'ARGS' for each parameter of a rule 
for k from 1 to nops(ARGS) do
  slot(Rule, op(ARGS, k)):=
  subsop(proc(RULE, VALUE = null())
         begin
           if VALUE = null() then // get
             extop(RULE, FAIL)
           else // set
             extsubsop(RULE, FAIL = VALUE)
           end_if
         end_proc, [4, 2, 2] = k, [4, 3, 2, 1] = k, Unsimplified)
end_for:
end():

Rule::VAL := table():

// priority: liefert die erwartete Komplexitaet des Ergebnisses
Rule::priority:=
proc(RULE, strat, valuation)
  local m;
  //option remember;
begin
  if contains(Rule::strategy(RULE), strat) then
    Rule::strategy(RULE)[strat]
  elif contains(Rule::strategy(RULE), "Default") then
    Rule::strategy(RULE)["Default"]
  elif contains(Rule::VAL, RULE) then
    Rule::VAL[RULE][1]
  else
    m := max(valuation(Rule::result(RULE))/valuation(Rule::pattern(RULE)), 0.5);
    //Rule::strategy(RULE, table("Default" = m, Rule::strategy(RULE)));
    // initialization of Rule::VAL[RULE]
    sysassign(Rule::VAL[RULE], [float(m), 1]);
//fprint(0, ">>", RULE = m);
    m
  end_if
end_proc:

// apply rule
// ARGS: RULE, EXPRESSION
Rule::apply:=
  proc(RULE : Rule, EXPRESSION)
    local MATCH;
  begin
    // special case - strange procedure
    /*if not domtype(RULE) = Rule then
      return(RULE(EXPRESSION))
    el*/
    if Rule::result(RULE) = FAIL then
      // procedure
      if Rule::cond(RULE) = {} or
        Rule::cond(RULE)(EXPRESSION) = TRUE then
        return(Rule::pattern(RULE)(EXPRESSION))
      end_if
    elif domtype(Rule::pattern(RULE)) = DOM_IDENT then
      // no match, the pattern is an identifier
      if Rule::cond(RULE) = {} or
        Rule::cond(RULE)(EXPRESSION) = TRUE then
        return(subs(Rule::result(RULE), Rule::pattern(RULE) = EXPRESSION, EvalChanges))
      end_if
    elif (MATCH:= match(EXPRESSION, Rule::pattern(RULE),
                        hold(Cond) = Rule::cond(RULE))) <> FAIL then
      %if Rule::DEBUG = TRUE then
        sysassign(Rule::VAL[RULE], zip(Rule::VAL[RULE], [0, 0, 1, 0], _plus))
      end_if;//%end
      return(eval(subs(Rule::result(RULE), MATCH)))
    end_if;
    %if Rule::DEBUG = TRUE then
      sysassign(Rule::VAL[RULE], zip(Rule::VAL[RULE], [0, 0, 0, 1], _plus))
    end_if;//%end
    FAIL
  end_proc:

Rule::print:=
  proc(RULE)
    local printPattern;
  begin
    printPattern:=
    proc(R)
    begin
      if domtype(R) = DOM_PROC then
        if op(R, 6) <> NIL then
          op(R, 6)
        else
          stdlib::Exposed(DOM_PROC::print(R))
        end_if  
      elif domtype(R) = DOM_FUNC_ENV then
        printPattern(op(R, 1))
      else
        R
      end_if
    end_proc;
    
    _outputSequence(
       if Rule::result(RULE) = FAIL then
          //"X --> ".
         printPattern(Rule::pattern(RULE)), stdlib::Exposed("(X)")
       else
         Rule::pattern(RULE), stdlib::Exposed(" ==> "), Rule::result(RULE)
       end_if,
       if Rule::cond(RULE) <> {} then
        stdlib::Exposed(" if "),  Rule::cond(RULE)
      else
        null()
      end_if,
      if Rule::strategy(RULE) <> table() then
        stdlib::Exposed("   Strategy: "), Rule::strategy(RULE)
      else
        null()
      end_if)
  end_proc:

// the print output is not parseable, we need an expr2text method
Rule::expr2text :=
proc(RULE)
begin
  _concat("Rule(",
          expr2text(Rule::pattern(RULE)), 
          if Rule::result(RULE) <> FAIL then ", ", expr2text(Rule::result(RULE)) end_if,
          if Rule::cond(RULE) <> {} then ", ", expr2text(Rule::cond(RULE)) end,
          if Rule::strategy(RULE) <> table() then ", ", expr2text(Rule::strategy(RULE)) end,          
          ")")
end_proc:
  
Rule::Content:=
  proc(Out, RULE)
    local pat;
  begin
    pat:= Rule::pattern(RULE);
    _outputSequence(
       if Rule::result(RULE) = FAIL then
          //"X --> ".
         if domtype(pat) = DOM_PROC then
           hold(``).DOM_PROC::print(pat)
         elif domtype(pat) = DOM_FUNC_ENV and domtype(op(pat, 1)) = DOM_PROC then
           hold(``).DOM_PROC::print(op(pat, 1))
         else
           pat
         end_if, hold(`(X)`)
       else
         pat, hold(`&Rightarrow;`), Rule::result(RULE)
       end_if,
       if Rule::cond(RULE) <> {} then
        hold(` if `),  Rule::cond(RULE)
      else
        null()
      end_if,
      if Rule::strategy(RULE) <> table() then
        hold(`   Strategy: `), Rule::strategy(RULE)
      else
        null()
      end_if);
    Out(%)
  end_proc:


// rules moved to Simplify::MatchRules

null():
