Symbol := newDomain("Symbol"):
Symbol::info := "Symbol -- typesetting symbols":


/* we define some lists of symols of different type */
Symbol::GreekLetters :=
[
 hold(alpha),
 hold(beta),
 hold(gamma),
 hold(delta),
 [hold(epsi),
  hold(epsilon)],
 [hold(varepsilon),
 hold(epsiv)],
 hold(zeta),
 hold(eta),
 hold(theta),
 [hold(thetasym),
 hold(thetav),
 hold(vartheta)],
 hold(iota),
 hold(kappa),
 hold(lambda),
 [hold(mu),
  hold(micro)],
 hold(nu),
 hold(xi),
 hold(omicron),
 hold(pi),
 [hold(varpi),
 hold(piv)],
 hold(rho),
 hold(sigma),
 [hold(sigmaf),
 hold(sigmav),
 hold(varsigma)],
 hold(tau),
 [hold(upsilon),
 hold(upsi)],
 [hold(straightphi),
 hold(phi)],
 [hold(phiv),
 hold(varphi)],
 hold(chi),
 hold(psi),
 hold(omega),
 
 hold(Alpha),
 hold(Beta),
 hold(Gamma),
 hold(Delta),
 [hold(Epsi),
  hold(Epsilon)],
 hold(Zeta),
 hold(Eta),
 hold(Theta),
 hold(Iota),
 hold(Kappa),
 hold(Lambda),
 hold(Mu),
 hold(Nu),
 hold(Xi),
 hold(Omicron),
 hold(Pi),
 hold(Rho),
 hold(Sigma),
 hold(Tau),
 [hold(Upsi),
  hold(upsih),
  hold(Upsilon)],
 hold(Phi),
 hold(Chi),
 hold(Psi),
 [hold(Omega),
  hold(ohm)],
 null()
 ]:

Symbol::Arrows :=
[
 [hold(uarr),
  hold(UpArrow)],
 [hold(Uparrow),
  hold(DoubleUpArrow),
  hold(uArr)],

 [hold(darr),
  hold(DownArrow)],
 [hold(Downarrow),
  hold(dArr),
  hold(DoubleDownArrow)],
 
 [hold(LeftArrow),
  hold(larr), //  consistent with rarr
  hold(leftarrow)],
 [hold(DoubleLeftArrow),
  hold(Leftarrow),
 hold(lArr)],

 [hold(leftrightarrow),
 hold(harr),
 hold(LeftRightArrow)],
 [hold(Leftrightarrow),
  hold(DoubleLeftRightArrow),
  hold(iff),
  hold(hArr)],

 [hold(RightArrow),
  hold(rarr), //   prob with generate::TeX
  hold(rightarrow)],
 [hold(Rightarrow),
  hold(Implies),
  hold(rArr),
  hold(DoubleRightArrow)],
 hold(ldsh),
 null()
 ]:

Symbol::OpenFaceLetters :=
[
 hold(Aopf),
 hold(Bopf),
 hold(Copf),
 hold(Dopf),
 hold(Eopf),
 hold(Fopf),
 hold(Gopf),
 hold(Hopf),
 hold(Iopf),
 hold(Jopf),
 hold(Kopf),
 hold(Lopf),
 hold(Mopf),
 hold(Nopf),
 hold(Oopf),
 hold(Popf),
 hold(Qopf),
 hold(Ropf),
 hold(Sopf),
 hold(Topf),
 hold(Uopf),
 hold(Vopf),
 hold(Wopf),
 hold(Xopf),
 hold(Yopf),
 hold(Zopf)
 ]:

Symbol::Operators :=
[
 hold(plus),
 hold(`minus`),
 [hold(PlusMinus),
  hold(plusmn),
  hold(pm)],
 hold(times),
 [hold(Hat),
  hold(circ)],
 hold(dot),
 hold(prod),
 [hold(coprod),
  hold(Coproduct),
  hold(amalg)],
 hold(ast),
 hold(lowast),
 [hold(bull),
 hold(bullet)],
 [hold(cdot),
 hold(middot),
 hold(CenterDot),
 hold(centerdot)],
 [hold(cir),
  hold(compfn),
  hold(SmallCircle)],
 hold(deg),
 hold(oplus),
 hold(otimes),
 [hold(CirclePlus),
  hold(bigoplus),
  hold(xoplus)],
 [hold(CircleTimes),
  hold(bigotimes),
  hold(xotime)],
 [hold(bigodot),
  hold(xodot),
  hold(CircleDot)],
 hold(dagger),
 hold(Dagger),
 hold(Del),
 [hold(`div`),
  hold(divide)],
 [hold(Backslash),
  hold(setminus),
  hold(setmn),
  hold(bsol)], 
 [hold(Element),
 hold(isin),
 hold(isinv),
 hold(`in`)],
 [hold(`or`),
  hold(vee)],
 [hold(wedge),
  hold(`and`)],
 [hold(Vee),
  hold(bigvee),
  hold(xvee)],
 [hold(Wedge),
  hold(xwedge),
  hold(bigwedge),
  hold(And)],
 hold(cap),
 hold(cup),
 [hold(Intersection),
  hold(bigcap),
  hold(xcap)],
 [hold(xcup),
  hold(bigcup),
  hold(Union)],
 [hold(biguplus),
  hold(xuplus),
  hold(UnionPlus)],
 [hold(bigsqcup),
  hold(xsqcup),
  hold(SquareUnion)],
 null()
 ]:

Symbol::ComparisonOperators :=
[
 [hold(ap),
  hold(approx),
  hold(asymp),
  hold(TildeTilde)],
 [hold(tilde),
  hold(Tilde),
  hold(sim)],
 [hold(TildeFullEqual),
  hold(cong)],
 [hold(bot),
  hold(bottom),
  hold(UpTee),
  hold(perp)],
 [hold(Congruent),
  hold(equiv)],
 [hold(Equal),
  hold(equals)],
 [hold(ge),
  hold(geq),
  hold(GreaterEqual)],
 hold(gt),
 [hold(le),
  hold(leq)],
 [hold(NotEqual),
  hold(ne)],
 hold(lt),
 [hold(Subset),
  hold(sub),
  hold(`subset`)],
 [hold(subseteq),
  hold(sube),
  hold(SubsetEqual)],
 [hold(Superset),
  hold(sup),
  hold(supset)],
 [hold(SupersetEqual),
  hold(supe),
  hold(supseteq)],
 [hold(NotElement),
  hold(notin)],
 [hold(NotSubset),
  hold(nsub),
  hold(nsubset),
  hold(vnsub)],
 null()
 ]:

Symbol::Other :=
[
 hold(brvbar),
 [hold(UnderBar),
  hold(UnderLine),
  hold(lowbar)],
 hold(OverBar),
 [hold(num),
  hold(sharp)],
 hold(amp),
 hold(true),
 hold(false),
 hold(`UNKNOWN`),
 hold(`NIL`),
 hold(`FAIL`),
 hold(NULL),
 hold(NotANumber),
 [hold(CapitalDifferentialD),
 hold(D),
 hold(DD)],
 [hold(PartialD),
  hold(part)],
 [hold(DifferentialD),
 hold(dd)],
 hold(commat),
 hold(copy),
 hold(trade),
 hold(reg),
 [hold(die),
 hold(uml)],
 [hold(diam),
 hold(diams),
 hold(diamond),
 hold(diamondsuit)],
 [hold(hearts),
 hold(heartsuit)],
 [hold(spades),
  hold(spadesuit)],
 hold(clubs),
 hold(`E`),
 hold(`I`),
 [hold(half),
  hold(frac12)],
 hold(frac14),
 hold(frac34),
 hold(sup1),
 hold(sup2),
 hold(sup3),
 hold(para),
 hold(permil),
 [hold(percnt),
  hold(percent)],
 hold(sect),
 null()
 ]:

Symbol::WhiteSpaces :=
[
 hold(ApplyFunction),
 hold(InvisibleComma),
 hold(InvisibleTimes),
 hold(Tab),
 hold(blank),
 hold(MediumSpace),
 hold(Space),
 hold(ThickSpace),
 hold(NonBreakingSpace),
 null()
 ]:

Symbol::Braces :=
[
 [hold(lang),
  hold(langle),
  hold(LeftAngleBracket)],
 [hold(lbrace),
 hold(lcub)],
 [hold(lbrack),
 hold(lsqb)],
 [hold(lceil),
  hold(LeftCeiling)],
 [hold(LeftFloor),
  hold(lfloor)],
 hold(lpar),
 
 [hold(verbar),
  hold(vert)],
 [hold(Verbar),
  hold(Vert)],

 hold(rpar),
 [hold(rfloor),
  hold(RightFloor)],
 [hold(rceil),
  hold(RightCeiling)],
 [hold(rsqb),
  hold(rbrack)],
 [hold(rbrace),
  hold(rcub)],
 [hold(rang),
  hold(rangle),
  hold(RightAngleBracket)],
 null()
 ]:

Symbol::PunctuationMarks :=
[
 hold(Colon),
 hold(colon),
 hold(comma),
 hold(semi),
 hold(period),
 hold(sdot),
 [hold(Dot),
  hold(DoubleDot)],
 [hold(hellip),
  hold(tdot),
  hold(dots)],
 hold(cdots),
 [hold(horbar),
  hold(mdash)],
 [hold(hyphen),
  hold(ndash)],
 [hold(apos),
  hold(quot),
  hold(rsquo)],
  hold(prime),
 [hold(backprime),
  hold(bprime)],
 [hold(lsquor),
  hold(sbquo)],
 [hold(lsquo),
  hold(OpenCurlyQuote)],
 [hold(ldquor),
  hold(bdquo)],
 [hold(ldquo),
 hold(OpenCurlyDoubleQuote)],
 
 [hold(rsquor),
  hold(CloseCurlyQuote)],
 [hold(Prime),
  hold(rdquo)],
 [hold(rdquor),
  hold(CloseCurlyDoubleQuote)],
 
 hold(laquo),
 hold(raquo),
 hold(excl),
 hold(iexcl),
 hold(quest),
 hold(iquest),
 null()
 ]:

Symbol::Umlauts :=
[
 hold(auml),
 hold(Auml),
 hold(ouml),
 hold(Ouml),
 hold(uuml),
 hold(Uuml),
 hold(szlig),
 null()
 ]:

Symbol::Currency :=
[
 hold(cent),
 hold(dollar),
 hold(euro),
 hold(pound),
 hold(yen),
 null()
 ]:

Symbol::MathSymbols :=
[
 hold(nabla),
 [hold(vprop),
  hold(varpropto),
  hold(vprop)],
 [hold(weierp),
  hold(wp)],
 hold(`not`),
 [hold(aleph),
  hold(alefsym)],
 [hold(loz),
  hold(lozenge)],
 [hold(Sqrt),
  hold(radic)],
 [hold(Sum),
  hold(sum)],
 [hold(int),
  hold(Integral)],
 [hold(conint),
  hold(oint),
  hold(ContourIntegral)],
 [hold(cauchypv),
  hold(pvint),
  hold(PrincipalValueIntegral)],
 [hold(there4),
  hold(Therefore),
  hold(therefore)],
 [hold(exist),
  hold(Exists)],
 [hold(ForAll),
  hold(forall)],
 hold(infin),
 [hold(emptyv),
  hold(varnothing)],
 [hold(ang),
 hold(angle)],
 hold(Re),
 hold(real),
 [hold(Im),
 hold(image)],
 [hold(ee),
  hold(ExponentialE)],
 [hold(ImaginaryI),
  hold(ii)],
 null()
]:


Symbol::symbols :=
map({
     op(Symbol::GreekLetters),
     op(Symbol::OpenFaceLetters),
     op(Symbol::Arrows),
     op(Symbol::Operators),
     op(Symbol::ComparisonOperators),
     op(Symbol::Other),
     op(Symbol::WhiteSpaces),
     op(Symbol::Braces),
     op(Symbol::PunctuationMarks),
     op(Symbol::Umlauts),
     op(Symbol::Currency),
     op(Symbol::MathSymbols)
     }, op):




Symbol::interface := Symbol::symbols union
{hold(subScript), hold(superScript), hold(subSuperScript), 
 hold(accentPrime), hold(accentAsterisk), hold(accentTilde),
 hold(accentHat), hold(accentRightArrow),
 hold(accentDot), hold(accentDoubleDot), hold(accentTripleDot),
 hold(accentUnderBar), hold(accentOverBar), hold(all)}:
Symbol::keywords := Pref::keywords():
Symbol::interface := select(level(Symbol::interface, 1),
                            x -> not contains(Symbol::keywords, expr2text(x))):
sysdelete(Symbol::keywords):

Symbol::accentPrime      := proc(x : DOM_IDENT) begin x.hold(`&prime;`) end:
Symbol::accentAsterisk   := proc(x : DOM_IDENT) begin x.hold(`&ast;`) end:
Symbol::accentTilde      := proc(x : DOM_IDENT) begin x.hold(`&tilde;`) end:
Symbol::accentHat        := proc(x : DOM_IDENT) begin x.hold(`&circ;`) end:
Symbol::accentRightArrow := proc(x : DOM_IDENT) begin x.hold(`&rarr;`) end:
Symbol::accentDot        := proc(x : DOM_IDENT) begin x.hold(`&dot;`) end:
Symbol::accentDoubleDot  := proc(x : DOM_IDENT) begin x.hold(`&die;`) end:
Symbol::accentTripleDot  := proc(x : DOM_IDENT) begin x.hold(`&tdot;`) end:
Symbol::accentOverBar    := proc(x : DOM_IDENT) begin x.hold(`&OverBar;`) end:
Symbol::accentUnderBar   := proc(x : DOM_IDENT) begin x.hold(`&UnderBar;`) end:

// utility function: when receiving strings,
// the functions below should return something rendering the string faithfully,
// including all the {}_$^& characters
Symbol::escapeString :=
str -> stringlib::subs(str,
  "&" = "&amp;",
  "{" = "&lbrace;",
  "}" = "&rbrace;",
  "_" = "{&UnderBar;}",
  "^" = "{&circ;}",
  "$" = "&dollar;"):

Symbol::subScript :=
proc(x, y)
begin
  if args(0) <> 2 then
    error("2 arguments expected")
  end_if;
  if x::dom = DOM_STRING then
    x := Symbol::escapeString(x);
  end_if;
  if y::dom = DOM_STRING then
    y := Symbol::escapeString(y);
  end_if;
  x := hold(``).x;  y := hold(``).y;
  hold(`{`).x.hold(`}_{`).y.hold(`}`)
end:
Symbol::superScript :=
proc(x, y)
begin
  if args(0) <> 2 then
    error("2 arguments expected")
  end_if;
  if x::dom = DOM_STRING then
    x := Symbol::escapeString(x);
  end_if;
  if y::dom = DOM_STRING then
    y := Symbol::escapeString(y);
  end_if;
  x := hold(``).x;  y := hold(``).y;
  hold(`{`).x.hold(`}^{`).y.hold(`}`)
end:
Symbol::subSuperScript :=
proc(x, y, z)
begin
  if args(0) <> 3 then
    error("3 arguments expected")
  end_if;
  if x::dom = DOM_STRING then
    x := Symbol::escapeString(x);
  end_if;
  if y::dom = DOM_STRING then
    y := Symbol::escapeString(y);
  end_if;
  if z::dom = DOM_STRING then
    z := Symbol::escapeString(z);
  end_if;
  x := hold(``).x;  y := hold(``).y;  z := hold(``).z;
  hold(`{`).x.hold(`}${`).y.hold(`}{`).z.hold(`}`)
end:


// initialise slots
(() -> map(Symbol::symbols, s -> slot(Symbol, "".expr2text(s), hold(`&`).expr2text(s).hold(`;`))))():

Symbol::cdots := `&cdot;&cdot;&cdot;`:
Symbol::symbols := Symbol::symbols minus {hold(cdots)}:

// allow Symbol(string) for keywords
Symbol::new :=x -> slot(dom, x):
Symbol::all := () -> (map(DOM_SET::sort(map(Symbol::symbols, expr2text)), 
                         x -> print(Typeset, hold(Symbol)(x) = hold(`&`).x.hold(`;`)));
                       null()):

