// linalg.mu  --  the linear algebra library

linalg := newDomain("linalg"):
linalg::create_dom:=hold(linalg):
linalg::info := "Library 'linalg': the linear algebra package":
linalg::interface := {
    hold(matlinsolve), hold(gaussElim), hold(companion),
    hold(det), hold(permanent), hold(rank), hold(concatMatrix),
    hold(cond),
    hold(stackMatrix), hold(swapCol), hold(swapRow),
    hold(nrows), hold(ncols), hold(matdim), hold(gaussJordan),
    hold(delRow), hold(delCol), hold(transpose), hold(htranspose),
    hold(row), hold(col), hold(sylvester), hold(hessian),
    hold(setRow), hold(setCol), hold(nonZeros), hold(angle),
    hold(scalarProduct), hold(crossProduct), hold(tr),
    hold(expr2Matrix), hold(vecdim), hold(charmat),
    hold(charpoly), hold(addRow), hold(addCol),
    hold(multRow), hold(multCol), hold(adjoint), hold(factorQR),
    hold(orthog), hold(nullspace), hold(normalize),
    hold(isUnitary), hold(grad), hold(divergence), hold(curl),
    hold(potential),
    hold(vectorPotential), hold(ogCoordTab), hold(isHermitean),
    hold(submatrix), hold(randomMatrix), hold(jacobian),
    hold(eigenvalues), hold(isPosDef), hold(factorCholesky),
    hold(jordanForm), hold(eigenvectors), hold(hermiteForm),
    hold(basis), hold(sumBasis), hold(intBasis), hold(pseudoInverse),
    hold(factorLU), hold(matlinsolveLU), hold(inverseLU),
    hold(wiedemann), hold(hessenberg), hold(substitute),
    hold(minpoly), hold(smithForm), hold(frobeniusForm),
    hold(laplacian), hold(kroneckerProduct),
    hold(hilbert), hold(invhilbert),
    hold(pascal), hold(invpascal),
    hold(vandermonde), hold(invvandermonde), hold(vandermondeSolve),
    hold(toeplitz),
    hold(toeplitzSolve),
    hold(vectorOf)
}:

alias(path = pathname("LINALG"));

linalg::cond :=  loadproc( linalg::cond, path, "cond" ):
linalg::companion:= loadproc( linalg::companion, path, "companion" ):
linalg::factorLU:= loadproc( linalg::factorLU, path, "factorLU" ):
linalg::matlinsolveLU:= loadproc( linalg::matlinsolveLU, path, "lsolvLU" ):
linalg::inverse:= loadproc( linalg::inverse, path, "inverse" ):
linalg::inverseOverField:= loadproc( linalg::inverseOverField, path, "inverseOverField" ):
linalg::inverseLU:= loadproc( linalg::inverseLU, path, "invLU" ):
linalg::ogCoordTab:= loadproc( linalg::ogCoordTab, path, "ogsystab" ):
linalg::potential:= loadproc( linalg::potential, path, "potential" ):
linalg::vectorPotential:= loadproc( linalg::vectorPotential, path, "vecpot" ):
linalg::grad:= loadproc( linalg::grad, path, "grad" ):
linalg::hessian:= loadproc( linalg::hessian, path, "hessian" ):
linalg::divergence:= loadproc( linalg::divergence, path, "diverge" ):
linalg::curl:= loadproc( linalg::curl, path, "curl" ):
linalg::isUnitary:= loadproc( linalg::isUnitary, path, "isorthog" ):
linalg::normalize:= loadproc( linalg::normalize, path, "normaliz" ):
linalg::vectorOf:= loadproc( linalg::vectorOf, path, "VectorOf" ):
linalg::charmat:= loadproc( linalg::charmat, path, "charmat" ):
linalg::charpoly:= loadproc( linalg::charpoly, path, "charpoly" ):
linalg::minpoly:= loadproc( linalg::minpoly, path, "minpoly" ):
linalg::vecdim:= loadproc( linalg::vecdim, path, "vectdim" ):
linalg::gaussElim:= loadproc( linalg::gaussElim, path, "gausElim" ):
linalg::gaussJordan:= loadproc( linalg::gaussJordan, path, "gausJord" ):
linalg::det:= loadproc( linalg::det, path, "det" ):
linalg::permanent:= loadproc( linalg::permanent, path, "perman"):
linalg::rank:= loadproc( linalg::rank, path, "rank" ):
linalg::adjoint:= loadproc( linalg::adjoint, path, "adjoint" ):
linalg::laplacian:= loadproc( linalg::laplacian, path, "laplacian" ):
linalg::matlinsolve:= loadproc( linalg::matlinsolve, path, "matlinsol" ):
linalg::concatMatrix:= loadproc( linalg::concatMatrix, path, "concat" ):
linalg::stackMatrix:= loadproc( linalg::stackMatrix, path, "stack" ):
linalg::swapCol:= loadproc( linalg::swapCol, path, "swapcol" ):
linalg::swapRow:= loadproc( linalg::swapRow, path, "swaprow" ):
linalg::transpose:= loadproc( linalg::transpose, path, "transpos" ):
linalg::htranspose:= loadproc( linalg::htranspose, path, "htranspose" ):
linalg::matdim:= loadproc( linalg::matdim, path, "matdim" ):
linalg::nrows:= loadproc( linalg::nrows, path, "nrows" ):
linalg::ncols:= loadproc( linalg::ncols, path, "ncols" ):
linalg::row:= loadproc( linalg::row, path, "row" ):
linalg::col:= loadproc( linalg::col, path, "col" ):
linalg::addRow:= loadproc( linalg::addRow, path, "addrow" ):
linalg::addCol:= loadproc( linalg::addCol, path, "addcol" ):
linalg::multRow:= loadproc( linalg::multRow, path, "mulrow" ):
linalg::multCol:= loadproc( linalg::multCol, path, "mulcol" ):
linalg::delRow:= loadproc( linalg::delRow, path, "delrow" ):
linalg::delCol:= loadproc( linalg::delCol, path, "delcol" ):
linalg::setRow:= loadproc( linalg::setRow, path, "setrow" ):
linalg::setCol:= loadproc( linalg::setCol, path, "setcol" ):
linalg::sylvester:= loadproc( linalg::sylvester, path, "sylv" ):
linalg::bezout:= loadproc(linalg::bezout, path, "bezout"):
linalg::nonZeros:= loadproc( linalg::nonZeros, path, "nonZeros" ):
linalg::angle:= loadproc( linalg::angle, path, "angle" ):
linalg::crossProduct:= loadproc( linalg::crossProduct, path, "crossmul" ):
linalg::scalarProduct:= loadproc( linalg::scalarProduct, path, "scmult" ):
linalg::tr:= loadproc( linalg::tr, path, "tr" ):
linalg::expr2Matrix:= loadproc( linalg::expr2Matrix, path, "expr2mat" ):
linalg::basis:= loadproc( linalg::basis, path, "basis" ):
linalg::sumBasis:= loadproc( linalg::sumBasis, path, "sumBasis" ):
linalg::intBasis:= loadproc( linalg::intBasis, path, "intBasis" ):
linalg::factorQR:= loadproc( linalg::factorQR, path, "factorQR" ):
linalg::orthog:= loadproc( linalg::orthog, path, "orthog" ):
linalg::nullspace:= loadproc( linalg::nullspace, path, "nulspace" ):
linalg::isHermitean:= loadproc( linalg::isHermitean, path, "isherm" ):
linalg::submatrix:= loadproc( linalg::submatrix, path, "submat" ):
linalg::randomMatrix:= loadproc( linalg::randomMatrix, path, "randmat" ):
linalg::jacobian:= loadproc( linalg::jacobian, path, "jacobian" ):
linalg::eigenvalues:= loadproc( linalg::eigenvalues, path, "eigenval" ):
linalg::factorCholesky:= loadproc( linalg::factorCholesky, path, "factorCh" ):
linalg::ffG:= loadproc( linalg::ffG, path, "ffG" ):
linalg::ffGaussJordan:= loadproc( linalg::ffGaussJordan, path, "ffGaussJordan" ):
linalg::isPosDef:= loadproc( linalg::isPosDef, path, "isposdef" ):
linalg::jordanForm:= loadproc( linalg::jordanForm, path, "jordForm" ):
linalg::eigenvectors:= loadproc( linalg::eigenvectors, path, "eigenvec"):
linalg::eigenvectorsRational:= loadproc(linalg::eigenvectorsRational, path,
                                        "eigenvectorsRational"):
linalg::polynomializeMatrix:= loadproc(linalg::polynomializeMatrix, path, "polynomializeMatrix"):
linalg::rationalizeMatrix:= loadproc(linalg::rationalizeMatrix, path, "rationalizeMatrix"):
linalg::symbolicEigenvectors:= loadproc(linalg::symbolicEigenvectors, path,
                                        "eigenvectorsSymbolic"):
linalg::symbolicity:= loadproc(linalg::symbolicity, path, "symbolicity"):
linalg::sqrtMatrix:= loadproc(linalg::sqrtMatrix, path, "sqrtMatrix"):

linalg::hermiteForm:= loadproc( linalg::hermiteForm, path, "hermite"):
linalg::wiedemann:= loadproc( linalg::wiedemann, path, "wiedeman"):
linalg::pseudoInverse:= loadproc( linalg::pseudoInverse, path, "pseudinv"):

linalg::hilbert:= loadproc( linalg::hilbert, path, "hilbert"):
linalg::invhilbert:= loadproc( linalg::invhilbert, path, "invHilbert"):
linalg::pascal:= loadproc( linalg::pascal, path, "pascal"):
linalg::invpascal:= loadproc( linalg::invpascal, path, "invpascal"):
linalg::toeplitz:= loadproc( linalg::toeplitz, path, "toeplitz"):
linalg::toeplitzSolve:= loadproc( linalg::toeplitzSolve, path, "toeplitzSolve"):
linalg::vandermonde:= loadproc(linalg::vandermonde, path, "vandermonde"):
linalg::invvandermonde:= loadproc( linalg::invvandermonde, path, "invvandermonde"):
linalg::vandermondeSolve:= loadproc( linalg::vandermondeSolve, path, "vandsolv"):

linalg::hessenberg:= loadproc( linalg::hessenberg, path, "hessenber" ):
linalg::substitute:= loadproc( linalg::substitute, path, "substitute" ):
linalg::smithForm:= loadproc( linalg::smithForm, path, "smith" ):
linalg::frobeniusForm:= loadproc( linalg::frobeniusForm, path, "frobenius" ):
linalg::frobeniusFormOzello:= loadproc( linalg::frobeniusFormOzello, path, "frobeniusOzello" ):
linalg::checkForFloats:= loadproc( linalg::checkForFloats, path, "checkForFloats" ):
linalg::floatable:= loadproc( linalg::floatable, path, "floatable" ):
linalg::SSS:= loadproc( linalg::SSS, path, "SSS" ):
linalg::SSS2:= loadproc( linalg::SSS2, path, "SSS2" ):
linalg::SSSGaussJordan:= loadproc( linalg::SSSGaussJordan, path, "SSSGaussJordan" ):
linalg::SSSffGaussJordan:= loadproc( linalg::SSSffGaussJordan, path, "SSSffGaussJordan" ):
linalg::otimes   := loadproc( linalg::otimes, path, "otimes" ):
linalg::otimes_Fu:= loadproc( linalg::otimes_Fu, path, "otimes_Fu" ):
linalg::symbolicAdjoint_Fu:= loadproc(linalg::symbolicAdjoint_Fu, path, "symbolicAdjoint_Fu" ):
linalg::symbolicDet   := loadproc( linalg::symbolicDet,    path, "symbolicDet" ):
linalg::symbolicDet_Fu:= loadproc( linalg::symbolicDet_Fu, path, "symbolicDet_Fu" ):
linalg::symbolicInverse:= loadproc( linalg::symbolicInverse,    path, "symbolicInverse" ):
linalg::symbolicRank:= loadproc( linalg::symbolicRank, path, "symbolicRank" ):
linalg::kroneckerProduct:= loadproc( linalg::kroneckerProduct, path, "kroneckerProduct" ):

linalg::zeroTest:= loadproc(linalg::zeroTest, path, "zeroTest"):

null():

