// 
//       
// 

/*++
the library 'listlib' implements some auxiliary methods for lists. It comprises:

        removeDuplicates(l) -- removes duplicate elements from a list; only
                the last occurance is kept. The ordering of the remaining
                elements is not changed.

	removeDupSorted(l) -- removes duplicate elements from a sorted list;
		faster than removeDuplicates if there are not many duplicates
		and the list is rather long.

        sort_desc(l) -- brings l in descending order, i.e. the reverse of
                what sort does.

        merge(l1,l2) resp. merge(l1,l2,less) -- merges two sorted lists; the
                optional third argument is a boolean function according to
                which the lists must be sorted (this is not checked!).

	singleMerge(l1,l2) resp. singleMerge(l1,l2,less) -- merges two sorted
		lists; if elements occur in both lists, they are taken only
		once. Thus if l1 and l2 contain no duplicates, the results
		will also contain no duplicates. The third argument has the
		same effect as in merge.

        setDifference(l1,l2) -- returns all elements of l1 which are not
                elements of l2. Works also for sets. Return type is the
                type of l1.

	sublist(l1,l2,<i>,<Consecutive>) -- checks whether l2 is a sublist
		of l1. If an index i is given, comparison starts in l1 at
		position i. If the option Consecutive is given, the elements
		of l2 must lie consecutively in l1.

	insert( ... ) -- insert ordered.

	insertAt( ... ) -- insert at position
++*/

    listlib:= newDomain("listlib"):
    listlib::create_dom:=hold(listlib):
    listlib::info:= "Library 'listlib': utilities for list operations":
    listlib::interface:= { 
        hold(removeDuplicates), hold(merge), hold(setDifference),
	hold(removeDupSorted), hold(singleMerge), hold(sublist),
        hold(insert),hold(insertAt)
    }:
    
    alias(path = pathname("LISTLIB")):

    listlib::removeDuplicates:= loadproc( listlib::removeDuplicates, path, "mvdup" ):
    listlib::removeDupSorted:= loadproc( listlib::removeDupSorted, path, "mvdups" ):
    listlib::merge:= loadproc( listlib::merge, path, "merge" ):
    listlib::singleMerge:= loadproc( listlib::singleMerge, path, "smerge" ):
    listlib::setDifference:= loadproc( listlib::setDifference, path, "setdiff" ):
    listlib::sublist:= loadproc( listlib::sublist, path, "sublist" ):
    listlib::insert:= loadproc( listlib::insert, path, "insert" ):
    listlib::insertAt:= loadproc( listlib::insertAt, path, "insertAt" ):

    null():

// end of file 
