//    

/*++
	numeric -- functions for numerical mathematics
++*/


numeric:= newDomain("numeric"):
numeric::create_dom:=hold(numeric):
numeric::info:= "Library 'numeric': functions for numerical mathematics":
numeric::interface:= { 
 // hold(abs),       // utility function, not to be documented
 // hold(bairstow),  // durch numeric::polyroots ueberfluessig
 // hold(bisect),    // durch numeric::realroot ueberfluessig
 // hold(allRealRoots), // utility function, not to be documented
    hold(butcher), 
 // hold(_cubicSpline), // utility function, not to be documented
    hold(cubicSpline),
    hold(cubicSpline2d),
    hold(complexRound),
    hold(det), 
    hold(eigenvalues), 
    hold(eigenvectors), 
    hold(expMatrix),
//  hold(factor), // undocumented utility
    hold(factorLU),
    hold(factorQR),
    hold(factorCholesky),
    hold(fft),
    hold(invfft), 
    hold(int),
    hold(fMatrix),
    hold(fsolve), 
    hold(gaussAGM),
    hold(gldata),
    hold(gtdata),
    hold(inverse),
    hold(indets),
 // hold(lagrange),  // nach (stdlib) interpolate gewandert
 // hold(lagrange2d), // in Lagrange absorbiert
    hold(leastSquares),
    hold(linsolve),
    hold(matlinsolve),
 // hold(minimax),  // once completed & documented
    hold(ncdata), 
    hold(odesolve),
    hold(odesolve2),
    hold(ode2vectorfield),
    hold(odesolveGeometric),
 // hold(partfrac), // utility for (stdlib) partfrac, not to be documented
    hold(polyrootbound),
    hold(polyroots),
//  hold(polyroots2), //internal reserve solver,  should not be documented !!
    hold(polysysroots), 
    hold(product),
    hold(pseudoInverse),
    hold(quadrature),
    hold(rank),        // new in MuPAD 3.5
    hold(rationalize),
    hold(realroot),
    hold(realroots),
//  hold(realroots2), // based on Dom::Interval rather than on DOM_INTERVAL
                      // Just for internal use (bugfinder for Dom::Interval ;-))
    hold(rotationMatrix),
    hold(singularvalues), 
    hold(singularvectors), 
    hold(svd),  // alias for singularvectors 
    hold(solve),
    hold(sort),
    hold(spectralradius),
    hold(spectralRadius),
    hold(startHardwareFloats),
    hold(sum)
//  hold(testfloat), // utility function, not to be documented
//  hold(isnonzero)  // utility function, not to be documented
}:

alias(path = pathname("NUMERIC"));

numeric::abs:= loadproc(numeric::abs, path, "abs"):
numeric::allRealRoots:= loadproc(numeric::allRealRoots, path, "allRealRoots"):
//obsolete, durch numeric::polyroots ueberfluessig
//numeric::bairstow:= loadproc(numeric::bairstow, path, "Bairstow"):
//obsolete, durch numeric::realroot ueberfluessig
//numeric::bisect:= loadproc(numeric::bisect, path, "bisect"):
numeric::butcher:= loadproc(numeric::butcher, path, "butcher" ):
numeric::complexRound:= loadproc(numeric::complexRound,path,"cmplxrnd"):
numeric::_cubicSpline:= loadproc(numeric::_cubicSpline, path, "_cSpline"):
numeric::cubicSpline:= loadproc(numeric::cubicSpline, path, "cSpline"):
numeric::cubicSpline2d:= loadproc(numeric::cubicSpline2d, path, "cSpline2d"):
numeric::det:= loadproc(numeric::det, path, "det" ):
numeric::eigenvalues:= loadproc(numeric::eigenvalues, path, "eigenval"):
numeric::eigenvectors:= loadproc(numeric::eigenvectors, path, "eigenvec"):
numeric::expMatrix:= loadproc(numeric::expMatrix, path, "expMatr"):
numeric::factor:= loadproc(numeric::factor, path, "factor"): // undocumented utility
numeric::factorCholesky:= loadproc(numeric::factorCholesky, path, "factorCh" ):
numeric::factorLU:= loadproc(numeric::factorLU, path, "factorLU" ):
numeric::factorQR:= loadproc(numeric::factorQR, path, "factorQR" ):
numeric::fft:= loadproc(numeric::fft, path, "fft"):
numeric::invfft:= loadproc(numeric::invfft, path, "invfft"):
numeric::fMatrix:= loadproc(numeric::fMatrix, path, "fMatrix"):
numeric::fsolve:= loadproc(numeric::fsolve,path,"fsolve"):
//numeric::fsolve_Sqrfpoly in numeric::polyroots umbenannt
//numeric::fsolve_Sqrfpoly:= loadproc(numeric::fsolve_Sqrfpoly,path,"solvepol"):
numeric::gaussAGM:= loadproc(numeric::gaussAGM, path, "gaussAGM"):
numeric::gldata:= loadproc(numeric::gldata, path, "GLData"):
numeric::gtdata:= loadproc(numeric::gtdata, path, "GTData"):
autoload(numeric::hasroot):
numeric::inverse:= loadproc(numeric::inverse, path, "inverse" ):
numeric::indets:= loadproc(numeric::indets, path, "indets" ):
numeric::isnonzero:= loadproc(numeric::isnonzero, path, "isnonzero"):
numeric::isless:= loadproc(numeric::isless, path, "isnonzero"):
numeric::isreal:= loadproc(numeric::isreal, path, "isnonzero"):
//numeric::lagrange:= loadproc(numeric::lagrange, path, "lagrange"): --> (stdlib) interpolate
//numeric::lagrange2d:= loadproc(numeric::lagrange2d, path, "lagrange"): --> in lagrange absorbiert
numeric::leastSquares:= loadproc(numeric::leastSquares, path, "leastSquares"):
numeric::linsolve:= loadproc(numeric::linsolve, path, "linsolve" );
numeric::linsolveSciSparse:= loadproc(numeric::linsolveSciSparse, path, "linsolveSciSparse" );
numeric::linsolveSciDense:= loadproc(numeric::linsolveSciDense, path, "linsolveSciDense" );
numeric::matlinsolve:= loadproc(numeric::matlinsolve, path, "matlinso" );
numeric::minimax := loadproc(numeric::minimax, path, "minimax");
numeric::ncdata:= loadproc(numeric::ncdata, path, "NCData"):
numeric::odesolve:= loadproc(numeric::odesolve, path, "odesolve" ):
numeric::odesolve2:= loadproc(numeric::odesolve2, path, "odesolv2" ):
numeric::ode2vectorfield:= loadproc(numeric::ode2vectorfield, path, "ode2vectorfield" ):
numeric::odesolveGeometric:= loadproc(numeric::odesolveGeometric, path, "odesolvG" ):
numeric::partfrac:= loadproc(numeric::partfrac, path, "partfrac"):
numeric::piecewise:= loadproc(numeric::piecewise, path, "piecewise"):
numeric::polyrootbound:= loadproc(numeric::polyrootbound, path, "polyrootbound"):
numeric::polyroots:= loadproc(numeric::polyroots, path, "polyroots"):
numeric::polyroots2:= loadproc(numeric::polyroots2, path, "polyrts2"):
numeric::polysysroots:= loadproc(numeric::polysysroots, path, "polysysroots"):
numeric::pseudoInverse:= loadproc(numeric::pseudoInverse, path, "pseudoInverse"):
numeric::quadrature:= loadproc(numeric::quadrature, path, "Quad"):
numeric::rank:= loadproc(numeric::rank, path, "rank"):
numeric::rationalize:= loadproc(numeric::rationalize, path, "rational"):
numeric::realroot:= loadproc(numeric::realroot, path, "realroot"):
numeric::realroots:= loadproc(numeric::realroots, path, "realroots"):
numeric::realroots2:= loadproc(numeric::realroots2, path, "realroots2"):
numeric::rotationMatrix:= loadproc(numeric::rotationMatrix, path, "rotationMatrix"):
numeric::singularvalues:= loadproc(numeric::singularvalues, path, "singval" ):
numeric::singularvectors:= loadproc(numeric::singularvectors, path, "singvec" ):
numeric::svd:= loadproc(numeric::svd, path, "singvec" ):
numeric::sort:= loadproc(numeric::sort, path, "sort" ):
numeric::spectralradius:= loadproc(numeric::spectralradius, path, "spectralradius"):
numeric::spectralRadius:= loadproc(numeric::spectralRadius, path, "spectralradius"):
numeric::startHardwareFloats:= loadproc(numeric::startHardwareFloats, path, "startHardwareFloats"):

// plotlib utilities
numeric::discont:= loadproc(numeric::discont, path, "discont"):
numeric::intsolve:= loadproc(numeric::intsolve, path, "intsolve"):


// float attributes
numeric::int:= loadproc(numeric::int, path, "int" ):
numeric::solve:= loadproc(numeric::solve, path, "solve"):
numeric::sum:=   loadproc(numeric::sum, path, "floatsum"):
numeric::product:= loadproc(numeric::product, path, "floatproduct"):

null():

// end of file 
