//       

// numlib.mu -- functions for elementary number theory 
// fritz, 16/09/94 

/*++
User functions:

checkPrimalityCertificate  - check the primality certificate returned by proveprime
contfrac         - domain for continued fractions arithmetic
contfracPeriodic - returns a periodic continued fraction
cornacchia       - solves ax^2 + by^2 = m
ecm		 - factors an integer using the Elliptic Curve Method (ECM)
decimal          - returns a infinite representation of a rational
divisors         - returns the list of divisors of an integer
factorGaussInt   - factors a Gaussian integer
fibonacci        - calculates Fibonacci numbers
fromAscii        - decodes a list of ASCII-codes
g_adic           - calculates g-adic representations
ichrem           - generalized Chinese remainder algorithm
igcdmult         - extended Euclidean algorithm
invphi           - the inverse of the Euler phi function
isquadres        - checks if a number is a quadratic residue
issqr            - checks if an integer is a square
jacobi           - Jacobi symbol
lambda           - the Carmichael function
Lambda           - the von Mangoldt function
legendre         - Legendre symbol
lincongruence    - solves linear congruences
mersenne         - returns the primes p such that M(p) is a prime
moebius          - the Moebius mu-function
mpqs             - the multi-polynomial quadratic sieve
mroots           - calculates modular roots of univariate polynomials
msqrts           - calculates square roots of quadratic residues
numdivisors      - returns number of divisors
numprimedivisors - returns number of primedivisors
omega            - the same as numprimedivisors
Omega            - returns the number of primedivisors, taking into
  		   account their multiplicities
order            - calculates orders in the group of units modulo m
phi              - Euler phi function
pi               - number of primes below a given size
pollard          - factors an integer using Pollard's rho method
primedivisors    - returns list of primedivisors
primroot         - returns a primitive root
proveprime	 - primality proving using elliptic curves
reconstructRational - rational number reconstruction
sigma            - returns the sum of kth powers of the divisors
sqrt2cfrac       - returns the continued fraction expansion of a square root
sqrtmodp         - calculates square roots modulo p, where p is a prime
sumdivisors      - returns the sum of the divisors
sumOfDigits      - sum of all digits
tau              - returns number of divisors
toAscii          - encodes a string as a list of ASCII-codes 

++*/

  numlib := newDomain("numlib"):
  numlib::create_dom:=hold(numlib):
  numlib::info := "Library 'numlib': the package for elementary number theory":
  numlib::interface :=
  {
   hold(checkPrimalityCertificate),
   hold(cornacchia),
   hold(ecm),
   hold(decimal),
   hold(divisors),
   hold(factorGaussInt),
   hold(fibonacci),
	hold(fromAscii),
	hold(g_adic),
	hold(ichrem),
	hold(igcdmult),
	hold(invphi),
   hold(ispower),
	hold(isquadres),
	hold(issqr),
	hold(jacobi),
   hold(lambda),
   hold(Lambda),
	hold(legendre),
	hold(lincongruence),
	hold(mersenne),
	hold(moebius),
	hold(mpqs),
	hold(mroots),
	hold(msqrts),
	hold(numdivisors),
	hold(numprimedivisors),
   hold(omega),
   hold(Omega),
	hold(order),
   hold(phi),
   hold(pi),                     
	hold(pollard),
	hold(primedivisors),
	hold(primroot),
   hold(proveprime),
   hold(reconstructRational),
	hold(sigma),
	hold(sqrt2cfrac),
   hold(sqrtmodp),                     
	hold(sumdivisors),
   hold(sumOfDigits),                     
	hold(tau),
	hold(toAscii),
   hold(contfrac),
   hold(contfracPeriodic)
	}:
  
alias(path = pathname("NUMLIB")):

numlib::checkPrimalityCertificate:= loadproc(numlib::checkPrimalityCertificate, path, "prfprime"):
numlib::contfrac:= loadproc(numlib::contfrac, path, "contfrac"):
numlib::contfracPeriodic:= loadproc(numlib::contfracPeriodic, path,
                                    "contfracPeriodic"):
numlib::cornacchia:= loadproc(numlib::cornacchia, path, "cornacchia"):
numlib::ecm:= loadproc(numlib::ecm, path, "ecm"):
numlib::decimal:= loadproc(numlib::decimal, path, "decimal"):
numlib::divisors:= loadproc(numlib::divisors, path, "divisors"):
numlib::factorGaussInt:= loadproc(numlib::factorGaussInt, path, "factorGaussInt"):
numlib::fibonacci:= loadproc(numlib::fibonacci, path, "fibonacc"):
numlib::ascii2char:= loadproc(numlib::ascii2char, path, "fromAsc");
numlib::fromAscii:= loadproc(numlib::fromAscii, path, "fromAsc"):
numlib::g_adic:= loadproc(numlib::g_adic, path, "g_adic"):
numlib::ichrem:= loadproc(numlib::ichrem, path, "ichrem"):
numlib::igcdmult:= loadproc(numlib::igcdmult, path, "igcdmult"):
numlib::invphi:= loadproc(numlib::invphi, path, "invphi"):
numlib::ispower:= loadproc(numlib::ispower, path, "ispower"):
numlib::isquadres:= loadproc(numlib::isquadres, path, "isqdres"):
numlib::issqr:= loadproc(numlib::issqr, path, "issqr"):
numlib::jacobi:= loadproc(numlib::jacobi, path, "jacobi"):
numlib::lambda:= loadproc(numlib::lambda, path, "lambda"):
numlib::Lambda:= loadproc(numlib::Lambda, path, "lambda"):
numlib::legendre:= loadproc(numlib::legendre, path, "legendre"):
numlib::lincongruence:= loadproc(numlib::lincongruence, path, "lincongr"):
numlib::mersenne:= loadproc(numlib::mersenne, path, "mersenne"):
numlib::moebius:= loadproc(numlib::moebius, path, "moebius"):
numlib::mpqs:= loadproc(numlib::mpqs, path, "mpqs"):
numlib::mroots:= loadproc(numlib::mroots, path, "mroots"):
numlib::msqrts:= loadproc(numlib::msqrts, path, "msqrts"):
numlib::numdivisors:= loadproc(numlib::numdivisors, path, "numdivs"):
numlib::numprimedivisors:= loadproc(numlib::numprimedivisors, path, "numpdivs"):
numlib::omega:= loadproc(numlib::omega, path, "omega"):
numlib::Omega:= loadproc(numlib::Omega, path, "omega"):
numlib::order:= loadproc(numlib::order, path, "order"):
numlib::phi:= loadproc(numlib::phi, path, "phi"):
numlib::pi:= loadproc(numlib::pi, path, "pi"):
numlib::pollard:= loadproc(numlib::pollard, path, "pollard"):
numlib::primedivisors:= loadproc(numlib::primedivisors, path, "primdivs"):
numlib::primroot:= loadproc(numlib::primroot, path, "primroot"):
numlib::proveprime:= loadproc(numlib::proveprime, path, "prfprime"):
numlib::reconstructRational:= loadproc(numlib::reconstructRational, path, "reconstruct"):
numlib::sigma:= loadproc(numlib::sigma, path, "sigma"):
numlib::sqrt2cfrac:= loadproc(numlib::sqrt2cfrac, path, "sqcf"):
numlib::sqrtmodp:= loadproc(numlib::sqrtmodp, path, "sqrtmodp"):
numlib::sumdivisors:= loadproc(numlib::sumdivisors, path, "sumdivs"):
numlib::sumOfDigits:= loadproc(numlib::sumOfDigits, path, "sumOfDigits"):
numlib::tau:= loadproc(numlib::tau, path, "tau"):
numlib::toAscii:= loadproc(numlib::toAscii, path, "toAscii"):

// functions without interface: 

// for msqrts: 
numlib::hensel2:= loadproc(numlib::hensel2, path, "hensel2"):

// for mroots: 
numlib::mrootsPP:= loadproc(numlib::mrootsPP, path, "mrootsPP"):
numlib::regularHensel:= loadproc(numlib::regularHensel, path, "hensel"):
numlib::singularHensel:= loadproc(numlib::singularHensel, path, "hensel"):

// for ithprime in STDLIB, and certain modular algorithms 
numlib::thePrimes:= loadproc(numlib::thePrimes, path, "primes"):
numlib::primelist511:= loadproc(numlib::primelist511, path, "primes"):

null():


