/*++
	polylib - a library for working with polynomials.
++*/

polylib:=newDomain("polylib"):
polylib::create_dom:=hold(polylib):

polylib::info:="Library 'polylib': utilities for polynomials":
polylib::interface:=
{
 hold(Poly),hold(divisors),
 hold(decompose), hold(discrim), 
 hold(resultant), hold(subresultant),
 hold(sqrfree),
 hold(elemSym), hold(representByElemSym),
 hold(primpart), hold(randpoly), hold(cyclotomic), hold(splitfield),
 hold(primitiveElement), hold(Dpoly),
 hold(realroots),
 hold(makerat),
 hold(minpoly),
 hold(sortMonomials),
// hold(support), // not documented
 hold(coeffRing)
 // hold(variables) // not documented
}:


alias(path = pathname("POLYLIB")):

// Taken from MuPAD-Combinat
polylib::support  := loadproc(polylib::support, path, "support"):
polylib::coeffRing:= loadproc(polylib::coeffRing, path, "coeffRing"):
polylib::variables:= loadproc(polylib::variables, path, "variables"):
polylib::Poly     := loadproc(polylib::Poly, path, "Poly"):

polylib::sqrfree  := loadproc(polylib::sqrfree, path, "sqrfree"):
polylib::cyclotomic := loadproc(polylib::cyclotomic, path, "cyclotom"):
polylib::decompose:= loadproc(polylib::decompose, path, "decomp"):
polylib::discrim  := loadproc(polylib::discrim, path, "discrim"):
polylib::divisors := loadproc(polylib::divisors, path, "divisors"):
polylib::elemSym  := loadproc(polylib::elemSym, path, "sympol"):
polylib::makerat  := loadproc(polylib::makerat, path, "makerat"):
polylib::minpoly  := loadproc(polylib::minpoly, path, "minpoly"):
polylib::primpart := loadproc(polylib::primpart, path, "primpart"):
polylib::randpoly := loadproc(polylib::randpoly, path, "randpoly"):
polylib::refineFactorization:= loadproc(polylib::refineFactorization, path,
                                        "refineFact"):
polylib::representByElemSym := loadproc(polylib::representByElemSym, path, "sympol"):
polylib::resultant := loadproc(polylib::resultant, path, "resultan"):
polylib::realroots := loadproc(polylib::realroots, path, "realroots"):
polylib::shiftequiv:= loadproc(polylib::shiftequiv, path, "shiftequ"):
polylib::shift:= loadproc(polylib::shift, path, "shift"):
polylib::subresultant := loadproc(polylib::subresultant, path, "subresultant"):


polylib::Dpoly:= funcenv(
    builtin(522,NIL,"polylib::Dpoly",NIL),
    builtin(1101,0,NIL,"polylib::Dpoly"),
    table( "type" = "Dpoly" )
): // system function 'Dpoly'

// autoload(polylib::setcoeff):
polylib::setcoeff := stdlib::setcoeff:
sysdelete(stdlib::setcoeff):

// functions for algebraic extensions

polylib::horner   := loadproc(polylib::horner, path, "horner"):
polylib::primitiveElement := loadproc(polylib::primitiveElement, path,
                                      "primelem"):
polylib::splitFieldIrreducible := loadproc(polylib::splitFieldIrreducible,
                                           path, "splitirr"):
polylib::splitfield := loadproc(polylib::splitfield, path, "splitfld"):
polylib::sqrfreeNorm := loadproc(polylib::sqrfreeNorm, path, "sqfrnorm"):

polylib::trace := loadproc(polylib::trace, path, "trace"):
polylib::rootbound := loadproc(polylib::rootbound, path, "rootbound"):

// functions for arbitrary monomial orderings :

polylib::sortMonomials:=loadproc(polylib::sortMonomials, path, "sortmon"):

unalias(path):

// auxiliary functions for computing resultants

alias(path = pathname("POLYLIB", "RESULTANT")):

polylib::presultant:= loadproc(polylib::presultant, path, "presultant"):
polylib::univariateResultant:= loadproc(polylib::univariateResultant, path, "univariateResultant"):
polylib::multivariateResultant:= loadproc(polylib::multivariateResultant, path, "multivariateResultant"):

polylib::euclideanResultant:= loadproc(polylib::euclideanResultant, path, "euclideanResultant"):
polylib::bezoutResultant:= loadproc(polylib::bezoutResultant, path, "bezoutResultant"):
polylib::univariateResultantModP:= loadproc(polylib::univariateResultantModP, path, "univariateResultantModP"):
polylib::rationalResultant:= loadproc(polylib::rationalResultant, path, "rationalResultant"):

polylib::CRES:= loadproc(polylib::CRES, path, "CRES"):
polylib::CPRES:= loadproc(polylib::CPRES, path, "CPRES"):





null():

