//   

///   /*
///   
///   Simplify  - the new MuPAD simplifier
///   

///   
////  Simplify(e)
///   
///   e - any object
///   
///   

///   
///   
///   
///   directory structure
///   LIBFILES/simplify.mu    main library file
///   SIMPLIFY                main procedures/methods
///   SIMPLIFY/SLOTS          collections of methods/rules, type dependent
///                           (sorted by the type of MuPAD objects)
///                           each type gets its slot simplify::TYPE -> a list of rules/methods
///   SIMPLIFY/METHODS        methods to simplify special objects, this
///                           methods are used as rules in SLOTS
   
///   */

// create a domain called simplify
Simplify := newDomain("Simplify"):

Simplify::info := "Simplification of MuPAD objects":

Simplify::interface:=
  {
   hold(complexity),        // valuates an expression
   hold(defaultValuation)  // valuation, used by defaultSimplier
   //hold(defaultSimplifier), // returns the default simplifier  \ internal
   //hold(Simplifier)         // creates a new simplifier        /
   }:

Simplify::new:=
  proc(ex)
    name Simplify; //
  begin
    if args(0) = 0 then
      // return the default simplifier
      Simplify::defaultSimplifier
    else
      Simplify::defaultSimplifier(args())
    end_if
  end_proc:

Simplify::trace := {"new"}: // trace only the new method by default

//////////////////////////////////////////////////////////////////////
// New search mechanism
//////////////////////////////////////////////////////////////////////

// returns a procedure, that uses the new simplify stategy
// a lot of options can be given to create a completely adjusted simplifier
Simplify::Simplifier:=
  loadproc(Simplify::Simplifier, pathname("SIMPLIFY"), "Simplifier"):

// simplifier with default options - should be universal usable
Simplify::defaultSimplifier:=
  loadproc(Simplify::defaultSimplifier, pathname("SIMPLIFY"), "defaultSimplifier"):

// utility procedures, can be used as optional arguments
Simplify::exclude:=
  loadproc(Simplify::exclude, pathname("SIMPLIFY"), "Simplifier"):
Simplify::selectRules:=
  loadproc(Simplify::selectRules, pathname("SIMPLIFY"), "Simplifier"):
Simplify::defaultValuation:=
  loadproc(Simplify::defaultValuation, pathname("SIMPLIFY"), "Simplifier"):

// procedure, that valuates any MuPAD expression
Simplify::createValuation:=
  loadproc(Simplify::createValuation, pathname("SIMPLIFY", "VALUATION"), "complexity"):
// default procedure, that valuates any MuPAD expression
Simplify::complexity:=
  loadproc(Simplify::complexity, pathname("SIMPLIFY", "VALUATION"), "complexity"):
Simplify::defaultOperatorTable:=
  loadproc(Simplify::defaultOperatorTable, pathname("SIMPLIFY", "VALUATION"), "complexity"):
Simplify::indetComplexity:=
  loadproc(Simplify::indetComplexity, pathname("SIMPLIFY", "VALUATION"), "indetComplexity"):

Simplify::pairPenalty:=
loadproc(Simplify::pairPenalty, pathname("SIMPLIFY", "VALUATION"),
"pairPenalty"):

Simplify::outputSize:=
loadproc(Simplify::outputSize, pathname("SIMPLIFY", "VALUATION"),
"outputSize"):

// procedure, that returns a list of equivalent expressions
Simplify::equivalent:=
  loadproc(Simplify::equivalent, pathname("SIMPLIFY"), "equivalent"):

// Domain, that contains the mechanism to define and apply simplification (match-) rules
// -> Rule is realized as own top level library

//////////////////////////////////////////////////////////////////////
// Slots
// Simplify::XXX - method to simplify objects of type XXX
//                 this method gets only the arguments of an expression
//                 without the 0-th operand
// and
// special simplification methods (``rule procedures'')
//////////////////////////////////////////////////////////////////////

   ///////////////////////////////////////////////////////
   // --  T Y P E  --
   ///////////////////////////////////////////////////////

(slot(Simplify, k) := loadproc(slot(Simplify, k), pathname("SIMPLIFY", "SLOTS"), k))
 $ k in [
         //"Ci", "D", "Ei",
         "Im", "Re", // "RootOf", "Si",
         "_and",
         //"_div", // "_divide",
          "_equal",
         "_equiv", // "_exists", "_exprseq",
         "_fconcat",
         //"_forall",
         //"function",
         "_implies",
          "_in",
          "_intersect",
         //"_invert",
         "_leequal", "_less",
         "_minus", 
         // "_mod",
         "_mult",
         //"_negate",
         //"_not",
         "_or",
         "_plus", "_power",
         //"_subtract",
         "_unequal", "_union",

         "abs", // "arccos", "arccosh",
         "arccot", // "arccoth",
         //"arccsc", "arccsch", "arcsec", "arcsech", "arcsin",
         "arcsinh",
         "arctan", "arctanh", // "arg", "asympt",
         //"bernoulli", 
         "besselJ",
         "besselI",
         "besselK",
         "besselY",
         //"beta",
         "binomial",
         //"conjugate",
         "cos", "cosh",
         "cot", // "coth", "csc", "csch",
         //"diff", 
         "dilog",
         // "dirac", "divide",
         //"erf", "erfc",
         "erfi",
         // "exp",
         "fact",
         "fact2",
         "gamma",
         // "gcov", 
         "heaviside",
         "int",
         "kroneckerDelta",
         // "lambertV", "lambertW",
         "ln", "log",
         "max", "min",
         //"modp", "mods",
         //"norm", "pdivide", "poly", "polylog",
         //"product", "psi",
         //"sec", "sech", "series",
         "sign",
         // "signIm",
         "sin",
         "sinh", // "solve", "sqrt", "sum",
         "tan", "tanh", // "taylor",
         //"whittakerM"               // "zeta"
         // generic rules for any expression
         "All", "Global", "Local"
         ]:



// switch off ...::simplify slots as far as we have special rules for them


_plus::Simplify:=
_mult::Simplify:=
_power::Simplify:=
// arctan::Simplify:=
//cos::Simplify:=
// cosh::Simplify:=
// cot::Simplify:=
// coth::Simplify:=
// exp::Simplify:=
// ln::Simplify:=
// sin::Simplify:=
// sinh::Simplify:=
// tan::Simplify:=
// tanh::Simplify:=
[]:


/*
   rule base IgnoreAnalyticConstraints
*/
Simplify::IgnoreAnalyticConstraints:= newDomain("Simplify::IgnoreAnalyticConstraints"):
     
(slot(Simplify::IgnoreAnalyticConstraints, k) := loadproc(slot(Simplify::IgnoreAnalyticConstraints, k),
                                      pathname("SIMPLIFY", "SLOPPY"), k))
$k in  [
       "All", "Global", "Local", "_plus", "_mult", "_power"
       ]:
  

   ///////////////////////////////////////////////////////
   // --  S P E C I A L   M E T H O D S  -- 
   ///////////////////////////////////////////////////////

(slot(Simplify, k) := loadproc(slot(Simplify, k), pathname("SIMPLIFY", "METHODS"), k))
 $ k in [
         "IToMinus1",
         "absInPower",
	"andIn",
      "cancel_and",
	"cancel_or",
	   "collectAbsSign",
         "combineConstantWithRoots",
         "combineIntPowers",
	"combineSinCos",
	"consensus_and",
	"consensus_or",
         "distribute_and",
         "distribute_or",
         "distributeExponent",
         "divide",
         "expand",
         "expPowLog",
         "extractContentFromBase",
         "factorEqualUnequal",
         "factorlnInt",
         "fractionalPowers",
         "inRemoveConst",
         "inRremoveConst",
         "intBase",
         "intPowHasLog",
         "minus1Power",
         "normalizesignBase",
         "orIn",
         "overload",
	   "radsimpMatchSqrt",
         "ratExponent",
         "resolution_and",
	"resolution_or",
      "rewriteTrig",
         "signToAbsInPower",
         "signToAbsInProd",
         "sqrfreeFactor",
         "tryIs",
         "zeroPower"
      ]:

// old func::simplify slots
// ==> - keep old overload methods "type"::simplify in STDLIB/SIMPLIFY/"type".mu
// (slot(Simplify, k."Simplify") := loadproc(slot(Simplify, k."Simplify"),
//                                           pathname("SIMPLIFY", "METHODS"), k))
//  $ k in [
//          "_power",
//          "arctan",
//          "exp",
//          "max",
//          "min",
//          "sin",
//          "cos",
//          "tan",
//          "cot"
//          ]:


//
Simplify::tempRules := []:


Simplify::print:=
  proc()
  begin
    hold(Simplify)(args())
  end_proc:


null():