//       

/*
stats.mu -- lib-file for statistics library
*/

  stats:=newDomain("stats"):
  stats::create_dom:=hold(stats):
  stats::info:="Library 'stats': statistics functions":
  stats::interface:={

// obsolete distributions
              //     hold(normal),   // obsolete, replaced by normalCDF.
              //     hold(ChiSquare),// obsolete, replaced by chisquareCDF.
              //     hold(Tdist),    // obsolete, replaced by tCDF.
// utilities for samples
                     hold(calc),
                     hold(col),
                     hold(concatCol),
                     hold(concatRow),
                     hold(row),
                     hold(sample),
                     hold(sample2list),
                     hold(selectRow),
                     hold(sortSample),
                     hold(tabulate),
                     hold(unzipCol),
                     hold(zipCol),
// data analysis
                 //  hold(a_quantile), // replaced by empiricalQuantile
                 //  hold(BPCorr),     // replaced by correlation
                 //  hold(FCorr),      // replaced by correlation
                     hold(correlation),
                     hold(correlationMatrix),
                     hold(covariance),
                     hold(frequency),
                     hold(geometricMean),
                     hold(harmonicMean),
                     hold(hodrickPrescottFilter), // new in MuPAD 3.5
                     hold(kurtosis),
                     hold(mean),
                     hold(meandev),
                     hold(median),
                     hold(modal),
                     hold(moment),
                     hold(obliquity),
                     hold(quadraticMean),
                     hold(stdev),
                     hold(variance),
// regression
                     hold(linReg),
                     hold(reg),
// distributions
                     hold(betaCDF),
                     hold(betaPDF),
                     hold(betaQuantile),
                     hold(betaRandom),

                     hold(binomialCDF),
                     hold(binomialPF),
                     hold(binomialQuantile),
                     hold(binomialRandom),

                     hold(hypergeometricPF),
                     hold(hypergeometricCDF),
                     hold(hypergeometricQuantile),
                     hold(hypergeometricRandom),

                     hold(cauchyCDF),
                     hold(cauchyPDF),
                     hold(cauchyQuantile),
                     hold(cauchyRandom),

                     hold(chisquareCDF),
                     hold(chisquarePDF),
                     hold(chisquareQuantile),
                     hold(chisquareRandom),

                     hold(empiricalCDF),
                     hold(empiricalPF),
                     hold(empiricalQuantile),
                     hold(empiricalRandom),

                     hold(erlangCDF),
                     hold(erlangPDF),
                     hold(erlangQuantile),
                     hold(erlangRandom),

                     hold(exponentialCDF),
                     hold(exponentialPDF),
                     hold(exponentialQuantile),
                     hold(exponentialRandom),

                     hold(fCDF),
                     hold(fPDF),
                     hold(fQuantile),
                     hold(fRandom),

                     hold(finiteCDF),
                     hold(finitePF),
                     hold(finiteQuantile),
                     hold(finiteRandom),

                     hold(gammaCDF), 
                     hold(gammaPDF), 
                     hold(gammaQuantile), 
                     hold(gammaRandom), 

                     hold(geometricCDF), 
                     hold(geometricPF),
                     hold(geometricQuantile),
                     hold(geometricRandom),

                     hold(logisticCDF),
                     hold(logisticPDF),
                     hold(logisticQuantile),
                     hold(logisticRandom),

                     hold(lognormalCDF),
                     hold(lognormalPDF),
                     hold(lognormalQuantile),
                     hold(lognormalRandom),

                     hold(normalCDF),
                     hold(normalPDF),
                     hold(normalQuantile),
                     hold(normalRandom),

                     hold(poissonCDF),
                     hold(poissonPF),
                     hold(poissonQuantile),
                     hold(poissonRandom),

                     hold(tCDF),
                     hold(tPDF),
                     hold(tQuantile),
                     hold(tRandom),

                     hold(uniformCDF),
                     hold(uniformPDF),
                     hold(uniformQuantile),
                     hold(uniformRandom),

                     hold(weibullCDF),
                     hold(weibullPDF),
                     hold(weibullQuantile),
                     hold(weibullRandom),

// statistical tests
                  // hold(meanTest), // durch tTest ersetzt
                     hold(csGOFT),
                     hold(ksGOFT),
                     hold(swGOFT),
                     hold(tTest),
// utility for csGOFT
                     hold(equiprobableCells),
// utilities
                     hold(cutoff),
                     hold(winsorize)
                    }:

alias(path = pathname("STATS")):

// ---------------------------------------------------------
// sample utilities
stats::sample      := loadproc(stats::sample, path, "sample"):
stats::calc        := loadproc(stats::calc, path, "calc"):
stats::selectRow   := loadproc(stats::selectRow, path, "selectRo"):
stats::tabulate    := loadproc(stats::tabulate, path, "tabulate"):
stats::zipCol      := loadproc(stats::zipCol, path, "zipCol"):
stats::unzipCol    := loadproc(stats::unzipCol, path, "unzipCol"):
stats::row         := loadproc(stats::row, path, "row"):
stats::col         := loadproc(stats::col, path, "col"):
stats::concatRow   := loadproc(stats::concatRow, path, "concatRo"):
stats::concatCol   := loadproc(stats::concatCol, path, "concatCo"):
stats::sample2list := loadproc(stats::sample2list, path, "sample2l"):
stats::testdata    := loadproc(stats::testdata, path, "testdata"):
stats::getdata     := loadproc(stats::getdata, path, "getdata"):
stats::sortSample  := loadproc(stats::sortSample, path, "sortSamp"):
// ---------------------------------------------------------
// tools for descriptive statistics
//stats::a_quantile replaced by empiricalQuantile
//stats::a_quantile  := loadproc(stats::a_quantile, path, "a_quanti"):
stats::covariance  := loadproc(stats::covariance, path, "covariance"):
//stats::FCorr replaced by stats::correlation
//stats::FCorr       := loadproc(stats::FCorr, path, "FCorr"):
//stats::BPCorr replaced by stats::correlation
//stats::BPCorr    := loadproc(stats::BPCorr, path, "BPCorr"):
stats::correlation := loadproc(stats::correlation, path, "correlation"):
stats::correlationMatrix
                   := loadproc(stats::correlationMatrix, path, "correlationMatrix"):
stats::geometricMean
                   := loadproc(stats::geometricMean, path, "geometri"):
stats::frequency   := loadproc(stats::frequency, path, "frequency"):
stats::harmonicMean:= loadproc(stats::harmonicMean, path, "harmonic"):
stats::hodrickPrescottFilter:= 
                      loadproc(stats::hodrickPrescottFilter, path, "hodrickPrescottFilter"):
stats::kurtosis    := loadproc(stats::kurtosis, path, "kurtosis"):
stats::linReg      := loadproc(stats::linReg, path, "linReg"):
stats::mean        := loadproc(stats::mean, path, "mean"):
stats::meandev     := loadproc(stats::meandev, path, "meandev"):
stats::median      := loadproc(stats::median, path, "median"):
stats::modal       := loadproc(stats::modal, path, "modal"):
stats::moment      := loadproc(stats::moment, path, "moment"):
stats::obliquity   := loadproc(stats::obliquity, path, "obliquit"):
stats::quadraticMean
                   := loadproc(stats::quadraticMean, path, "quadrati"):
stats::reg         := loadproc(stats::reg, path, "reg"):
stats::stdev       := loadproc(stats::stdev, path, "stdev"):
stats::variance    := loadproc(stats::variance, path, "variance"):
// ---------------------------------------------------------
// statistical tests
stats::swGOFT  := loadproc(stats::swGOFT, pathname("STATS","HYPT"), "swgoft"):
stats::ksGOFT  := loadproc(stats::ksGOFT, pathname("STATS","HYPT"), "ksgoft"):
stats::csGOFT  := loadproc(stats::csGOFT, pathname("STATS","HYPT"), "csgoft"):
stats::tTest   := loadproc(stats::tTest,  pathname("STATS","HYPT"), "tTest"):
// stats::meanTest was renamed to stats::tTest for version 2.1
// stats::meanTest:= loadproc(stats::meanTest, path, "meanTest"):
// utility for csGOFT
stats::equiprobableCells
               := loadproc(stats::equiprobableCells,  pathname("STATS"), "equiprobableCells"):
// ---------------------------------------------------------
// obsolete distributions
// stats::normal      := loadproc(stats::normal, path, "normal"): // obsolete,  old stuff
// We still need stats::Tdist as an internal undocumented
// utility for stats::tCDF
stats::Tdist       := loadproc(stats::Tdist, path, "Tdist"):   // obsolete,  old stuff
// stats::ChiSquare   := loadproc(stats::ChiSquare, path, "chi"): // obsolete,  old stuff
// ---------------------------------------------------------
// discrete distributions
stats::binomialCDF      := loadproc(stats::binomialCDF, pathname("STATS","CDF"), "binomialcdf"):
stats::binomialPF       := loadproc(stats::binomialPF, pathname("STATS","PF"), "binomialpf"):
stats::binomialQuantile := loadproc(stats::binomialQuantile, pathname("STATS","DQUANTILE"), "binomialquantile"):
stats::binomialRandom   := loadproc(stats::binomialRandom, pathname("STATS","RANDOM"), "binomialrand"):

stats::hypergeometricCDF := loadproc(stats::hypergeometricCDF, pathname("STATS","CDF"), "hypergeometriccdf"):
stats::hypergeometricPF := loadproc(stats::hypergeometricPF, pathname("STATS","PF"), "hypergeometricpf"):
stats::hypergeometricQuantile := loadproc(stats::hypergeometricQuantile, pathname("STATS","QUANTILE"), "hypergeometricquantile"):
stats::hypergeometricRandom := loadproc(stats::hypergeometricRandom, pathname("STATS","RANDOM"), "hypergeometricrand"):

stats::geometricCDF     := loadproc(stats::geometricCDF, pathname("STATS","CDF"), "geometriccdf"):
stats::geometricPF      := loadproc(stats::geometricPF, pathname("STATS","PF"), "geometricpf"):
stats::geometricQuantile:= loadproc(stats::geometricQuantile, pathname("STATS","DQUANTILE"), "geometricquantile"):
stats::geometricRandom  := loadproc(stats::geometricRandom, pathname("STATS","RANDOM"), "geometricrand"):

stats::poissonCDF       := loadproc(stats::poissonCDF, pathname("STATS","CDF"), "poissoncdf"):
stats::poissonPF        := loadproc(stats::poissonPF, pathname("STATS","PF"), "poissonpf"):
stats::poissonQuantile  := loadproc(stats::poissonQuantile, pathname("STATS","DQUANTILE"), "poissonquantile"):
stats::poissonRandom    := loadproc(stats::poissonRandom, pathname("STATS","RANDOM"), "poissonrand"):

// continuous distributions
stats::betaCDF     := loadproc(stats::betaCDF, pathname("STATS","CDF"), "betacdf"):
stats::betaPDF     := loadproc(stats::betaPDF, pathname("STATS","PDF"), "betapdf"):
stats::betaQuantile:= loadproc(stats::betaQuantile, pathname("STATS","QUANTILE"), "betaquantile"):
stats::betaRandom  := loadproc(stats::betaRandom, pathname("STATS","RANDOM"), "betarand"):

stats::cauchyCDF     := loadproc(stats::cauchyCDF, pathname("STATS","CDF"), "cauchycdf"):
stats::cauchyPDF     := loadproc(stats::cauchyPDF, pathname("STATS","PDF"), "cauchypdf"):
stats::cauchyQuantile:= loadproc(stats::cauchyQuantile, pathname("STATS","QUANTILE"), "cauchyquantile"):
stats::cauchyRandom  := loadproc(stats::cauchyRandom, pathname("STATS","RANDOM"), "cauchyrand"):

stats::chisquareCDF := loadproc(stats::chisquareCDF, pathname("STATS","CDF"), "chisquarecdf"):
stats::chisquarePDF := loadproc(stats::chisquarePDF, pathname("STATS","PDF"), "chisquarepdf"):
stats::chisquareQuantile
                    := loadproc(stats::chisquareQuantile, pathname("STATS","QUANTILE"), "chisquarequantile"):
stats::chisquareRandom:= loadproc(stats::chisquareRandom, pathname("STATS","RANDOM"), "chisquarerand"):

stats::erlangCDF     := loadproc(stats::erlangCDF, pathname("STATS","CDF"), "erlangcdf"):
stats::erlangPDF     := loadproc(stats::erlangPDF, pathname("STATS","PDF"), "erlangpdf"):
stats::erlangQuantile:= loadproc(stats::erlangQuantile, pathname("STATS","QUANTILE"), "erlangquantile"):
stats::erlangRandom  := loadproc(stats::erlangRandom, pathname("STATS","RANDOM"), "erlangrand"):

stats::empiricalCDF     := loadproc(stats::empiricalCDF, pathname("STATS","CDF"), "empiricalcdf"):
stats::empiricalPF      := loadproc(stats::empiricalPF, pathname("STATS","PF"), "empiricalpf"):
stats::empiricalQuantile:= loadproc(stats::empiricalQuantile, pathname("STATS","DQUANTILE"), "empiricalquantile"):
stats::empiricalRandom  := loadproc(stats::empiricalRandom, pathname("STATS","RANDOM"), "empiricalrand"):

stats::exponentialCDF := loadproc(stats::exponentialCDF, pathname("STATS","CDF"), "exponentialcdf"):
stats::exponentialPDF := loadproc(stats::exponentialPDF, pathname("STATS","PDF"), "exponentialpdf"):
stats::exponentialQuantile := loadproc(stats::exponentialQuantile, pathname("STATS","QUANTILE"), "exponentialquantile"):
stats::exponentialRandom := loadproc(stats::exponentialRandom, pathname("STATS","RANDOM"), "exponentialrand"):

stats::fCDF     := loadproc(stats::fCDF, pathname("STATS","CDF"), "fcdf"):
stats::fPDF     := loadproc(stats::fPDF, pathname("STATS","PDF"), "fpdf"):
stats::fQuantile:= loadproc(stats::fQuantile, pathname("STATS","QUANTILE"), "fquantile"):
stats::fRandom  := loadproc(stats::fRandom, pathname("STATS","RANDOM"), "frand"):

stats::finiteCDF     := loadproc(stats::finiteCDF, pathname("STATS","CDF"), "finitecdf"):
stats::finitePF      := loadproc(stats::finitePF, pathname("STATS","PF"), "finitepf"):
stats::finiteQuantile:= loadproc(stats::finiteQuantile, pathname("STATS","DQUANTILE"), "finitequantile"):
stats::finiteRandom:= loadproc(stats::finiteRandom, pathname("STATS","RANDOM"), "finiterand"):

stats::gammaCDF     := loadproc(stats::gammaCDF, pathname("STATS","CDF"), "gammacdf"):
stats::gammaPDF     := loadproc(stats::gammaPDF, pathname("STATS","PDF"), "gammapdf"):
stats::gammaQuantile:= loadproc(stats::gammaQuantile, pathname("STATS","QUANTILE"), "gammaquantile"):
stats::gammaRandom  := loadproc(stats::gammaRandom, pathname("STATS","RANDOM"), "gammarand"):

stats::logisticCDF     := loadproc(stats::logisticCDF, pathname("STATS","CDF"), "logisticcdf"):
stats::logisticPDF     := loadproc(stats::logisticPDF, pathname("STATS","PDF"), "logisticpdf"):
stats::logisticQuantile:= loadproc(stats::logisticQuantile, pathname("STATS","QUANTILE"), "logisticquantile"):
stats::logisticRandom  := loadproc(stats::logisticRandom, pathname("STATS","RANDOM"), "logisticrand"):

stats::normalCDF      := loadproc(stats::normalCDF, pathname("STATS","CDF"), "normalcdf"):
stats::normalPDF      := loadproc(stats::normalPDF, pathname("STATS","PDF"), "normalpdf"):
stats::normalQuantile := loadproc(stats::normalQuantile, pathname("STATS","QUANTILE"), "normalquantile"):
stats::normalRandom   := loadproc(stats::normalRandom, pathname("STATS","RANDOM"), "normalrand"):

stats::lognormalCDF      := loadproc(stats::lognormalCDF, pathname("STATS","CDF"), "lognormalcdf"):
stats::lognormalPDF      := loadproc(stats::lognormalPDF, pathname("STATS","PDF"), "lognormalpdf"):
stats::lognormalQuantile := loadproc(stats::lognormalQuantile, pathname("STATS","QUANTILE"), "lognormalquantile"):
stats::lognormalRandom   := loadproc(stats::lognormalRandom, pathname("STATS","RANDOM"), "lognormalrand"):

stats::tCDF     := loadproc(stats::tCDF, pathname("STATS","CDF"), "tcdf"):
stats::tPDF     := loadproc(stats::tPDF, pathname("STATS","PDF"), "tpdf"):
stats::tQuantile:= loadproc(stats::tQuantile, pathname("STATS","QUANTILE"), "tquantile"):
stats::tRandom  := loadproc(stats::tRandom, pathname("STATS","RANDOM"), "trand"):

stats::uniformCDF     := loadproc(stats::uniformCDF, pathname("STATS","CDF"), "uniformcdf"):
stats::uniformPDF     := loadproc(stats::uniformPDF, pathname("STATS","PDF"), "uniformpdf"):
stats::uniformQuantile:= loadproc(stats::uniformQuantile, pathname("STATS","QUANTILE"), "uniformquantile"):
stats::uniformRandom  := loadproc(stats::uniformRandom, pathname("STATS","RANDOM"), "uniformrand"):

stats::weibullCDF     := loadproc(stats::weibullCDF, pathname("STATS","CDF"), "weibullcdf"):
stats::weibullPDF     := loadproc(stats::weibullPDF, pathname("STATS","PDF"), "weibullpdf"):
stats::weibullQuantile:= loadproc(stats::weibullQuantile, pathname("STATS","QUANTILE"), "weibullquantile"):
stats::weibullRandom  := loadproc(stats::weibullRandom, pathname("STATS","RANDOM"), "weibullrand"):

autoload(stats::winsorize):
autoload(stats::cutoff):

null():

// end of file 
