// 

//

stringlib:=newDomain("stringlib"):
stringlib::create_dom:=hold(stringlib):
stringlib::info:="Library 'stringlib': utilities for string manipulation":
stringlib::interface:=
  {
   hold(collapseWhitespace),
   hold(contains),
   hold(format),
   hold(formatf),
   hold(formatTime),
   hold(lower),
   //hold(match), undocumented
   hold(order),
   hold(pos),
   hold(random),
   hold(readText),
   hold(remove),
   hold(split),
   hold(subs),
   hold(subsop),
   hold(upper),
   hold(validIdent)
   }:

alias(path = pathname("STRINGLIB")):

// Kern-Funktion
stringlib::collapseWhitespace := stdlib::collapsews:

stringlib::contains  := loadproc(stringlib::contains  , path, "contains"  ):
stringlib::format    := loadproc(stringlib::format    , path, "format"    ):
stringlib::formatf   := loadproc(stringlib::formatf   , path, "formatf"   ):
stringlib::formatTime:= loadproc(stringlib::formatTime, path, "formatTime"):
stringlib::validIdent:= loadproc(stringlib::validIdent, path, "validident"):
stringlib::lower     := loadproc(stringlib::lower     , path, "lower"     ):
stringlib::maskMeta  := loadproc(stringlib::maskMeta,   path, "maskMeta"  ):
stringlib::decode_XML:= loadproc(stringlib::decode_XML, path, "decode_XML"):
stringlib::match     := loadproc(stringlib::match     , path, "match"     ):
stringlib::order     := loadproc(stringlib::order     , path, "order"     ):
stringlib::pos       := loadproc(stringlib::pos       , path, "pos"       ):
stringlib::random    := loadproc(stringlib::random    , path, "random"    ):
stringlib::readText  := loadproc(stringlib::readText  , path, "readText"  ):
stringlib::remove    := loadproc(stringlib::remove    , path, "remove"    ):
stringlib::split     := loadproc(stringlib::split     , path, "split"     ):
stringlib::subs      := loadproc(stringlib::subs      , path, "subs"      ):
stringlib::subs_regex:= loadproc(stringlib::subs_regex, path, "subs"      ):
stringlib::subsop    := loadproc(stringlib::subsop    , path, "subsop"    ):
stringlib::upper     := loadproc(stringlib::upper     , path, "upper"     ):
stringlib::join      := loadproc(stringlib::join      , path, "join"      ):

stringlib::FirstIndex := 1:

stringlib::lowerLetters:= ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k",
                           "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
                           "w", "x", "y", "z"]:

stringlib::upperLetters:= ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K",
                           "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V",
                           "W", "X", "Y", "Z"]:

stringlib::digits:=       ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]:

stringlib::punctuation:=  [".", ",", ":", ";", "!", "#", "$", "%", "&", "(", ")",
                           "*", "+", "-", "/", "<", "=", ">", "?", "[", "\\", "]",
                           "'", "\"", "^", "_", "{", "|", "}", "~"]:

null():

/* strmatch and substring are used in read and pathname, therefore
   don't move them to this library */
