/*
        vectorOf -- returns type expression to test vectors
                   (of the linalg package)

        linalg::vectorOf(T [,n])

        T - type of coefficients
        n - dimension

        The type expression created returns TRUE if an expression is 
        a vector (an element of category Matrix) of dimension n over 
        the coefficient ring T.
        If 'n' is missing then the dimension dosn't matter.
        If 'T' equals to 'Type::AnyType' then the coefficient ring 
        doesn't matter.
*/

linalg::vectorOf := proc(T)
begin
 if testargs() then
   if args(0) < 1 or args(0) > 2 then
     error("wrong no of args")
   end_if;
   if args(0) = 2 then
     if not testtype( args(2),Type::PosInt ) then
       error("dimension must be a positive integer")
     end_if
   end_if;
   if T <> Type::AnyType and T::hasProp( Cat::Rng ) <> TRUE then
     error("wrong argument")
   end_if
 end_if;

 new(Type,
     hold(vectorOf),
     proc(t,x)
         local n;
     begin
         if args(0) <> 2 then return( FALSE ) end_if;
         if x::dom::hasProp( Cat::Matrix ) <> TRUE then
             return( FALSE )
         end_if;
         n:= x::dom::matdim(x);
         if n[1] <> 1 and n[2] <> 1 then return( FALSE ) end_if;
         if nops(t) = 2 then
             if max( op(n) ) <> t[2] then return( FALSE ) end_if
         end_if;
         if t[1] <> Type::AnyType and t[1] <> x::dom::coeffRing then
             return( FALSE )
         end_if;
         TRUE
     end_proc, [ args() ], FALSE)
end_proc:

