/* 
  ==============
  checkForFloats
  ==============

  The procedure checks for float entries in a matrix 

  - Calls: checkForFloat(A) 
    where A is of type Dom::DenseMatrix or of 
    type Dom::Matrix

  - Return value: 
    'TRUE' if the matrix A contains float entries 
    'FALSE' if the matrix A contains no float entries
*/

linalg::checkForFloats:= proc(A)
  local Set, List, R; 
begin
  // Type checking: if A is of type 'Dom::DenseMatrix' then 
  // List simply contains the sequence of operands of A.
  // If A is of type Dom::Matrix it suffices that 
  // A contains the non-zero operands of A. 
  // If A is neither of type Dom::DenseMatrix nor of 
  // type Dom::Matrix an error message is returned. 
  R:= A::dom::coeffRing;
  if A::dom::hasProp(Cat::Matrix) then 
    if A::dom::constructor = Dom::Matrix then 
      List:= [A::dom::nonZeroOperands(A)];
    else
      List:= [op(A)];
    end_if;
  else
    error("Argument should be of category 'Cat::Matrix'");
  end_if;
  // Treat some special cases first: only matrices defined over 
  // Dom::Float, Dom::Rational, Dom::Complex, Dom::ExpressionField
  // can contain float entries. 
  if R = Dom::Float then 
    // Use numeric routine
    return(A);
  elif
    R::constructor <> Dom::ExpressionField and 
    not contains({Dom::Numerical, Dom::Real, Dom::Complex}, R)
  then 
    // Use symbolic routine
    return(FALSE);
  end_if;
  // Search for floating point entries in A:
  // use French code to reach your aim ;-)
  if R::hasProp( Ax::systemRep ) = FALSE then
    List:= map(List, expr);
    Set:= { op(map(List, ind -> 
                  case domtype(ind) 
                  of DOM_FLOAT do 
                    return(1);
                  of DOM_COMPLEX do
                    if domtype(op(ind, 2)) = DOM_FLOAT then 
                      return(1);
                    end_if;
                  otherwise 
                    return(null());
                  end_case)) };
  else 
    Set:= { op(map(List, ind -> 
                  case domtype(ind) 
                  of DOM_FLOAT do 
                    return(1);
                  of DOM_COMPLEX do
                    if domtype(op(ind, 2)) = DOM_FLOAT then 
                      return(1);
                    end_if;
                  otherwise 
                    return(null());
                  end_case)) };
  end_if;
  if contains(Set,1) then 
    // In this case the matrix contains at least one floating 
    // point entry: we try to convert all entries of the matrix  
    //              into floating point numbers
    Set:= {op(map(List, domtype@float))} minus {DOM_FLOAT, DOM_COMPLEX};
    if Set = {} then 
      return(map(A, float));
    end_if; 
    // Not all entries of the matrix could be floated! We have 
    // to skip to the symbolic case. 
    return(FALSE);
  else 
    // There are no floating point entries in A, i.e. use 
    // the symbolic routine
    return(FALSE);
  end_if;     
end_proc:



