/*
     linalg::col(A,i)           -- return column i of A
     linalg::col(A,i..j)        -- return the list of columns i to j of A
     linalg::col(A,[i1,i2,...]) -- return the list of columns i1,i2, ... of A

     A must be a matrix of a domain of category Cat::Matrix. The domain
     of A must provide a slot "col" for extracting a single column vector.
*/

linalg::col := proc(A,l)
    local k;
begin
    if testargs() then
      if args(0) <> 2 then error("expecting 2 arguments") end_if;
      if A::dom::hasProp( Cat::Matrix ) <> TRUE then
        error("first argument is not of 'Cat::Matrix'")
      end_if;
      k := op( A::dom::matdim(A),2 );
      if testtype( l,Type::PosInt ) then
        if l > k then error("index out of range") end_if
      elif type(l) = "_range" then
        if not testtype( op(l,1),Type::PosInt ) 
        or not testtype( op(l,2),Type::PosInt )
        then
          error("expecting range of positive integers")
        end_if;
      if op(l,1) > k or op(l,2) > k then
        error("range larger than upper matrix bound")
      end_if
    elif testtype(l,Type::ListOf(Type::PosInt,1)) then
      if max(op(l)) > k then
        error("indices in list larger than upper matrix bound")
      end_if
    else 
      error("expecting a range or list of column indices")
    end_if
  end_if;

  case domtype(l)
  of DOM_INT do
    return( A::dom::col(A,l) )
  of DOM_LIST do
    return( [A::dom::col(A,l[k]) $ k=1..nops(l)] )
  otherwise
    return( [A::dom::col( A,k ) $ k=op(l,1)..op(l,2)] )
  end_case
end_proc:

