/*
 linalg::concatMatrix  --  inserts matrices horizontally

 concatMatrix(A [,B,C,...])

 Appends matrices B,C,.. to A horizontally. The matrices
 B,C,... are converted to matrices of type of A.
 If A is of type SquareMatrix then A is converted to Matrix.
*/

linalg::concatMatrix := proc(A)
    local m, B, Mat;
begin
    if args(0) = 0 then
        error("expecting at least one argument")
    elif args(0) = 1 then 
        return( A ) 
    end_if;

    Mat:= A::dom;
    if testargs() and Mat::hasProp( Cat::Matrix ) <> TRUE then
        error("first argument is not of 'Cat::Matrix'")
    end_if;

    Mat:= A::dom;
    if Mat::constructor = Dom::SquareMatrix then
        Mat:= Mat::getSuperDomain();
        A:= Mat::coerce(A)
    end_if;

    m:= Mat::matdim(A)[1]; // number of rows
    for B in [args(2..args(0))] do
        B:= Mat::coerce(B);
        if B = FAIL or Mat::matdim(B)[1] <> m then 
            error("types of matrices don't match")
        else
            A:= Mat::concatMatrix( A,B )
        end_if
    end_for;

    return( A )
end_proc:

