// 

/* cond.mu
 *
 * linalg::cond -- computes the condition number of a matrix
 */

linalg::cond := proc(A, k=Infinity)
  local d;
begin
  if A::dom::hasProp(Cat::Matrix) <> TRUE then
     error("First argument should be a matrix.")
  end;
  d := linalg::matdim(A);
  if d[1] <> d[2] then
     error("Square matrix expected.")
  end;
  if {k} intersect {1, 
                    2, Spectral, Euclidean,
                    Infinity, Maximum, 
                    Frobenius} = {} then
     error("Unknown matrix norm ".expr2text(k).": 1, 2, Infinity, Frobenius, Spectral expected.")
  end;
  d := A^(-1);
  if d=FAIL then
    return( infinity );
  end_if;
  norm(A, k) * norm(d, k)
end:
