/*++
    crossmul.mu

    linalg::crossProduct(u,v) 

    u,v: vectors of length 3

    Returns the vector cross product of u and v where u and v are
    vectors over the same coeffRing, each with three elements.

++*/

linalg::crossProduct := proc(u,v)
    local R, Rmult, Rplus, R_negate;
begin
    if testargs() then
      if args(0) <> 2 then error("expecting 2 arguments") end_if;
      if not testtype( u,linalg::vectorOf(Type::AnyType,3) ) then
        error("expecting vectors of dimension 3")
      end_if;
      if not testtype( v,linalg::vectorOf(u::dom::coeffRing,3) ) then
        error("vectors are not compatible")
      end_if
    end_if;

    R:= u::dom::coeffRing;
    Rmult:= R::_mult;
    Rplus:= R::_plus;
    R_negate:= R::_negate;

    u::dom::create( op(u::dom::matdim(u)), [
       Rplus( Rmult(u[2],v[3]), R_negate(Rmult(u[3],v[2])) ),
       Rplus( Rmult(u[3],v[1]), R_negate(Rmult(u[1],v[3])) ),
       Rplus( Rmult(u[1],v[2]), R_negate(Rmult(u[2]*v[1])) )
    ])
end_proc:

linalg::crossProduct := funcenv(linalg::crossProduct):
linalg::crossProduct::Content := (Out, data) ->
                              if nops(data) <> 2 then
                                return(Out::stdFunc(data));
                              else
                                Out::Capply(Out::Cvectorproduct, 
                                            Out(op(data, 1)),
                                            Out(op(data, 2))):
                              end_if:
