/* 
  =========
  floatable 
  =========

  The procedure 'floatable' checks whether the compontents of a 
  matrix A can be converted to floating point numbers or not. 

  - Calls: floatable(A) 
    where A is of type Dom::DenseMatrix or of type Dom::Matrix

  - Return value: 
    'TRUE' if the compontents of the matrix A can be converted to floating 
           point numbers 
    'FALSE' otherwise
*/

linalg::floatable:= proc(A)
  local Set, List, R; 
begin
  // Type checking: if A is of type 'Dom::DenseMatrix' then 
  // List simply contains the sequence of operands of A.
  // If A is of type Dom::Matrix it suffices that 
  // A contains the non-zero operands of A. 
  // If A is neither of type Dom::DenseMatrix nor of 
  // type Dom::Matrix an error message is returned. 
  if not A::dom::hasProp(Cat::Matrix) then
    error("Argument should be of category 'Cat::Matrix'");
  end_if;
  R:= A::dom::coeffRing;
  // Treat some special cases first: only matrices defined over 
  // Dom::Float, Dom::Rational, Dom::Complex, Dom::ExpressionField
  // can contain float entries. 
  if R = Dom::Float then 
    // The components of A are already floating point numbers
    return(TRUE);
  elif
    R::constructor <> Dom::ExpressionField and 
    not contains({Dom::Numerical, Dom::Real, Dom::Complex}, R)
  then 
    // Use symbolic routine
    return(FALSE);
  end_if;
  if A::dom::isSparse then
      List:= [A::dom::nonZeroOperands(A)];
    else
      List:= [op(A)];
  end_if;
  // Search for floating point entries in A:
  // use French code to reach your aim ;-)
  List:= map(List, expr);
  Set:= {op(map(List, domtype@float))} minus {DOM_FLOAT, DOM_COMPLEX};
  if Set = {} then 
    return(TRUE);
  else 
    return(FALSE);
  end_if; 
end_proc:
