/*
        linalg::isPosDef -- test if a matrix is positive definite

        isPosDef( A )

        A: square matrix over a field

        isPosDef(A) tests if A is positive definite and returns TRUE
        and FALSE, respectivly.

        A is positive definite if A satisfies

             T
            x  A x > 0

        for all positive vectors x of type of A.
*/

linalg::isPosDef := proc(A)
    local tmp;
begin
    if testargs() then
        if args(0) <> 1 then error("expecting 1 argument") end_if;
        if A::dom::hasProp( Cat::Matrix ) <> TRUE then
            error("argument is not of 'Cat::Matrix'")
        end_if;
        tmp:= A::dom::matdim( A );
        if tmp[1] <> tmp[2] then
            error("not a square matrix")
        elif not A::dom::coeffRing::hasProp( Cat::Field ) then
            error("expecting a matrix over a 'Cat::Field'")
        end_if
    end_if;

    linalg::factorCholesky( A,hold(Test) )
end_proc:

