/*++
  mulcol.mu

 linalg::multCol -- multiply columns of a matrix by an expression

 multCol(A,{p,i..j,l},s)

 A   : matrix
 p   : positive integers
 i..j: range of positive integers
 l   : list of positive integers
 s   : expression

 After 's' is converted into an element of the coeff. ring of 'A',
 'multCol' returns a copy of matrix A in which column
 p is multiplied right by 's', or in which the columns i to j are 
 multiplied right by 's' when the second argument is a range of
 positive integers i and j. If a list l is given then these
 columns are multiplied by s which are specified in l.
++*/

linalg::multCol := proc(A,p,s)
    local j, r, R, i;
begin
    if testargs() then
      if args(0) <> 3 then error("expecting 3 arguments") end_if;
      if A::dom::hasProp( Cat::Matrix ) <> TRUE then
        error ("first argument is not of 'Cat::Matrix'")
      end_if;
      j := op( A::dom::matdim(A),2 );
      if testtype( p,Type::PosInt ) then
        if p > j then error("index out of range") end_if
        elif type(p) = "_range" then
        if not testtype( op(p,1),Type::PosInt )
        or not testtype( op(p,2),Type::PosInt )
        then
          error("expecting range of positive integers")
        end_if;
        if op(p,1) > j or op(p,2) > j then
          error("range larger than upper matrix bound")
        end_if
      elif testtype(p,Type::ListOf(Type::PosInt,1)) then
        if max(op(p)) > j then
          error("indices in list larger than upper matrix bound")
        end_if
      else
          error("invalid 2nd argument")
      end_if;
      if not testtype( s,A::dom::coeffRing ) then
        // Konvertierungsstrategie eingebaut 
	// Kai, den 04.05.2004 
        if A::dom::coeffRing::coerce(s) = FAIL then 
          error("unable to convert ".expr2text(s))
        end_if;
      end_if
    end_if;

    if A::dom::multCol <> FAIL then
      if type(p) = "_range" then
        for j from min(op(p)) to max(op(p)) do
          A:= A::dom::multCol(A, j, s);
        end_for;
        return(A);
      elif domtype(p) = DOM_LIST then
        for j in p do
          A:= A::dom::multCol(A, j, s);
        end_for;
        return(A);
      else
        return(A::dom::multCol(args())) 
      end_if;
    end_if;

    R:= A::dom::coeffRing;
    s:= R::coerce( s );

    r := op( A::dom::matdim(A),1 );
    if type(p) = "_range" then
      for j from min(op(p)) to max(op(p)) do
        ( A[i,j] := R::_mult(A[i,j],s) ) $ i=1..r
      end_for
    elif domtype(p) = DOM_LIST then
      for j in p do
        ( A[i,j] := R::_mult(A[i,j],s) ) $ i=1..r
      end_for
    else
      ( A[i,p] := R::_mult(A[i,p],s) ) $ i=1..r
    end_if;
    A
end_proc:

// end of file 
