/*++
  mulrow.mu

 linalg::multRow -- multiply rows of a matrix by an expression

 multRow(A,{p,i..j,l},s)

 A   : matrix, square matrix
 p   : positive integers
 i..j: range of positive integers
 l   : list of positive integers

 After s is converted into an element of A::coeffRing, 'multRow'
 returns a copy of matrix A in which row p is multiplied right by 's',
 or in which the rows i to j are multiplied right by 's' when the
 second argument is a range of positive integers i and j. If a list
 l is given then the rows are multiplied by s which are specified in l.
++*/

linalg::multRow := proc(A,p,s)
    local i, c, R, j;
begin
 if testargs() then
   if args(0) <> 3 then error("expecting 3 arguments") end_if;
   if A::dom::hasProp( Cat::Matrix ) <> TRUE then
     error ("first argument is not of 'Cat::Matrix'")
   end_if;
   i := op( A::dom::matdim(A),1 );
   if testtype( p,Type::PosInt ) then
     if p > i then error("index out of range") end_if
   elif type(p) = "_range" then
     if not testtype( op(p,1),Type::PosInt )
     or not testtype( op(p,2),Type::PosInt )
     then
       error("expecting range of positive integers")
     end_if;
     if op(p,1) > i or op(p,2) > i then
       error("range larger than upper matrix bound")
     end_if
   elif testtype(p,Type::ListOf(Type::PosInt,1)) then
     if max(op(p)) > i then
       error("indices in list larger than upper matrix bound")
     end_if
   else
     error("invalid 2nd argument")
   end_if;
   if not testtype( s,A::dom::coeffRing ) then
     // Konvertierungsstrategie eingebaut 
     // Kai, den 04.05.2004 
     if A::dom::coeffRing::coerce(s) = FAIL then 
       error("unable to convert ".expr2text(s))
     end_if;
   end_if
 end_if;

 if A::dom::multRow <> FAIL then
   if type(p) = "_range" then
     for j from min(op(p)) to max(op(p)) do
       A:= A::dom::multRow(A, j, s);
     end_for;
     return(A);
   elif domtype(p) = DOM_LIST then
     for j in p do
       A:= A::dom::multRow(A, j, s);
     end_for;
     return(A);
   else
     return(A::dom::multRow(args())) 
   end_if;
 end_if;


 R:= A::dom::coeffRing;
 s:= R::coerce( s );

 c := op( A::dom::matdim(A),2 );
 if type(p) = "_range" then
   for i from min(op(p)) to max(op(p)) do
     ( A[i,j] := R::_mult(A[i,j],s) ) $ j=1..c
   end_for
 elif domtype(p) = DOM_LIST then
   for i in p do
     ( A[i,j] := R::_mult(A[i,j],s) ) $ j=1..c
   end_for
 else
   ( A[p,j] := R::_mult(A[p,j],s) ) $ j=1..c
 end_if;
 A
end_proc:

// end of file 
