/* otimes -- a special multiplication for multivariate polynomials 
             
  PARAMETERS: 

   -- P, Ptilde are multivariate polynomials 
   -- i, k are indices 

  REFERENCE:
   
   Efficient Gaussian Elimination Method for Symbolic
   Determinants and Linear Systems, T. Sasaki, H. Murao, 
   ACM Transactions on Mathematical Software, Vol. 8, 
   No. 3, September 1982, Pages 228-289. 
*/

linalg::otimes:= 
proc(P,     // : Type::Union(Type::Zero,DOM_POLY),
     Ptilde,// : Type::Union(Type::Zero,DOM_POLY), 
     i, k, nm2, Ring)
local P1, P0, P1tilde, P0tilde, j;
begin
  // nm2:= n - 2;
  if args(0) < 6 then
     Ring:= Expr:
  end_if;
  if iszero(P) then
     return(P);
  end_if;
  if iszero(Ptilde) then
     return(Ptilde);
  end_if;
  if i <= k then 
    P1:= poly(coeff(P,`#X`[i], 1), [`#X`[j] $ j = 1..nm2], Ring);
    P0:= poly(coeff(P,`#X`[i], 0), [`#X`[j] $ j = 1..nm2], Ring);
    P1tilde:= poly(coeff(Ptilde, `#X`[i], 1), [`#X`[j] $ j = 1..nm2], Ring);
    P0tilde:= poly(coeff(Ptilde, `#X`[i], 0), [`#X`[j] $ j = 1..nm2], Ring);
    if iszero(P1) then
       return(linalg::otimes(P0, P1tilde, i+1, k, nm2, Ring));
    elif iszero(P1tilde) then
       return(linalg::otimes(P1, P0tilde, i+1, k, nm2, Ring));
    elif iszero(P0) then
       return(linalg::otimes(P1, P1tilde, i+1, k, nm2, Ring) * 
                 poly(`#X`[i], [`#X`[j] $ j = 1..nm2], Ring) + 
              linalg::otimes(P1, P0tilde, i+1, k, nm2, Ring));
    elif iszero(P0tilde) then
       return(linalg::otimes(P1, P1tilde, i+1, k, nm2, Ring) * 
                 poly(`#X`[i], [`#X`[j] $ j = 1..nm2], Ring) + 
              linalg::otimes(P0, P1tilde, i+1, k, nm2, Ring));
    else // the full monty
       return(linalg::otimes(P1, P1tilde, i+1, k, nm2, Ring) * 
                 poly(`#X`[i], [`#X`[j] $ j = 1..nm2], Ring) + 
             (linalg::otimes(P1, P0tilde, i+1, k, nm2, Ring) + 
              linalg::otimes(P0, P1tilde, i+1, k, nm2, Ring)));
    end_if;
  else // i > k 
    return(P * Ptilde);
  end_if;
end_proc:
