// linalg::polynomializeMatrix is a utility used 
// in linalg::inverse to represent all matrix 
// entries as poly of its indets. 
// Rational expressions are multiplied row-wise
// with the common denom to cast the entries into
// polynomial form. (This may blow up the complexity
// of the matrix. However, experiments have shown that this
// may be well worth its while because it allows to avoid
// the extremely expensive 'normal' in the Gauss elim. The
// input matrix is of the form
//   A =  squareMatrix . identity.
// The return value is fed into linalg::SSS and
// forwarded to linalg::ffG, which uses the poly
// structure to avoid normal(x/y) in exact divisions 
// of the fraction free Gauss elimination and 
// replaces it by the much faster divide(x, y, Quo).

linalg::polynomializeMatrix:= proc(A)
local Mat, m, n, subst, vars, i, j, row,
      numerators, denoms, commondenom;
begin
  Mat:= A::dom:
  [m, n]:= Mat::matdim(A);
  if has([args()], "MatrixIsRationalized") then
     subst:= {};
  else
     [A, subst]:= [linalg::rationalizeMatrix(args())]:
  end_if:
  vars:= indets(A);
  if nops(vars) = 0 then
     vars:= [#dummy]
  else
     vars:= [op(vars)];
  end_if;
  for i from 1 to m do
    row:= [A[i, j] $ j = 1..n];
    row:= map(row, normal, List);
    numerators:= map(row, op, 1);
    denoms:= map(row, op,2);
    commondenom:= lcm(op(denoms));
    denoms:= map(denoms, d -> divide(commondenom, d, Exact));
    assert(not has(denoms, FAIL));
    row:= zip(numerators, denoms, _mult);
    row:= map(row, poly, vars);
    assert(not has(row, FAIL));
    for j from 1 to n do
       A[i,j]:= row[j];
    end_for:
  end_for;
  A, subst;
end_proc:
  
